﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.IO;
using System.Data;
using System.Data.OleDb;
using System.Data.SqlClient;
using System.Configuration;
using System.Text;
using OfficeOpenXml;

namespace CAE_WEB_PROJECT.CAT.Reports
{
    public partial class SOIReport1 : System.Web.UI.Page
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            ExcelPackage.LicenseContext = LicenseContext.NonCommercial;
            using (ExcelPackage excel = new ExcelPackage())
            {

                //Add Worksheets in Excel file
                excel.Workbook.Worksheets.Add("SOIQRY");

                //Create Excel file in Uploads folder of your project
                FileInfo excelFile = new FileInfo(Server.MapPath("~/files/SOIQRY.xlsx"));

                //Add header row columns name in string list array
                var headerRow = new List<string[]>()
                  {
                    new string[] { "SOIID", "SOITITLE", "SOIDATE", "SOISTATUS", "LESSNUMBER", "LESSTITLE", "LESSREV", "REVDATE", "FEADATE", "LESSSTATUS", "LESSNOTE", "MEDIAlku", "OBJNUMBER", "OBJDESC", "RPL", "QUESTIONNUM", "QUESTIONDESC", "MIDESC", "CLASSIFICATION" }
                  };

                // Get the header range
                string Range = "A1:" + Char.ConvertFromUtf32(headerRow[0].Length + 64) + "1";

                // get the workSheet in which you want to create header
                var worksheet = excel.Workbook.Worksheets["SOIQRY"];

                // Popular header row data
                worksheet.Cells[Range].LoadFromArrays(headerRow);

                int rowcounter = 2;
                string soiid = Request.QueryString["soiid"];
                string cs = System.Configuration.ConfigurationManager.ConnectionStrings["Database1.mdf"].ConnectionString;
                SqlConnection con = new SqlConnection(cs);
                con.Open();
                SqlCommand cmd = new SqlCommand("select s.SOIID, s.SOITITLE, CONVERT(varchar,s.SOIDATE,101) as SOIDATE, stat.status as SOISTATUS, l.LESSNUMBER, l.LESSTITLE, rev.rev as LESSREV, CONVERT(varchar,l.REVDATE,101) as REVDATE, CONVERT(varchar,l.FEADATE,101) " +
                    "as FEADATE, stat2.status as LESSSTATUS, l.LESSNOTE, media.media as MEDIAlku, o.OBJNUMBER, o.OBJDESC, o.RPL, q.QUESTIONNUM, q.QUESTIONDESC, m.MIDESC, class.CLASSIFICATION from soi s, lesson l, soiless sl, soimi sm, soimi2obj sm2o, objectives o, " +
                    "question q, mi m, statusiku stat, statusiku stat2, reviku rev, mediaiku media, classification class where s.soiid=" + soiid + " and s.soistatus=stat.id and l.status=stat2.id and l.lessrev=rev.id and s.soiid=sl.soiidfk and s.soiid=sm.soiidfk and " +
                    "sm.soimiid=sm2o.soimiidfk and sl.lessidfk=l.lessid and l.lessid=o.lessidfk and sm.miidfk=m.miid and sm2o.objidfk=o.objid and o.objid=q.objidfk and l.mediaiku=media.id and l.classification=class.classid and l.MP!=1 order by l.LESSNUMBER");
                cmd.Connection = con;
                SqlDataReader reader = cmd.ExecuteReader();
                {
                    while (reader.Read())
                    {
                        string SOIID = reader["SOIID"].ToString();
                        int SOIIDINT = Int32.Parse(SOIID);
                        string SOITITLE = reader["SOITITLE"].ToString();
                        string SOIDATE = reader["SOIDATE"].ToString();
                        string SOISTATUS = reader["SOISTATUS"].ToString();
                        string LESSNUMBER = reader["LESSNUMBER"].ToString();
                        string LESSTITLE = reader["LESSTITLE"].ToString();
                        string LESSREV = reader["LESSREV"].ToString();
                        string REVDATE = reader["REVDATE"].ToString();
                        string FEADATE = reader["FEADATE"].ToString();
                        string LESSSTATUS = reader["LESSSTATUS"].ToString();
                        string LESSNOTE = reader["LESSNOTE"].ToString();
                        string MEDIAlku = reader["MEDIAlku"].ToString();
                        string OBJNUMBER = reader["OBJNUMBER"].ToString();             
                        string OBJDESC = reader["OBJDESC"].ToString();
                        string RPL = reader["RPL"].ToString();                      
                        string QUESTIONNUM = reader["QUESTIONNUM"].ToString();            
                        string QUESTIONDESC = reader["QUESTIONDESC"].ToString();
                        string MIDESC = reader["MIDESC"].ToString();
                        string CLASSIFICATION = reader["CLASSIFICATION"].ToString();
                        //Table Rows
                        //Now add some data in rows for each column
                        var Data = new List<object[]>()
                            {
                              new object[] {SOIIDINT,SOITITLE,SOIDATE,SOISTATUS,LESSNUMBER,LESSTITLE,LESSREV,REVDATE,FEADATE,LESSSTATUS,LESSNOTE,MEDIAlku,OBJNUMBER,OBJDESC,RPL,QUESTIONNUM,QUESTIONDESC,MIDESC,CLASSIFICATION},
                            };
                        worksheet.Cells[rowcounter, 1].LoadFromArrays(Data);
                        //worksheet.Cells[worksheet.Dimension.Address].AutoFitColumns();
                        worksheet.DefaultColWidth = 15;
                        worksheet.Column(5).Width = 40;
                        worksheet.Column(6).Width = 40;
                        worksheet.Column(11).Width = 120;
                        worksheet.Column(14).Width = 120;
                        worksheet.Column(17).Width = 120;
                        worksheet.Column(18).Width = 120;
                        rowcounter++;
                    }
                }
                con.Dispose();

                //Save Excel file
                excel.SaveAs(excelFile);
            }
            byte[] fileBytes = System.IO.File.ReadAllBytes(Server.MapPath("~/files/SOIQRY.xlsx"));
            Response.Redirect("../files/SOIQRY.xlsx", false);
            Context.ApplicationInstance.CompleteRequest();
        }
    }
}