﻿<%@ Page Title="Smartsheet Tasks" Language="C#" MasterPageFile="~/Header.Master" AutoEventWireup="true" CodeBehind="Tasks.aspx.cs" Inherits="CAE_WEB_PROJECT.admin.smartsheet.Tasks" %>
<asp:Content ID="Content1" ContentPlaceHolderID="head" runat="server">
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="ContentPlaceHolder1" runat="server">

<script type="text/javascript" src="../scripts/jquery-3.5.1.js"></script>
<script type="text/javascript" src="../scripts/jquery.dataTables.min.js"></script>
<link rel="stylesheet" href="../styles/jquery.dataTables.css" /> 
   
<script>
    var tasknumber; 
    var taskname; 
    var taskgroup; 
    var selid;

    $(document).ready(function () {
        $('#example').dataTable({
            "order": [],
            "bPaginate": false,
            "bLengthChange": false,
            "bFilter": true,
            "bInfo": false,
            "bAutoWidth": true,
            "scrollY": "400px",
            "sScrollX": "100%",
            "sScrollXInner": "100%",
            "scrollCollapse": true,
            "language": {
                "emptyTable": "No Tasks"            
            }
        });

        var table = $('#example').DataTable();

        $('#example tbody').on('click', 'tr', function () {
            if ($(this).hasClass('selected')) {
                $(this).removeClass('selected');
                selid = null;
            }
            else {
                table.$('tr.selected').removeClass('selected');
                $(this).addClass('selected');
                var data = table.row(this).data();
                savedata(data);
            }
        });     
    }); 

    function savedata(rowdata) {
        tasknumber = rowdata[0];
        taskname = rowdata[1];
        taskgroup = rowdata[3];
        selid = rowdata[4];       
    }

    function editdata() {
        if (selid == null) {
            alert("No row selected")
        }
        else {
            var modalcheck = document.getElementById("myModal2");
            if (modalcheck.style.display == "block") {
                modalcheck.style.display = "none";
            }

            // Get the modal
            var modal = document.getElementById("myModal");
            modal.style.display = "block";

            // Get the <span> element that closes the modal
            var span = document.getElementsByClassName("close")[0];

            // When the user clicks on <span> (x), close the modal
            span.onclick = function () {
                modal.style.display = "none";
            }

            // When the user clicks anywhere outside of the modal, close it
            window.onclick = function (event) {
                if (event.target == modal) {
                    modal.style.display = "none";
                }
            }

            document.onkeydown = function (evt) {
                evt = evt;
                if (evt.key === 'Escape') {
                    modal.style.display = "none";
                }
            };

            $('#editid').val(selid);
            $('#edittasknumber').val(tasknumber);    
            $('#edittaskname').val(taskname); 
            $('#edittaskgroup').val(taskgroup); 
        }        
    }

    function addphase() {
        var modalcheck = document.getElementById("myModal");
        if (modalcheck.style.display == "block") {
            modalcheck.style.display = "none";
        }

        // Get the modal
        var modal = document.getElementById("myModal2");
        modal.style.display = "block";

        // Get the <span> element that closes the modal
        var span = document.getElementsByClassName("close2")[0];

        // When the user clicks on <span> (x), close the modal
        span.onclick = function () {
            modal.style.display = "none";
        }

        // When the user clicks anywhere outside of the modal, close it
        window.onclick = function (event) {
            if (event.target == modal) {
                modal.style.display = "none";
            }
        }

        document.onkeydown = function (evt) {
            evt = evt;
            if (evt.key === 'Escape') {
                modal.style.display = "none";
            }
        };         
    }

    function deletedata() {
        if (selid == null) {
            alert("No row selected")
        }
        else {
            if (confirm("Are you sure that you want to delete this task?") == true) {
                window.location.href = "../admin/deletetask.aspx?selid=" + selid;
            } else {
                return;
            }            
        }
    }

</script>
<br /><br />
 <div style="text-align: center; font-family:sans-serif;"><h1>Smartsheet Tasks</h1></div>
<hr />
<div style="margin: 35px;">
<button class="button" onclick="addphase()">Add Task</button>
<button class="button" onclick="editdata()">Edit Row</button>
<button class="button" onclick="deletedata()">Delete Row</button>
<br /><br />
<table id="example" class="display" style="width:100%; border: none">
        <thead style="background-color: #005EB8; color: white">
            <tr>     
                <th>Task Number</th>
                <th>Task Name</th>
                <th>Task Group</th>
                <th style="display:none;">Task Group</th>
                <th style="display:none;">ID</th>
            </tr>
        </thead>
        <tbody>
            <asp:Label ID="Label1" runat="server" />                          
        </tbody>
    </table>
</div>

<!-- The Modal -->
<div id="myModal" class="modal">
  <!-- Modal content -->
  <div class="modal-content" style="background-color: lightgray;">
    <span class="close">&times;</span>
      <br /><br />
       <h4 style="text-align: center">Edit Task</h4><br />
       <form class="form login" name="form1" action="../admin/edittask.aspx" method="post" enctype="multipart/form-data">
       <input type="hidden" name="editid" id="editid" /> 
       <div class="form__field">
       <input style="color: white" type="number" name="edittasknumber" id="edittasknumber" placeholder="Task Number" required="required"/>
       </div>          
       <div class="form__field">
       <input style="color: white" type="text" name="edittaskname" id="edittaskname" placeholder="Task Name" required="required"/>
       </div>
       <div class="form__field" style="color: black">
            <select class="selectstyle" id="edittaskgroup" name="edittaskgroup" required="required">
                <asp:Label ID="Label2" runat="server" />
            </select>
       </div>
       <div class="form__field">
       <input type="submit" value="Update" />
       </div>          
       </form>
  </div>
</div>

<!-- The Modal -->
<div id="myModal2" class="modal">
  <!-- Modal content -->
  <div class="modal-content" style="background-color: lightgray;">
    <span class="close2">&times;</span>
      <br /><br />
       <h4 style="text-align: center">Add Task</h4><br />
       <form class="form login" name="form1" action="../admin/addtask.aspx" method="post" enctype="multipart/form-data">       
       <div class="form__field">
       <input style="color: white" type="number" name="tasknumber" id="tasknumber" placeholder="Task Number" required="required"/>
       </div>
       <div class="form__field">
       <input style="color: white" type="text" name="taskname" id="taskname" placeholder="Task Name" required="required"/>
       </div>
       <div class="form__field" style="color: black">
            <select class="selectstyle" id="taskgroup" name="taskgroup" required="required">
                <asp:Label ID="Label3" runat="server" />
            </select>
       </div>
       <div class="form__field">
       <input type="submit" value="Add Task" />
       </div>          
       </form>
  </div>
</div>

</asp:Content>
