﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.IO;
using System.Data.SqlClient;
using System.Configuration;
using System.Data;

namespace CAE_WEB_PROJECT.CAT
{
    public partial class Feedback : System.Web.UI.Page
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            if (Session["UserName"] == null)
            {
                Response.Write("<script>alert('Session Timeout')</script>");
                Response.Write("<script>window.location.href='../Default.aspx'</script>");
                return;
            }

            string cs = System.Configuration.ConfigurationManager.ConnectionStrings["Database1.mdf"].ConnectionString;
            string reqOptPlaceholderTag = "<option value='' disabled selected hidden>";
            List<string> optList = new List<string>();
            optList.Add(reqOptPlaceholderTag + "Select a lesson</option>");
            SqlConnection con = new SqlConnection(cs);
            con.Open();
            SqlCommand cmd = new SqlCommand("SELECT * from Lesson where (MP != 1) and (status != 2) order by LESSNUMBER");
            cmd.Connection = con;
            SqlDataReader reader = cmd.ExecuteReader();
            {
                while (reader.Read())
                {
                    string lessid = reader["lessid"].ToString();
                    string LESSNUMBER = reader["LESSNUMBER"].ToString();
                    string LESSTITLE = reader["LESSTITLE"].ToString();
                    string mediaIKU = reader["MEDIAIku"].ToString();
                    optList.Add( $"<option data-mediaiku='{mediaIKU}' value='{lessid}'>{LESSNUMBER} | {LESSTITLE}</option>" );
                }
            }
            con.Dispose();
            lessidOpts.Text = string.Join("", optList.ToArray());
            optList.Clear();
            //editlessidOpts.Text = labeltext;

            optList.Add(reqOptPlaceholderTag + "Select feedback type</option>");
            SqlConnection con2 = new SqlConnection(cs);
            con2.Open();
            SqlCommand cmd2 = new SqlCommand("SELECT * from Feedback_Types order by sequence");
            cmd2.Connection = con2;
            SqlDataReader reader2 = cmd2.ExecuteReader();
            {
                while (reader2.Read())
                {
                    string feedback_id = reader2["id"].ToString();
                    string feedback_type = reader2["feedback_type"].ToString();             
                    optList.Add($"<option value='{feedback_id}'>{feedback_type}</option>");
                }
            }
            con2.Dispose();
            fbtypeOpts.Text = string.Join("", optList.ToArray());
            optList.Clear();
            //editfbtypeOpts.Text = labeltext2;

            List<string> rxnOptList = new List<string>();
            optList.Add(reqOptPlaceholderTag + "Select one</option>");
            SqlConnection con4 = new SqlConnection(cs);
            con4.Open();
            SqlCommand cmd4 = new SqlCommand("SELECT * from Feedback_Reactions order by rank desc");
            cmd4.Connection = con4;
            SqlDataReader reader4 = cmd4.ExecuteReader();
            {
                while (reader4.Read())
                {
                    string rxnId = reader4["rank"].ToString();
                    string rxnLabel = reader4["descript"].ToString();
                    optList.Add($"<option value='{rxnId}'>{rxnLabel}</option>");
                }
            }
            con4.Dispose();
            string labeltext = string.Join("", optList.ToArray());
            durationRxnOpts.Text = labeltext;
            contentRxnOpts.Text = labeltext;
            flowRxnOpts.Text = labeltext;
            functltyRxnOpts.Text = labeltext;
            incKnowRxnOpts.Text = labeltext;
            senseRxnOpts.Text = labeltext;
            objvsRxnOpts.Text = labeltext;
            accurRxnOpts.Text = labeltext;
            engageRxnOpts.Text = labeltext;
            needsMMRxnOpts.Text = labeltext;
            needsUIRxnOpts.Text = labeltext;
            issuesRxnOpts.Text = labeltext;
            sgUsedRxnOpts.Text = labeltext;
            sgValueRxnOpts.Text = labeltext;
            ciStyleRxnOpts.Text = labeltext;
            pptValueRxnOpts.Text = labeltext;
            pptFitRxnOpts.Text = labeltext;
            pptAmtRxnOpts.Text = labeltext;
            formatRxnOpts.Text = labeltext;
            needAidsRxnOpts.Text = labeltext;

            string actionbuttons = "";
            string userid = Session["UserID"].ToString();
            SqlConnection conX = new SqlConnection(cs);
            conX.Open();
            SqlCommand cmdX = new SqlCommand("SELECT * from Members where id=" + userid);
            cmdX.Connection = conX;
            SqlDataReader readerX = cmdX.ExecuteReader();
            {
                while (readerX.Read())
                {
                    string catroles = readerX["catroles"].ToString();
                    if (catroles == "1" || catroles == "5")
                    {
                        actionbuttons = "<button class='button' onclick='newfeedback()'>New Feedback</button>&nbsp;";
                    }
                    if (catroles == "1")
                    {
                        actionbuttons += "<button class='button' onclick='editdata()'>Edit Row</button>&nbsp;";
                        actionbuttons += "<button class='button' onclick='deletedata()'>Delete Row</button>&nbsp;";                        
                    }
                    buttonsHtml.Text = actionbuttons;
                }
            }
            conX.Dispose();
        }
    }
}