# PowerShell script to configure Outlook settings

function Ensure-RegistryPath {
    param (
        [string]$Path
    )
    if (-not (Test-Path $Path)) {
        New-Item -Path $Path -Force | Out-Null
    }
}

function Set-RegistryValue {
    param (
        [string]$Path,
        [string]$Name,
        [int]$Value
    )
    Ensure-RegistryPath -Path $Path
    Set-ItemProperty -Path $Path -Name $Name -Value $Value
}

function Show-Menu {
    param (
        [string]$Title = 'Please choose an action:'
    )
    Clear-Host
    Write-Host "================ $Title ================"
    Write-Host "1: Switch to new Outlook"
    Write-Host "2: Switch to old Outlook"
    Write-Host "3: Show 'New Outlook' toggle"
    Write-Host "4: Hide 'New Outlook' toggle"
    Write-Host "Q: Quit"
}

do {
    Show-Menu
    $input = Read-Host "Select an option"
    switch ($input) {
        '1' {
            Set-RegistryValue -Path "HKCU:\SOFTWARE\Microsoft\Office\16.0\Outlook\Preferences" -Name "UseNewOutlook" -Value 1
            Write-Host "Switched to new Outlook."
        }
        '2' {
            Set-RegistryValue -Path "HKCU:\SOFTWARE\Microsoft\Office\16.0\Outlook\Preferences" -Name "UseNewOutlook" -Value 0
            Write-Host "Switched to old Outlook."
        }
        '3' {
            Set-RegistryValue -Path "HKCU:\Software\Microsoft\Office\16.0\Outlook\Options\General" -Name "HideNewOutlookToggle" -Value 0
            Write-Host "'New Outlook' toggle is now visible."
        }
        '4' {
            Set-RegistryValue -Path "HKCU:\Software\Microsoft\Office\16.0\Outlook\Options\General" -Name "HideNewOutlookToggle" -Value 1
            Write-Host "'New Outlook' toggle is now hidden."
        }
        'Q' {
            return
        }
        default {
            Write-Host "Invalid option, please try again."
        }
    }
    Pause
} while ($input -ne 'Q')

