﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.IO;
using System.Data;
using System.Data.OleDb;
using System.Data.SqlClient;
using System.Configuration;
using System.Text;
using OfficeOpenXml;

namespace CAE_WEB_PROJECT.CAT.Reports
{
    public partial class SOIReport2 : System.Web.UI.Page
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            ExcelPackage.LicenseContext = LicenseContext.NonCommercial;
            using (ExcelPackage excel = new ExcelPackage())
            {

                //Add Worksheets in Excel file
                excel.Workbook.Worksheets.Add("QRYSOILESS");

                //Create Excel file in Uploads folder of your project
                FileInfo excelFile = new FileInfo(Server.MapPath("~/files/QRYSOILESS.xlsx"));

                //Add header row columns name in string list array
                var headerRow = new List<string[]>()
                  {
                    new string[] { "SOIID", "SOITITLE", "LESSSTATUS", "LESSNUMBER", "LESSTITLE", "MEDIAlku", "FEADATE", "LESSREV", "REVDATE", "CLASSIFICATION" }
                  };

                // Get the header range
                string Range = "A1:" + Char.ConvertFromUtf32(headerRow[0].Length + 64) + "1";

                // get the workSheet in which you want to create header
                var worksheet = excel.Workbook.Worksheets["QRYSOILESS"];

                // Popular header row data
                worksheet.Cells[Range].LoadFromArrays(headerRow);

                int rowcounter = 2;
                string soiid = Request.QueryString["soiid"];
                string cs = System.Configuration.ConfigurationManager.ConnectionStrings["Database1.mdf"].ConnectionString;
                SqlConnection con = new SqlConnection(cs);
                con.Open();
                SqlCommand cmd = new SqlCommand("select s.SOIID, s.SOITITLE, stat.status as LESSSTATUS, l.LESSNUMBER, l.LESSTITLE, media.media as MEDIAlku, CONVERT(varchar,l.FEADATE,101) as FEADATE, rev.rev as LESSREV, CONVERT(varchar,l.REVDATE,101) as REVDATE, " +
                    "class.CLASSIFICATION from soi s, lesson l, soiless sl, statusiku stat, reviku rev, mediaiku media, classification class where s.soiid=" + soiid + " and s.soiid=sl.soiidfk and l.status=stat.id and l.lessrev=rev.id and l.lessid=sl.lessidfk " +
                    "and l.mediaiku=media.id and l.classification=class.classid and l.MP!=1 order by l.LESSNUMBER");
                cmd.Connection = con;
                SqlDataReader reader = cmd.ExecuteReader();
                {
                    while (reader.Read())
                    {
                        string SOIID = reader["SOIID"].ToString();
                        int SOIIDINT = Int32.Parse(SOIID);
                        string SOITITLE = reader["SOITITLE"].ToString();
                        string LESSSTATUS = reader["LESSSTATUS"].ToString();
                        string LESSNUMBER = reader["LESSNUMBER"].ToString();
                        string LESSTITLE = reader["LESSTITLE"].ToString();                    
                        string MEDIAlku = reader["MEDIAlku"].ToString();
                        string FEADATE = reader["FEADATE"].ToString();
                        string LESSREV = reader["LESSREV"].ToString();
                        string REVDATE = reader["REVDATE"].ToString();
                        string CLASSIFICATION = reader["CLASSIFICATION"].ToString();
                        //Table Rows
                        //Now add some data in rows for each column
                        var Data = new List<object[]>()
                            {
                              new object[] {SOIIDINT,SOITITLE,LESSSTATUS,LESSNUMBER,LESSTITLE,MEDIAlku,FEADATE,LESSREV,REVDATE,CLASSIFICATION},
                            };
                        worksheet.Cells[rowcounter, 1].LoadFromArrays(Data);
                        worksheet.DefaultColWidth = 15;
                        worksheet.Column(2).Width = 40;
                        worksheet.Column(4).Width = 40;
                        worksheet.Column(5).Width = 40;
                        rowcounter++;
                    }
                }
                con.Dispose();

                //Save Excel file
                excel.SaveAs(excelFile);
            }
            byte[] fileBytes = System.IO.File.ReadAllBytes(Server.MapPath("~/files/QRYSOILESS.xlsx"));
            Response.Redirect("../files/QRYSOILESS.xlsx", false);
            Context.ApplicationInstance.CompleteRequest();            
        }
    }
}