﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.IO;
using System.Data;
using System.Data.OleDb;
using System.Data.SqlClient;
using System.Configuration;
using System.Text;
using OfficeOpenXml;

namespace CAE_WEB_PROJECT.CAT.Reports
{
    public partial class AuditReport2 : System.Web.UI.Page
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            ExcelPackage.LicenseContext = LicenseContext.NonCommercial;
            using (ExcelPackage excel = new ExcelPackage())
            {
                var worksheet = excel.Workbook.Worksheets.Add("qryLessInfo");
                var headerLabels = new List<string[]>()
                  {
                    new string[] { "LESSNUMBER", "LESSTITLE", "LESSREV", "REVDATE", "FEADATE", "STATUS", "MP", "LESSNOTE", "MEDIAlku", "LESS_PER" }
                  };
                string Range = "A1:" + Char.ConvertFromUtf32(headerLabels[0].Length + 64) + "1";
                var headerCells = worksheet.Cells[Range];
                headerCells.LoadFromArrays(headerLabels);
                headerCells.Style.Fill.PatternType = OfficeOpenXml.Style.ExcelFillStyle.Solid;
                headerCells.Style.Fill.BackgroundColor.SetColor(System.Drawing.Color.DeepSkyBlue);
                worksheet.View.FreezePanes(2, 1); // Freeze the header cells row

                int rowcounter = 2; // step past the header row, in preparation for adding data rows

                string cs = System.Configuration.ConfigurationManager.ConnectionStrings["Database1.mdf"].ConnectionString;
                SqlConnection con = new SqlConnection(cs);
                con.Open();
                SqlCommand cmd = new SqlCommand("SELECT l.LESSNUMBER, l.LESSTITLE, ISNULL(r.REV, null) as LESSREV, CONVERT(varchar,l.REVDATE,101) as REVDATE, CONVERT(varchar,l.FEADATE,101) as FEADATE, ISNULL(s.STATUS, null) as STATUS, " +
                    "l.MP, l.LESSNOTE, ISNULL(m.MEDIA, null) as MEDIAlku, ISNULL(d.DURATION_PER, null) as LESS_PER FROM LESSON l LEFT JOIN MEDIAIku m on l.MEDIAIku=m.id LEFT JOIN DURATION_PER d on l.LESS_PER=d.id LEFT JOIN " +
                    "STATUSIku s on l.STATUS=s.id LEFT JOIN REVIku r on l.LESSREV=r.id where l.MP!=1 order by l.LESSID");
                cmd.Connection = con;
                SqlDataReader reader = cmd.ExecuteReader();
                {
                    while (reader.Read())
                    {
                        string LESSNUMBER = reader["LESSNUMBER"].ToString();
                        string LESSTITLE = reader["LESSTITLE"].ToString();                        
                        string LESSREV = reader["LESSREV"].ToString();
                        string REVDATE = reader["REVDATE"].ToString();
                        string FEADATE = reader["FEADATE"].ToString();
                        string STATUS = reader["STATUS"].ToString();
                        string MP = reader["MP"].ToString();
                        string LESSNOTE = reader["LESSNOTE"].ToString();
                        string MEDIAlku = reader["MEDIAlku"].ToString();                 
                        string LESS_PER = reader["LESS_PER"].ToString();          
                        //Table Rows
                        //Now add some data in rows for each column
                        var Data = new List<object[]>()
                            {
                              new object[] {LESSNUMBER,LESSTITLE,LESSREV,REVDATE,FEADATE,STATUS,MP,LESSNOTE,MEDIAlku,LESS_PER},
                            };
                        worksheet.Cells[rowcounter, 1].LoadFromArrays(Data);
                        //worksheet.Cells[worksheet.Dimension.Address].AutoFitColumns();
                        worksheet.DefaultColWidth = 15;
                        worksheet.Column(1).Width = 40;
                        worksheet.Column(2).Width = 45;
                        worksheet.Column(8).Width = 120;                    
                        rowcounter++;
                    }
                }
                con.Dispose();

                FileInfo excelFile = new FileInfo(Server.MapPath("~/files/qryLessInfo.xlsx"));
                excel.SaveAs(excelFile);
            }
            // Previous author may have introduced the following line in preparation to stream bytes to the user? But not being used here...
            //byte[] fileBytes = System.IO.File.ReadAllBytes(Server.MapPath("~/files/qryLessInfo.xlsx"));
            Response.Redirect("../files/qryLessInfo.xlsx", false);
            Context.ApplicationInstance.CompleteRequest();

            /*
            //Fill dataset with records
            DataSet dataSet = GetRecordsFromDatabase();

            StringBuilder sb = new StringBuilder();

            sb.Append("<table>");

            //LINQ to get Column names
            var columnName = dataSet.Tables[0].Columns.Cast<DataColumn>()
                                 .Select(x => x.ColumnName)
                                 .ToArray();
            sb.Append("<tr style='text-align: center;'>");
            //Looping through the column names
            foreach (var col in columnName)
            {
                if (col == "LESSTITLE")
                {
                    sb.Append("<td style='width: 600px;'>" + col + "</td>");
                }
                else if (col == "LESSNOTE")
                {
                    sb.Append("<td style='width: 1789px;'>" + col + "</td>");
                }
                else
                {
                    sb.Append("<td>" + col + "</td>");
                }
            }

            sb.Append("</tr>");

            //Looping through the records
            foreach (DataRow dr in dataSet.Tables[0].Rows)
            {
                sb.Append("<tr>");
                foreach (DataColumn dc in dataSet.Tables[0].Columns)
                {
                    sb.Append("<td>&nbsp;" + dr[dc] + "</td>");  //Adding &nbsp; appears to have stopped Excel from auto-formatting text into date
                }
                sb.Append("</tr>");
            }

            sb.Append("</table>");

            //Writing StringBuilder content to an excel file.
            Response.Clear();
            Response.ClearContent();
            Response.ClearHeaders();
            Response.Charset = "";
            Response.Buffer = true;
            Response.ContentType = "application/vnd.ms-excel";
            Response.AddHeader("content-disposition", "attachment;filename=qryLessInfo.xls");
            Response.Write(sb.ToString());
            Response.Flush();
            Response.Close();
            */
        }

        DataSet GetRecordsFromDatabase()
        {
            DataSet dataSet = new DataSet();

            SqlConnection con = new SqlConnection();
            con.ConnectionString = ConfigurationManager.ConnectionStrings["Database1.mdf"].ConnectionString;
            SqlCommand cmd = new SqlCommand();
            cmd.CommandType = CommandType.Text;
            cmd.CommandText = "SELECT l.LESSNUMBER, l.LESSTITLE, ISNULL(r.REV, null) as LESSREV, CONVERT(varchar,l.REVDATE,101) as REVDATE, CONVERT(varchar,l.FEADATE,101) as FEADATE, ISNULL(s.STATUS, null) as STATUS, l.MP, l.LESSNOTE, " +
                "ISNULL(m.MEDIA, null) as MEDIAlku, l.LESS_DURATION, ISNULL(d.DURATION_PER, null) as LESS_PER FROM LESSON l LEFT JOIN MEDIAIku m on l.MEDIAIku=m.id LEFT JOIN DURATION_PER d on l.LESS_PER=d.id " +
                "LEFT JOIN STATUSIku s on l.STATUS=s.id LEFT JOIN REVIku r on l.LESSREV=r.id order by l.LESSID";
            cmd.Connection = con;

            SqlDataAdapter sqlDataAdapter = new SqlDataAdapter();
            sqlDataAdapter.SelectCommand = cmd;
            sqlDataAdapter.Fill(dataSet);

            return dataSet;
        }
    }
}