/*
  Check all the expected fields of a Lesson form against the original values kept
  in the given cache object
*/
const editLessonFormIsChanged = (cacheObj) => {
    if (
        $('#LESSNUMBER').val() != cacheObj.LESSNUMBER ||
        $('#LESSTITLE').val() != cacheObj.LESSTITLE ||
        $('#REV').val() != cacheObj.REVNUMBER ||
        $('#REVDATE').val() != cacheObj.REVDATE ||
        $('#MEDIATYPE').val() != cacheObj.MEDIANUMBER ||
        $('#SUBTYPE').val() != cacheObj.SUBTYPENUMBER ||
        $('#FEADATE').val() != cacheObj.FEADATE ||
        $('#STATUS').val() != cacheObj.STATUSNUMBER ||
        $('#CLASSIFICATION').val() != cacheObj.CLASSNUMBER ||
        $('#ICWL').val() != cacheObj.ICWL ||
        $('#MP').val() != cacheObj.MPNUMBER ||
        $('#LESSNOTE').val() != cacheObj.LESSNOTE ||
        $('#MESL').val() != cacheObj.MESL ||
        $("#FORMAC130J").prop("checked") != (cacheObj.AC130J == "True") ||
        $("#FORMHC130J").prop("checked") != (cacheObj.HC130J == "True") ||
        $("#FORMMC130J").prop("checked") != (cacheObj.MC130J == "True") ||
        $("#FORMUH1N").prop("checked") != (cacheObj.UH1N == "True") ||
        $("#FORMHH60").prop("checked") != (cacheObj.HH60 == "True") ||
        $("#FORMCV22").prop("checked") != (cacheObj.CV22 == "True") ||
        $("#FORMFTRUCKER").prop("checked") != (cacheObj.FTRUCKER == "True") ||
        $('#PRIMARYINSTRUCTOR').val() != cacheObj.PRIMARY_INSTRUCTOR_NUMBER ||
        $('#ALTERNATEINSTRUCTOR').val() != cacheObj.ALTERNATE_INSTRUCTOR_NUMBER
    )
        return true;
    else
        return false;
}

/*
  Raise a dialog box that warns the user of unsaved changes,
  and gives 2 or 3 choices of how to proceed:
  Yes (Save), No (Discard), and Cancel (Go back to form).
  The Cancel button (value="c") is optional - in some cases, it won't have any use.
  The dialog must have this structure at a minimum:

    <dialog id="changeAlert">
      <p>PROMPT MESSAGE HERE</p>
      <form method="dialog">
        <button value="n">Don't Save</button>
        <button value="y" autofocus>Save</button>
      </form>
    </dialog >
*/
const askUserAboutChanges = (dialogId, formId, closeFunc) => {
    const dlg = document.getElementById(dialogId);
    const onClose = () => {
        dlg.removeEventListener('close', onClose);
        switch (dlg.returnValue) {
            case 'y':
                // In case window.onbeforeunload has been set for the same reason we raised the dialog:
                window.onbeforeunload = null; // so that we don't get the "Leave site?" confirmation dialog
                document.getElementById(formId).requestSubmit();
                break;
            case 'n':
                closeFunc();
                break;
        }
    };
    dlg.addEventListener('close', onClose);
    dlg.showModal();
}
