﻿<%@ Page Title="Role Editor" Language="C#" MasterPageFile="~/Header.Master" AutoEventWireup="true" CodeBehind="Roles.aspx.cs" Inherits="CAE_WEB_PROJECT.CAT.Roles" %>
<asp:Content ID="Content1" ContentPlaceHolderID="head" runat="server">
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="ContentPlaceHolder1" runat="server">

<script type="text/javascript" src="../scripts/jquery-3.5.1.js"></script>
<script type="text/javascript" src="../scripts/jquery.dataTables.min.js"></script>
<link rel="stylesheet" href="../styles/jquery.dataTables.css" /> 

<script>   
    var selid;
    var member;
    var role;
    var role_status;
    $(document).ready(function () {        
        $('#example').dataTable({
            "bPaginate": false,
            "bLengthChange": false,
            "bFilter": true,
            "bInfo": false,
            "bAutoWidth": true,
            "scrollY": "400px",
            "sScrollX": "100%",
            "sScrollXInner": "100%",
            "scrollCollapse": true,
            "language": {
                "emptyTable": "No Admin Members"
            }
        });

        var table = $('#example').DataTable();

        $('#example tbody').on('click', 'tr', function () {
            if ($(this).hasClass('selected')) {
                $(this).removeClass('selected');
                selid = null;
            }
            else {
                table.$('tr.selected').removeClass('selected');
                $(this).addClass('selected');
                var data = table.row(this).data();
                savedata(data);
            }
        });
    });

    function savedata(rowdata) {
        member = rowdata[0];
        role = rowdata[1];
        role_status = rowdata[2];
        roleid = rowdata[3];
        selid = rowdata[4];
    }

    function adduser() {
        var modalcheck = document.getElementById("myModal2");
        if (modalcheck.style.display == "block") {
            modalcheck.style.display = "none";
        }

        // Get the modal
        var modal = document.getElementById("myModal");
        modal.style.display = "block";

        // Get the <span> element that closes the modal
        var span = document.getElementsByClassName("close")[0];

        // When the user clicks on <span> (x), close the modal
        span.onclick = function () {
            modal.style.display = "none";
        }

        // When the user clicks anywhere outside of the modal, close it
        window.onclick = function (event) {
            if (event.target == modal) {
                modal.style.display = "none";
            }
        }

        document.onkeydown = function (evt) {
            evt = evt;
            if (evt.key === 'Escape') {
                modal.style.display = "none";
            }
        };
    }

    function edituser() {
        if (selid == null) {
            alert("No row selected")
        }
        else {
            if (roleid == "4") {
                alert("Cannot change instructor role. Can only change status.");
                return false;
            }

            var modalcheck = document.getElementById("myModal");
            if (modalcheck.style.display == "block") {
                modalcheck.style.display = "none";
            }

            // Get the modal
            var modal = document.getElementById("myModal2");
            modal.style.display = "block";

            // Get the <span> element that closes the modal
            var span = document.getElementsByClassName("close2")[0];

            // When the user clicks on <span> (x), close the modal
            span.onclick = function () {
                modal.style.display = "none";
            }

            // When the user clicks anywhere outside of the modal, close it
            window.onclick = function (event) {
                if (event.target == modal) {
                    modal.style.display = "none";
                }
            }

            document.onkeydown = function (evt) {
                evt = evt;
                if (evt.key === 'Escape') {
                    modal.style.display = "none";
                }
            };

            $('#editid').val(selid);
            $('#editmembers').val(member);
            $('#editcatroles').val(roleid);
        }
    }

    function removeuser() {  
        if (selid == null) {
            alert("No row selected")
        }
        else {
            if (roleid == "4") {
                alert("Cannot remove instructor. Can only change status.");
                return false;
            }
            if (confirm("Are you sure that you want to remove this member from CAT roles?") == true) {
                window.location.href = "../CAT/removecatrole.aspx?selid=" + selid;
            } else {
                return;
            }
        }
    }

    function changestatus() {
        if (selid == null) {
            alert("No row selected")
        }
        else {
            if (roleid != "4") {
                alert("Can only change instructor status.");
                return false;
            }
            window.location.href = "../CAT/changecatrolestatus.aspx?selid=" + selid;
        }
    }
</script>

<style>
#main {
    overflow-x: hidden;
}
</style>

<br /><br />
 <div style="text-align: center; font-family:sans-serif;"><h1>Role Editor</h1></div>
<hr />

<div style="margin: 35px; min-width: 500px;">
<button class="button" onclick="adduser()">Add CAT Member</button>
<button class="button" onclick="edituser()">Edit Role</button>
<button class="button" onclick="changestatus()">Change Status</button>
<button class="button" onclick="removeuser()">Remove Member</button>
<br /><br />
<table id="example" class="display" style="width:100%; border: none">
        <thead style="background-color: #005EB8; color: white">
            <tr>                
                <th>CAT Members</th>        
                <th>Role</th>
                <th>Status</th>
                <th style="display:none;">Role ID</th>
                <th style="display:none;">ID</th>
            </tr>
        </thead>
        <tbody>
            <asp:Label ID="Label1" runat="server" />                          
        </tbody>
    </table>
</div>


<!-- The Modal -->
<div id="myModal" class="modal">
  <!-- Modal content -->
  <div class="modal-content" style="background-color: lightgray;">
    <span class="close">&times;</span>
      <br /><br />
       <h4 style="text-align: center">Add CAT Member</h4><br />
       <form class="form login" name="form1" action="../CAT/addcatmember.aspx" method="post" enctype="multipart/form-data">         
       <div class="form__field" style="color: black">           
            <select class="selectstyle" id="members" name="members" required="required">
                <asp:Label ID="Label2" runat="server" />
            </select>
       </div>  
       <div class="form__field" style="color: black">           
            <select class="selectstyle" id="catroles" name="catroles" required="required">
                <asp:Label ID="Label3" runat="server" />
            </select>
       </div>              
       <div class="form__field">
       <input type="submit" value="Add CAT Member" />
       </div>          
       </form>
  </div>
</div>

<!-- The Modal -->
<div id="myModal2" class="modal">
  <!-- Modal content -->
  <div class="modal-content" style="background-color: lightgray;">
    <span class="close2">&times;</span>
      <br /><br />
       <h4 style="text-align: center">Edit Role</h4><br />
       <form class="form login" name="form1" action="../CAT/editcatmember.aspx" method="post" enctype="multipart/form-data"> 
       <input type="hidden" name="editid" id="editid" /> 
       <div class="form__field" style="color: black">    
           <input style="color: white; background-color: black" type="text" name="editmembers" id="editmembers" required="required" readonly/>
       </div>  
       <div class="form__field" style="color: black">           
            <select class="selectstyle" id="editcatroles" name="editcatroles" required="required">
                <asp:Label ID="Label5" runat="server" />
            </select>
       </div>              
       <div class="form__field">
       <input type="submit" value="Update" />
       </div>          
       </form>
  </div>
</div>

</asp:Content>
