﻿<%@ Page Title="New SOI Build" Language="C#" MasterPageFile="~/Header.Master" AutoEventWireup="true" CodeBehind="newsoitable.aspx.cs" Inherits="CAE_WEB_PROJECT.SOITable.newsoitable" %>
<asp:Content ID="Content1" ContentPlaceHolderID="head" runat="server">
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="ContentPlaceHolder1" runat="server">
<script type="text/javascript" src="../scripts/jquery-3.5.1.js"></script>
<script type="text/javascript" src="../scripts/select2.min.js"></script>
<link rel="stylesheet" href="../styles/select2.min.css" />
<meta http-equiv='cache-control' content='no-cache'>
<meta http-equiv='expires' content='0'>
<meta http-equiv='pragma' content='no-cache'>
<script>
    $(document).ready(function () {
        $("#selSOI").select2();  
        createTable();
    });

    var removerowcounter = 0;
    var removedrow = 0;

    // Start ---> Must keep this code here even though it isn't really being used
    let arrHead = new Array();
    arrHead = ['', 'Day', 'Lesson', 'Duration', 'Pre Brief', 'Post Brief', '# of Missions', 'Pilot', 'Pilot Prereqs', 'CSO', 'CSO Prereqs', 'SMA', 'SMA Prereqs', 'LM', 'LM Prereqs'];      // table headers.

    // first create a TABLE structure by adding few headers.
    let createTable = () => {
        let empTable = document.createElement('table');
        empTable.setAttribute('id', 'empTable');  // table id.       
        let tr = empTable.insertRow(-1);
        for (let h = 0; h < arrHead.length; h++) {            
            let th = document.createElement('th'); // the header object.
            tr.setAttribute('id', 'tableheader');
            th.setAttribute('class', 'column' + h);
            th.innerHTML = arrHead[h];
            th.style.backgroundColor = "#005EB8";
            th.style.color = "white"; 
            //tr.appendChild(th);  //Removed the header because it was not working properly with drag and drop
        }

        let div = document.getElementById('cont');
        div.appendChild(empTable);    // add table to a container.
    }
    // End ---> Must keep this code here even though it isn't really being used

    // function to add new row.
    let addRow = () => {   
        document.getElementById("multirowsdiv").style.display = "none";
        document.getElementById('addRow').style.backgroundColor = "transparent"; 
        document.getElementById('addRow').style.color = "black";   
        document.getElementById("addRow").addEventListener("mouseover", function () {
            document.getElementById("addRow").style.backgroundColor = "#005EB8";
            document.getElementById("addRow").style.color = "white";
        });

        document.getElementById("addRow").addEventListener("mouseout", function () {
            document.getElementById("addRow").style.backgroundColor = "transparent";
            document.getElementById("addRow").style.color = "black";
        });       

        let empTab = document.getElementById('empTable');
        empTab.setAttribute('class', 'table-dragable');
        let rowCnt = empTab.rows.length;    // get the number of rows.
        
        if (removerowcounter != 0) {  
            //alert(removerowcounter);
            for (let j = 0; j <= rowCnt; j++) {
                if ($('#rownumber' + j).length === 0) {
                    //alert("Row " + j + " added.");
                    rowCnt = j;
                }
                else {
                    //alert("Row " + j + " already exists.");
                }
            }
            removerowcounter = removerowcounter - 1;
        }        

        let tr = empTab.insertRow(rowCnt); // table row.
        tr.setAttribute('id', 'rownumber' + rowCnt);
        tr.setAttribute('class', 'grabable');        

        $('.table-dragable tbody .grabable').mousedown(function (e) {
            var tr = $(e.target).closest('tr'), sy = e.pageY, drag;
            if ($(e.target).is('tr')) tr = $(e.target);
            var index = tr.index();           
            $(tr).addClass('grabbed');
            function move(e) {
                if (!drag && Math.abs(e.pageY - sy) < 10) return;                
                drag = true;
                tr.siblings().each(function () {
                    var s = $(this), i = s.index(), y = s.offset().top;
                    if (e.pageY >= y && e.pageY < y + s.outerHeight()) {
                        if (i < tr.index()) {
                            s.insertAfter(tr);                          
                        }
                        else {
                            s.insertBefore(tr);   
                        }
                        return false;
                    }
                });
            }
            function up(e) {
                if (drag && index != tr.index()) {
                    drag = false;
                }
                $(document).unbind('mousemove', move).unbind('mouseup', up);
                $(tr).removeClass('grabbed');
            }
            $(document).mousemove(move).mouseup(up);
        });

        for (let c = 0; c < arrHead.length; c++) {
            let td = document.createElement('td');          // table definition.           
            td = tr.insertCell(c);

            if (c == 0) {   // if its the first column of the table.
                // add a button control.
                const button = document.createElement('input');

                // set the attributes.
                if (rowCnt != 0) {
                    button.setAttribute('type', 'button');
                    button.setAttribute('class', 'removebutton');
                    button.setAttribute('value', 'Remove');
                    button.setAttribute('onclick', 'removeRow(this)');
                    td.appendChild(button);
                }
                else {
                    button.setAttribute('type', 'button');
                    button.setAttribute('class', 'removebutton');
                    button.setAttribute('value', 'Remove');
                    button.setAttribute('style', 'visibility: hidden');
                    td.appendChild(button);
                }
            }
            else if (c == 1) {
                // 2nd column will have textbox.
                const ele = document.createElement('input');
                ele.setAttribute('type', 'number');
                ele.setAttribute('min', '1');
                ele.setAttribute('id', 'day' + rowCnt);
                ele.setAttribute('class', 'dayinput');
                //alert(rowCnt);
                if (rowCnt == 0) {
                    ele.setAttribute('value', '1');
                    ele.setAttribute('readonly', 'readonly');
                }
                else {
                    ele.setAttribute('value', '');
                }
                td.appendChild(ele);
            }
            else if (c == 2) {
                // 3rd column will have dropdown
                const ele = document.createElement('select');
                ele.setAttribute('class', 'lessonselect');
                ele.setAttribute('id', 'lessonsel' + rowCnt);
                ele.value = "Select Lesson";
                ele.add(new Option("Select Lesson"));
                ele.setAttribute('onchange', 'checkmediatype(' + rowCnt + ')');
                $.get("../SOITable/getlessons.aspx", function (data) {
                    //alert(data);
                    const myArray = data.split("<!DOCTYPE html>");
                    var data = myArray[0];
                    //alert(myArray[0]); 
                    const myData = data.split("^");

                    for (let i = 0; i < myData.length - 1; i++) {
                        //alert(myData[i]);  
                        var optdata = myData[i];
                        const optvalue = optdata.split("~");
                        var option = document.createElement("option");
                        option.value = optvalue[0];
                        //option.text = optvalue[1] + " <" + optvalue[0] + ">";
                        option.text = optvalue[1];
                        ele.add(option);
                    }
                });
                td.appendChild(ele);
                $(".lessonselect").select2();
            }
            else if (c == 3) {
                // 4th column will have textbox.
                const ele = document.createElement('input');
                ele.setAttribute('type', 'number');
                ele.setAttribute('min', '0');
                ele.setAttribute('step', '0.1');
                ele.setAttribute('value', '0');
                ele.setAttribute('class', 'durationinput');
                ele.setAttribute('id', 'duration' + rowCnt);
                td.appendChild(ele);
            }
            else if (c == 4) {
                // 5th column will have textbox.
                const ele = document.createElement('input');
                ele.setAttribute('type', 'number');
                ele.setAttribute('min', '0');
                ele.setAttribute('step', '0.1');
                ele.setAttribute('value', '0');
                ele.setAttribute('class', 'prebriefinput');
                ele.setAttribute('id', 'prebrief' + rowCnt);
                td.appendChild(ele);
            }
            else if (c == 5) {
                // 6th column will have textbox.
                const ele = document.createElement('input');
                ele.setAttribute('type', 'number');
                ele.setAttribute('min', '0');
                ele.setAttribute('step', '0.1');
                ele.setAttribute('value', '0');
                ele.setAttribute('class', 'postbriefinput');
                ele.setAttribute('id', 'postbrief' + rowCnt);
                td.appendChild(ele);
            }
            else if (c == 6) {
                // 7th column will have textbox.
                const ele = document.createElement('input');
                ele.setAttribute('type', 'number');
                ele.setAttribute('min', '0');
                ele.setAttribute('value', '0');
                ele.setAttribute('class', 'missioninput');
                ele.setAttribute('id', 'mission' + rowCnt);
                td.appendChild(ele);
            }
            else if (c == 7) {
                // 8th column will have check box
                var checkboxdiv = document.createElement('div');
                checkboxdiv.style.minWidth = "70px";
                var checkbox = document.createElement('input');
                checkbox.type = "checkbox";
                checkbox.name = "Pilot";
                checkbox.value = "Pilot";
                checkbox.id = "Pilot" + rowCnt; 
                checkbox.setAttribute('class', 'cbclass');
                var label = document.createElement('label');
                label.appendChild(document.createTextNode(' Pilot '));
                label.setAttribute('class', 'checkboxlabels');
                td.appendChild(checkbox);
                td.appendChild(label);
                td.appendChild(checkboxdiv);
            }
            else if (c == 8) {
                // 9th column will have dropdown
                const ele = document.createElement('select');
                empTab.rows[rowCnt].cells.item(8).setAttribute("id", "pilottd" + rowCnt);
                ele.setAttribute('class', 'pilotprereqsel');
                ele.setAttribute('multiple', 'multiple');
                ele.setAttribute('id', 'pilotprereq' + rowCnt);
                ele.setAttribute('onchange', 'Pilotprereq(' + rowCnt + ')');
                //ele.value = "0";
                //ele.add(new Option("None"));
                $.get("../SOITable/getlessons.aspx", function (data) {
                    //alert(data);
                    const myArray = data.split("<!DOCTYPE html>");
                    var data = myArray[0];
                    //alert(myArray[0]); 
                    const myData = data.split("^");

                    for (let i = 0; i < myData.length - 1; i++) {
                        //alert(myData[i]);  
                        var optdata = myData[i];
                        const optvalue = optdata.split("~");
                        var option = document.createElement("option");
                        option.value = optvalue[0];
                        option.text = optvalue[1];
                        ele.add(option);
                    }
                });
                td.appendChild(ele);
                $(".pilotprereqsel").select2({
                    placeholder: "Select Pilot Prereqs"
                });
                /*
                setTimeout(function () {
                    $('#pilotprereq' + rowCnt).select2();
                    $('#pilotprereq' + rowCnt).select2().val("None");
                    $('#pilotprereq' + rowCnt).select2().trigger('change');
                }, 1000);
                */
            }
            else if (c == 9) {
                // 10th column will have check box
                var checkboxdiv = document.createElement('div');
                checkboxdiv.style.minWidth = "70px";
                var checkbox = document.createElement('input');
                checkbox.type = "checkbox";
                checkbox.name = "CSO";
                checkbox.value = "CSO";
                checkbox.id = "CSO" + rowCnt;
                checkbox.setAttribute('class', 'cbclass');
                checkbox.setAttribute('onclick', 'validateCSO(' + rowCnt + ')');
                var label = document.createElement('label');
                label.appendChild(document.createTextNode(' CSO '));
                label.setAttribute('class', 'checkboxlabels');
                td.appendChild(checkbox);
                td.appendChild(label);
                td.appendChild(checkboxdiv);
            }
            else if (c == 10) {
                // 11th column will have dropdown
                const ele = document.createElement('select');
                empTab.rows[rowCnt].cells.item(10).setAttribute("id", "csotd" + rowCnt);
                ele.setAttribute('class', 'csoprereqsel');
                ele.setAttribute('multiple', 'multiple');
                ele.setAttribute('id', 'csoprereq' + rowCnt);
                ele.setAttribute('onchange', 'CSOprereq(' + rowCnt + ')');
                //ele.value = "0";
                //ele.add(new Option("None"));
                $.get("../SOITable/getlessons.aspx", function (data) {
                    //alert(data);
                    const myArray = data.split("<!DOCTYPE html>");
                    var data = myArray[0];
                    //alert(myArray[0]); 
                    const myData = data.split("^");

                    for (let i = 0; i < myData.length - 1; i++) {
                        //alert(myData[i]);  
                        var optdata = myData[i];
                        const optvalue = optdata.split("~");
                        var option = document.createElement("option");
                        option.value = optvalue[0];
                        option.text = optvalue[1];
                        ele.add(option);
                    }
                });
                td.appendChild(ele);
                $(".csoprereqsel").select2({
                    placeholder: "Select CSO Prereqs"
                });
                /*
                setTimeout(function () {
                    $('#csoprereq' + rowCnt).select2();
                    $('#csoprereq' + rowCnt).select2().val("None");
                    $('#csoprereq' + rowCnt).select2().trigger('change');
                }, 1000);
                */
            }
            else if (c == 11) {
                // 12th column will have check box
                var checkboxdiv = document.createElement('div');
                checkboxdiv.style.minWidth = "70px";
                var checkbox = document.createElement('input');
                checkbox.type = "checkbox";
                checkbox.name = "SMA";
                checkbox.value = "SMA";
                checkbox.id = "SMA" + rowCnt;
                checkbox.setAttribute('class', 'cbclass');
                checkbox.setAttribute('onclick', 'validateSMA(' + rowCnt + ')');
                var label = document.createElement('label');
                label.appendChild(document.createTextNode(' SMA '));
                label.setAttribute('class', 'checkboxlabels');
                td.appendChild(checkbox);
                td.appendChild(label);
                td.appendChild(checkboxdiv);
            }
            else if (c == 12) {
                // 13th column will have dropdown
                const ele = document.createElement('select');
                empTab.rows[rowCnt].cells.item(12).setAttribute("id", "smatd" + rowCnt);
                ele.setAttribute('class', 'smaprereqsel');
                ele.setAttribute('multiple', 'multiple');
                ele.setAttribute('id', 'smaprereq' + rowCnt);
                ele.setAttribute('onchange', 'SMAprereq(' + rowCnt + ')');
                //ele.value = "0";
                //ele.add(new Option("None"));
                $.get("../SOITable/getlessons.aspx", function (data) {
                    //alert(data);
                    const myArray = data.split("<!DOCTYPE html>");
                    var data = myArray[0];
                    //alert(myArray[0]); 
                    const myData = data.split("^");

                    for (let i = 0; i < myData.length - 1; i++) {
                        //alert(myData[i]);  
                        var optdata = myData[i];
                        const optvalue = optdata.split("~");
                        var option = document.createElement("option");
                        option.value = optvalue[0];
                        option.text = optvalue[1];
                        ele.add(option);
                    }
                });
                td.appendChild(ele);
                $(".smaprereqsel").select2({
                    placeholder: "Select SMA Prereqs"
                });
                /*
                setTimeout(function () {
                    $('#smaprereq' + rowCnt).select2();
                    $('#smaprereq' + rowCnt).select2().val("None");
                    $('#smaprereq' + rowCnt).select2().trigger('change');
                }, 1000);
                */
            }
            else if (c == 13) {
                // 14th column will have check box
                var checkboxdiv = document.createElement('div');
                checkboxdiv.style.minWidth = "70px";
                var checkbox = document.createElement('input');
                checkbox.type = "checkbox";
                checkbox.name = "LM";
                checkbox.value = "LM";
                checkbox.id = "LM" + rowCnt;  
                checkbox.setAttribute('class', 'cbclass');                
                var label = document.createElement('label');         
                label.appendChild(document.createTextNode(' LM '));
                label.setAttribute('class', 'checkboxlabels');                 
                td.appendChild(checkbox);
                td.appendChild(label);
                td.appendChild(checkboxdiv);
            }
            else if (c == 14) {
                // 15th column will have dropdown
                const ele = document.createElement('select');
                empTab.rows[rowCnt].cells.item(14).setAttribute("id", "lmtd" + rowCnt);
                ele.setAttribute('class', 'lmprereqsel');
                ele.setAttribute('multiple', 'multiple');
                ele.setAttribute('id', 'lmprereq' + rowCnt);
                ele.setAttribute('onchange', 'LMprereq(' + rowCnt + ')');
                //ele.value = "0";
                //ele.add(new Option("None"));         
                $.get("../SOITable/getlessons.aspx", function (data) {
                    //alert(data);
                    const myArray = data.split("<!DOCTYPE html>");
                    var data = myArray[0];
                    //alert(myArray[0]); 
                    const myData = data.split("^");

                    for (let i = 0; i < myData.length - 1; i++) {
                        //alert(myData[i]);  
                        var optdata = myData[i];
                        const optvalue = optdata.split("~");
                        var option = document.createElement("option");
                        option.value = optvalue[0];
                        option.text = optvalue[1];
                        ele.add(option);                       
                    }
                });
                td.appendChild(ele);       
                $(".lmprereqsel").select2({
                    placeholder: "Select LM Prereqs"
                });  
                /*
                setTimeout(function () {
                    $('#lmprereq' + rowCnt).select2();
                    $('#lmprereq' + rowCnt).select2().val("None");
                    $('#lmprereq' + rowCnt).select2().trigger('change');
                }, 1000);
                */
            }  
        }
    }

    // function to delete a row.
    let removeRow = (oButton) => {
        let empTab = document.getElementById('empTable');        
        removedrow = oButton.parentNode.parentNode.rowIndex;
        //alert(removedrow);
        empTab.deleteRow(oButton.parentNode.parentNode.rowIndex); // buttton -> td -> tr
        removerowcounter++;
    }

    // function to extract and submit table data.
    let submit = () => {
        let myTab = document.getElementById('empTable');
        let arrValues = new Array();        
    
        // loop through each row of the table.
        for (let row of myTab.rows) {
            for (let cell of row.cells) {               
                if (cell.childNodes[0] != undefined) {
                    if (cell.childNodes[0].type == 'text' || cell.childNodes[0].nodeName == 'SELECT' || cell.childNodes[0].type == 'number' || cell.childNodes[0].type == 'checkbox') {
                        if (cell.childNodes[0].value != '' || cell.childNodes[0].hasAttribute("multiple")) {    
                            if (cell.childNodes[0].hasAttribute("multiple")) {
                                //alert(cell.childNodes[0].id); 
                                var nodeid = cell.childNodes[0].id.replace(/[0-9]/g, '');                      
                                //var rowid = cell.childNodes[0].id.slice(-1);
                                var rowid = cell.childNodes[0].id.replace(/[^0-9]/g, '');
                                //alert(nodeid);
                                if (nodeid == "pilotprereq") {
                                    var values = $('#pilotprereq' + rowid).val();
                                }
                                else if (nodeid == "csoprereq") {
                                    var values = $('#csoprereq' + rowid).val();
                                }
                                else if (nodeid == "smaprereq") {
                                    var values = $('#smaprereq' + rowid).val();
                                }
                                else if (nodeid == "lmprereq") {
                                    var values = $('#lmprereq' + rowid).val();
                                }  
                                //alert(values);
                                arrValues.push(values);         
                            }                            
                            else if (cell.childNodes[0].type == 'checkbox') {
                                var nodeid = cell.childNodes[0].id.replace(/[0-9]/g, '');                     
                                //alert(nodeid);
                                var Pilot = "False";
                                var CSO = "False";                               
                                var SMA = "False";
                                var LM = "False";
                                //var rowid = cell.childNodes[0].id.slice(-1);
                                var rowid = cell.childNodes[0].id.replace(/[^0-9]/g, '');
                                if (document.getElementById('Pilot' + rowid).checked) {
                                    var Pilot = "True";
                                } else {
                                    var Pilot = "False";
                                }
                                if (document.getElementById('CSO' + rowid).checked) {
                                    var CSO = "True";
                                } else {
                                    var CSO = "False";
                                }
                                if (document.getElementById('SMA' + rowid).checked) {
                                    var SMA = "True";
                                } else {
                                    var SMA = "False";
                                }
                                if (document.getElementById('LM' + rowid).checked) {
                                    var LM = "True";
                                } else {
                                    var LM = "False";
                                }

                                if (nodeid == "Pilot") {
                                    arrValues.push(Pilot);
                                }
                                else if (nodeid == "CSO") {
                                    arrValues.push(CSO);
                                }
                                else if (nodeid == "SMA") {
                                    arrValues.push(SMA);
                                }
                                else if (nodeid == "LM") {
                                    arrValues.push(LM);
                                }

                                //const checkboxArr = [Pilot, CSO, SMA, LM];
                                //alert(checkboxArr);
                                //let checkboxString = checkboxArr.toString();
                                //arrValues.push(checkboxString);
                                //alert("Pilot: " + Pilot + " CSO: " + CSO + " SMA: " + SMA + " LM: " + LM);
                            }                            
                            else {
                                arrValues.push(cell.childNodes[0].value);
                            }                            
                        }                            
                        else {
                            alert("All fields must be filled out!");
                            return;
                        }
                    }
                }
            }
        }

        // The final output.
        //document.getElementById('output').innerHTML = arrValues;
        //alert(arrValues);
        arrValues = arrValues.join("~");       
        //alert(arrValues);
                
        if (arrValues.indexOf('Select Lesson') >= 0) {
            alert("Must select a lesson for every row!");
            return false;
        }
        if (arrValues == "") {
            alert("No row added!");
            return false;
        }       

        var soiid = document.getElementById('selSOI').value;   
        $('#tabledata').val(arrValues);
        $('#soiid').val(soiid);
        document.getElementById("savedata").submit(); // Submitting form
    }

    // function to extract and submit table data.
    let submit2 = () => {
        let myTab = document.getElementById('empTable');
        let arrValues = new Array();

        // loop through each row of the table.
        for (let row of myTab.rows) {
            for (let cell of row.cells) {
                if (cell.childNodes[0] != undefined) {
                    if (cell.childNodes[0].type == 'text' || cell.childNodes[0].nodeName == 'SELECT' || cell.childNodes[0].type == 'number' || cell.childNodes[0].type == 'checkbox') {
                        if (cell.childNodes[0].value != '' || cell.childNodes[0].hasAttribute("multiple")) {
                            if (cell.childNodes[0].hasAttribute("multiple")) {
                                //alert(cell.childNodes[0].id); 
                                var nodeid = cell.childNodes[0].id.replace(/[0-9]/g, '');                
                                //var rowid = cell.childNodes[0].id.slice(-1);
                                var rowid = cell.childNodes[0].id.replace(/[^0-9]/g, '');
                                //alert(nodeid);
                                if (nodeid == "pilotprereq") {
                                    var values = $('#pilotprereq' + rowid).val();
                                }
                                else if (nodeid == "csoprereq") {
                                    var values = $('#csoprereq' + rowid).val();
                                }
                                else if (nodeid == "smaprereq") {
                                    var values = $('#smaprereq' + rowid).val();
                                }
                                else if (nodeid == "lmprereq") {
                                    var values = $('#lmprereq' + rowid).val();
                                }
                                //alert(values);
                                arrValues.push(values);
                            }
                            else if (cell.childNodes[0].type == 'checkbox') {
                                var nodeid = cell.childNodes[0].id.replace(/[0-9]/g, '');               
                                //alert(nodeid);
                                var Pilot = "False";
                                var CSO = "False";
                                var SMA = "False";
                                var LM = "False";
                                //var rowid = cell.childNodes[0].id.slice(-1);
                                var rowid = cell.childNodes[0].id.replace(/[^0-9]/g, '');
                                if (document.getElementById('Pilot' + rowid).checked) {
                                    var Pilot = "True";
                                } else {
                                    var Pilot = "False";
                                }
                                if (document.getElementById('CSO' + rowid).checked) {
                                    var CSO = "True";
                                } else {
                                    var CSO = "False";
                                }
                                if (document.getElementById('SMA' + rowid).checked) {
                                    var SMA = "True";
                                } else {
                                    var SMA = "False";
                                }
                                if (document.getElementById('LM' + rowid).checked) {
                                    var LM = "True";
                                } else {
                                    var LM = "False";
                                }

                                if (nodeid == "Pilot") {
                                    arrValues.push(Pilot);
                                }
                                else if (nodeid == "CSO") {
                                    arrValues.push(CSO);
                                }
                                else if (nodeid == "SMA") {
                                    arrValues.push(SMA);
                                }
                                else if (nodeid == "LM") {
                                    arrValues.push(LM);
                                }

                                //const checkboxArr = [Pilot, CSO, SMA, LM];
                                //alert(checkboxArr);
                                //let checkboxString = checkboxArr.toString();
                                //arrValues.push(checkboxString);
                                //alert("Pilot: " + Pilot + " CSO: " + CSO + " SMA: " + SMA + " LM: " + LM);
                            }
                            else {
                                arrValues.push(cell.childNodes[0].value);
                            }
                        }
                        else {                        
                            alert("All fields must be filled out!");
                            return;
                        }
                    }
                }
            }
        }

        // The final output.
        //document.getElementById('output').innerHTML = arrValues;
        //alert(arrValues);
        arrValues = arrValues.join("~");
        //alert(arrValues);

        if (arrValues.indexOf('Select Lesson') >= 0) {
            alert("Must select a lesson for every row!");
            return false;
        }
        if (arrValues == "") {
            alert("No row added!");
            return false;
        }     
    
        var soiid = document.getElementById('selSOI').value;    
        $('#templatetabledata').val(arrValues);        
        $('#templatesoiid').val(soiid);
       
        document.getElementById("savetemplate").submit(); // Submitting form
    }

    function loadsoitable() {
        var timeoutvalue = 1000;
        var dropdownid = document.getElementById('selSOI').value;        
        $("#empTable tr").remove();         
        document.getElementById("notemplate").style.display = "none";
        document.getElementById("yestemplate").style.display = "none";
        //use get method to get the template data for the soi selected      
        $.get("../SOITable/gettemplatedata.aspx?soiid=" + dropdownid, function (data) {
            //alert(data);
            const myArray = data.split("<!DOCTYPE html>");
            var data = myArray[0];           
            //alert(data);
            if (data == 0) {                
                //No template for this SOI
                document.getElementById("notemplate").style.display = "inline";
                document.getElementById("multirowsdiv").style.display = "inline";
                $('#bt2').val("Save New Template");
            }
            else {                
                //Populate table with template
                //alert(data);
                const myData = data.split("^");              
                const myData2 = data.split("^"); 
                const myData3 = data.split("^"); 
                const myData4 = data.split("^");
                //alert(myData.length);
                if (myData.length <= 10) {
                    timeoutvalue = 1000;
                }
                else if (myData.length > 10 && myData.length <= 15) {
                    timeoutvalue = 2000;
                }
                else if (myData.length > 15 && myData.length <= 20) {
                    timeoutvalue = 3000;
                }
                else if (myData.length > 20 && myData.length <= 25) {
                    timeoutvalue = 4000;
                }
                else if (myData.length > 25 && myData.length <= 30) {
                    timeoutvalue = 5000;
                }
                else if (myData.length > 30 && myData.length <= 35) {
                    timeoutvalue = 6000;
                }
                else if (myData.length > 35 && myData.length <= 40) {
                    timeoutvalue = 7000;
                }
                else if (myData.length > 40 && myData.length <= 45) {
                    timeoutvalue = 8000;
                }
                else if (myData.length > 45 && myData.length <= 50) {
                    timeoutvalue = 15000;
                }
                else if (myData.length > 50 && myData.length <= 55) {
                    timeoutvalue = 16000;
                }
                else if (myData.length > 55 && myData.length <= 60) {
                    timeoutvalue = 17000;
                }
                else if (myData.length > 60 && myData.length <= 65) {
                    timeoutvalue = 18000;
                }
                else if (myData.length > 65 && myData.length <= 70) {
                    timeoutvalue = 19000;
                }
                else if (myData.length > 70 && myData.length <= 75) {
                    timeoutvalue = 20000;
                }
                else if (myData.length > 75 && myData.length <= 80) {
                    timeoutvalue = 21000;
                }
                else {  //myData.length > 80
                    timeoutvalue = 22000;
                }
                //alert(timeoutvalue);

                for (let i = 0; i < myData.length - 1; i++) {                    
                    //alert(myData[i]);
                    var optdata = myData[i];
                    const optvalue = optdata.split("~");
                    //alert(optvalue[0]);
                    //alert(optvalue[1]);
                    addRow();
                    $('#day' + i).val(optvalue[0]); 
                    setTimeout(function () {
                        $('#lessonsel' + i).select2();
                        $('#lessonsel' + i).select2().val(optvalue[1]);
                        $('#lessonsel' + i).select2().trigger('change');
                    }, timeoutvalue);
                    $('#duration' + i).val(optvalue[2]);
                    $('#prebrief' + i).val(optvalue[3]);
                    $('#postbrief' + i).val(optvalue[4]);
                    $('#mission' + i).val(optvalue[5]);    
                    //alert(optvalue[6]);
                    //var pcslarray = optvalue[6].split(',');                   
                    //alert(pcslarray[0]);  //Pilot 
                    //alert(pcslarray[1]);  //CSO
                    //alert(pcslarray[2]);  //SMA
                    //alert(pcslarray[3]);  //LM
                    if (optvalue[6] == "True") {
                        $("#Pilot" + i).prop("checked", true);
                    }
                    else {
                        $("#Pilot" + i).prop("checked", false);
                    }
                    if (optvalue[8] == "True") {
                        $("#CSO" + i).prop("checked", true);            
                    }
                    else {
                        $("#CSO" + i).prop("checked", false);
                    }
                    if (optvalue[10] == "True") {
                        $("#SMA" + i).prop("checked", true);              
                    }
                    else {
                        $("#SMA" + i).prop("checked", false);
                    }
                    if (optvalue[12] == "True") {
                        $("#LM" + i).prop("checked", true);
                    }
                    else {
                        $("#LM" + i).prop("checked", false);
                    }     
                    
                    if (optvalue[7] == "None") {
                        /*
                        setTimeout(function () {
                            $('#pilotprereq' + i).select2();
                            $('#pilotprereq' + i).select2().val("None");
                            $('#pilotprereq' + i).select2().trigger('change');
                        }, 1000);
                        */
                    }
                    else {                            
                        //create unique array
                        myData[i] = JSON.parse("[" + optvalue[7] + "]");
                        setTimeout(function () {
                            $('#pilotprereq' + i).select2();
                            $('#pilotprereq' + i).select2().val(myData[i]);
                            $('#pilotprereq' + i).select2().trigger('change');
                        }, timeoutvalue);
                    }   

                    if (optvalue[9] == "None") {
                        /*
                        setTimeout(function () {
                            $('#csoprereq' + i).select2();
                            $('#csoprereq' + i).select2().val("None");
                            $('#csoprereq' + i).select2().trigger('change');
                        }, 1000);
                        */
                    }
                    else {
                        //create unique array
                        myData2[i] = JSON.parse("[" + optvalue[9] + "]");
                        setTimeout(function () {
                            $('#csoprereq' + i).select2();
                            $('#csoprereq' + i).select2().val(myData2[i]);
                            $('#csoprereq' + i).select2().trigger('change');
                        }, timeoutvalue);
                    }


                    if (optvalue[11] == "None") {
                        /*
                        setTimeout(function () {
                            $('#smaprereq' + i).select2();
                            $('#smaprereq' + i).select2().val("None");
                            $('#smaprereq' + i).select2().trigger('change');
                        }, 1000);
                        */
                    }
                    else {
                        //create unique array
                        myData3[i] = JSON.parse("[" + optvalue[11] + "]");
                        setTimeout(function () {
                            $('#smaprereq' + i).select2();
                            $('#smaprereq' + i).select2().val(myData3[i]);
                            $('#smaprereq' + i).select2().trigger('change');
                        }, timeoutvalue);
                    }

                    if (optvalue[13] == "None") {
                        /*
                        setTimeout(function () {
                            $('#lmprereq' + i).select2();
                            $('#lmprereq' + i).select2().val("None");
                            $('#lmprereq' + i).select2().trigger('change');
                        }, 1000);
                        */
                    }
                    else {
                        //create unique array
                        myData4[i] = JSON.parse("[" + optvalue[13] + "]");
                        setTimeout(function () {
                            $('#lmprereq' + i).select2();
                            $('#lmprereq' + i).select2().val(myData4[i]);
                            $('#lmprereq' + i).select2().trigger('change');
                        }, timeoutvalue);
                    }
                }
                document.getElementById("yestemplate").style.display = "inline";
                $('#bt2').val("Overwrite Template");
            }
        });
        
        if (dropdownid == 0) {
            document.getElementById("SOITable").style.display = "none";
        }
        else {
            document.getElementById("SOITable").style.display = "inline";
        }        
        
    }

    function validateSMA(rowCnt) {
        if ($("#SMA" + rowCnt).is(':checked')) {
            $("#CSO" + rowCnt).prop("checked", false);
        }     
    }
    function validateCSO(rowCnt){
        if ($("#CSO" + rowCnt).is(':checked')) {
            $("#SMA" + rowCnt).prop("checked", false);
        }   
    }

    function Pilotprereq(rowCnt) {
        var data = $('#pilotprereq' + rowCnt).val();
        var dataarray = JSON.parse("[" + data + "]");
        $("#pilottd" + rowCnt)[0].style.backgroundColor = 'white';
        for (let j = 0; j < dataarray.length; j++) {
            var prereqbool = 0;
            for (let i = 0; i < rowCnt; i++) {
                var lessonid = $('#lessonsel' + i).val();
                if (lessonid == dataarray[j]) {
                    prereqbool = 1;
                }
            }
            if (prereqbool == 0) {
                data = $('#pilotprereq' + rowCnt).val();
                if (data != "") {
                    //alert("Selected prereq is not a previous lesson on this build.");
                    $("#pilottd" + rowCnt)[0].style.backgroundColor = 'red';
                    //$("#select2-pilotprereq" + rowCnt + "-container")[0].style.color = 'red';
                }
            }  
        }

        if (data != "") {
            $("#Pilot" + rowCnt).prop("checked", true);
        }
        else {
            $("#Pilot" + rowCnt).prop("checked", false);
        }
    }

    function CSOprereq(rowCnt) {
        var data = $('#csoprereq' + rowCnt).val();
        var dataarray = JSON.parse("[" + data + "]");
        $("#csotd" + rowCnt)[0].style.backgroundColor = 'white';
        for (let j = 0; j < dataarray.length; j++) {
            var prereqbool = 0;
            for (let i = 0; i < rowCnt; i++) {
                var lessonid = $('#lessonsel' + i).val();
                if (lessonid == dataarray[j]) {
                    prereqbool = 1;
                }
            }
            if (prereqbool == 0) {
                data = $('#csoprereq' + rowCnt).val();
                if (data != "") {
                    //alert("Selected prereq is not a previous lesson on this build.");
                    $("#csotd" + rowCnt)[0].style.backgroundColor = 'red';
                }       
            }
        }

        if (data != "") {
            if ($("#SMA" + rowCnt).is(':checked')) {
                // do nothing
            }
            else {
                $("#CSO" + rowCnt).prop("checked", true);
            }
        }
        else {
            $("#CSO" + rowCnt).prop("checked", false);
        }
    }

    function SMAprereq(rowCnt) {
        var data = $('#smaprereq' + rowCnt).val();
        var dataarray = JSON.parse("[" + data + "]");
        $("#smatd" + rowCnt)[0].style.backgroundColor = 'white';
        for (let j = 0; j < dataarray.length; j++) {
            var prereqbool = 0;
            for (let i = 0; i < rowCnt; i++) {
                var lessonid = $('#lessonsel' + i).val();
                if (lessonid == dataarray[j]) {
                    prereqbool = 1;
                }
            }
            if (prereqbool == 0) {
                data = $('#smaprereq' + rowCnt).val();
                if (data != "") {
                    //alert("Selected prereq is not a previous lesson on this build.");
                    $("#smatd" + rowCnt)[0].style.backgroundColor = 'red';
                }
            }
        }

        if (data != "") {
            if ($("#CSO" + rowCnt).is(':checked')) {
                // do nothing
            }
            else {
                $("#SMA" + rowCnt).prop("checked", true);
            }
        }
        else {
            $("#SMA" + rowCnt).prop("checked", false);
        }
    }

    function LMprereq(rowCnt) {
        var data = $('#lmprereq' + rowCnt).val();
        var dataarray = JSON.parse("[" + data + "]");
        $("#lmtd" + rowCnt)[0].style.backgroundColor = 'white';
        for (let j = 0; j < dataarray.length; j++) {
            var prereqbool = 0;
            for (let i = 0; i < rowCnt; i++) {
                var lessonid = $('#lessonsel' + i).val();
                if (lessonid == dataarray[j]) {
                    prereqbool = 1;
                }
            }
            if (prereqbool == 0) {
                data = $('#lmprereq' + rowCnt).val();
                if (data != "") {
                    //alert("Selected prereq is not a previous lesson on this build.");
                    $("#lmtd" + rowCnt)[0].style.backgroundColor = 'red';
                }
            }
        }

        if (data != "") {
            $("#LM" + rowCnt).prop("checked", true);
        }
        else {
            $("#LM" + rowCnt).prop("checked", false);
        }
    }

    function handleChange(input) {
        if (input.value < 1) input.value = 1;
        if (input.value > 50) input.value = 50;
    }

    function insertrows() {  
        let empTab = document.getElementById('empTable');
        let rowCnt = empTab.rows.length;    // get the number of rows.
        let rowstoadd = document.getElementById('rowstoadd').value;
        let rowCntint = parseInt(rowCnt);
        let rowstoaddint = parseInt(rowstoadd);   
        let totalrows = rowCntint + rowstoaddint;        
        if (rowCntint != 0) {
            for (let i = 0; i < rowstoaddint; i++) {
                addRow();
            }
        }
        else {
            for (let i = 0; i < totalrows; i++) {
                addRow();
            }
        }    
    }

    function checkmediatype(rowCnt) {       
        //alert(rowCnt);
        var lessid = $('#lessonsel' + rowCnt).val();
        var duration = $('#duration' + rowCnt).val();
        var prebrief = $('#prebrief' + rowCnt).val();
        var postbrief = $('#postbrief' + rowCnt).val();
        //alert(lessid);
        if (lessid != "Select Lesson") {
            $.get("../SOITable/getmediatype.aspx?lessid=" + lessid, function (data) {
                const myArray = data.split("<!DOCTYPE html>");
                var data = myArray[0];
                //alert(data);
                if (data == 1) {
                    //alert("This is CAI");   
                    $("#duration" + rowCnt)[0].type = 'text';
                    $("#duration" + rowCnt)[0].style.backgroundColor = 'lightblue';
                    $("#duration" + rowCnt).val('R');
                    $("#duration" + rowCnt).prop("readonly", true);

                    $("#prebrief" + rowCnt)[0].type = 'text';
                    $("#prebrief" + rowCnt)[0].style.backgroundColor = 'lightblue';
                    $("#prebrief" + rowCnt).val('R');
                    $("#prebrief" + rowCnt).prop("readonly", true);

                    $("#postbrief" + rowCnt)[0].type = 'text';
                    $("#postbrief" + rowCnt)[0].style.backgroundColor = 'lightblue';
                    $("#postbrief" + rowCnt).val('R');
                    $("#postbrief" + rowCnt).prop("readonly", true);
                }
                else {
                    if (duration == 0 || duration == "R") {
                        $("#duration" + rowCnt)[0].type = 'number';
                        $("#duration" + rowCnt)[0].style.backgroundColor = 'white';
                        $("#duration" + rowCnt).val('0');
                        $("#duration" + rowCnt).prop("readonly", false);
                    }
                    if (prebrief == 0 || prebrief == "R") {
                        $("#prebrief" + rowCnt)[0].type = 'number';
                        $("#prebrief" + rowCnt)[0].style.backgroundColor = 'white';
                        $("#prebrief" + rowCnt).val('0');
                        $("#prebrief" + rowCnt).prop("readonly", false);
                    }
                    if (postbrief == 0 || postbrief == "R") {
                        $("#postbrief" + rowCnt)[0].type = 'number';
                        $("#postbrief" + rowCnt)[0].style.backgroundColor = 'white';
                        $("#postbrief" + rowCnt).val('0');
                        $("#postbrief" + rowCnt).prop("readonly", false);
                    }
                }
            });
        }
        else {
            if (duration == 0 || duration == "R") {
                $("#duration" + rowCnt)[0].type = 'number';
                $("#duration" + rowCnt)[0].style.backgroundColor = 'white';
                $("#duration" + rowCnt).val('0');
                $("#duration" + rowCnt).prop("readonly", false);
            }  
            if (prebrief == 0 || prebrief == "R") {
                $("#prebrief" + rowCnt)[0].type = 'number';
                $("#prebrief" + rowCnt)[0].style.backgroundColor = 'white';
                $("#prebrief" + rowCnt).val('0');
                $("#prebrief" + rowCnt).prop("readonly", false);
            }
            if (postbrief == 0 || postbrief == "R") {
                $("#postbrief" + rowCnt)[0].type = 'number';
                $("#postbrief" + rowCnt)[0].style.backgroundColor = 'white';
                $("#postbrief" + rowCnt).val('0');
                $("#postbrief" + rowCnt).prop("readonly", false);
            }
        }
    }
</script>


<style>
.table-dragable > tbody .grabable { cursor: grab; user-select: none }
.table-dragable > tbody > tr.grabbed {
  box-shadow: 0 0 10px 0 rgba(0,0,0,0.5);
}
.table-dragable > tbody > tr.grabbed:active * {
  cursor: grabbing !important;
}

    table { 
        width: 98%;
        margin: auto;
        left: 0;
        right: 0;
        top: 0;
        bottom: 0;
        background-color: white;
 -webkit-user-select: auto; /* Safari */
 -ms-user-select: none; /* IE 10+ and Edge */
 user-select: auto; /* Standard syntax */
    }
    table, th, td { 
        border: solid 1px #DDD;
        border-collapse: collapse; 
        padding: 2px 3px; 
        text-align: center;   
    }

.buttonstyle {
    background-color: transparent;
    font-family: "Poppins", sans-serif;
    border: solid;
    border-color: #005EB8;
    color: black;
    font-weight: 700;
    text-transform: uppercase;
    border-radius: 0.25rem;
    padding: 1rem;
    cursor: pointer;
    margin-left: 30px;
}

.buttonstyle:focus,
.buttonstyle:hover {
    background-color: #005EB8;
    color: white;
}

.removebutton {
    height: 30px;
    line-height: 3px;
    background-color: transparent;
    font-family: "Poppins", sans-serif;
    border: solid;
    border-color: #005EB8;
    color: black;
    font-weight: 700;
    text-transform: uppercase;
    border-radius: 0.25rem;
    padding: 1rem;
    cursor: pointer;
    margin-left: 30px;
}

.removebutton:focus,
.removebutton:hover {
    background-color: #005EB8;
    color: white;
}
input{
    color: black;
}
.lessonselect{
    width: 400px;
}
.pilotprereqsel{
    width: 400px;
}
.csoprereqsel{
    width: 400px;
}
.smaprereqsel{
    width: 400px;
}
.lmprereqsel{
    width: 400px;
}

.dayinput{
    border: 1px solid;
    font-weight: bold;
    font-size: 20px;
    text-align: center;
    width: 50px;
}
.durationinput{
    border: 1px solid;
    font-weight: bold;
    font-size: 20px;
    text-align: center;
    width: 70px;
}
.prebriefinput{
    border: 1px solid;
    font-weight: bold;
    font-size: 20px;
    text-align: center;
    width: 70px;
}
.postbriefinput{
    border: 1px solid;
    font-weight: bold;
    font-size: 20px;
    text-align: center;
    width: 70px;
}
.missioninput{
    border: 1px solid;
    font-weight: bold;
    font-size: 20px;
    text-align: center;
    width: 70px;
}
.checkboxlabels{
    width: 100px;  
}
.column0{
    width: 156.73px;
    min-width: 132.78px;
}
.column1{
    width: 67.28px;
    min-width: 57px;
}
.column2{
    width: 480.45px;
    min-width: 407px;
}
.column3{
    width: 90.89px;
    min-width: 77px;
}
.column4{
    width: 90.89px;
    min-width: 77px;
}
.column5{
    width: 90.89px;
    min-width: 77px;
}
.column6{
    width: 90.89px;
    min-width: 77px;
}
.column7{
    width: 90.89px;
    min-width: 77px;
}
.column8{
    width: 480.45px;
    min-width: 407px;
}
.column9{
    width: 90.89px;
    min-width: 77px;
}
.column10{
    width: 480.45px;
    min-width: 407px;
}
.column11{
    width: 90.89px;
    min-width: 77px;
}
.column12{
    width: 480.45px;
    min-width: 407px;
}
.column13{
    width: 90.89px;
    min-width: 77px;
}
.column14{
    width: 480.58px;
    min-width: 407px;
}
.cbclass{
    width: 25px;
    height: 25px;
}

.editlink{
    font-size: small;
    text-decoration: none;
    line-height: 30px;
}
.editlink:hover{
    text-decoration: underline;
}
#multirowsdiv{

    width: 260px;
    margin-left: 30px;
    margin-top: 10px;
    padding-left: 10px;
    padding-bottom: 10px;
    padding-right: 5px;
}
</style>

<br /><br />
 <div style="text-align: center; font-family:sans-serif;"><h1>New SOI Build</h1></div>
<hr />
<br />
<div style="text-align: center; min-width: 520px;">
    <select id="selSOI" style="width: 450px;" onchange="loadsoitable()">
        <asp:Label ID="Label3" runat="server" />
    </select>
    <a class='editlink' href='../CAT/EditSOI.aspx'>(edit list)</a>
</div>
    <div id="SOITable" style="display: none;">

    <div id="multirowsdiv" style="display: none;">
        Add <input type="number" min="1" value="1" max="99" id="rowstoadd" class="dayinput" onchange="handleChange(this);" style="width: 60px;" /> Row(s)<input type="button" style="margin-top: 10px;" class="buttonstyle" id="insertrows" value="Go" onclick="insertrows()" /> 
    </div>
    
        
        <span id="notemplate" style="display: none; float: right; border: 1px solid red; color:red; padding:3px; margin-right: 100px; margin-top: 30px; margin-bottom: 20px;">No Template Saved</span>    
        <span id="yestemplate" style="display: none; float: right; border: 1px solid green; color:green; padding:3px; margin-right: 100px; margin-top: 30px; margin-bottom: 20px;">Saved Template Loaded</span> 
  
    <table style="width: 98%; min-width: 1614.78px; background-color: #005EB8; color: white;">
    <thead>
    <tr>
    <th class="column0"></th>
    <th class="column1">Day</th>
    <th class="column2">Lesson</th>
    <th class="column3">Duration</th>
    <th class="column4">Pre Brief</th>
    <th class="column5">Post Brief</th>
    <th class="column6"># of Missions</th>
    <th class="column7">Pilot</th>
    <th class="column8">Pilot Prereqs</th>
    <th class="column9">CSO</th>
    <th class="column10">CSO Prereqs</th>
    <th class="column11">SMA</th>
    <th class="column12">SMA Prereqs</th>
    <th class="column13">LM</th>
    <th class="column14">LM Prereqs</th>
    </tr>
    </thead>
    </table>
    <div id="cont"></div>   <!--the container to add the table.-->
    <br />
    <div style="min-width: 500px;">
    <input type="button" style="margin-top: 10px;" class="buttonstyle" id="addRow" value="Add New Row" onclick="addRow()" />  
    <input type="button" style="margin-left: 0px;" class="buttonstyle" id="bt" value="Save Build" onclick="submit()" />
    <input type="button" style="margin-left: 0px;" class="buttonstyle" id="bt2" value="Save New Template" onclick="submit2()" />
    </div>
    <p id='output'></p>
    </div>

<br /><br /><br /><br /><br /><br />

<form name="savedata" id="savedata" method="post" enctype="multipart/form-data" action="../SOITable/savetabledata.aspx">
    <input style="width: 2000px;" type="hidden" id="tabledata" name="tabledata" />
    <input type="hidden" id="soiid" name="soiid" />
</form>

<form name ="savetemplate" id="savetemplate" method="post" enctype="multipart/form-data" action="../SOITable/savetemplate.aspx">
    <input type="hidden" id="templatetabledata" name="templatetabledata" />
    <input type="hidden" id="templatesoiid" name="templatesoiid" />
</form>


<script>

</script>
</asp:Content>
