﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.IO;
using System.Data;
using System.Data.OleDb;
using System.Data.SqlClient;
using System.Configuration;
using System.Text;
using OfficeOpenXml;
using System.Threading;

namespace CAE_WEB_PROJECT.CAT
{
    public partial class InactiveLessons : System.Web.UI.Page
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            ExcelPackage.LicenseContext = LicenseContext.NonCommercial;
            using (ExcelPackage excel = new ExcelPackage())
            {

                //Add Worksheets in Excel file
                excel.Workbook.Worksheets.Add("INACTIVELESSONS");

                //Create Excel file in Uploads folder of your project
                FileInfo excelFile = new FileInfo(Server.MapPath("~/files/INACTIVELESSONS.xlsx"));

                //Add header row columns name in string list array
                var headerRow = new List<string[]>()
                  {
                    new string[] { "LESSID", "LESSNUMBER", "LESSTITLE", "LESSREV", "REVDATE", "MEDIAlku", "FEADATE", "STATUS", "CLASSIFICATION", "ICWL", "MP", "LESSNOTE", "MESL", "HC130J", "MC130J", "UH1N", "HH60", "CV22", "FTRUCKER" }                
                  };

                // Get the header range
                string Range = "A1:" + Char.ConvertFromUtf32(headerRow[0].Length + 64) + "1";

                // get the workSheet in which you want to create header
                var worksheet = excel.Workbook.Worksheets["INACTIVELESSONS"];

                // Popular header row data
                worksheet.Cells[Range].LoadFromArrays(headerRow);

                int rowcounter = 2;
                string cs = System.Configuration.ConfigurationManager.ConnectionStrings["Database1.mdf"].ConnectionString;
                SqlConnection con = new SqlConnection(cs);
                con.Open();
                SqlCommand cmd = new SqlCommand("SELECT l.LESSID, l.LESSNUMBER, l.LESSTITLE, ISNULL(r.REV, null) as LESSREV, ISNULL(c.CLASSIFICATION, null) as CLASSIFICATION, CONVERT(varchar,l.REVDATE,101) as REVDATE, CONVERT(varchar,l.FEADATE,101) as FEADATE, ISNULL(s.STATUS, null) as STATUS, " +
                    "l.LESSNOTE, l.HC130J, l.MC130J, l.UH1N, l.HH60, l.CV22, l.FTRUCKER, l.MESL, ISNULL(m.MEDIA, null) as MEDIAlku, ISNULL(i.ICWL, null) as ICWL, ISNULL(p.MP, null) as MP FROM LESSON l LEFT JOIN MEDIAIku m on l.MEDIAIku=m.id LEFT JOIN " +
                    "STATUSIku s on l.STATUS=s.id LEFT JOIN REVIku r on l.LESSREV=r.id LEFT JOIN CLASSIFICATION c on l.CLASSIFICATION=c.id LEFT JOIN ICWL i on l.ICWL=i.id LEFT JOIN MP p on l.MP=p.id where l.STATUS=2 and l.MP!=1 order by l.LESSID");
                cmd.Connection = con;
                SqlDataReader reader = cmd.ExecuteReader();
                {
                    while (reader.Read())
                    {
                        string LESSID = reader["LESSID"].ToString();
                        string LESSNUMBER = reader["LESSNUMBER"].ToString();
                        string LESSTITLE = reader["LESSTITLE"].ToString();
                        string LESSREV = reader["LESSREV"].ToString();
                        string REVDATE = reader["REVDATE"].ToString();
                        string FEADATE = reader["FEADATE"].ToString();
                        string STATUS = reader["STATUS"].ToString();
                        string LESSNOTE = reader["LESSNOTE"].ToString();
                        string MEDIAlku = reader["MEDIAlku"].ToString();                       
                        string CLASSIFICATION = reader["CLASSIFICATION"].ToString();
                        string ICWL = reader["ICWL"].ToString();                      
                        string MP = reader["MP"].ToString();
                        string MESL = reader["MESL"].ToString();
                        string HC130J = reader["HC130J"].ToString();
                        string MC130J = reader["MC130J"].ToString();
                        string UH1N = reader["UH1N"].ToString();
                        string HH60 = reader["HH60"].ToString();                        
                        string CV22 = reader["CV22"].ToString();
                        string FTRUCKER = reader["FTRUCKER"].ToString();
                        //Table Rows
                        //Now add some data in rows for each column

                        var Data = new List<object[]>()
                            {
                              new object[] {LESSID,LESSNUMBER,LESSTITLE,LESSREV,REVDATE,MEDIAlku,FEADATE,STATUS,CLASSIFICATION,ICWL,MP,LESSNOTE,MESL,HC130J,MC130J,UH1N,HH60,CV22,FTRUCKER},                            
                            };
                        worksheet.Cells[rowcounter, 1].LoadFromArrays(Data);

                        //For some reason autofitcolumns was breaking this report, so I used column width instead
                        worksheet.DefaultColWidth = 15;
                        worksheet.Column(2).Width = 30;
                        worksheet.Column(3).Width = 60;
                        worksheet.Column(12).Width = 150;
                        worksheet.Column(13).Width = 150;
                        rowcounter++;
                    }
                }
                con.Dispose();

                //Save Excel file
                excel.SaveAs(excelFile);
            }
            byte[] fileBytes = System.IO.File.ReadAllBytes(Server.MapPath("~/files/INACTIVELESSONS.xlsx"));
            Response.Redirect("../files/INACTIVELESSONS.xlsx", false);
            Context.ApplicationInstance.CompleteRequest();
        }
    }
}