﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data.SqlClient;
using System.Configuration;
using System.Collections;
using System.Collections.Specialized;
using System.Reflection.Emit;

namespace CAE_WEB_PROJECT.CAT
{
    public partial class UpdateLesson : System.Web.UI.Page
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            if (Session["UserName"] == null)
            {
                Response.Write("<script>alert('Session Timeout')</script>");
                Response.Write("<script>window.location.href='../Default.aspx'</script>");
                return;
            }

            string catroles = "";
            string userid = Session["UserID"].ToString();
            string cs = System.Configuration.ConfigurationManager.ConnectionStrings["Database1.mdf"].ConnectionString;
            SqlConnection userCon = new SqlConnection(cs);
            userCon.Open();
            SqlCommand selUserCmd = new SqlCommand("SELECT catroles from Members where id=" + userid);
            selUserCmd.Connection = userCon;
            SqlDataReader userRdr = selUserCmd.ExecuteReader();
            {
                if (userRdr.Read())
                {
                    catroles = userRdr["catroles"].ToString();
                }
            }
            userCon.Dispose();
            switch (catroles)
            {
                case "1": case "2": case "3": case "4": case "5": case "7":
                    // The only roles allowed to change Lesson records
                    break;
                default:
                    // TODO: consider either (a) "Forbidden" or (b) just immediately send to the default page
                    Response.Write("<script>alert('Session Timeout')</script>");
                    Response.Write("<script>window.location.href='../Default.aspx'</script>");
                    return;
            }

            string urlreference = Request.QueryString["id"];

            DbToWeb lookup = new DbToWeb();
            NameValueCollection nvc = Request.Form;
            string selid = nvc["lessonid"];
            string LESSNUMBER = nvc["LESSNUMBER"];
            string LESSTITLE = nvc["LESSTITLE"];
            LESSTITLE = LESSTITLE.Replace("'", "''");
            string REV = nvc["REV"];
            string REVDATE = nvc["REVDATE"];
            string MEDIATYPE = nvc["MEDIATYPE"];
            string SUBTYPE = nvc["SUBTYPE"];
            string FEADATE = nvc["FEADATE"];
            string STATUS = nvc["STATUS"];
            string CLASSIFICATION = nvc["CLASSIFICATION"];
            string ICWL = nvc["ICWL"];
            //string LESSDURATION = nvc["LESSDURATION"];
            string LESSNOTE = nvc["LESSNOTE"];
            LESSNOTE = LESSNOTE.Replace("'", "''");
            string MESL = nvc["MESL"];
            MESL = MESL.Replace("'", "''");
            string MP = nvc["MP"];
            //string SPTTIME = nvc["SPTTIME"];
            string PRIMARY_INSTRUCTOR = nvc["PRIMARYINSTRUCTOR"];
            string ALTERNATE_INSTRUCTOR = nvc["ALTERNATEINSTRUCTOR"];

            // If you try to put an empty string into a datetime column,
            // it gets converted into the datetime value 1/1/1900 12:00:00 AM.
            // We don't want that. (Earlier version put cases of this in the db.)

            List<string> updateStmtList = new List<string>();
            if (catroles == "1")
            {
                updateStmtList.Add($"LESSNUMBER='{LESSNUMBER}', LESSTITLE='{LESSTITLE}', MEDIAIku={MEDIATYPE}");
                updateStmtList.Add("SUBTYPE=" + (string.IsNullOrEmpty(SUBTYPE) ? "NULL" : SUBTYPE));
                updateStmtList.Add("FEADATE=" + (string.IsNullOrEmpty(FEADATE) ? "NULL" : $"'{FEADATE}'"));
                updateStmtList.Add($"STATUS={STATUS}, MESL='{MESL}'");
                updateStmtList.Add("MP=" + (string.IsNullOrEmpty(MP) ? "NULL" : MP));
            }
            if (catroles == "1" || catroles == "3")
            {
                updateStmtList.Add("LESSREV=" + (string.IsNullOrEmpty(REV) ? "NULL" : $"'{REV}'"));
                updateStmtList.Add($"REVDATE=" + (string.IsNullOrEmpty(REVDATE) ? "NULL" : $"'{REVDATE}'"));
                updateStmtList.Add("ICWL=" + (string.IsNullOrEmpty(ICWL) ? "NULL" : ICWL));
            }
            if (catroles == "1" || catroles == "2" || catroles == "3")
            {
                updateStmtList.Add("CLASSIFICATION=" + (string.IsNullOrEmpty(CLASSIFICATION) ? "NULL" : CLASSIFICATION));
                updateStmtList.Add($"LESSNOTE='{LESSNOTE}'");
                // Applicable Airframes:
                string[] airframeNames = lookup.getAirframeNames(cs);
                uint airframeFlags = 0;
                foreach (string name in airframeNames)
                {
                    string colName = lookup.getAirframeColumnName(name);
                    if (nvc["FORM" + colName] == "on")
                    {
                        airframeFlags |= lookup.getAirframeFlagValue(name);
                        if (colName != "AC130J")
                            updateStmtList.Add(colName + "='True'");
                    }
                    else if (colName != "AC130J")
                    {
                        updateStmtList.Add(colName + "='False'");
                    }
                }
                updateStmtList.Add("airframes=" + airframeFlags);
                // NOTE the per-airframe columns will no longer need to be updated when all of the values
                // have been migrated to the airframes column
            }
            if (catroles == "1" || catroles == "4" || catroles == "5" || catroles == "7")
            {
                updateStmtList.Add("PRIMARY_INSTRUCTOR=" + (string.IsNullOrEmpty(PRIMARY_INSTRUCTOR) ? "NULL" : PRIMARY_INSTRUCTOR));
                updateStmtList.Add("ALTERNATE_INSTRUCTOR=" + (string.IsNullOrEmpty(ALTERNATE_INSTRUCTOR) ? "NULL" : ALTERNATE_INSTRUCTOR));
                // last field for catroles 1, 4, 5, and 7
            }

            SqlConnection con4 = new SqlConnection(cs);
            SqlCommand cmd4 = new SqlCommand("UPDATE LESSON SET " + string.Join(", ", updateStmtList.ToArray()) + " where id=" + selid, con4);
            con4.Open();
            cmd4.ExecuteNonQuery();
            con4.Dispose();

            string lessid = "";
            SqlConnection updateCon = new SqlConnection(cs);
            updateCon.Open();
            SqlCommand cmd7 = new SqlCommand("SELECT * from LESSON where id=" + selid);
            cmd7.Connection = updateCon;
            SqlDataReader reader7 = cmd7.ExecuteReader();
            {
                while (reader7.Read())
                {
                    lessid = reader7["lessid"].ToString();
                }
            }
            updateCon.Dispose();
            
            if (urlreference == "lesson")
            {
                Response.Write("<script>alert('Lesson Updated')</script>");
                Response.Write("<script>window.location.href='../CAT/Lesson.aspx?id=" + lessid + "&objid=0&questionid=0'</script>");             
            }
            else
            {
                Response.Write("<script>alert('Lesson Updated')</script>");
                Response.Write("<script>window.location.href='../CAT/EditLessons.aspx'</script>");
            }            
        }
    }
}