﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.IO;
using System.Data;
using System.Data.OleDb;
using System.Data.SqlClient;
using System.Configuration;
using System.Text;
using OfficeOpenXml;

namespace CAE_WEB_PROJECT.CAT.Reports
{
    public partial class AuditReport1 : System.Web.UI.Page
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            ExcelPackage.LicenseContext = LicenseContext.NonCommercial;
            using (ExcelPackage excel = new ExcelPackage())
            {
                var worksheet = excel.Workbook.Worksheets.Add("qryAUDIT_LESSNOMIs");
                var headerLabels = new List<string[]>()
                  {
                    new string[] { "SOITITLE", "SOIDATE", "LESSNUMBER", "LESSTITLE", "FEADATE", "LESSREV", "REVDATE", "MEDIAlku", "LESSNOTE", "OBJNUMBER", "OBJDESC", "RPL", "QUESTIONNUM", "QUESTIONDESC", "MESL" }
                  };
                string Range = "A1:" + Char.ConvertFromUtf32(headerLabels[0].Length + 64) + "1";
                var headerCells = worksheet.Cells[Range];
                headerCells.LoadFromArrays(headerLabels);
                headerCells.Style.Fill.PatternType = OfficeOpenXml.Style.ExcelFillStyle.Solid;
                headerCells.Style.Fill.BackgroundColor.SetColor(System.Drawing.Color.DeepSkyBlue);
                worksheet.View.FreezePanes(2, 1); // Freeze the header cells row

                int rowcounter = 2; // step past the header row, in preparation for adding data rows

                string cs = System.Configuration.ConfigurationManager.ConnectionStrings["Database1.mdf"].ConnectionString;
                SqlConnection con = new SqlConnection(cs);
                con.Open();
                SqlCommand cmd = new SqlCommand("SELECT SOI.SOITITLE, CONVERT(varchar,SOI.SOIDATE,101) as SOIDATE, LESSON.LESSNUMBER, LESSON.LESSTITLE, CONVERT(varchar,LESSON.FEADATE,101) as FEADATE, ISNULL(r.REV, null) as LESSREV, CONVERT(varchar,LESSON.REVDATE,101) as " +
                    "REVDATE, ISNULL(m.MEDIA, null) as MEDIAlku, LESSON.LESSNOTE, OBJECTIVES.OBJNUMBER, OBJECTIVES.OBJDESC, OBJECTIVES.RPL, QUESTION.QUESTIONNUM, QUESTION.QUESTIONDESC, LESSON.MESL FROM SOI INNER JOIN(((LESSON INNER JOIN (OBJECTIVES LEFT " +
                    "JOIN SOIMI2OBJ ON OBJECTIVES.[OBJID] = SOIMI2OBJ.[OBJIDfk]) ON LESSON.LESSID = OBJECTIVES.LESSIDfk) INNER JOIN SOILESS ON LESSON.LESSID = SOILESS.LESSIDfk) INNER JOIN QUESTION ON OBJECTIVES.OBJID = QUESTION.OBJIDfk) ON SOI.SOIID = SOILESS.SOIIDfk LEFT " +
                    "JOIN REVIku r on LESSON.LESSREV=r.id LEFT JOIN MEDIAIku m on LESSON.MEDIAIku=m.id WHERE SOIMI2OBJ.OBJIDfk Is Null and LESSON.MP!=1 order by LESSON.LESSID");
                cmd.Connection = con;
                SqlDataReader reader = cmd.ExecuteReader();
                {
                    while (reader.Read())
                    {                                       
                        string SOITITLE = reader["SOITITLE"].ToString();
                        string SOIDATE = reader["SOIDATE"].ToString();                      
                        string LESSNUMBER = reader["LESSNUMBER"].ToString();
                        string LESSTITLE = reader["LESSTITLE"].ToString();
                        string FEADATE = reader["FEADATE"].ToString();
                        string LESSREV = reader["LESSREV"].ToString();
                        string REVDATE = reader["REVDATE"].ToString();
                        string MEDIAlku = reader["MEDIAlku"].ToString();                     
                        string LESSNOTE = reader["LESSNOTE"].ToString();
                        string OBJNUMBER = reader["OBJNUMBER"].ToString();            
                        string OBJDESC = reader["OBJDESC"].ToString();
                        string RPL = reader["RPL"].ToString();
                        string QUESTIONNUM = reader["QUESTIONNUM"].ToString();       
                        string QUESTIONDESC = reader["QUESTIONDESC"].ToString();
                        string MESL = reader["MESL"].ToString();

                        var Data = new List<object[]>()
                            {
                              new object[] {SOITITLE,SOIDATE,LESSNUMBER,LESSTITLE,FEADATE,LESSREV,REVDATE,MEDIAlku,LESSNOTE,OBJNUMBER,OBJDESC,RPL,QUESTIONNUM,QUESTIONDESC,MESL},
                            };
                        worksheet.Cells[rowcounter, 1].LoadFromArrays(Data);
                        //worksheet.Cells[worksheet.Dimension.Address].AutoFitColumns(); // no no no
                        worksheet.DefaultColWidth = 15;
                        worksheet.Column(1).Width = 40;
                        worksheet.Column(3).Width = 45;
                        worksheet.Column(4).Width = 70;
                        worksheet.Column(9).Width = 120;
                        worksheet.Column(11).Width = 120;
                        worksheet.Column(14).Width = 120;
                        worksheet.Column(15).Width = 120;
                        rowcounter++;
                    }
                }
                con.Dispose();

                FileInfo excelFile = new FileInfo(Server.MapPath("~/files/qryAUDIT_LESSNOMIs.xlsx"));
                excel.SaveAs(excelFile);
            }
            // Previous author may have introduced the following line in preparation to stream bytes to the user? But not being used here...
            //byte[] fileBytes = System.IO.File.ReadAllBytes(Server.MapPath("~/files/qryAUDIT_LESSNOMIs.xlsx"));
            Response.Redirect("../files/qryAUDIT_LESSNOMIs.xlsx", false);
            Context.ApplicationInstance.CompleteRequest();            
        }
    }
}