﻿<%@ Page Title="SOI Manager" Language="C#" MasterPageFile="~/Header.Master" AutoEventWireup="true" CodeBehind="EditSOI.aspx.cs" Inherits="CAE_WEB_PROJECT.CAT.EditSOI" %>
<asp:Content ID="Content1" ContentPlaceHolderID="head" runat="server">
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="ContentPlaceHolder1" runat="server">

<link rel="stylesheet" type="text/css" href="../styles/main.css" />
<link rel="stylesheet" type="text/css" href="../styles/jquery-ui.css" />
<script type="text/javascript" src="../scripts/jquery-3.5.1.js"></script>
<script type="text/javascript" src="../scripts/main.js"></script>    
<script type="text/javascript" src="../scripts/jquery-ui.min.js"></script>

<script type="text/javascript" src="../scripts/jquery.dataTables.min.js"></script>
<link rel="stylesheet" href="../styles/jquery.dataTables.css" /> 
   
<script>
    var SOIID;
    var SOITITLE;
    var SOIDATE;
    var SOISTATUS;
    var AIRFRAME;
    var SOINOTE;
    var STATUSID;
    var AIRFRAMEID;
    var selid;

    $(document).ready(function () {   
        $(function () {
            $("#SOIDate").datepicker({
                changeMonth: true,
                changeYear: true
            });
            $("#EditSOIDate").datepicker({
                changeMonth: true,
                changeYear: true
            });
        });

        $('#example').dataTable({
            "bPaginate": false,
            "bLengthChange": false,
            "bFilter": true,
            "bInfo": true,
            "bAutoWidth": true,
            "scrollY": "400px",
            "sScrollX": "100%",
            "sScrollXInner": "100%",
            "scrollCollapse": true,
            "language": {
                "emptyTable": "No SOIs"
            }
        });

        var table = $('#example').DataTable();

        $('#example tbody').on('click', 'tr', function () {
            if ($(this).hasClass('selected')) {
                $(this).removeClass('selected');
                selid = null;               
            }
            else {
                table.$('tr.selected').removeClass('selected');
                $(this).addClass('selected');   
                var data = table.row(this).data();
                savedata(data);
            }          
        });       
    }); 

    function savedata(rowdata) {
        SOIID = rowdata[0];
        SOITITLE = rowdata[1];
        SOIDATE = rowdata[2];
        SOISTATUS = rowdata[3];
        AIRFRAME = rowdata[4];
        SOINOTE = rowdata[5];
        STATUSID = rowdata[6];
        AIRFRAMEID = rowdata[7];
        selid = rowdata[8];  
    }

    function addSOI() {
        var modalcheck = document.getElementById("myModal2");
        if (modalcheck.style.display == "block") {
            modalcheck.style.display = "none";
        }

        // Get the modal
        var modal = document.getElementById("myModal");
        modal.style.display = "block";

        // Get the <span> element that closes the modal
        var span = document.getElementsByClassName("close")[0];

        // When the user clicks on <span> (x), close the modal
        span.onclick = function () {
            modal.style.display = "none";
        }

        // When the user clicks anywhere outside of the modal, close it
        window.onclick = function (event) {
            if (event.target == modal) {
                modal.style.display = "none";
            }
        }

        document.onkeydown = function (evt) {
            evt = evt;
            if (evt.key === 'Escape') {
                modal.style.display = "none";
            }
        };        
    }

    function editdata() {     
        if (selid == null) {
            alert("No row selected")
        }
        else {
            var modalcheck = document.getElementById("myModal");
            if (modalcheck.style.display == "block") {
                modalcheck.style.display = "none";
            }

            // Get the modal
            var modal = document.getElementById("myModal2");
            modal.style.display = "block";

            // Get the <span> element that closes the modal
            var span = document.getElementsByClassName("close2")[0];

            // When the user clicks on <span> (x), close the modal
            span.onclick = function () {
                modal.style.display = "none";
            }

            // When the user clicks anywhere outside of the modal, close it
            window.onclick = function (event) {
                if (event.target == modal) {
                    modal.style.display = "none";
                }
            }

            document.onkeydown = function (evt) {
                evt = evt;
                if (evt.key === 'Escape') {
                    modal.style.display = "none";
                }
            };

            $('#editid').val(selid);
            $('#EditSOITitle').val(SOITITLE);
            $('#EditSOIDate').val(SOIDATE);
            $('#EditSOIStatus').val(STATUSID);
            $('#EditAirframe').val(AIRFRAMEID);
            $('#EditSOINote').val(SOINOTE);  
        }        
    }

    function deletedata() {
        if (selid == null) {
            alert("No row selected")
        }
        else {
            if (confirm("Are you sure that you want to delete this SOI? This will delete the SOI, all of its associated MIs, and the MIs that are attached to the objectives.") == true) {          
                window.location.href = "../CAT/deleteSOI.aspx?selid=" + selid;
            } else {
                return;
            }            
        }
    }

    function viewMI() {
        if (selid == null) {
            alert("No row selected")
        }
        else {
            window.location.href = "../CAT/viewMI.aspx?id=" + SOIID + "&CTSID=0";
        }
    }

    function checkDate(form) {
        var SOIdateString = form.SOIDate.value;

        if (SOIdateString == "") {
            //do nothing
        }
        else {
            // First check for the pattern
            if (!/^\d{1,2}\/\d{1,2}\/\d{4}$/.test(SOIdateString)) {
                alert("ERROR: Date must be valid!");
                return false;
            }

            // Parse the date parts to integers
            var parts = SOIdateString.split("/");
            var month = parseInt(parts[0], 10);
            var year = parseInt(parts[2], 10);

            // Check the ranges of month and year
            if (year < 1000 || year > 3000 || month == 0 || month > 12) {
                alert("ERROR: Date must be valid!");
                return false;
            }
        }
    }

    function checkDate2(form) {
        var SOIdateString = form.EditSOIDate.value;

        if (SOIdateString == "") {
            //do nothing
        }
        else {
            // First check for the pattern
            if (!/^\d{1,2}\/\d{1,2}\/\d{4}$/.test(SOIdateString)) {
                alert("ERROR: Date must be valid!");
                return false;
            }

            // Parse the date parts to integers
            var parts = SOIdateString.split("/");
            var month = parseInt(parts[0], 10);
            var year = parseInt(parts[2], 10);

            // Check the ranges of month and year
            if (year < 1000 || year > 3000 || month == 0 || month > 12) {
                alert("ERROR: Date must be valid!");
                return false;
            }
        }
    }
</script>

<style>
#main {
    overflow-x: hidden;
}

@media screen and (max-width: 1300px) {
  #myModal{
        width: 525px;
    }
  #myModal2{
        width: 525px;
    }
}

.modal{
    width: 1700px;
}
</style>

<br /><br />
 <div style="text-align: center; font-family:sans-serif;"><h1>SOI Manager</h1></div>
<hr />
<div id="SOITable" style="margin: 35px;">
<div style="min-width: 500px;">
<button class="button" onclick="addSOI()">Add New</button>
<button class="button" onclick="editdata()">Edit Row</button>
<button class="button" onclick="deletedata()">Delete Row</button>
<button class="button" onclick="viewMI()">Add / View MIs</button>
</div>

<br /><br />
<table id="example" class="display" style="width:100%; border: none">
        <thead style="background-color: #005EB8; color: white">
            <tr>                
                <th>SOI ID</th>
                <th>SOI Title</th>    
                <th>SOI Date</th>  
                <th>SOI Status</th>                 
                <th>Airframe</th>
                <th>SOI Note</th>  
                <th style="display:none;">Status ID</th>
                <th style="display:none;">Airframe ID</th>
                <th style="display:none;">ID</th>
            </tr>
        </thead>
        <tbody>
            <asp:Label ID="Label1" runat="server" />                          
        </tbody>
    </table>
</div>

<!-- The Modal -->
<div id="myModal" class="modal">
  <!-- Modal content -->
  <div class="modal-content" style="background-color: lightgray;">
    <span class="close">&times;</span>
      <br /><br />
       <h4 style="text-align: center">Add New SOI</h4><br />
       <form class="form login" name="form1" action="../CAT/addSOI.aspx" method="post" enctype="multipart/form-data" onsubmit="return checkDate(this)">
       <div class="form__field">
       <input style="color: white" type="text" name="SOITitle" id="SOITitle" placeholder="SOI Title" required="required"/>
       </div>
       <div class="form__field" style="color: black">
       <input id="SOIDate" name="SOIDate" type="text" placeholder="SOI Date" style="color: white" autocomplete="off" required="required" />
       </div>
       <div class="form__field" style="color: black">
            <select class="selectstyle" id="SOIStatus" name="SOIStatus" style="width: 100%;" required>
                 <asp:Label ID="Label2" runat="server" />  
            </select>
       </div>
       <div class="form__field" style="color: black">
            <select class="selectstyle" id="Airframe" name="Airframe" style="width: 100%;" required>
                 <asp:Label ID="Label3" runat="server" />  
            </select>
       </div>
       <div class="form__field">
       <textarea class="textareastyle" name="SOINote" id="SOINote" placeholder="SOI Note" style="resize: none;"></textarea>
       </div> 
       <div class="form__field">
       <input type="submit" value="Submit" style="width: 300px;" />
       </div>          
       </form>
  </div>
</div>

<!-- The Modal -->
<div id="myModal2" class="modal">
  <!-- Modal content -->
  <div class="modal-content" style="background-color: lightgray;">
    <span class="close2">&times;</span>
      <br /><br />
       <h4 style="text-align: center">Edit SOI</h4><br />
       <form class="form login" name="form1" action="../CAT/editSOIrow.aspx" method="post" enctype="multipart/form-data" onsubmit="return checkDate2(this)">
       <input type="hidden" name="editid" id="editid" />   
       <div class="form__field">
       <input style="color: white" type="text" name="EditSOITitle" id="EditSOITitle" placeholder="SOI Title" required="required"/>
       </div>
       <div class="form__field" style="color: black">
       <input id="EditSOIDate" name="EditSOIDate" type="text" placeholder="SOI Date" style="color: white" autocomplete="off" required="required" />
       </div>
       <div class="form__field" style="color: black">
            <select class="selectstyle" id="EditSOIStatus" name="EditSOIStatus" style="width: 100%;" required>
                 <asp:Label ID="Label4" runat="server" />  
            </select>
       </div>
       <div class="form__field" style="color: black">
            <select class="selectstyle" id="EditAirframe" name="EditAirframe" style="width: 100%;" required>
                 <asp:Label ID="Label5" runat="server" />  
            </select>
       </div>
       <div class="form__field">
       <textarea class="textareastyle" name="EditSOINote" id="EditSOINote" placeholder="SOI Note" style="resize: none;"></textarea>
       </div> 
       <div class="form__field">
       <input type="submit" value="Update" style="width: 300px;" />
       </div>          
       </form>
  </div>
</div>

</asp:Content>
