﻿<%@ Page Title="Lesson Manager" Language="C#" MasterPageFile="~/Header.Master" AutoEventWireup="true" CodeBehind="EditLessons.aspx.cs" Inherits="CAE_WEB_PROJECT.CAT.EditLessons" %>
<asp:Content ID="Content1" ContentPlaceHolderID="head" runat="server">
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="ContentPlaceHolder1" runat="server">

<link rel="stylesheet" type="text/css" href="../styles/main.css" />
<link rel="stylesheet" type="text/css" href="../styles/jquery-ui.css" />
<script type="text/javascript" src="../scripts/jquery-3.5.1.js"></script>
<script type="text/javascript" src="../scripts/main.js"></script>
<script type="text/javascript" src="../scripts/jquery-ui.min.js"></script>

<script type="text/javascript" src="../scripts/jquery.dataTables.min.js"></script>
<link rel="stylesheet" href="../styles/jquery.dataTables.css" />

<script src="../scripts/catformlib.js"></script>

<script>
    const lessonCache = {};

    $(document).ready(function () {
        $(function () {
            $("#REVDATE").datepicker({
                changeMonth: true,
                changeYear: true
            });
            $("#FEADATE").datepicker({
                changeMonth: true,
                changeYear: true
            });
        });

        //bPaginate is true because otherwise the search field reaction time is slow
        $.ajax({
            url: 'getlessons.asmx/GetLessons',
            method: 'post',
            dataType: 'json',
            success: function (data) {
                $('#example').dataTable({
                    "bPaginate": false,
                    "bLengthChange": false,
                    "bFilter": true,
                    "bInfo": true,
                    "bAutoWidth": true,
                    "scrollY": "400px",
                    "sScrollX": "100%",
                    "sScrollXInner": "110%",
                    "scrollCollapse": true,
                    "language": {
                        "emptyTable": "No Lessons"
                    },
                    data: data,
                    columns: [
                        { 'data': 'LESSID' },
                        { 'data': 'LESSNUMBER' },
                        { 'data': 'LESSTITLE' },
                        { 'data': 'REV' },
                        { 'data': 'REVDATE' },
                        { 'data': 'MEDIA' },
                        { 'data': 'SUBTYPE' },
                        { 'data': 'FEADATE' },
                        { 'data': 'LESS_STATUS' },
                        { 'data': 'LESS_CLASSIFICATION' },
                        { 'data': 'ICWL' },
                        //{ 'data': 'LESS_DURATION' },
                        { 'data': 'MP' },
                        //{ 'data': 'SPTTIME' },
                        { 'data': 'LESSNOTE' },
                        { 'data': 'MESL' },
                        { 'data': 'Airframes' },
                        { 'data': 'PRIMARY_INSTRUCTOR' },
                        { 'data': 'ALTERNATE_INSTRUCTOR' },
                        { 'data': 'AC130J', "visible": false },
                        { 'data': 'HC130J', "visible": false },
                        { 'data': 'MC130J', "visible": false },
                        { 'data': 'UH1N', "visible": false },
                        { 'data': 'HH60', "visible": false },
                        { 'data': 'CV22', "visible": false },
                        { 'data': 'FTRUCKER', "visible": false },
                        { 'data': 'REVNUMBER', "visible": false },
                        { 'data': 'MEDIANUMBER', "visible": false },
                        { 'data': 'SUBTYPENUMBER', "visible": false },
                        { 'data': 'STATUSNUMBER', "visible": false },
                        { 'data': 'CLASSNUMBER', "visible": false },
                        { 'data': 'MPNUMBER', "visible": false },
                        { 'data': 'PRIMARY_INSTRUCTOR_NUMBER', "visible": false },
                        { 'data': 'ALTERNATE_INSTRUCTOR_NUMBER', "visible": false },
                        { 'data': 'Id', "visible": false }
                    ],
                    initComplete: function () {
                        // Without the setTimeout, this action happens before the table gets drawn!
                        // Despite what the manual says!
                        // We want the function to run *after* the table is drawn & styled with all data loaded.
                        setTimeout(() => {
                            $('#loader').hide();
                            $('#CTSTable').css('visibility', 'visible');
                        }, 0);
                    }
                });
                var table = $('#example').DataTable();

                $('#example tbody').on('click', 'tr', function () {
                    if ($(this).hasClass('selected')) {
                        $(this).removeClass('selected');
                        lessonCache.Id = null;
                    }
                    else {
                        table.$('tr.selected').removeClass('selected');
                        $(this).addClass('selected');
                        var data = table.row(this).data();
                        //const myJSON = JSON.stringify(data);
                        //alert(myJSON);
                        cacheData(data);
                    }
                });

                const dlg = document.getElementById('changeAlert');
                dlg.addEventListener('keydown', function(ev) {
                    // Make Esc equivalent to the Cancel button:
                    if (ev.key === 'Escape') this.returnValue = 'c';
                });
            }
        });
    });

    function cacheData(rowdata) {
        Object.assign(lessonCache, rowdata);
    }

    const clearForm = () => {
        document.getElementById('lessonForm').reset();
        $('#lessonid').val('');
    };

    const newFormIsChanged = () => {
        const inputNames = [
            'LESSNUMBER', 'LESSTITLE', 'REVDATE', 'FEADATE', 'LESSNOTE', 'MESL'
        ];
        for (const name of inputNames) {
            if ($('#' + name).val() != '') {
                console.log('newFormIsChanged: it was', name);
                return true;
            }
        }
        const selectNames = [
            'REV', 'MEDIATYPE', 'SUBTYPE', 'STATUS', 'CLASSIFICATION', 'ICWL', 'MP', 'PRIMARYINSTRUCTOR', 'ALTERNATEINSTRUCTOR'
        ];
        for (const name of selectNames) {
            const val = $('#' + name).val();
            if (val && val != '0') {
                console.log('newFormIsChanged: it was', name);
                return true;
            }
        }
        const cbxNames = [
            'FORMHC130J', 'FORMMC130J', 'FORMUH1N', 'FORMHH60', 'FORMCV22', 'FORMFTRUCKER'
        ]
        for (const name of cbxNames) {
            const $box = $('#' + name);
            if ($box.prop('checked') != $box.prop('defaultChecked')) {
                console.log('newFormIsChanged: it was', name);
                return true;
            }
        }
        return false;
    }

    function onBeforeUnloadPageNew(ev) {
        if (newFormIsChanged()) {
            ev.preventDefault();
        }
    }

    function newlesson() {
        const modal = document.getElementById("modalScreen");
        clearForm();
        document.getElementById('formTitle').innerHTML = 'Add New Lesson';
        $('#lessonForm').attr('action', '../CAT/NewLesson.aspx');
        modal.style.display = "block";

        const oldClickHandler = window.onclick;
        const oldKeydownHandler = document.onkeydown;
        const revertAndClose = () => {
            window.onbeforeunload = null;
            window.onclick = oldClickHandler;
            document.onkeydown = oldKeydownHandler;
            modal.style.display = "none";
        };

        // When the user clicks on <span> (x), close the modal
        $('#modalScreen .close')[0].onclick = function (ev) {
            ev.stopImmediatePropagation();
            if (newFormIsChanged()) {
                askUserAboutChanges('changeAlert', 'lessonForm', revertAndClose);
            }
            else revertAndClose();
        }

        // When the user clicks anywhere outside of content area of the modal, close it
        // (*not* when the click is inside the content area, except the x, handled above)
        window.onclick = function (ev) {
            if (ev.target == modal) {
                if (newFormIsChanged()) {
                    askUserAboutChanges('changeAlert', 'lessonForm', revertAndClose);
                }
                else revertAndClose();
            }
        }

        document.onkeydown = function (ev) {
            if (ev.key === 'Escape') {
                revertAndClose();
            }
        };

        window.onbeforeunload = onBeforeUnloadPageNew;
    }

    function onBeforeUnloadPageEdit(ev) {
        if (editLessonFormIsChanged(lessonCache)) {
            ev.preventDefault();
        }
    }

    function editdata() {
        if (lessonCache.Id == null) {
            alert("No row selected");
            return;
        }

        clearForm();
        document.getElementById('formTitle').innerHTML = 'Edit Lesson';
        $('#lessonForm').attr('action', '../CAT/UpdateLesson.aspx');

        $('#lessonid').val(lessonCache.Id);
        $('#LESSNUMBER').val(lessonCache.LESSNUMBER);
        $('#LESSTITLE').val(lessonCache.LESSTITLE);
        $('#REV').val(lessonCache.REVNUMBER);
        $('#REVDATE').val(lessonCache.REVDATE);
        $('#MEDIATYPE').val(lessonCache.MEDIANUMBER);
        $('#SUBTYPE').val(lessonCache.SUBTYPENUMBER);
        $('#FEADATE').val(lessonCache.FEADATE);
        $('#STATUS').val(lessonCache.STATUSNUMBER);
        $('#CLASSIFICATION').val(lessonCache.CLASSNUMBER);
        $('#ICWL').val(lessonCache.ICWL);
        //$('#LESSDURATION').val(lessonCache.LESS_DURATION);
        $('#MP').val(lessonCache.MPNUMBER);

        togglereadonly(); // configure certain fields read-only according to MP value

        $('#LESSNOTE').val(lessonCache.LESSNOTE);
        $('#MESL').val(lessonCache.MESL);

        $("#FORMAC130J").prop("checked", lessonCache.AC130J == "True");
        $("#FORMHC130J").prop("checked", lessonCache.HC130J == "True");
        $("#FORMMC130J").prop("checked", lessonCache.MC130J == "True");
        $("#FORMUH1N").prop("checked", lessonCache.UH1N == "True");
        $("#FORMHH60").prop("checked", lessonCache.HH60 == "True");
        $("#FORMCV22").prop("checked", lessonCache.CV22 == "True");
        $("#FORMFTRUCKER").prop("checked", lessonCache.FTRUCKER == "True");

        $('#PRIMARYINSTRUCTOR').val(lessonCache.PRIMARY_INSTRUCTOR_NUMBER);
        $('#ALTERNATEINSTRUCTOR').val(lessonCache.ALTERNATE_INSTRUCTOR_NUMBER);

        const modal = document.getElementById("modalScreen");
        modal.style.display = "block";
        // TODO: maybe replace that with $("#modalScreen").show()?
        // (Note: the identifier is used in revertAndClose below)

        const oldClickHandler = window.onclick;
        const oldKeydownHandler = document.onkeydown;

        const revertAndClose = () => {
            window.onbeforeunload = null;
            window.onclick = oldClickHandler;
            document.onkeydown = oldKeydownHandler;
            modal.style.display = "none";
        };

        // When the user clicks on <span> (x), close the modal
        $('#modalScreen .close')[0].onclick = function (ev) {
            ev.stopImmediatePropagation();
            if (editLessonFormIsChanged(lessonCache)) {
                askUserAboutChanges('changeAlert', 'lessonForm', revertAndClose);
            }
            else revertAndClose();
        }

        // When the user clicks anywhere outside of content area of the modal, close it
        window.onclick = function (ev) {
            if (ev.target == modal) {
                if (editLessonFormIsChanged(lessonCache)) {
                    askUserAboutChanges('changeAlert', 'lessonForm', revertAndClose);
                }
                else revertAndClose();
            }
        }

        document.onkeydown = function (ev) {
            if (ev.key === 'Escape') {
                revertAndClose();
            }
        };

        window.onbeforeunload = onBeforeUnloadPageEdit;
    }

    function deletedata() {
        if (lessonCache.Id == null) {
            alert("No row selected")
        }
        else if (confirm("Are you sure that you want to delete this lesson?")) {
            window.location.href = "../CAT/deleteLesson.aspx?selid=" + lessonCache.Id;
        }
    }

    function checkDate(dateStr) {
        // Empty string is OK; else we need to analyze it
        if (dateStr) {
            // First check for the pattern
            if (!/^\d{1,2}\/\d{1,2}\/\d{4}$/.test(dateStr)) {
                return false;
            }

            // Parse the date parts to integers
            const parts = dateStr.split("/");
            const month = parseInt(parts[0], 10);
            const year = parseInt(parts[2], 10);

            // Check the ranges of month and year
            if (year < 1000 || year > 3000 || month == 0 || month > 12) {
                return false;
            }
        }
        return true;
    }

    function isAllValid(form) {
        let isGood = true;
        const beforeunloadHandler = window.onbeforeunload;
        window.onbeforeunload = null;
        if (!checkDate(form.REVDATE.value)) {
            alert("ERROR: Dates must be valid!");
            isGood = false;
        }
        if (!checkDate(form.FEADATE.value)) {
            alert("ERROR: Dates must be valid!");
            isGood = false;
        }
        if (!isGood) {
            window.onbeforeunload = beforeunloadHandler;
            return false;
        }
    }

    function datepickeroff() {
        $("#REVDATE").datepicker("disable");
    }

    function togglereadonly() {
        const $rev = $('#REV');
        const $revDate = $('#REVDATE');
        const $classif = $('#CLASSIFICATION');
        const $icwl = $('#ICWL');

        // TODO: find out what MP=='A' means, and why these fields get disabled in that case,
        // and whether the values in these fields should be cleared when MP 'A' is selected.
        // This also goes for Lesson.aspx
        if ($('#MP').val() == '1') {
            $rev.removeAttr("required")
                .css({ backgroundColor: "black", pointerEvents: "none" });
            $revDate.prop('readOnly', true)
                .css({ backgroundColor: "black" })
                .datepicker("disable");
            $classif.removeAttr("required")
                .css({ backgroundColor: "black", pointerEvents: "none" });
            $icwl.css({ backgroundColor: "black", pointerEvents: "none" });
        }
        else {
            $rev.attr("required", true)
                .css({ backgroundColor: "#3b4148", pointerEvents: "auto" });
            $revDate.prop('readOnly', false)
                .css({ backgroundColor: "#3b4148" })
                .datepicker("enable");
            $classif.attr("required", true)
                .css({ backgroundColor: "#3b4148", pointerEvents: "auto" });
            $icwl.css({ backgroundColor: "#3b4148", pointerEvents: "auto" });
        }            
    }
</script>

<style>
#main {
    overflow-x: hidden;
}
#loader {
    position: absolute;
    left: 50%; top: 200px;
    transform: translateX(-50%);
    font-weight: bold;
    color: #005EB8;
    /* only visible until CTSTable is done loading */
}
#CTSTable {
    min-width: 500px;
    margin: 35px;
    visibility: hidden; /* until loaded */
}

@media screen and (max-width: 1300px) {
  #myModal{
        width: 525px;
    }
  #divcheckboxes {
        overflow-x: auto;  
        white-space: nowrap;
    }
}

.modal{
    width: 1700px;
}
#divcheckboxes{
    background-color: #3b4148;
    border-radius: 0.25rem;
}
#divcheckboxes > input[type="checkbox"] {
    margin-left: 18px;
}
#divcheckboxes label{
    padding: 1rem 5px;
}
.InfoTitles{
    padding-top: 1rem;
    float: left;
    width: 200px;
    color: black;
    text-align: right;
}
#changeAlert {
    position: absolute;
    left: 50%; top: 50%;
    transform: translate(-50%, -50%);
    width: 450px;
    padding: 10px;
    border: 2px solid darkred;
}
#changeAlert form {
    margin-top: 20px;
    text-align: center;
}
#changeAlert button {
    width: 108px;
    padding: 4px 0;
    color: #fff;
    background-color: #606060;
    border: none;
    border-radius: 2px;
}
#changeAlert button:not(:first-of-type) {
    margin-left: 10px;
}
#changeAlert button[autofocus] {
    background-color: #0080ff;
}
</style>

<br /><br />
 <div style="text-align: center; font-family:sans-serif;"><h1>Lesson Manager</h1></div>
<hr />

<div id="loader">Data loading; please wait...</div>

<div id="CTSTable" class="animate-bottom">
    <button class="button" onclick="newlesson()">Add New</button>
    <button class="button" onclick="editdata()">Edit Row</button>
    <button class="button" onclick="deletedata()">Delete Row</button>
    <br /><br />
    <table id="example" class="display" style="width:100%; border: none;">
        <thead style="background-color: #005EB8; color: white">
            <tr>
                <th>Lesson ID</th>
                <th style="width: 200px; min-width: 200px;">Lesson Number</th>
                <th style="width: 200px; min-width: 200px;">Lesson Title</th>
                <th>Rev</th>
                <th>Rev Date</th>
                <th>Media Type</th>
                <th>Subtypes</th>
                <th>FEA Date</th>
                <th>Status</th>
                <th>Classification</th> 
                <th>ICWL</th>
                <!--<th>Lesson Duration</th>-->
                <th>MP</th>
                <!--<th>Spt Time</th>-->
                <th style="width: 500px; min-width: 500px;">Note</th>
                <th style="width: 500px; min-width: 500px;">MESL</th>
                <th style="width: 575px; min-width: 575px;">Applicable Airframes</th>
                <th>Primary Instructor</th>
                <th>Alternate Instructor</th>
                <th>AC130J</th>
                <th>HC130J</th>
                <th>MC130J</th>
                <th>UH1N</th>
                <th>HH60</th>
                <th>CV22</th>
                <th>FTRUCKER</th>
                <th>REVNUMBER</th>
                <th>MEDIANUMBER</th>
                <th>SUBTYPENUMBER</th>
                <th>STATUSNUMBER</th>
                <th>CLASSNUMBER</th>
                <th>MPNUMBER</th>
                <th>PRIMARYINSTRUCTORNUMBER</th>
                <th>ALTERNATEINSTRUCTORNUMBER</th>
                <th>ID</th> 
            </tr>
        </thead>
        <tbody>
        </tbody>
    </table>
</div>

<!-- The Modal -->
<div id="modalScreen" class="modal">
  <!-- Modal content -->
  <div class="modal-content" style="background-color: lightgray;">
    <span class="close">&times;</span>
    <br /><br />
    <h4 id="formTitle" style="text-align: center">Add New Lesson</h4><br />
    <form id="lessonForm" name="form1" class="form login" action="../CAT/NewLesson.aspx" method="post" enctype="multipart/form-data" onsubmit="return isAllValid(this)">
      <input type="hidden" name="lessonid" id="lessonid" />
      <div class='InfoTitles'>Lesson Number:&nbsp;</div><div class="form__field">
        <input style="color: white" type="text" name="LESSNUMBER" id="LESSNUMBER" placeholder="Lesson Number" required="required"/>
      </div>
      <div class='InfoTitles'>Lesson Title:&nbsp;</div><div class="form__field">
        <input style="color: white" type="text" name="LESSTITLE" id="LESSTITLE" placeholder="Lesson Title" required="required"/>
      </div>
      <div class='InfoTitles'>Rev:&nbsp;</div><div class="form__field" style="color: black">
        <select class="selectstyle" id="REV" name="REV" style="width: 100%;" required>
            <asp:Label ID="Label2" runat="server" />
        </select>
      </div>
      <div class='InfoTitles'>Rev Date:&nbsp;</div><div class="form__field" style="color: black">
        <input id="REVDATE" name="REVDATE" type="text" placeholder="Rev Date" style="color: white" autocomplete="off" />
      </div>
      <div class='InfoTitles'>Media Type:&nbsp;</div><div class="form__field" style="color: black">
        <select class="selectstyle" id="MEDIATYPE" name="MEDIATYPE" style="width: 100%;" required>
            <asp:Label ID="Label3" runat="server" />
        </select>
      </div>
      <div class='InfoTitles'>Subtype:&nbsp;</div><div class="form__field" style="color: black">
        <select class="selectstyle" id="SUBTYPE" name="SUBTYPE" style="width: 100%;">
            <asp:Label ID="Label14" runat="server" />
        </select>
      </div>
      <div class='InfoTitles'>FEA Date:&nbsp;</div><div class="form__field" style="color: black">
        <input id="FEADATE" name="FEADATE" type="text" placeholder="FEA Date" style="color: white" autocomplete="off" />
      </div>
      <div class='InfoTitles'>Status:&nbsp;</div><div class="form__field" style="color: black">
        <select class="selectstyle" id="STATUS" name="STATUS" style="width: 100%;" required>
            <asp:Label ID="Label4" runat="server" />
        </select>
      </div>
      <div class='InfoTitles'>Classification:&nbsp;</div><div class="form__field" style="color: black">
        <select class="selectstyle" id="CLASSIFICATION" name="CLASSIFICATION" style="width: 100%;" required>
            <asp:Label ID="Label5" runat="server" />
        </select>
      </div>
      <div class='InfoTitles'>ICWL:&nbsp;</div><div class="form__field" style="color: black">
        <select class="selectstyle" id="ICWL" name="ICWL" style="width: 100%;">
            <asp:Label ID="Label6" runat="server" />
        </select>
      </div>
      <!--
      <div class='InfoTitles'>Lesson Duration:&nbsp;</div><div class="form__field">
        <input style="color: white" type="text" name="LESSDURATION" id="LESSDURATION" placeholder="Lesson Duration" required="required"/>
      </div>
      -->
      <div class='InfoTitles'>&nbsp;MP:&nbsp;</div><div class="form__field" style="color: black">
        <select class="selectstyle" id="MP" name="MP" style="width: 100%;" onchange="togglereadonly();">
            <asp:Label ID="Label12" runat="server" />
        </select>
      </div>
      <!--
      <div class='InfoTitles'>Spt Time:&nbsp;</div><div class="form__field">
        <input style="color: white" type="text" name="SPTTIME" id="SPTTIME" placeholder="Spt Time" />
      </div>
      -->
      <div class='InfoTitles'>Note:&nbsp;</div><div class="form__field">
        <textarea class="textareastyle" name="LESSNOTE" id="LESSNOTE" placeholder="Note" style="resize: none;"></textarea>
      </div> 
      <div class='InfoTitles'>MESL:&nbsp;</div><div class="form__field">
        <textarea class="textareastyle" name="MESL" id="MESL" placeholder="MESL" style="resize: none;"></textarea>
      </div>
      <div class='InfoTitles'>Applicable Airframes:&nbsp;</div><div class="form__field" id="divcheckboxes">
        <input type='checkbox' id='FORMAC130J' name='FORMAC130J'><label for='FORMAC130J'>AC130J</label>
        <input type='checkbox' id='FORMHC130J' name='FORMHC130J'><label for='FORMHC130J'>HC130J</label>
        <input type='checkbox' id='FORMMC130J' name='FORMMC130J'><label for='FORMMC130J'>MC130J</label>
        <input type='checkbox' id='FORMUH1N' name='FORMUH1N'><label for='FORMUH1N'>UH1N</label>
        <input type='checkbox' id='FORMHH60' name='FORMHH60'><label for='FORMHH60'>HH60</label>
        <input type='checkbox' id='FORMCV22' name='FORMCV22'><label for='FORMCV22'>CV22</label>
        <input type='checkbox' id='FORMFTRUCKER' name='FORMFTRUCKER'><label for='FORMFTRUCKER'>Ft Rucker</label>
      </div>
      <div class='InfoTitles'>Primary Instructor:&nbsp;</div><div class="form__field" style="color: black">
        <select class="selectstyle" id="PRIMARYINSTRUCTOR" name="PRIMARYINSTRUCTOR" style="width: 100%;">
            <asp:Label ID="Label16" runat="server" />
        </select>
      </div>
      <div class='InfoTitles'>Alternate Instructor:&nbsp;</div><div class="form__field" style="color: black">
        <select class="selectstyle" id="ALTERNATEINSTRUCTOR" name="ALTERNATEINSTRUCTOR" style="width: 100%;">
            <asp:Label ID="Label17" runat="server" />
        </select>
      </div>
      <div class="form__field">
        <input type="submit" value="Submit" style="width: 300px;" />
      </div>
    </form>
  </div>
  <br /><br />
</div>

<dialog id="changeAlert">
    <p>Changes have been made to the information in this form.
       Would you like to save the changes?</p>
    <form method="dialog">
        <button value="c">Cancel</button>
        <button value="n">Don't Save</button>
        <button value="y" autofocus>Save</button>
    </form>
</dialog>

</asp:Content>
