﻿<%@ Page Title="CTS Manager" Language="C#" MasterPageFile="~/Header.Master" AutoEventWireup="true" CodeBehind="EditCTS.aspx.cs" Inherits="CAE_WEB_PROJECT.CAT.EditCTS" %>
<asp:Content ID="Content1" ContentPlaceHolderID="head" runat="server">
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="ContentPlaceHolder1" runat="server">

<link rel="stylesheet" type="text/css" href="../styles/main.css" />
<link rel="stylesheet" type="text/css" href="../styles/jquery-ui.css" />
<script type="text/javascript" src="../scripts/jquery-3.5.1.js"></script>
<script type="text/javascript" src="../scripts/main.js"></script>    
<script type="text/javascript" src="../scripts/jquery-ui.min.js"></script>

<script type="text/javascript" src="../scripts/jquery.dataTables.min.js"></script>
<link rel="stylesheet" href="../styles/jquery.dataTables.css" /> 
   
<script>
    var CTSID;
    var Description;
    var ReleaseDate;
    var selid;

    $(document).ready(function () {   
        $(function () {
            $("#RelDate").datepicker({
                changeMonth: true,
                changeYear: true
            });
            $("#EditRelDate").datepicker({
                changeMonth: true,
                changeYear: true
            });
        });

        $('#example').dataTable({
            "bPaginate": false,
            "bLengthChange": false,
            "bFilter": true,
            "bInfo": true,
            "bAutoWidth": true,
            "scrollY": "400px",
            "sScrollX": "100%",
            "sScrollXInner": "100%",
            "scrollCollapse": true,
            "language": {
                "emptyTable": "No Airframes"
            }
        });

        var table = $('#example').DataTable();

        $('#example tbody').on('click', 'tr', function () {
            if ($(this).hasClass('selected')) {
                $(this).removeClass('selected');
                selid = null;               
            }
            else {
                table.$('tr.selected').removeClass('selected');
                $(this).addClass('selected');   
                var data = table.row(this).data();
                savedata(data);
            }          
        });       
    }); 

    function savedata(rowdata) {
        CTSID = rowdata[0];
        Description = rowdata[1];
        ReleaseDate = rowdata[2];
        selid = rowdata[3];  
    }

    function addCTS() {
        var modalcheck = document.getElementById("myModal2");
        if (modalcheck.style.display == "block") {
            modalcheck.style.display = "none";
        }

        // Get the modal
        var modal = document.getElementById("myModal");
        modal.style.display = "block";

        // Get the <span> element that closes the modal
        var span = document.getElementsByClassName("close")[0];

        // When the user clicks on <span> (x), close the modal
        span.onclick = function () {
            modal.style.display = "none";
        }

        // When the user clicks anywhere outside of the modal, close it
        window.onclick = function (event) {
            if (event.target == modal) {
                modal.style.display = "none";
            }
        }

        document.onkeydown = function (evt) {
            evt = evt;
            if (evt.key === 'Escape') {
                modal.style.display = "none";
            }
        };        
    }

    function editdata() {     
        if (selid == null) {
            alert("No row selected")
        }
        else {
            var modalcheck = document.getElementById("myModal");
            if (modalcheck.style.display == "block") {
                modalcheck.style.display = "none";
            }

            // Get the modal
            var modal = document.getElementById("myModal2");
            modal.style.display = "block";

            // Get the <span> element that closes the modal
            var span = document.getElementsByClassName("close2")[0];

            // When the user clicks on <span> (x), close the modal
            span.onclick = function () {
                modal.style.display = "none";
            }

            // When the user clicks anywhere outside of the modal, close it
            window.onclick = function (event) {
                if (event.target == modal) {
                    modal.style.display = "none";
                }
            }

            document.onkeydown = function (evt) {
                evt = evt;
                if (evt.key === 'Escape') {
                    modal.style.display = "none";
                }
            };

            $('#editid').val(selid);
            $('#EditCTSID').val(CTSID);
            $('#EditDesc').val(Description);     
            $('#EditRelDate').val(ReleaseDate);       
        }        
    }

    function deletedata() {
        if (selid == null) {
            alert("No row selected")
        }
        else {
            if (confirm("Are you sure that you want to delete this CTS?") == true) {          
                window.location.href = "../CAT/deleteCTS.aspx?selid=" + selid;
            } else {
                return;
            }            
        }
    }

    function checkDate(form) {
        var RELdateString = form.RelDate.value;

        if (RELdateString == "") {
            //do nothing
        }
        else {
            // First check for the pattern
            if (!/^\d{1,2}\/\d{1,2}\/\d{4}$/.test(RELdateString)) {
                alert("ERROR: Date must be valid!");
                return false;
            }

            // Parse the date parts to integers
            var parts = RELdateString.split("/");
            var month = parseInt(parts[0], 10);
            var year = parseInt(parts[2], 10);

            // Check the ranges of month and year
            if (year < 1000 || year > 3000 || month == 0 || month > 12) {
                alert("ERROR: Date must be valid!");
                return false;
            }
        }
    }

    function checkDate2(form) {
        var RELdateString = form.EditRelDate.value;

        if (RELdateString == "") {
            //do nothing
        }
        else {
            // First check for the pattern
            if (!/^\d{1,2}\/\d{1,2}\/\d{4}$/.test(RELdateString)) {
                alert("ERROR: Date must be valid!");
                return false;
            }

            // Parse the date parts to integers
            var parts = RELdateString.split("/");
            var month = parseInt(parts[0], 10);
            var year = parseInt(parts[2], 10);

            // Check the ranges of month and year
            if (year < 1000 || year > 3000 || month == 0 || month > 12) {
                alert("ERROR: Date must be valid!");
                return false;
            }
        }
    }
</script>

<style>
#main {
    overflow-x: hidden;
}

</style>

<br /><br />
 <div style="text-align: center; font-family:sans-serif;"><h1>CTS Manager</h1></div>
<hr />
<div id="CTSTable" style="margin: 35px;">
<button class="button" onclick="addCTS()">Add New</button>
<button class="button" onclick="editdata()">Edit Row</button>
<button class="button" onclick="deletedata()">Delete Row</button>
<br /><br />
<table id="example" class="display" style="width:100%; border: none">
        <thead style="background-color: #005EB8; color: white">
            <tr>                
                <th style="width: 300px;">CTS ID</th>
                <th>Description</th>    
                <th style="width: 300px;">Release Date</th>   
                <th style="display:none;">ID</th>
            </tr>
        </thead>
        <tbody>
            <asp:Label ID="Label1" runat="server" />                          
        </tbody>
    </table>
</div>

<!-- The Modal -->
<div id="myModal" class="modal">
  <!-- Modal content -->
  <div class="modal-content" style="background-color: lightgray;">
    <span class="close">&times;</span>
      <br /><br />
       <h4 style="text-align: center">Add New CTS</h4><br />
       <form class="form login" name="form1" action="../CAT/addCTS.aspx" method="post" enctype="multipart/form-data" onsubmit="return checkDate(this)">
       <div class="form__field">
       <input style="color: white" type="text" name="Desc" id="Desc" placeholder="Description" required="required"/>
       </div>
       <div class="form__field" style="color: black">
       <input id="RelDate" name="RelDate" type="text" placeholder="Release Date" style="color: white" autocomplete="off" required="required" />
       </div>
       <div class="form__field">
       <input type="submit" value="Submit" />
       </div>          
       </form>
  </div>
</div>

<!-- The Modal -->
<div id="myModal2" class="modal">
  <!-- Modal content -->
  <div class="modal-content" style="background-color: lightgray;">
    <span class="close2">&times;</span>
      <br /><br />
       <h4 style="text-align: center">Edit CTS</h4><br />
       <form class="form login" name="form1" action="../CAT/editCTSrow.aspx" method="post" enctype="multipart/form-data" onsubmit="return checkDate2(this)">
       <input type="hidden" name="editid" id="editid" />   
       <div class="form__field" style="display: none;">
       <input style="color: white" type="text" name="EditCTSID" id="EditCTSID" placeholder="CTS ID" required="required"/>
       </div>
       <div class="form__field">
       <input style="color: white" type="text" name="EditDesc" id="EditDesc" placeholder="Description" required="required"/>
       </div>
       <div class="form__field" style="color: black">
       <input id="EditRelDate" name="EditRelDate" type="text" placeholder="Release Date" style="color: white" autocomplete="off" required="required" />
       </div>
       <div class="form__field">
       <input type="submit" value="Update" />
       </div>          
       </form>
  </div>
</div>

</asp:Content>
