﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.IO;
using System.Data.SqlClient;
using System.Configuration;
using System.Collections;
using System.Collections.Specialized;
using System.Data;
using System.Text;
using System.Data.Odbc;
using System.Text.RegularExpressions;

namespace CAE_WEB_PROJECT.admin.sqlcommand
{
    public partial class sqlcommandcenter : System.Web.UI.Page
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            if (Session["UserName"] == null)
            {
                Response.Write("<script>alert('Session Timeout')</script>");
                Response.Write("<script>window.location.href='../Default.aspx'</script>");
                return;
            }

            string userrole = Session["UserRole"].ToString();
            if (userrole != "1")
            {
                Response.Write("<script>alert('Access Denied')</script>");
                Response.Write("<script>window.location.href='../Default.aspx'</script>");
                return;
            }
        }

        protected void querybutton_Click(object sender, EventArgs e)
        {
            string sqlquerytext = QueryTextArea.Text;
            sqlquerytext = sqlquerytext.ToLower();
            sqlquerytext = sqlquerytext.Replace("'", "''");
            string userid = Session["UserID"].ToString();

            string cs = System.Configuration.ConfigurationManager.ConnectionStrings["Database1.mdf"].ConnectionString;

            string labeltext = "";

            Boolean result = sqlquerytext.Contains("select");
            if (result == true) //Select statement needs table
            {
                string tablename = sqlquerytext.ToLower().Substring(sqlquerytext.IndexOf("FROM".ToLower())).Split(' ')[1];
                //Response.Write("tablename: " + tablename + "<br/>");

                //Check if table exists
                SqlConnection con = new SqlConnection(cs);
                con.Open();
                SqlCommand cmd = new SqlCommand("select * from information_schema.tables where table_name = '" + tablename + "'");
                cmd.Connection = con;
                SqlDataReader reader = cmd.ExecuteReader();
                {
                    if (reader.HasRows)
                    {
                        //do nothing
                    }
                    else
                    {
                        Response.Write("<script>alert('Table does not exist!')</script>");
                        con.Dispose();
                        return;
                    }
                }
                con.Dispose();

                //Populating a DataTable from database.
                DataTable dt = this.GetData(sqlquerytext);                

                //Building an HTML string.
                StringBuilder html = new StringBuilder();

                //Table start.
                html.Append("<table>");

                //Building the Header row.
                html.Append("<tr class='headerrow'>");
                foreach (DataColumn column in dt.Columns)
                {
                    html.Append("<th>");
                    html.Append(column.ColumnName.ToUpper());
                    html.Append("</th>");
                }
                html.Append("</tr>");

                //Building the Data rows.
                foreach (DataRow row in dt.Rows)
                {
                    html.Append("<tr class='hoverrow'>");
                    foreach (DataColumn column in dt.Columns)
                    {
                        html.Append("<td>");
                        html.Append(row[column.ColumnName]);
                        html.Append("</td>");
                    }
                    html.Append("</tr>");
                }

                //Table end.
                html.Append("</table>");

                //Append the HTML string to labeltext.            
                labeltext = html.ToString();
                Label1.Text = labeltext;
            }
            else //Other query does not need table
            {
                var querytype = Regex.Match(sqlquerytext, @"^([\w\-]+)");               
                //Response.Write("querytype: " + querytype + "<br/>");
                string querytypestring = querytype.ToString();
                if (querytypestring == "update")
                {
                    string tablename = sqlquerytext.Split(' ')[1];
                    //Response.Write("tablename: " + tablename + "<br/>");
                   
                    //Check if table exists
                    SqlConnection con = new SqlConnection(cs);
                    con.Open();
                    SqlCommand cmd = new SqlCommand("select * from information_schema.tables where table_name = '" + tablename + "'");
                    cmd.Connection = con;
                    SqlDataReader reader = cmd.ExecuteReader();
                    {
                        if (reader.HasRows)
                        {
                            //do nothing
                        }
                        else
                        {
                            Response.Write("<script>alert('Table does not exist!')</script>");
                            con.Dispose();
                            return;
                        }
                    }
                    con.Dispose();
                }
                else if (querytypestring == "create" || querytypestring == "drop" || querytypestring == "truncate" || querytypestring == "alter" || querytypestring == "insert")
                {
                    string tablename = sqlquerytext.Split(' ')[2];
                    //Response.Write("tablename: " + tablename + "<br/>");

                    //Check if table exists
                    SqlConnection con = new SqlConnection(cs);
                    con.Open();
                    SqlCommand cmd = new SqlCommand("select * from information_schema.tables where table_name = '" + tablename + "'");
                    cmd.Connection = con;
                    SqlDataReader reader = cmd.ExecuteReader();
                    {
                        if (reader.HasRows)
                        {
                            //do nothing
                        }
                        else
                        {
                            Response.Write("<script>alert('Table does not exist!')</script>");
                            con.Dispose();
                            return;
                        }
                    }
                    con.Dispose();
                }
                else if (querytypestring == "delete")
                {
                    string tablename = sqlquerytext.ToLower().Substring(sqlquerytext.IndexOf("FROM".ToLower())).Split(' ')[1];
                    //Response.Write("tablename: " + tablename + "<br/>");

                    //Check if table exists
                    SqlConnection con = new SqlConnection(cs);
                    con.Open();
                    SqlCommand cmd = new SqlCommand("select * from information_schema.tables where table_name = '" + tablename + "'");
                    cmd.Connection = con;
                    SqlDataReader reader = cmd.ExecuteReader();
                    {
                        if (reader.HasRows)
                        {
                            //do nothing
                        }
                        else
                        {
                            Response.Write("<script>alert('Table does not exist!')</script>");
                            con.Dispose();
                            return;
                        }
                    }
                    con.Dispose();
                }
                else //unknown statement
                {
                    Response.Write("<script>alert('Could not recognize query. Check spelling and format.')</script>");                    
                    return;
                }
                             
                
                try
                {
                    sqlquerytext = sqlquerytext.Replace("''", "'");
                    SqlConnection con2 = new SqlConnection(cs);
                    SqlCommand cmd2 = new SqlCommand(sqlquerytext, con2);
                    con2.Open();
                    cmd2.ExecuteNonQuery();
                    con2.Dispose();
                    Response.Write("<script>alert('Query Successful')</script>");
                }
                catch (Exception ex)
                {
                    Response.Write("<script>alert('Error: " + ex + "')</script>");
                    return;
                }
            }

            sqlquerytext = sqlquerytext.Replace("'", "''");
            SqlConnection con4 = new SqlConnection(cs);
            SqlCommand cmd4 = new SqlCommand("INSERT INTO SQLCommandData (querytext, userid, timestamp) VALUES ('" + sqlquerytext + "'," + userid + ",'" + DateTime.Now + "')", con4);
            con4.Open();
            cmd4.ExecuteNonQuery();
            con4.Dispose();
        }

        private DataTable GetData(string sqltext)
        {
            string constr = System.Configuration.ConfigurationManager.ConnectionStrings["Database1.mdf"].ConnectionString;
            sqltext = sqltext.Replace("''", "'");
            using (SqlConnection con = new SqlConnection(constr))
            {
                using (SqlCommand cmd = new SqlCommand(sqltext))
                {                    
                    using (SqlDataAdapter sda = new SqlDataAdapter())
                    {
                        cmd.Connection = con;
                        sda.SelectCommand = cmd;
                        using (DataTable dt = new DataTable())
                        {
                            sda.Fill(dt);
                            return dt;
                        }
                    } 
                }
            }
        }
    }
}