-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------


with Class_Test_Result_File;
with Ada.Calendar; use Ada.Calendar;

with Master_Caution_Panel_G;
with Annunciator_G;

procedure Master_Caution_Panel_G_Ctd is


begin

   declare

      -------------------------------------------------------------------------------
      -------------------------------------------------------------------------------

      Interval : Duration := 10.0;
      Stop_Time :  Ada.Calendar.Time := Ada.Calendar.Clock + Interval;

      Half_Stop_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.50000) * Interval;

      One_Third_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.66666) * Interval;
      Two_Thirds_Time     : Ada.Calendar.Time := Stop_Time - Duration(0.33333) * Interval;

      One_Quarter_Time    : Ada.Calendar.Time := Stop_Time - Duration(0.75000) * Interval;
      Two_Quarter_Time    : Ada.Calendar.Time := Stop_Time - Duration(0.50000) * Interval;
      Three_Quarter_Time  : Ada.Calendar.Time := Stop_Time - Duration(0.25000) * Interval;

      Reset_In_Time       : Ada.Calendar.Time := Stop_Time - Duration(0.2000) * Interval;
      Reset_Off_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.1660) * Interval;

      function Now return Ada.Calendar.Time renames Ada.Calendar.Clock;

      Iconst : Float := 0.06666666;
      I : Integer := 0;

      In_First_Quarter  : Boolean := true;
      In_Second_Quarter : Boolean := true;
      In_Third_Quarter  : Boolean := true;
      In_Fourth_Quarter : Boolean := true;

      -------------------------------------------------------------------------------
      -------------------------------------------------------------------------------

      package Ann is new Annunciator_G;
      type Warn_Ann_Name_Type is (Warn_A, Warn_B, Warn_C);
      type Warn_Ann_Array is array (Warn_Ann_Name_Type) of Ann.Instance;
      type Warn_Ann_Bool_Array is array (Warn_Ann_Name_Type) of Boolean;
      type Caution_Ann_Name_Type is (Caution_A, Caution_B, Caution_C);
      type Caution_Ann_Array is array (Caution_Ann_Name_Type) of Ann.Instance;
      type Caution_Ann_Bool_Array is array (Caution_Ann_Name_Type) of Boolean;
      type Advisory_Ann_Name_Type is (Advisory_A, Advisory_B, Advisory_C);
      type Advisory_Ann_Array is array (Advisory_Ann_Name_Type) of Ann.Instance;
      type Advisory_Ann_Bool_Array is array (Advisory_Ann_Name_Type) of Boolean;
      type Spare_Ann_Name_Type is (Spare_A, Spare_B, Spare_C);
      type Spare_Ann_Array is array (Spare_Ann_Name_Type) of Ann.Instance;

      package Mc_Panel is new Master_Caution_Panel_G
        (Annunciator_Type                   => Ann.Instance,
         Warn_Annunciator_Name_Type         => Warn_Ann_Name_Type,
         Warn_Array_Of_Annunciator_Type     => Warn_Ann_Array,
         Warn_Array_Of_Boolean              => Warn_Ann_Bool_Array,
         Caution_Annunciator_Name_Type      => Caution_Ann_Name_Type,
         Caution_Array_Of_Annunciator_Type  => Caution_Ann_Array,
         Caution_Array_Of_Boolean           => Caution_Ann_Bool_Array,
         Advisory_Annunciator_Name_Type     => Advisory_Ann_Name_Type,
         Advisory_Array_Of_Annunciator_Type => Advisory_Ann_Array,
         Advisory_Array_Of_Boolean          => Advisory_Ann_Bool_Array,
         Spare_Annunciator_Name_Type        => Spare_Ann_Name_Type,
         Spare_Array_Of_Annunciator_Type    => Spare_Ann_Array,
         Update_A_Annunciator               => Ann.Update,
         A_Annunciator_Flash_Request        => Ann.Flash_Request,
         Initialize_A_Annunciator           => Ann.Initialize,
         A_Annunciator_Is_On                => Ann.Is_On);

      A_Mc_Panel : Mc_Panel.Instance;

      Warn_Power     : Warn_Ann_Bool_Array := (others => False);
      Warn_Req       : Warn_Ann_Bool_Array := (others => False);
      Caution_Power  : Caution_Ann_Bool_Array := (others => False);
      Caution_Req    : Caution_Ann_Bool_Array := (others => False);
      Advisory_Power : Advisory_Ann_Bool_Array := (others => False);
      Advisory_Req   : Advisory_Ann_Bool_Array := (others => False);



      Test_1  : Boolean; Test_31 : Boolean; Test_61 : Boolean;
      Test_2  : Boolean; Test_32 : Boolean; Test_62 : Boolean;
      Test_3  : Boolean; Test_33 : Boolean; Test_63 : Boolean;
      Test_4  : Boolean; Test_34 : Boolean; Test_64 : Boolean;
      Test_5  : Boolean; Test_35 : Boolean; Test_65 : Boolean;
      Test_6  : Boolean; Test_36 : Boolean; Test_66 : Boolean;
      Test_7  : Boolean; Test_37 : Boolean; Test_67 : Boolean;
      Test_8  : Boolean; Test_38 : Boolean; Test_68 : Boolean;
      Test_9  : Boolean; Test_39 : Boolean; Test_69 : Boolean;
      Test_10 : Boolean; Test_40 : Boolean; Test_70 : Boolean;
      Test_11 : Boolean; Test_41 : Boolean;
      Test_12 : Boolean; Test_42 : Boolean;
      Test_13 : Boolean; Test_43 : Boolean;
      Test_14 : Boolean; Test_44 : Boolean;
      Test_15 : Boolean; Test_45 : Boolean;
      Test_16 : Boolean; Test_46 : Boolean;
      Test_17 : Boolean; Test_47 : Boolean;
      Test_18 : Boolean; Test_48 : Boolean;
      Test_19 : Boolean; Test_49 : Boolean;
      Test_20 : Boolean; Test_50 : Boolean;
      Test_21 : Boolean; Test_51 : Boolean;
      Test_22 : Boolean; Test_52 : Boolean;
      Test_23 : Boolean; Test_53 : Boolean;
      Test_24 : Boolean; Test_54 : Boolean;
      Test_25 : Boolean; Test_55 : Boolean;
      Test_26 : Boolean; Test_56 : Boolean;
      Test_27 : Boolean; Test_57 : Boolean;
      Test_28 : Boolean; Test_58 : Boolean;
      Test_29 : Boolean; Test_59 : Boolean;
      Test_30 : Boolean; Test_60 : Boolean;

   begin

      Mc_Panel.Initialize (A_Mc_Panel);
      Test_1  := not Mc_Panel.Is_On (A_Mc_Panel,Warn_A);
      Test_2  := not Mc_Panel.Is_On (A_Mc_Panel,Warn_B);
      Test_3  := not Mc_Panel.Is_On (A_Mc_Panel,Warn_C);
      Test_4  := not Mc_Panel.Is_On (A_Mc_Panel,Caution_A);
      Test_5  := not Mc_Panel.Is_On (A_Mc_Panel,Caution_B);
      Test_6  := not Mc_Panel.Is_On (A_Mc_Panel,Caution_C);
      Test_7  := not Mc_Panel.Is_On (A_Mc_Panel,Advisory_A);
      Test_8  := not Mc_Panel.Is_On (A_Mc_Panel,Advisory_B);
      Test_9  := not Mc_Panel.Is_On (A_Mc_Panel,Advisory_C);
      Test_10 := not Mc_Panel.Is_On (A_Mc_Panel,Spare_A);
      Test_11 := not Mc_Panel.Is_On (A_Mc_Panel,Spare_B);
      Test_12 := not Mc_Panel.Is_On (A_Mc_Panel,Spare_C);
      Test_13 := not Mc_Panel.Warn_Flash_Command (A_Mc_Panel);
      Test_14 := not Mc_Panel.Caution_Flash_Command (A_Mc_Panel);

      Class_Test_Result_File.Report_Case_Status (Success => Test_1 , Number => 1 );
      Class_Test_Result_File.Report_Case_Status (Success => Test_2 , Number => 2 );
      Class_Test_Result_File.Report_Case_Status (Success => Test_3 , Number => 3 );
      Class_Test_Result_File.Report_Case_Status (Success => Test_4 , Number => 4 );
      Class_Test_Result_File.Report_Case_Status (Success => Test_5 , Number => 5 );
      Class_Test_Result_File.Report_Case_Status (Success => Test_6 , Number => 6 );
      Class_Test_Result_File.Report_Case_Status (Success => Test_7 , Number => 7 );
      Class_Test_Result_File.Report_Case_Status (Success => Test_8 , Number => 8 );
      Class_Test_Result_File.Report_Case_Status (Success => Test_9 , Number => 9 );
      Class_Test_Result_File.Report_Case_Status (Success => Test_10, Number => 10);
      Class_Test_Result_File.Report_Case_Status (Success => Test_11, Number => 11);
      Class_Test_Result_File.Report_Case_Status (Success => Test_12, Number => 12);
      Class_Test_Result_File.Report_Case_Status (Success => Test_13, Number => 13);
      Class_Test_Result_File.Report_Case_Status (Success => Test_14, Number => 14);


      while Now < Stop_Time
      loop

         if Now < One_Quarter_Time then

            for Name in Warn_Ann_Name_Type
            loop
               if Name = Warn_A then
                  Warn_Power (Name) := True;
                  Warn_Req (Name) := True;
               end if;
               if Name = Warn_B then
                  Warn_Power (Name) := True;
                  Warn_Req (Name) := True;
               end if;
               if Name = Warn_C then
                  Warn_Power (Name) := True;
                  Warn_Req (Name) := True;
               end if;
            end loop;
            for Name in Caution_Ann_Name_Type
            loop
               if Name = Caution_A then
                  Caution_Power (Name) := True;
                  Caution_Req (Name) := True;
               end if;
               if Name = Caution_B then
                  Caution_Power (Name) := True;
                  Caution_Req (Name) := True;
               end if;
               if Name = Caution_C then
                  Caution_Power (Name) := True;
                  Caution_Req (Name) := True;
               end if;
            end loop;
            for Name in Advisory_Ann_Name_Type
            loop
               if Name = Advisory_A then
                  Advisory_Power (Name) := True;
                  Advisory_Req (Name) := True;
               end if;
               if Name = Advisory_B then
                  Advisory_Power (Name) := True;
                  Advisory_Req (Name) := True;
               end if;
               if Name = Advisory_C then
                  Advisory_Power (Name) := True;
                  Advisory_Req (Name) := True;
               end if;
            end loop;


            Mc_Panel.Update
              (An_Instance      => A_Mc_Panel,      -- in out Instance;
               Warn_Request     => Warn_Req,        -- in     Warn_Array_Of_Boolean;
               Warn_Power       => Warn_Power,      -- in     Warn_Array_Of_Boolean;
               Caution_Request  => Caution_Req,     -- in     Caution_Array_Of_Boolean;
               Caution_Power    => Caution_Power,   -- in     Caution_Array_Of_Boolean;
               Advisory_Request => Advisory_Req,    -- in     Advisory_Array_Of_Boolean;
               Advisory_Power   => Advisory_Power,  -- in     Advisory_Array_Of_Boolean;
               Warn_Reset       => False,           -- in     Boolean;
               Caution_Reset    => False,           -- in     Boolean;
               Test             => False);          -- in     Boolean);



            if In_First_Quarter then
               Test_15 := Mc_Panel.Is_On (A_Mc_Panel,Warn_A);
               Test_16 := Mc_Panel.Is_On (A_Mc_Panel,Warn_B);
               Test_17 := Mc_Panel.Is_On (A_Mc_Panel,Warn_C);
               Test_18 := Mc_Panel.Is_On (A_Mc_Panel,Caution_A);
               Test_19 := Mc_Panel.Is_On (A_Mc_Panel,Caution_B);
               Test_20 := Mc_Panel.Is_On (A_Mc_Panel,Caution_C);
               Test_21 := Mc_Panel.Is_On (A_Mc_Panel,Advisory_A);
               Test_22 := Mc_Panel.Is_On (A_Mc_Panel,Advisory_B);
               Test_23 := Mc_Panel.Is_On (A_Mc_Panel,Advisory_C);
               Test_24 := not Mc_Panel.Is_On (A_Mc_Panel,Spare_A);
               Test_25 := not Mc_Panel.Is_On (A_Mc_Panel,Spare_B);
               Test_26 := not Mc_Panel.Is_On (A_Mc_Panel,Spare_C);
               Test_27 := Mc_Panel.Warn_Flash_Command (A_Mc_Panel);
               Test_28 := Mc_Panel.Caution_Flash_Command (A_Mc_Panel);

               Class_Test_Result_File.Report_Case_Status (Success => Test_15, Number => 15);
               Class_Test_Result_File.Report_Case_Status (Success => Test_16, Number => 16);
               Class_Test_Result_File.Report_Case_Status (Success => Test_17, Number => 17);
               Class_Test_Result_File.Report_Case_Status (Success => Test_18, Number => 18);
               Class_Test_Result_File.Report_Case_Status (Success => Test_19, Number => 19);
               Class_Test_Result_File.Report_Case_Status (Success => Test_20, Number => 20);
               Class_Test_Result_File.Report_Case_Status (Success => Test_21, Number => 21);
               Class_Test_Result_File.Report_Case_Status (Success => Test_22, Number => 22);
               Class_Test_Result_File.Report_Case_Status (Success => Test_23, Number => 23);
               Class_Test_Result_File.Report_Case_Status (Success => Test_24, Number => 24);
               Class_Test_Result_File.Report_Case_Status (Success => Test_25, Number => 25);
               Class_Test_Result_File.Report_Case_Status (Success => Test_26, Number => 26);
               Class_Test_Result_File.Report_Case_Status (Success => Test_27, Number => 27);
               Class_Test_Result_File.Report_Case_Status (Success => Test_28, Number => 28);
            end if;
            In_First_Quarter := False;
         elsif Now < Two_Quarter_Time then



            for Name in Warn_Ann_Name_Type
            loop
               if Name = Warn_A then
                  Warn_Power (Name) := True;
                  Warn_Req (Name) := True;
               end if;
               if Name = Warn_B then
                  Warn_Power (Name) := True;
                  Warn_Req (Name) := True;
               end if;
               if Name = Warn_C then
                  Warn_Power (Name) := True;
                  Warn_Req (Name) := True;
               end if;
            end loop;
            for Name in Caution_Ann_Name_Type
            loop
               if Name = Caution_A then
                  Caution_Power (Name) := True;
                  Caution_Req (Name) := True;
               end if;
               if Name = Caution_B then
                  Caution_Power (Name) := True;
                  Caution_Req (Name) := True;
               end if;
               if Name = Caution_C then
                  Caution_Power (Name) := True;
                  Caution_Req (Name) := True;
               end if;
            end loop;
            for Name in Advisory_Ann_Name_Type
            loop
               if Name = Advisory_A then
                  Advisory_Power (Name) := True;
                  Advisory_Req (Name) := True;
               end if;
               if Name = Advisory_B then
                  Advisory_Power (Name) := True;
                  Advisory_Req (Name) := True;
               end if;
               if Name = Advisory_C then
                  Advisory_Power (Name) := True;
                  Advisory_Req (Name) := True;
               end if;
            end loop;


            Mc_Panel.Update
              (An_Instance      => A_Mc_Panel,      -- in out Instance;
               Warn_Request     => Warn_Req,        -- in     Warn_Array_Of_Boolean;
               Warn_Power       => Warn_Power,      -- in     Warn_Array_Of_Boolean;
               Caution_Request  => Caution_Req,     -- in     Caution_Array_Of_Boolean;
               Caution_Power    => Caution_Power,   -- in     Caution_Array_Of_Boolean;
               Advisory_Request => Advisory_Req,    -- in     Advisory_Array_Of_Boolean;
               Advisory_Power   => Advisory_Power,  -- in     Advisory_Array_Of_Boolean;
               Warn_Reset       => True,           -- in     Boolean;
               Caution_Reset    => False,           -- in     Boolean;
               Test             => False);          -- in     Boolean);


            if In_Second_Quarter then
               Test_29 := Mc_Panel.Is_On (A_Mc_Panel,Warn_A);
               Test_30 := Mc_Panel.Is_On (A_Mc_Panel,Warn_B);
               Test_31 := Mc_Panel.Is_On (A_Mc_Panel,Warn_C);
               Test_32 := Mc_Panel.Is_On (A_Mc_Panel,Caution_A);
               Test_33 := Mc_Panel.Is_On (A_Mc_Panel,Caution_B);
               Test_34 := Mc_Panel.Is_On (A_Mc_Panel,Caution_C);
               Test_35 := Mc_Panel.Is_On (A_Mc_Panel,Advisory_A);
               Test_36 := Mc_Panel.Is_On (A_Mc_Panel,Advisory_B);
               Test_37 := Mc_Panel.Is_On (A_Mc_Panel,Advisory_C);
               Test_38 := not Mc_Panel.Is_On (A_Mc_Panel,Spare_A);
               Test_39 := not Mc_Panel.Is_On (A_Mc_Panel,Spare_B);
               Test_40 := not Mc_Panel.Is_On (A_Mc_Panel,Spare_C);
               Test_41 := not Mc_Panel.Warn_Flash_Command (A_Mc_Panel);
               Test_42 := Mc_Panel.Caution_Flash_Command (A_Mc_Panel);

               Class_Test_Result_File.Report_Case_Status (Success => Test_29, Number => 29);
               Class_Test_Result_File.Report_Case_Status (Success => Test_30, Number => 30);
               Class_Test_Result_File.Report_Case_Status (Success => Test_31, Number => 31);
               Class_Test_Result_File.Report_Case_Status (Success => Test_32, Number => 32);
               Class_Test_Result_File.Report_Case_Status (Success => Test_33, Number => 33);
               Class_Test_Result_File.Report_Case_Status (Success => Test_34, Number => 34);
               Class_Test_Result_File.Report_Case_Status (Success => Test_35, Number => 35);
               Class_Test_Result_File.Report_Case_Status (Success => Test_36, Number => 36);
               Class_Test_Result_File.Report_Case_Status (Success => Test_37, Number => 37);
               Class_Test_Result_File.Report_Case_Status (Success => Test_38, Number => 38);
               Class_Test_Result_File.Report_Case_Status (Success => Test_39, Number => 39);
               Class_Test_Result_File.Report_Case_Status (Success => Test_40, Number => 40);
               Class_Test_Result_File.Report_Case_Status (Success => Test_41, Number => 41);
               Class_Test_Result_File.Report_Case_Status (Success => Test_42, Number => 42);
            end if;
            In_Second_Quarter := False;
         elsif Now < Three_Quarter_Time then


            for Name in Warn_Ann_Name_Type
            loop
               if Name = Warn_A then
                  Warn_Power (Name) := True;
                  Warn_Req (Name) := True;
               end if;
               if Name = Warn_B then
                  Warn_Power (Name) := True;
                  Warn_Req (Name) := True;
               end if;
               if Name = Warn_C then
                  Warn_Power (Name) := True;
                  Warn_Req (Name) := True;
               end if;
            end loop;
            for Name in Caution_Ann_Name_Type
            loop
               if Name = Caution_A then
                  Caution_Power (Name) := True;
                  Caution_Req (Name) := True;
               end if;
               if Name = Caution_B then
                  Caution_Power (Name) := True;
                  Caution_Req (Name) := True;
               end if;
               if Name = Caution_C then
                  Caution_Power (Name) := True;
                  Caution_Req (Name) := True;
               end if;
            end loop;
            for Name in Advisory_Ann_Name_Type
            loop
               if Name = Advisory_A then
                  Advisory_Power (Name) := True;
                  Advisory_Req (Name) := True;
               end if;
               if Name = Advisory_B then
                  Advisory_Power (Name) := True;
                  Advisory_Req (Name) := True;
               end if;
               if Name = Advisory_C then
                  Advisory_Power (Name) := True;
                  Advisory_Req (Name) := True;
               end if;
            end loop;


            Mc_Panel.Update
              (An_Instance      => A_Mc_Panel,      -- in out Instance;
               Warn_Request     => Warn_Req,        -- in     Warn_Array_Of_Boolean;
               Warn_Power       => Warn_Power,      -- in     Warn_Array_Of_Boolean;
               Caution_Request  => Caution_Req,     -- in     Caution_Array_Of_Boolean;
               Caution_Power    => Caution_Power,   -- in     Caution_Array_Of_Boolean;
               Advisory_Request => Advisory_Req,    -- in     Advisory_Array_Of_Boolean;
               Advisory_Power   => Advisory_Power,  -- in     Advisory_Array_Of_Boolean;
               Warn_Reset       => False,           -- in     Boolean;
               Caution_Reset    => True,           -- in     Boolean;
               Test             => False);          -- in     Boolean);


            if In_Third_Quarter then
               Test_43 := Mc_Panel.Is_On (A_Mc_Panel,Warn_A);
               Test_44 := Mc_Panel.Is_On (A_Mc_Panel,Warn_B);
               Test_45 := Mc_Panel.Is_On (A_Mc_Panel,Warn_C);
               Test_46 := Mc_Panel.Is_On (A_Mc_Panel,Caution_A);
               Test_47 := Mc_Panel.Is_On (A_Mc_Panel,Caution_B);
               Test_48 := Mc_Panel.Is_On (A_Mc_Panel,Caution_C);
               Test_49 := Mc_Panel.Is_On (A_Mc_Panel,Advisory_A);
               Test_50 := Mc_Panel.Is_On (A_Mc_Panel,Advisory_B);
               Test_51 := Mc_Panel.Is_On (A_Mc_Panel,Advisory_C);
               Test_52 := not Mc_Panel.Is_On (A_Mc_Panel,Spare_A);
               Test_53 := not Mc_Panel.Is_On (A_Mc_Panel,Spare_B);
               Test_54 := not Mc_Panel.Is_On (A_Mc_Panel,Spare_C);
               Test_55 := not Mc_Panel.Warn_Flash_Command (A_Mc_Panel);
               Test_56 := not Mc_Panel.Caution_Flash_Command (A_Mc_Panel);

               Class_Test_Result_File.Report_Case_Status (Success => Test_43, Number => 43);
               Class_Test_Result_File.Report_Case_Status (Success => Test_44, Number => 44);
               Class_Test_Result_File.Report_Case_Status (Success => Test_45, Number => 45);
               Class_Test_Result_File.Report_Case_Status (Success => Test_46, Number => 46);
               Class_Test_Result_File.Report_Case_Status (Success => Test_47, Number => 47);
               Class_Test_Result_File.Report_Case_Status (Success => Test_48, Number => 48);
               Class_Test_Result_File.Report_Case_Status (Success => Test_49, Number => 49);
               Class_Test_Result_File.Report_Case_Status (Success => Test_50, Number => 50);
               Class_Test_Result_File.Report_Case_Status (Success => Test_51, Number => 51);
               Class_Test_Result_File.Report_Case_Status (Success => Test_52, Number => 52);
               Class_Test_Result_File.Report_Case_Status (Success => Test_53, Number => 53);
               Class_Test_Result_File.Report_Case_Status (Success => Test_54, Number => 54);
               Class_Test_Result_File.Report_Case_Status (Success => Test_55, Number => 55);
               Class_Test_Result_File.Report_Case_Status (Success => Test_56, Number => 56);
            end if;
            In_Third_Quarter := False;
         else



            for Name in Warn_Ann_Name_Type
            loop
               if Name = Warn_A then
                  Warn_Power (Name) := True;
                  Warn_Req (Name) := True;
               end if;
               if Name = Warn_B then
                  Warn_Power (Name) := True;
                  Warn_Req (Name) := True;
               end if;
               if Name = Warn_C then
                  Warn_Power (Name) := True;
                  Warn_Req (Name) := True;
               end if;
            end loop;
            for Name in Caution_Ann_Name_Type
            loop
               if Name = Caution_A then
                  Caution_Power (Name) := True;
                  Caution_Req (Name) := True;
               end if;
               if Name = Caution_B then
                  Caution_Power (Name) := True;
                  Caution_Req (Name) := True;
               end if;
               if Name = Caution_C then
                  Caution_Power (Name) := True;
                  Caution_Req (Name) := True;
               end if;
            end loop;
            for Name in Advisory_Ann_Name_Type
            loop
               if Name = Advisory_A then
                  Advisory_Power (Name) := True;
                  Advisory_Req (Name) := True;
               end if;
               if Name = Advisory_B then
                  Advisory_Power (Name) := True;
                  Advisory_Req (Name) := True;
               end if;
               if Name = Advisory_C then
                  Advisory_Power (Name) := True;
                  Advisory_Req (Name) := True;
               end if;
            end loop;


            Mc_Panel.Update
              (An_Instance      => A_Mc_Panel,      -- in out Instance;
               Warn_Request     => Warn_Req,        -- in     Warn_Array_Of_Boolean;
               Warn_Power       => Warn_Power,      -- in     Warn_Array_Of_Boolean;
               Caution_Request  => Caution_Req,     -- in     Caution_Array_Of_Boolean;
               Caution_Power    => Caution_Power,   -- in     Caution_Array_Of_Boolean;
               Advisory_Request => Advisory_Req,    -- in     Advisory_Array_Of_Boolean;
               Advisory_Power   => Advisory_Power,  -- in     Advisory_Array_Of_Boolean;
               Warn_Reset       => False,           -- in     Boolean;
               Caution_Reset    => False,           -- in     Boolean;
               Test             => False);          -- in     Boolean);

            if In_Fourth_Quarter then
               Test_57 := Mc_Panel.Is_On (A_Mc_Panel,Warn_A);
               Test_58 := Mc_Panel.Is_On (A_Mc_Panel,Warn_B);
               Test_59 := Mc_Panel.Is_On (A_Mc_Panel,Warn_C);
               Test_60 := Mc_Panel.Is_On (A_Mc_Panel,Caution_A);
               Test_61 := Mc_Panel.Is_On (A_Mc_Panel,Caution_B);
               Test_62 := Mc_Panel.Is_On (A_Mc_Panel,Caution_C);
               Test_63 := Mc_Panel.Is_On (A_Mc_Panel,Advisory_A);
               Test_64 := Mc_Panel.Is_On (A_Mc_Panel,Advisory_B);
               Test_65 := Mc_Panel.Is_On (A_Mc_Panel,Advisory_C);
               Test_66 := not Mc_Panel.Is_On (A_Mc_Panel,Spare_A);
               Test_67 := not Mc_Panel.Is_On (A_Mc_Panel,Spare_B);
               Test_68 := not Mc_Panel.Is_On (A_Mc_Panel,Spare_C);
               Test_69 := not Mc_Panel.Warn_Flash_Command (A_Mc_Panel);
               Test_70 := not Mc_Panel.Caution_Flash_Command (A_Mc_Panel);

               Class_Test_Result_File.Report_Case_Status (Success => Test_57, Number => 57);
               Class_Test_Result_File.Report_Case_Status (Success => Test_58, Number => 58);
               Class_Test_Result_File.Report_Case_Status (Success => Test_59, Number => 59);
               Class_Test_Result_File.Report_Case_Status (Success => Test_60, Number => 60);
               Class_Test_Result_File.Report_Case_Status (Success => Test_61, Number => 61);
               Class_Test_Result_File.Report_Case_Status (Success => Test_62, Number => 62);
               Class_Test_Result_File.Report_Case_Status (Success => Test_63, Number => 63);
               Class_Test_Result_File.Report_Case_Status (Success => Test_64, Number => 64);
               Class_Test_Result_File.Report_Case_Status (Success => Test_65, Number => 65);
               Class_Test_Result_File.Report_Case_Status (Success => Test_66, Number => 66);
               Class_Test_Result_File.Report_Case_Status (Success => Test_67, Number => 67);
               Class_Test_Result_File.Report_Case_Status (Success => Test_68, Number => 68);
               Class_Test_Result_File.Report_Case_Status (Success => Test_69, Number => 69);
               Class_Test_Result_File.Report_Case_Status (Success => Test_70, Number => 70);
            end if;
            In_Fourth_Quarter := False;
         end if;

      end loop;



      null;
   end;



   declare
      -------------------------------------------------------------------------------
      -------------------------------------------------------------------------------

      Interval : Duration := 10.0;
      Stop_Time :  Ada.Calendar.Time := Ada.Calendar.Clock + Interval;

      Half_Stop_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.50000) * Interval;

      One_Third_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.66666) * Interval;
      Two_Thirds_Time     : Ada.Calendar.Time := Stop_Time - Duration(0.33333) * Interval;

      One_Quarter_Time    : Ada.Calendar.Time := Stop_Time - Duration(0.75000) * Interval;
      Two_Quarter_Time    : Ada.Calendar.Time := Stop_Time - Duration(0.50000) * Interval;
      Three_Quarter_Time  : Ada.Calendar.Time := Stop_Time - Duration(0.25000) * Interval;

      Reset_In_Time       : Ada.Calendar.Time := Stop_Time - Duration(0.2000) * Interval;
      Reset_Off_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.1660) * Interval;

      function Now return Ada.Calendar.Time renames Ada.Calendar.Clock;

      Iconst : Float := 0.06666666;
      I : Integer := 0;

      In_First_Quarter  : Boolean := true;
      In_Second_Quarter : Boolean := true;
      In_Third_Quarter  : Boolean := true;
      In_Fourth_Quarter : Boolean := true;

      -------------------------------------------------------------------------------
      -------------------------------------------------------------------------------
   begin
      null;
   end;
   declare
      -------------------------------------------------------------------------------
      -------------------------------------------------------------------------------

      Interval : Duration := 10.0;
      Stop_Time :  Ada.Calendar.Time := Ada.Calendar.Clock + Interval;

      Half_Stop_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.50000) * Interval;

      One_Third_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.66666) * Interval;
      Two_Thirds_Time     : Ada.Calendar.Time := Stop_Time - Duration(0.33333) * Interval;

      One_Quarter_Time    : Ada.Calendar.Time := Stop_Time - Duration(0.75000) * Interval;
      Two_Quarter_Time    : Ada.Calendar.Time := Stop_Time - Duration(0.50000) * Interval;
      Three_Quarter_Time  : Ada.Calendar.Time := Stop_Time - Duration(0.25000) * Interval;

      Reset_In_Time       : Ada.Calendar.Time := Stop_Time - Duration(0.2000) * Interval;
      Reset_Off_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.1660) * Interval;

      function Now return Ada.Calendar.Time renames Ada.Calendar.Clock;

      Iconst : Float := 0.06666666;
      I : Integer := 0;

      In_First_Quarter  : Boolean := true;
      In_Second_Quarter : Boolean := true;
      In_Third_Quarter  : Boolean := true;
      In_Fourth_Quarter : Boolean := true;

      -------------------------------------------------------------------------------
      -------------------------------------------------------------------------------
   begin
      null;
   end;


end Master_Caution_Panel_G_Ctd;
