-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Ada.Text_Io; use Ada.Text_Io;
with Ada.Float_Text_Io; use Ada.Float_Text_Io;
with Ada.Integer_Text_Io; use Ada.Integer_Text_Io;

with Class_Test_Result_File;
with Jpats_Warning.Controller;
with Jpats_Warning.Container;

procedure Jpats_Warning.Controller_Ctd is

   package Ctnr          renames Container;
   package Panel         renames Ctnr.Master_Caution_Panel;
   package Flasher       renames Ctnr.Flasher;
   package Annunciator   renames Ctnr.Annunciator;
   package Fire_Sensors  renames Ctnr.Fire_Sensors;

   The_Panel            : Panel.Instance        renames Ctnr.This_Subsystem.The_Master_Caution_Panel;
   The_Warn_Flasher     : Flasher.Instance      renames Ctnr.This_Subsystem.The_Warn_Flasher;
   The_Caution_Flasher  : Flasher.Instance      renames Ctnr.This_Subsystem.The_Caution_Flasher;
   The_Fire_Annunciator : Annunciator.Instance  renames Ctnr.This_Subsystem.The_Fire_Annunciator;
   The_Fire_Sensors     : Fire_Sensors.Instance renames Ctnr.This_Subsystem.The_Fire_Sensors;

begin

-------------------------------------------------------------------------------
-- Test_2
--
-- Inputs           :
-- Expected results :
-- Purpose          :

Test_1 : declare

   Test_Case_1 : array (1..4) of Boolean;
   Flag : Integer := 0;
   Caution_Flag : Integer := 0;
   Warn_Flag : Integer := 0;
   spare_Flag : Integer := 0;
   advisory_Flag : Integer := 0;

begin

   Controller.Initialize;

   for Name in Ctnr.Caution_Annunciator_Name_Type
   loop
      exit when Panel.Is_On (The_Panel, Name);
      Caution_Flag := Caution_Flag + 1;
   end loop;

   for Name in Ctnr.Warn_Annunciator_Name_Type
   loop
      exit when Panel.Is_On (The_Panel, Name);
      Warn_Flag := Warn_Flag + 1;
   end loop;

   for Name in Ctnr.Spare_Annunciator_Name_Type
   loop
      exit when Panel.Is_On (The_Panel, Name);
      spare_Flag := spare_Flag + 1;
   end loop;

   for Name in Ctnr.Advisory_Annunciator_Name_Type
   loop
      exit when Panel.Is_On (The_Panel, Name);
      advisory_Flag := advisory_Flag + 1;
   end loop;

   Test_Case_1(1) := Caution_Flag + Warn_Flag + Spare_Flag + advisory_Flag = 30;
   Test_Case_1(2) := not Flasher.Is_Illuminated (The_Warn_Flasher) and not Flasher.Is_Illuminated (The_Caution_Flasher);
   Test_Case_1(3) := not Annunciator.Is_On (The_Fire_Annunciator);
   Test_Case_1(4) := not Fire_Sensors.Is_Fire (The_Fire_Sensors,Ctnr.number_1) and not Fire_Sensors.Is_Fire (The_Fire_Sensors,Ctnr.number_2);
   for I in 1..4
   loop
      exit when not Test_Case_1(I);
      Flag := I;
   end loop;
   Class_Test_Result_File.Report_Case_Status (Success => Flag = 4, Number => 1);
end Test_1;




-------------------------------------------------------------------------------
-- Test_2
--
-- Inputs           :
-- Expected results :
-- Purpose          :
Test_2 : declare

   Test_Case_2 : array (1..4) of Boolean;
   Flag : Integer := 0;
   Iconst : constant Float := 0.0666667;

begin
   Controller.Initialize;




   Controller.Update (iconst);



   Test_Case_2(1) := Panel.Is_On (The_Panel,Ctnr.Chip);
   Test_Case_2(2) := Flasher.Is_Illuminated (The_Warn_Flasher);
   Test_Case_2(3) := not Annunciator.Is_On (The_Fire_Annunciator);
   Test_Case_2(4) := not Fire_Sensors.Is_Fire (The_Fire_Sensors,Ctnr.number_1) and not Fire_Sensors.Is_Fire (The_Fire_Sensors,Ctnr.number_2);


   for I in 1..4
   loop
      exit when not Test_Case_2(I);
      Flag := I;
   end loop;
   Class_Test_Result_File.Report_Case_Status (Success => Flag = 4, Number => 2);
end Test_2;

end Jpats_Warning.Controller_Ctd;
