-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                      JPATS T-6A Flight Training Device
--
--
--  Engineer:  Steven D. Roberts
--
--  Revision:
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------
-- Update Count    : 0

--with Jpats_Powerplant.Container;
--with Jpats_Powerplant.Controller;
-- with Power_Management_Unit;

package body JPATS_Powerplant is


-- Outside of Powerplant_Cat, Propeller_Cat, and Engine_Data_Manager_Cat

  function Qeng return Normalized_Types.Normalize is
  begin
    return 0.0;
  end Qeng;


  -- Method Engine_Torque_Pct
  function Engine_Torque_Pct return Normalized_Types.Normalize is
  begin
    return 0.0; -- Power_Management_Unit.Qeng;
  end Engine_Torque_Pct;

    -- Accessor Fuel_Flow
  function Fuel_Flow return Mass_Types.Pph is
  begin
    return 0.0;
  end Fuel_Flow;

  -- Accessor Chip_Annunciator_Request
  function Chip_Annunciator_Request return Boolean is
  begin
    return True;
  end Chip_Annunciator_Request;

  -- Accessor PMU_Status_Annunciator_Request
  function PMU_Status_Annunciator_Request return Boolean is
  begin
    return True;
  end PMU_Status_Annunciator_Request;

  -- Accessor IGN_Select_Annunciator_Request
  function IGN_Select_Annunciator_Request return Boolean is
  begin
    return True;
  end IGN_Select_Annunciator_Request;

  -- Accessor Start_Ready_Annunciator_Request
  function Start_Ready_Annunciator_Request return Boolean is
  begin
    return True;
  end Start_Ready_Annunciator_Request;

  -- Accessor Ignition_Exciter_Load
  function Ignition_Exciter_Load return Electrical_Units_Types.Amps is
  begin
    return 0.0;
  end Ignition_Exciter_Load;

  -- Accessor Auto_Ignition_Relay_Load
  function Auto_Ignition_Relay_Load return Electrical_Units_Types.Amps is
  begin
    return 0.0;
  end Auto_Ignition_Relay_Load;

-- Between Powerplant_Cat, Propeller_Cat, and Engine_Data_Manager_Cat

  -- Method Bleed_Temperature
  function Bleed_Temperature return Temperature_Types.Kelvin is
  begin
    return 0.0;
  end Bleed_Temperature;

  -- Method Bleed_Pressure
  function Bleed_Pressure return Force_Types.Psi is
  begin
    return 0.0;
  end Bleed_Pressure;

  -- Accessor Intermediate_Fuel_Pump_Pressure
  function Intermediate_Fuel_Pump_Pressure return Force_Types.Psi is
  begin
    return 0.0;
  end Intermediate_Fuel_Pump_Pressure;

  -- Accessor Propeller_Speed in percent;
  function Propeller_Speed_Pct return Normalized_Types.Normalize is
  begin
    return 0.0;
  end Propeller_Speed_Pct;

  -- Accessor Gas_Generator_Speed in Percent;  -- Ng
  function Gas_Generator_Speed_Pct return Normalized_Types.Normalize is
  begin
    return 0.0;
  end Gas_Generator_Speed_Pct;

  -- Accessor Gas_Generator_Speed in Rpm;
  function Gas_Generator_Speed return Angle_Types.Rpm is
  begin
    return 0.0;
  end Gas_Generator_Speed;

  -- Access Reduction_Gear_Box_Speed
  function Reduction_Gear_Box_Speed
    return Jpats_Propeller_Types.Propeller_Angular_Rate_Vector_Type.Instance
  is
  begin
    return (Angle_Types.Rpm(0.0),Angle_Types.Rpm(0.0),Angle_Types.Rpm(0.0));
  end Reduction_Gear_Box_Speed;

  -- Accessor PMU_Start_PinS
  function PMU_Start_PinS return Boolean is
  begin
    return True;
  end PMU_Start_PinS;

  -- Accessor PMU_Fail_Relay_Load
  function PMU_Fail_Relay_Load return Electrical_Units_Types.Amps is
  begin
    return 0.0;
  end PMU_Fail_Relay_Load;

  -- Accessor PMU_Load
  function PMU_Load return Electrical_Units_Types.Amps is
  begin
    return 0.0;
  end PMU_Load;

  -- Access Propeller_Feather_Signal
  function Manual_Feather_Signal
    return Boolean is
  begin
    return False;
  end Manual_Feather_Signal;

  -- Access Overspeed_Governor_Reset
  function Overspeed_Governor_Reset return Boolean is
  begin
    return False;
  end Overspeed_Governor_Reset;

  -- Access Power_Control_Lever_Angle
  function Power_Control_Lever_Angle return Angle_Types.Rpm is
  begin
    return 0.0;
    --    return Container.This_Io_Interface.Throttle_Control;
  end Power_Control_Lever_Angle;

  -- Access Start_Relay
  function Start_Relay return Boolean is
  begin
    return False;
    --    return Container.Auto_Return_Relay.Is_Energized
--      ( An_Instance => Container.This_Subsystem.The_Start_Relay);
  end Start_Relay;

  -- Access PMU_Fail_Relay
  function Pmu_Fail_Relay return Boolean is
  begin
    return False;
    --    return Container.Auto_Return_Relay.Is_Energized
--      ( An_Instance => Container.This_Subsystem.The_Pmu_Fail_Relay);
  end Pmu_Fail_Relay;

  -- Access Generator_Shaft_Rpm
  function Generator_Shaft_Rpm return Angle_Types.Rpm is
  begin
    return Angle_Types.Degrees(0.0);
  end Generator_Shaft_Rpm;

  -- Access Engine_Oil_Pressure
  function Engine_Oil_Pressure return Force_Types.Psi is
  begin
    return Force_Types.Psi(0.0);
  end Engine_Oil_Pressure;

  -- Access Piu_Torque_Motor_Voltage
  function Piu_Torque_Motor_Voltage return Electrical_Units_Types.Volts_DC is
  begin
    return 0.0;
  end Piu_Torque_Motor_Voltage;

  -- Access Overspeed_Governor_Reset_Solenoid
  function Overspeed_Governor_Reset_Solenoid return Boolean is
  begin
    return False;
  end Overspeed_Governor_Reset_Solenoid;



end JPATS_Powerplant;






