-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------


with Class_Test_Result_File;
with Ada.Calendar; use Ada.Calendar;

with Fire_Sensor_G;

procedure Fire_Sensor_G_Ctd is


begin


   -------------------------------------------------------------------------------
   -- Test_1
   --
   -- Inputs           :
   -- Expected results :
   -- Purpose          :

   Test_1 : declare
      -------------------------------------------------------------------------------
      -------------------------------------------------------------------------------

      Interval : Duration := 10.0;
      Stop_Time :  Ada.Calendar.Time := Ada.Calendar.Clock + Interval;

      Half_Stop_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.50000) * Interval;

      One_Third_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.66666) * Interval;
      Two_Thirds_Time     : Ada.Calendar.Time := Stop_Time - Duration(0.33333) * Interval;

      One_Quarter_Time    : Ada.Calendar.Time := Stop_Time - Duration(0.75000) * Interval;
      Two_Quarter_Time    : Ada.Calendar.Time := Stop_Time - Duration(0.50000) * Interval;
      Three_Quarter_Time  : Ada.Calendar.Time := Stop_Time - Duration(0.25000) * Interval;

      Reset_In_Time       : Ada.Calendar.Time := Stop_Time - Duration(0.2000) * Interval;
      Reset_Off_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.1660) * Interval;

      function Now return Ada.Calendar.Time renames Ada.Calendar.Clock;

      Iconst : Float := 0.06666666;
      I : Integer := 0;

      In_First_Quarter  : Boolean := true;
      In_Second_Quarter : Boolean := true;
      In_Third_Quarter  : Boolean := true;
      In_Fourth_Quarter : Boolean := true;

      -------------------------------------------------------------------------------
      -------------------------------------------------------------------------------

      package Sensor is new Fire_Sensor_G;

      A_Sensor : Sensor.Instance;
      Test_Case_1 : Boolean;

   begin

      Sensor.Initialize (A_Sensor);

      Test_Case_1 := not Sensor.Is_Fire (A_Sensor);

      Class_Test_Result_File.Report_Case_Status (Success => Test_Case_1, Number => 1);

   end Test_1;



   -------------------------------------------------------------------------------
   -- Test_2
   --
   -- Inputs           :
   -- Expected results :
   -- Purpose          :

   Test_2 : declare
      -------------------------------------------------------------------------------
      -------------------------------------------------------------------------------

      Interval : Duration := 10.0;
      Stop_Time :  Ada.Calendar.Time := Ada.Calendar.Clock + Interval;

      Half_Stop_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.50000) * Interval;

      One_Third_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.66666) * Interval;
      Two_Thirds_Time     : Ada.Calendar.Time := Stop_Time - Duration(0.33333) * Interval;

      One_Quarter_Time    : Ada.Calendar.Time := Stop_Time - Duration(0.75000) * Interval;
      Two_Quarter_Time    : Ada.Calendar.Time := Stop_Time - Duration(0.50000) * Interval;
      Three_Quarter_Time  : Ada.Calendar.Time := Stop_Time - Duration(0.25000) * Interval;

      Reset_In_Time       : Ada.Calendar.Time := Stop_Time - Duration(0.2000) * Interval;
      Reset_Off_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.1660) * Interval;

      function Now return Ada.Calendar.Time renames Ada.Calendar.Clock;

      Iconst : Float := 0.06666666;
      I : Integer := 0;

      In_First_Quarter  : Boolean := true;
      In_Second_Quarter : Boolean := true;
      In_Third_Quarter  : Boolean := true;
      In_Fourth_Quarter : Boolean := true;

      -------------------------------------------------------------------------------
      -------------------------------------------------------------------------------

      package Sensor is new Fire_Sensor_G;

      A_Sensor : Sensor.Instance;
      Test_Case_2 : array (1..3) of Boolean;
      Req_Fire : Boolean := False;
      Flag : Integer := 0;
   begin

      Sensor.Initialize (A_Sensor);

      Req_Fire := True;
      Sensor.Update
        (An_Instance => A_Sensor, -- in out Instance;
         Is_Fire     => Req_Fire); -- in     Boolean);
      Test_Case_2(1) := Sensor.Is_Fire (A_Sensor);
      Req_Fire := False;
      Sensor.Update
        (An_Instance => A_Sensor, -- in out Instance;
         Is_Fire     => Req_Fire); -- in     Boolean);
      Test_Case_2(2) := not Sensor.Is_Fire (A_Sensor);
      Req_Fire := True;
      Sensor.Update
        (An_Instance => A_Sensor, -- in out Instance;
         Is_Fire     => Req_Fire); -- in     Boolean);
      Test_Case_2(3) := Sensor.Is_Fire (A_Sensor);

      for I in 1..3
      loop
         exit when not Test_Case_2(I);
         Flag := I;
      end loop;

      Class_Test_Result_File.Report_Case_Status (Success => Flag = 3, Number => 2);

   end Test_2;

end Fire_Sensor_G_Ctd;
