-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------


with Class_Test_Result_File;
with Ada.Calendar; use Ada.Calendar;

with Fire_Sensor_G;
with Fire_Sensor_Collection_G;

procedure Fire_Sensor_Collection_G_Ctd is


begin


   -------------------------------------------------------------------------------
   -- Test_1
   --
   -- Inputs           :
   -- Expected results :
   -- Purpose          :

   Test_1 : declare
      -------------------------------------------------------------------------------
      -------------------------------------------------------------------------------

      Interval : Duration := 10.0;
      Stop_Time :  Ada.Calendar.Time := Ada.Calendar.Clock + Interval;

      Half_Stop_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.50000) * Interval;

      One_Third_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.66666) * Interval;
      Two_Thirds_Time     : Ada.Calendar.Time := Stop_Time - Duration(0.33333) * Interval;

      One_Quarter_Time    : Ada.Calendar.Time := Stop_Time - Duration(0.75000) * Interval;
      Two_Quarter_Time    : Ada.Calendar.Time := Stop_Time - Duration(0.50000) * Interval;
      Three_Quarter_Time  : Ada.Calendar.Time := Stop_Time - Duration(0.25000) * Interval;

      Reset_In_Time       : Ada.Calendar.Time := Stop_Time - Duration(0.2000) * Interval;
      Reset_Off_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.1660) * Interval;

      function Now return Ada.Calendar.Time renames Ada.Calendar.Clock;

      Iconst : Float := 0.06666666;
      I : Integer := 0;

      In_First_Quarter  : Boolean := true;
      In_Second_Quarter : Boolean := true;
      In_Third_Quarter  : Boolean := true;
      In_Fourth_Quarter : Boolean := true;

      -------------------------------------------------------------------------------
      -------------------------------------------------------------------------------

      package Sensor is new Fire_Sensor_G;

      type Sensor_Name_Type is (Sensor_1, Sensor_2);
      type Sensor_Array is array (Sensor_Name_Type) of Sensor.Instance;
      type Sensor_Logic is array (Sensor_Name_Type) of Boolean;

      package Sensors is new Fire_Sensor_Collection_G
        (Fire_Sensor_Name_Type         => Sensor_Name_Type,      --is (<>);
         Fire_Sensor_Type              => Sensor.Instance,       --is private;
         Array_Of_Fire_Sensor_Type     => Sensor_Array,          --   is array (Fire_Sensor_Name_Type) of Fire_Sensor_Type;
         Fire_Sensors_Array_Of_Boolean => Sensor_Logic,          -- is array (Fire_Sensor_Name_Type) of Boolean;
         A_Sensor_Is_Fire              => Sensor.Is_Fire,        --(A_Sensor : in Fire_Sensor_Type) return Boolean;
         Update_A_Sensor               => Sensor.Update,         --(A_Sensor : in out Fire_Sensor_Type;
                                                                 -- Is_Fire  : in     Boolean);
         Initialize_A_Sensor           => Sensor.Initialize);    -- (A_Sensor : in out Fire_Sensor_Type);

      The_Sensors : Sensors.Instance;
      Test_Case_1 : array (1..2) of Boolean;
      Flag : Integer := 0;

   begin

      Sensors.Initialize (The_Sensors);

      Test_Case_1(1) := not Sensors.Is_Fire (The_Sensors,Sensor_1);
      Test_Case_1(2) := not Sensors.Is_Fire (The_Sensors,Sensor_2);

      Class_Test_Result_File.Report_Case_Status (Success => Test_Case_1(1) and Test_Case_1(2), Number => 1);

   end Test_1;





   -------------------------------------------------------------------------------
   -- Test_2
   --
   -- Inputs           :
   -- Expected results :
   -- Purpose          :

   Test_2 : declare
      -------------------------------------------------------------------------------
      -------------------------------------------------------------------------------

      Interval : Duration := 10.0;
      Stop_Time :  Ada.Calendar.Time := Ada.Calendar.Clock + Interval;

      Half_Stop_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.50000) * Interval;

      One_Third_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.66666) * Interval;
      Two_Thirds_Time     : Ada.Calendar.Time := Stop_Time - Duration(0.33333) * Interval;

      One_Quarter_Time    : Ada.Calendar.Time := Stop_Time - Duration(0.75000) * Interval;
      Two_Quarter_Time    : Ada.Calendar.Time := Stop_Time - Duration(0.50000) * Interval;
      Three_Quarter_Time  : Ada.Calendar.Time := Stop_Time - Duration(0.25000) * Interval;

      Reset_In_Time       : Ada.Calendar.Time := Stop_Time - Duration(0.2000) * Interval;
      Reset_Off_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.1660) * Interval;

      function Now return Ada.Calendar.Time renames Ada.Calendar.Clock;

      Iconst : Float := 0.06666666;
      I : Integer := 0;

      In_First_Quarter  : Boolean := true;
      In_Second_Quarter : Boolean := true;
      In_Third_Quarter  : Boolean := true;
      In_Fourth_Quarter : Boolean := true;

      -------------------------------------------------------------------------------
      -------------------------------------------------------------------------------
      package Sensor is new Fire_Sensor_G;

      type Sensor_Name_Type is (Sensor_1, Sensor_2);
      type Sensor_Array is array (Sensor_Name_Type) of Sensor.Instance;
      type Sensor_Logic is array (Sensor_Name_Type) of Boolean;

      package Sensors is new Fire_Sensor_Collection_G
        (Fire_Sensor_Name_Type         => Sensor_Name_Type,      --is (<>);
         Fire_Sensor_Type              => Sensor.Instance,       --is private;
         Array_Of_Fire_Sensor_Type     => Sensor_Array,          --   is array (Fire_Sensor_Name_Type) of Fire_Sensor_Type;
         Fire_Sensors_Array_Of_Boolean => Sensor_Logic,          -- is array (Fire_Sensor_Name_Type) of Boolean;
         A_Sensor_Is_Fire              => Sensor.Is_Fire,        --(A_Sensor : in Fire_Sensor_Type) return Boolean;
         Update_A_Sensor               => Sensor.Update,         --(A_Sensor : in out Fire_Sensor_Type;
                                                                 -- Is_Fire  : in     Boolean);
         Initialize_A_Sensor           => Sensor.Initialize);    -- (A_Sensor : in out Fire_Sensor_Type);

      The_Sensors : Sensors.Instance;
      Test_Case_2 : array (1..6) of Boolean;
      Flag : Integer := 0;
--      Fire_Req : Boolean;

      Fire_Req : Sensor_Logic := (others => False);

   begin

      Sensors.Initialize (The_Sensors);


      Fire_Req := (True,True);

      Sensors.Update
        (An_Instance => The_Sensors, --: in out Instance;
         Fire        => Fire_Req); --: in     Fire_Sensors_Array_Of_Boolean);

      Test_Case_2(1) := Sensors.Is_Fire (The_Sensors,Sensor_1);
      Test_Case_2(2) := Sensors.Is_Fire (The_Sensors,Sensor_2);


      Fire_Req := (False,True);

      Sensors.Update
        (An_Instance => The_Sensors, --: in out Instance;
         Fire        => Fire_Req); --: in     Fire_Sensors_Array_Of_Boolean);

      Test_Case_2(3) := not Sensors.Is_Fire (The_Sensors,Sensor_1);
      Test_Case_2(4) := Sensors.Is_Fire (The_Sensors,Sensor_2);


      Fire_Req := (True,False);

      Sensors.Update
        (An_Instance => The_Sensors, --: in out Instance;
         Fire        => Fire_Req); --: in     Fire_Sensors_Array_Of_Boolean);

      Test_Case_2(5) := Sensors.Is_Fire (The_Sensors,Sensor_1);
      Test_Case_2(6) := not Sensors.Is_Fire (The_Sensors,Sensor_2);


      for I in 1..6
      loop
        exit when not Test_Case_2(i);
        Flag := I;
      end loop;

      Class_Test_Result_File.Report_Case_Status (Success => Flag = 6, Number => 1);

   end Test_2;





   -------------------------------------------------------------------------------
   -- Test_3
   --
   -- Inputs           :
   -- Expected results :
   -- Purpose          :

   Test_3 : declare
      -------------------------------------------------------------------------------
      -------------------------------------------------------------------------------

      Interval : Duration := 10.0;
      Stop_Time :  Ada.Calendar.Time := Ada.Calendar.Clock + Interval;

      Half_Stop_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.50000) * Interval;

      One_Third_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.66666) * Interval;
      Two_Thirds_Time     : Ada.Calendar.Time := Stop_Time - Duration(0.33333) * Interval;

      One_Quarter_Time    : Ada.Calendar.Time := Stop_Time - Duration(0.75000) * Interval;
      Two_Quarter_Time    : Ada.Calendar.Time := Stop_Time - Duration(0.50000) * Interval;
      Three_Quarter_Time  : Ada.Calendar.Time := Stop_Time - Duration(0.25000) * Interval;

      Reset_In_Time       : Ada.Calendar.Time := Stop_Time - Duration(0.2000) * Interval;
      Reset_Off_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.1660) * Interval;

      function Now return Ada.Calendar.Time renames Ada.Calendar.Clock;

      Iconst : Float := 0.06666666;
      I : Integer := 0;

      In_First_Quarter  : Boolean := true;
      In_Second_Quarter : Boolean := true;
      In_Third_Quarter  : Boolean := true;
      In_Fourth_Quarter : Boolean := true;

      -------------------------------------------------------------------------------
      -------------------------------------------------------------------------------
   begin
      null;
   end Test_3;


end Fire_Sensor_Collection_G_Ctd;
