-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  James F. Narrin
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Ada.Text_Io;
with Ada.Integer_Text_Io;
with Visibility;
with Class_Test_Result_File;
with Jpats_Visual_Weather_Types;

use Ada.Text_Io;
use Ada.Integer_Text_Io;

procedure Visibility_Ct is

   type Cloud_Mode is (Change_Vis, Change_Rvr,
                       Reset_Vis, Reset_Rvr,
                       Heavy_Rain, Med_Rain,
                       Light_Rain, Heavy_Snow,
                       Med_Snow, Light_Snow,
                       Reset_Precip, Max_Vis_Range,
                       Min_Vis_Range, Max_Rvr_Range,
                       Min_Rvr_Range);

   type Mode_Array is array (1..27) of Cloud_Mode;

   Mode : constant Mode_Array :=
     (Change_Vis, Reset_Vis,
      Change_Rvr, Reset_Rvr,
      Heavy_Rain, Reset_Precip,
      Med_Rain, Reset_Precip,
      Light_Rain, Reset_Precip,
      Heavy_Snow, Reset_Precip,
      Med_Snow, Reset_Precip,
      Light_Snow, Reset_Precip,
      Heavy_Rain, Light_Rain,
      Heavy_Snow, Light_Snow,
      Reset_Precip, Max_Vis_Range,
      Min_Vis_Range, Reset_Vis,
      Max_Rvr_Range, Min_Rvr_Range,
      Reset_Rvr);

   New_Vis : constant := 5.0;
   New_Rvr : constant := 1000;

   Max_Rvr : constant := 70000;
   Min_Rvr : constant := -1;
   Max_Vis : constant := 120.0;
   Min_Vis : constant := -1.0;
   The_Visibility : Visibility.Instance;

   Pass : Boolean;
   Nm_Pass : Boolean;
   Km_Pass : Boolean;
   Ft_Pass : Boolean;
   M_Pass : Boolean;

begin

   Visibility.Initialize(The_Visibility);

   for I in 1..27 loop

      if Mode(I) = Change_Vis then
         Visibility.Set_Visibility_Nm(The_Visibility, New_Vis);
         Nm_Pass := abs(Visibility.Visibility_Nm(The_Visibility) - New_Vis)
            < 0.0001;
         Km_Pass :=
           abs(Visibility.Visibility_Km(The_Visibility) - (New_Vis * 1.609))
            < 0.0001;
         Ft_Pass := Visibility.Rwy_Vis_Range_Ft(The_Visibility) = 0;
         M_Pass  := Visibility.Rwy_Vis_Range_M(The_Visibility) = 0;
         Pass := Nm_Pass and Km_Pass and Ft_Pass and M_Pass;

      elsif Mode(I) = Max_Vis_Range then
         Visibility.Set_Visibility_Nm(The_Visibility, Max_Vis);
         Nm_Pass := abs(Visibility.Visibility_Nm(The_Visibility) - 100.0)
            < 0.0001;
         Km_Pass := abs(Visibility.Visibility_Km(The_Visibility) - 160.9)
            < 0.0001;
         Ft_Pass :=  Visibility.Rwy_Vis_Range_Ft(The_Visibility) = 0;
         M_Pass  := Visibility.Rwy_Vis_Range_M(The_Visibility) = 0;
         Pass := Nm_Pass and Km_Pass and Ft_Pass and M_Pass;

      elsif Mode(I) = Min_Vis_Range then
         Visibility.Set_Visibility_Nm(The_Visibility, Min_Vis);
         Nm_Pass := abs(Visibility.Visibility_Nm(The_Visibility) - 0.0)
            < 0.0001;
         Km_Pass := abs(Visibility.Visibility_Km(The_Visibility) - 0.0)
            < 0.0001;
         Ft_Pass :=  Visibility.Rwy_Vis_Range_Ft(The_Visibility) = 0;
         M_Pass  := Visibility.Rwy_Vis_Range_M(The_Visibility) = 0;
         Pass := Nm_Pass and Km_Pass and Ft_Pass and M_Pass;

      elsif Mode(I) = Reset_Vis then
         Visibility.Set_Visibility_Nm(The_Visibility, 100.0);
         Nm_Pass := abs(Visibility.Visibility_Nm(The_Visibility) - 100.0)
            < 0.0001;
         Km_Pass := abs(Visibility.Visibility_Km(The_Visibility) - 160.9)
            < 0.0001;
         Ft_Pass :=  Visibility.Rwy_Vis_Range_Ft(The_Visibility) = 0;
         M_Pass  := Visibility.Rwy_Vis_Range_M(The_Visibility) = 0;
         Pass := Nm_Pass and Km_Pass and Ft_Pass and M_Pass;

      elsif Mode(I) = Change_Rvr then
         Visibility.Set_Rwy_Vis_Range_Ft(The_Visibility, New_Rvr);
         Nm_Pass := abs(Visibility.Visibility_Nm(The_Visibility) - 100.0)
            < 0.0001;
         Km_Pass := abs(Visibility.Visibility_Km(The_Visibility) - 160.9)
            < 0.0001;
         Ft_Pass := Visibility.Rwy_Vis_Range_Ft(The_Visibility) = New_Rvr;
         M_Pass  := Visibility.Rwy_Vis_Range_M(The_Visibility) =
           Integer(Float(New_Rvr)*0.3048);
         Pass := Nm_Pass and Km_Pass and Ft_Pass and M_Pass;

      elsif Mode(I) = Max_Rvr_Range then
         Visibility.Set_Rwy_Vis_Range_Ft(The_Visibility, Max_Rvr);
         Nm_Pass := abs(Visibility.Visibility_Nm(The_Visibility) - 100.0)
            < 0.0001;
         Km_Pass := abs(Visibility.Visibility_Km(The_Visibility) - 160.9)
            < 0.0001;
         Ft_Pass := Visibility.Rwy_Vis_Range_Ft(The_Visibility) = 65535;
         M_Pass  := Visibility.Rwy_Vis_Range_M(The_Visibility) =
           Integer(Float(65535)*0.3048);
         Pass := Nm_Pass and Km_Pass and Ft_Pass and M_Pass;

      elsif Mode(I) = Min_Rvr_Range then
         Visibility.Set_Rwy_Vis_Range_Ft(The_Visibility, Min_Rvr);
         Nm_Pass := abs(Visibility.Visibility_Nm(The_Visibility) - 100.0)
            < 0.0001;
         Km_Pass := abs(Visibility.Visibility_Km(The_Visibility) - 160.9)
            < 0.0001;
         Ft_Pass := Visibility.Rwy_Vis_Range_Ft(The_Visibility) = 1;
         M_Pass  := Visibility.Rwy_Vis_Range_M(The_Visibility) =
           Integer(Float(1)*0.3048);
         Pass := Nm_Pass and Km_Pass and Ft_Pass and M_Pass;

      elsif Mode(I) = Reset_Rvr then
         Visibility.Set_Rwy_Vis_Range_Ft(The_Visibility, 0);
         Nm_Pass := abs(Visibility.Visibility_Nm(The_Visibility) - 100.0)
            < 0.0001;
         Km_Pass := abs(Visibility.Visibility_Km(The_Visibility) - 160.9)
            < 0.0001;
         Ft_Pass := Visibility.Rwy_Vis_Range_Ft(The_Visibility) = 0;
         M_Pass  := Visibility.Rwy_Vis_Range_M(The_Visibility) = 0;
         Pass := Nm_Pass and Km_Pass and Ft_Pass and M_Pass;

      elsif Mode(I) = Heavy_Rain then
         Visibility.Calculate_Visibility(The_Visibility, 1, 3);
         Nm_Pass := abs(Visibility.Visibility_Nm(The_Visibility) - 0.682)
            < 0.0001;
         Km_Pass := abs(Visibility.Visibility_Km(The_Visibility) - 1.097338)
            < 0.0001;
         Ft_Pass := Visibility.Rwy_Vis_Range_Ft(The_Visibility) = 0;
         M_Pass  := Visibility.Rwy_Vis_Range_M(The_Visibility) = 0;
         Pass := Nm_Pass and Km_Pass and Ft_Pass and M_Pass;

      elsif Mode(I) = Med_Rain then
         Visibility.Calculate_Visibility(The_Visibility, 1, 2);
         Nm_Pass := abs(Visibility.Visibility_Nm(The_Visibility) - 1.894)
            < 0.0001;
         Km_Pass := abs(Visibility.Visibility_Km(The_Visibility) - 3.047446)
            < 0.0001;
         Ft_Pass := Visibility.Rwy_Vis_Range_Ft(The_Visibility) = 0;
         M_Pass  := Visibility.Rwy_Vis_Range_M(The_Visibility) = 0;
         Pass := Nm_Pass and Km_Pass and Ft_Pass and M_Pass;

      elsif Mode(I) = Light_Rain then
         Visibility.Calculate_Visibility(The_Visibility, 1, 1);
         Nm_Pass := abs(Visibility.Visibility_Nm(The_Visibility) - 7.57)
            < 0.0001;
         Km_Pass := abs(Visibility.Visibility_Km(The_Visibility) - 12.18013)
            < 0.0001;
         Ft_Pass := Visibility.Rwy_Vis_Range_Ft(The_Visibility) = 0;
         M_Pass  := Visibility.Rwy_Vis_Range_M(The_Visibility) = 0;
         Pass := Nm_Pass and Km_Pass and Ft_Pass and M_Pass;

      elsif Mode(I) = Heavy_Snow then
         Visibility.Calculate_Visibility(The_Visibility, 2, 3);
         Nm_Pass := abs(Visibility.Visibility_Nm(The_Visibility) - 0.165)
            < 0.0001;
         Km_Pass := abs(Visibility.Visibility_Km(The_Visibility) - 0.265485)
            < 0.0001;
         Ft_Pass := Visibility.Rwy_Vis_Range_Ft(The_Visibility) = 0;
         M_Pass  := Visibility.Rwy_Vis_Range_M(The_Visibility) = 0;
         Pass := Nm_Pass and Km_Pass and Ft_Pass and M_Pass;

      elsif Mode(I) = Med_Snow then
         Visibility.Calculate_Visibility(The_Visibility, 2, 2);
         Nm_Pass := abs(Visibility.Visibility_Nm(The_Visibility) - 0.263)
            < 0.0001;
         Km_Pass := abs(Visibility.Visibility_Km(The_Visibility) - 0.423167)
            < 0.0001;
         Ft_Pass := Visibility.Rwy_Vis_Range_Ft(The_Visibility) = 0;
         M_Pass  := Visibility.Rwy_Vis_Range_M(The_Visibility) = 0;
         Pass := Nm_Pass and Km_Pass and Ft_Pass and M_Pass;

      elsif Mode(I) = Light_Snow then
         Visibility.Calculate_Visibility(The_Visibility, 2, 1);
         Nm_Pass := abs(Visibility.Visibility_Nm(The_Visibility) - 1.646)
            < 0.0001;
         Km_Pass := abs(Visibility.Visibility_Km(The_Visibility) - 2.648414)
            < 0.0001;
         Ft_Pass := Visibility.Rwy_Vis_Range_Ft(The_Visibility) = 0;
         M_Pass  := Visibility.Rwy_Vis_Range_M(The_Visibility) = 0;
         Pass := Nm_Pass and Km_Pass and Ft_Pass and M_Pass;

      elsif Mode(I) = Reset_Precip then
         Visibility.Calculate_Visibility(The_Visibility, 0, 3);
         Nm_Pass := abs(Visibility.Visibility_Nm(The_Visibility) - 100.0)
            < 0.0001;
         Km_Pass := abs(Visibility.Visibility_Km(The_Visibility) - 160.9)
            < 0.0001;
         Ft_Pass := Visibility.Rwy_Vis_Range_Ft(The_Visibility) = 0;
         M_Pass  := Visibility.Rwy_Vis_Range_M(The_Visibility) = 0;
         Pass := Nm_Pass and Km_Pass and Ft_Pass and M_Pass;

      end if;

      Class_Test_Result_File.Report_Case_Status (Pass);

      if Pass then
         Put("Test Number ");
         Put(I);
         Put_Line(" Passed");
      else
         Put("Test Number ");
         Put(I);
         Put_Line(" Failed");
      end if;

   end loop;

   Put_Line("Finished");
end Visibility_Ct;
