-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  James F. Narrin
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Ada.Text_Io;
with Ada.Integer_Text_Io;
with Lightning;
with Class_Test_Result_File;
with Jpats_Visual_Weather_Types;

use Ada.Text_Io;
use Ada.Integer_Text_Io;

procedure Lightning_Ct is

   type Lightning_Mode is (Activate_Quadrant_1,
			   Activate_Quadrant_2,
			   Activate_Quadrant_3,
			   Activate_Quadrant_4,
			   Deactivate);

   type Mode_Array is array (1..8) of Lightning_Mode;

   Mode : constant Mode_Array :=
     (Activate_Quadrant_1,
      Deactivate,
      Activate_Quadrant_2,
      Deactivate,
      Activate_Quadrant_3,
      Deactivate,
      Activate_Quadrant_4,
      Deactivate);

   The_Lightning : Lightning.Instance;

   Pass : Boolean;

begin

   Lightning.Initialize(The_Lightning);
   
   for I in 1..8 loop

      if Mode(I) = Activate_Quadrant_1 then
         Lightning.Set_Enabled(The_Lightning, True);
	 Lightning.Calculate_Lightning_Direction
	   (The_Lightning, I,
	    45.00000, -45.00000,
	    0.0,
	    45.050000, -44.9292893,
	    0.5);
	 Pass := Lightning.Visible(The_Lightning) and
	   abs(Lightning.Direction(The_Lightning) - 45.0) < 1.0 and
	   abs(Lightning.Distance(The_Lightning) - 4.24) < 0.3;
	    
      elsif Mode(I) = Activate_Quadrant_2 then
         Lightning.Set_Enabled(The_Lightning, True);
	 Lightning.Calculate_Lightning_Direction
	   (The_Lightning, I,
	    45.00000, -45.00000,
	    0.0,
	    45.05000, -45.0707107,
	    0.5);
	 Pass := Lightning.Visible(The_Lightning) and
	   abs(Lightning.Direction(The_Lightning) + 45.0) < 1.0 and
	   abs(Lightning.Distance(The_Lightning) - 4.24) < 0.3;

      elsif Mode(I) = Activate_Quadrant_3 then
         Lightning.Set_Enabled(The_Lightning, True);
	 Lightning.Calculate_Lightning_Direction
	   (The_Lightning, I,
	    45.00000, -45.00000,
	    0.0,
	    44.95000, -44.9292893,
	    0.5);
	 Pass := not Lightning.Visible(The_Lightning) and
	   abs(Lightning.Direction(The_Lightning) - 135.0) < 1.0 and
	   abs(Lightning.Distance(The_Lightning) - 4.24) < 0.3;

      elsif Mode(I) = Activate_Quadrant_4 then
         Lightning.Set_Enabled(The_Lightning, True);
	 Lightning.Calculate_Lightning_Direction
	   (The_Lightning, I,
	    45.00000, -45.00000,
	    0.0,
	    44.95000, -45.0707107,
	    0.5);
	 Pass := not Lightning.Visible(The_Lightning) and
	   abs(Lightning.Direction(The_Lightning) + 135.0) < 1.0 and
	   abs(Lightning.Distance(The_Lightning) - 4.24) < 0.3;

      elsif Mode(I) = Deactivate then
         Lightning.Set_Enabled(The_Lightning, False);
	 Lightning.Calculate_Lightning_Direction
	   (The_Lightning, I,
	    45.00000, -45.00000,
	    0.0,
	    45.30000, -44.575736,
	    0.5);
	 Pass := not Lightning.Visible(The_Lightning) and
	   abs(Lightning.Direction(The_Lightning) - 0.0) < 0.01 and
	   abs(Lightning.Distance(The_Lightning) - 0.0) < 0.01;

      end if;

      Class_Test_Result_File.Report_Case_Status (Pass);

      if Pass then
         Put("Test Number ");
         Put(I);
         Put_Line(" Passed");
      else
         Put("Test Number ");
         Put(I);
         Put_Line(" Failed");
      end if;

   end loop;

   Put_Line("Finished");
end Lightning_Ct;
