-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  James F. Narrin
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Jpats_Visual_Weather.Controller;
with Jpats_Visual_Weather.Ios_If;
with Jpats_Visual_Weather;
with Class_Test_Result_File;

procedure Jpats_Visual_Weather.Controller_Ctd is

   -------------------------------------------------------
   -- Test Case 1
   --
   -- Inputs:
   --   Rain Enabled
   --
   -- Expected Results:
   --   Lower Cloud Layer overcast should be on
   --   Upper Cloud Layer should be clear
   --   Lower Cloud layer Ceiling/Top should be 4000/15000
   --   Upper Cloud Layer Ceiling/Top should be 0/0
   --   Rain should be on
   --   Snow should be off
   --
   -- Purpose:
   --   To verify that when setting a precipitation type when
   --   there are no clouds that the lower layer becomes overcast
   --   and the upper layer remains off.
   --
   -- Interfaces Tested:
   --   Jpats_Visual_Weather_Category to Jpats_Visual_Airport and
   --   Jpats_Simulated_Aircraft and Jpats_Visual_Buffer
   procedure Test_Case_1 is
      Pass : Boolean := False;
   begin

      Jpats_Visual_Weather.Controller.Initialize;

      Jpats_Visual_Weather.Ios_If.Set_Rain_Enabled(True);

      Jpats_Visual_Weather.Controller.Update(0.067);

      Pass :=
        Jpats_Visual_Weather.Lower_Cloud_Layer_Overcast and
        not Jpats_Visual_Weather.Lower_Cloud_Layer_Broken and
        not Jpats_Visual_Weather.Lower_Cloud_Layer_Scattered and
        not Jpats_Visual_Weather.Upper_Cloud_Layer_Overcast and
        not Jpats_Visual_Weather.Upper_Cloud_Layer_Broken and
        not Jpats_Visual_Weather.Upper_Cloud_Layer_Scattered and
        Jpats_Visual_Weather.Lower_Cloud_Layer_Active and
        not Jpats_Visual_Weather.Upper_Cloud_Layer_Active and
        Jpats_Visual_Weather.Lower_Cloud_Ceiling = 4000 and
        Jpats_Visual_Weather.Lower_Cloud_Top = 15000 and
        Jpats_Visual_Weather.Upper_Cloud_Ceiling = 0 and
        Jpats_Visual_Weather.Upper_Cloud_Top = 0 and
        not Jpats_Visual_Weather.Falling_Snow and
        Jpats_Visual_Weather.Rain_Enable;

      Class_Test_Result_File.Report_Case_Status(Pass);

   end Test_Case_1;

   -------------------------------------------------------
   -- Test Case 2
   --
   -- Inputs:
   --   Snow Enabled
   --
   -- Expected Results:
   --   Lower Cloud Layer overcast should be on
   --   Upper Cloud Layer should be clear
   --   Lower Cloud layer Ceiling/Top should be 4000/15000
   --   Upper Cloud Layer Ceiling/Top should be 0/0
   --   Snow should be on
   --   Rain should be off
   --
   -- Purpose:
   --   To verify that when setting a precipitation type when
   --   there are no clouds that the lower layer becomes overcast
   --   and the upper layer remains off.
   --
   -- Interfaces Tested:
   --   Jpats_Visual_Weather_Category to Jpats_Visual_Airport and
   --   Jpats_Simulated_Aircraft and Jpats_Visual_Buffer
   procedure Test_Case_2 is
      Pass : Boolean := False;
   begin
      Jpats_Visual_Weather.Controller.Initialize;

      Jpats_Visual_Weather.Ios_If.Set_Falling_Snow(True);

      Jpats_Visual_Weather.Controller.Update(0.067);

      Pass :=
        Jpats_Visual_Weather.Lower_Cloud_Layer_Overcast and
        not Jpats_Visual_Weather.Lower_Cloud_Layer_Broken and
        not Jpats_Visual_Weather.Lower_Cloud_Layer_Scattered and
        not Jpats_Visual_Weather.Upper_Cloud_Layer_Overcast and
        not Jpats_Visual_Weather.Upper_Cloud_Layer_Broken and
        not Jpats_Visual_Weather.Upper_Cloud_Layer_Scattered and
        Jpats_Visual_Weather.Lower_Cloud_Layer_Active and
        not Jpats_Visual_Weather.Upper_Cloud_Layer_Active and
        Jpats_Visual_Weather.Lower_Cloud_Ceiling = 4000 and
        Jpats_Visual_Weather.Lower_Cloud_Top = 15000 and
        Jpats_Visual_Weather.Upper_Cloud_Ceiling = 0 and
        Jpats_Visual_Weather.Upper_Cloud_Top = 0 and
        Jpats_Visual_Weather.Falling_Snow and
        not Jpats_Visual_Weather.Rain_Enable;

      Class_Test_Result_File.Report_Case_Status(Pass);

   end Test_Case_2;

   -------------------------------------------------------
   -- Test Case 3
   --
   -- Inputs:
   --   Fog Enabled
   --
   -- Expected Results:
   --   Fog should be on
   --   Fog top should be 200 ft.
   --   Lower Cloud Layer should be clear
   --   Upper Cloud Layer should be clear
   --   Lower Cloud layer Ceiling/Top should be 0/0
   --   Upper Cloud Layer Ceiling/Top should be 0/0
   --   Rain should be off
   --
   -- Purpose:
   --   To verify that when turning fog on, fog is set and a
   --   default fog top is activated and no other weather conditions
   --   are activated
   --
   -- Interfaces Tested:
   --   Jpats_Visual_Weather_Category to Jpats_Visual_Airport and
   --   Jpats_Simulated_Aircraft and Jpats_Visual_Buffer
   procedure Test_Case_3 is
      Pass : Boolean := False;
   begin
      Jpats_Visual_Weather.Controller.Initialize;

      Jpats_Visual_Weather.Ios_If.Set_Fog_Enabled(True);

      Jpats_Visual_Weather.Controller.Update(0.067);

      Pass :=
        not Jpats_Visual_Weather.Lower_Cloud_Layer_Overcast and
        not Jpats_Visual_Weather.Lower_Cloud_Layer_Broken and
        not Jpats_Visual_Weather.Lower_Cloud_Layer_Scattered and
        not Jpats_Visual_Weather.Upper_Cloud_Layer_Overcast and
        not Jpats_Visual_Weather.Upper_Cloud_Layer_Broken and
        not Jpats_Visual_Weather.Upper_Cloud_Layer_Scattered and
        not Jpats_Visual_Weather.Lower_Cloud_Layer_Active and
        not Jpats_Visual_Weather.Upper_Cloud_Layer_Active and
        Jpats_Visual_Weather.Lower_Cloud_Ceiling = 0 and
        Jpats_Visual_Weather.Lower_Cloud_Top = 0 and
        Jpats_Visual_Weather.Upper_Cloud_Ceiling = 0 and
        Jpats_Visual_Weather.Upper_Cloud_Top = 0 and
        not Jpats_Visual_Weather.Rain_Enable and
        Jpats_Visual_Weather.Fog_Active and
        Jpats_Visual_Weather.Fog_Top = 200;

      Class_Test_Result_File.Report_Case_Status(Pass);

   end Test_Case_3;

   -------------------------------------------------------
   -- Test Case 4
   --
   -- Inputs:
   --   Lower Cloud top set to 13250
   --   Upper Cloud top set to 15000
   --   Visibility set to 10.0 Nm
   --
   -- Expected Results:
   --   Lower Cloud Layer overcast should be on
   --   Upper Cloud Layer overcast should be on
   --   Lower Cloud layer Ceiling/Top should be 0/13250
   --   Upper Cloud Layer Ceiling/Top should be 14250/15000
   --   Rain should be off
   --   Visibility should be 10.0 Nm
   --
   -- Purpose:
   --   To verify that when setting a cloud layer altitude with no
   --   previous clouds, overcast is turned on and the altitude is
   --   taken, that the cloud layers get corrected for valid altitudes
   --   and that the visibility gets set.
   --
   -- Interfaces Tested:
   --   Jpats_Visual_Weather_Category to Jpats_Visual_Airport and
   --   Jpats_Simulated_Aircraft and Jpats_Visual_Buffer
   procedure Test_Case_4 is
      Pass : Boolean := False;
   begin
      Jpats_Visual_Weather.Controller.Initialize;

      Jpats_Visual_Weather.Ios_If.Set_Lcl_Top(13250);
      Jpats_Visual_Weather.Ios_If.Set_Ucl_Top(15000);
      Jpats_Visual_Weather.Ios_If.Set_Visibility_Nm(10.0);

      Jpats_Visual_Weather.Controller.Update(0.067);

      Pass :=
        Jpats_Visual_Weather.Lower_Cloud_Layer_Overcast and
        not Jpats_Visual_Weather.Lower_Cloud_Layer_Broken and
        not Jpats_Visual_Weather.Lower_Cloud_Layer_Scattered and
        Jpats_Visual_Weather.Upper_Cloud_Layer_Overcast and
        not Jpats_Visual_Weather.Upper_Cloud_Layer_Broken and
        not Jpats_Visual_Weather.Upper_Cloud_Layer_Scattered and
        Jpats_Visual_Weather.Lower_Cloud_Layer_Active and
        Jpats_Visual_Weather.Upper_Cloud_Layer_Active and
        Jpats_Visual_Weather.Lower_Cloud_Ceiling = 0 and
        Jpats_Visual_Weather.Lower_Cloud_Top = 13250 and
        Jpats_Visual_Weather.Upper_Cloud_Ceiling = 14250 and
        Jpats_Visual_Weather.Upper_Cloud_Top = 15000 and
        not Jpats_Visual_Weather.Rain_Enable and
        (abs(Jpats_Visual_Weather.Visibility_Nm - 10.0) < 0.0001);

      Class_Test_Result_File.Report_Case_Status(Pass);

   end Test_Case_4;

   -------------------------------------------------------
   -- Test Case 5
   --
   -- Inputs:
   --   Overcast Enabled
   --
   -- Expected Results:
   --   Lower Cloud Layer overcast should be on
   --   Upper Cloud Layer should be clear
   --   Lower Cloud layer Ceiling/Top should be 4000/15000
   --   Upper Cloud Layer Ceiling/Top should be 0/0
   --   Rain should be off
   --
   -- Purpose:
   --   To verify that when setting a cloud type, the selection
   --   becomes active and a default cloud altitude is set.
   --
   -- Interfaces Tested:
   --   Jpats_Visual_Weather_Category to Jpats_Visual_Airport and
   --   Jpats_Simulated_Aircraft and Jpats_Visual_Buffer
   procedure Test_Case_5 is
      Pass : Boolean := False;
   begin
      Jpats_Visual_Weather.Controller.Initialize;

      Jpats_Visual_Weather.Ios_If.Set_Lcl_Overcast(True);

      Jpats_Visual_Weather.Controller.Update(0.067);

      Pass :=
        Jpats_Visual_Weather.Lower_Cloud_Layer_Overcast and
        not Jpats_Visual_Weather.Lower_Cloud_Layer_Broken and
        not Jpats_Visual_Weather.Lower_Cloud_Layer_Scattered and
        not Jpats_Visual_Weather.Upper_Cloud_Layer_Overcast and
        not Jpats_Visual_Weather.Upper_Cloud_Layer_Broken and
        not Jpats_Visual_Weather.Upper_Cloud_Layer_Scattered and
        Jpats_Visual_Weather.Lower_Cloud_Layer_Active and
        not Jpats_Visual_Weather.Upper_Cloud_Layer_Active and
        Jpats_Visual_Weather.Lower_Cloud_Ceiling = 4000 and
        Jpats_Visual_Weather.Lower_Cloud_Top = 15000 and
        Jpats_Visual_Weather.Upper_Cloud_Ceiling = 0 and
        Jpats_Visual_Weather.Upper_Cloud_Top = 0 and
        not Jpats_Visual_Weather.Rain_Enable;

      Class_Test_Result_File.Report_Case_Status(Pass);

   end Test_Case_5;

   -------------------------------------------------------
   -- Test Case 6
   --
   -- Inputs:
   --   Lower Cloud top set to 12000
   --   Rain Enabled
   --
   -- Expected Results:
   --   Lower Cloud Layer overcast should be on
   --   Upper Cloud Layer should be clear
   --   Lower Cloud layer Ceiling/Top should be 0/12000
   --   Upper Cloud Layer Ceiling/Top should be 0/0
   --   Rain should be on
   --
   -- Purpose:
   --   To verify that when setting a cloud altitude and then a
   --   precipitation type, the cloud altitude stays where it was set.
   --
   -- Interfaces Tested:
   --   Jpats_Visual_Weather_Category to Jpats_Visual_Airport and
   --   Jpats_Simulated_Aircraft and Jpats_Visual_Buffer
   procedure Test_Case_6 is
      Pass : Boolean := False;
   begin
      Jpats_Visual_Weather.Controller.Initialize;

      Jpats_Visual_Weather.Ios_If.Set_Lcl_Top(12000);
      Jpats_Visual_Weather.Ios_If.Set_Rain_Enabled(True);

      Jpats_Visual_Weather.Controller.Update(0.067);

      Pass :=
        Jpats_Visual_Weather.Lower_Cloud_Layer_Overcast and
        not Jpats_Visual_Weather.Lower_Cloud_Layer_Broken and
        not Jpats_Visual_Weather.Lower_Cloud_Layer_Scattered and
        not Jpats_Visual_Weather.Upper_Cloud_Layer_Overcast and
        not Jpats_Visual_Weather.Upper_Cloud_Layer_Broken and
        not Jpats_Visual_Weather.Upper_Cloud_Layer_Scattered and
        Jpats_Visual_Weather.Lower_Cloud_Layer_Active and
        not Jpats_Visual_Weather.Upper_Cloud_Layer_Active and
        Jpats_Visual_Weather.Lower_Cloud_Ceiling = 0 and
        Jpats_Visual_Weather.Lower_Cloud_Top = 12000 and
        Jpats_Visual_Weather.Upper_Cloud_Ceiling = 0 and
        Jpats_Visual_Weather.Upper_Cloud_Top = 0 and
        Jpats_Visual_Weather.Rain_Enable;

      Class_Test_Result_File.Report_Case_Status(Pass);

   end Test_Case_6;

   -------------------------------------------------------
   -- Test Case 7
   --
   -- Inputs:
   --   Overcast enabled and the disabled
   --
   -- Expected Results:
   --   Lower Cloud Layer should be clear
   --   Upper Cloud Layer should be clear
   --   Lower Cloud layer Ceiling/Top should be 0/0
   --   Upper Cloud Layer Ceiling/Top should be 0/0
   --   Rain should be Off
   --
   -- Purpose:
   --   To verify that when going from a cloud cover to no cloud cover,
   --   all cloud altitudes are reset the the cloud cover is turned
   --   off.
   --
   -- Interfaces Tested:
   --   Jpats_Visual_Weather_Category to Jpats_Visual_Airport and
   --   Jpats_Simulated_Aircraft and Jpats_Visual_Buffer
   procedure Test_Case_7 is
      Pass : Boolean := False;
   begin
      Jpats_Visual_Weather.Controller.Initialize;

      Jpats_Visual_Weather.Ios_If.Set_Lcl_Overcast(True);
      Jpats_Visual_Weather.Controller.Update(0.067);

      Jpats_Visual_Weather.Ios_If.Set_Lcl_Overcast(False);
      Jpats_Visual_Weather.Controller.Update(0.067);

      Pass :=
        not Jpats_Visual_Weather.Lower_Cloud_Layer_Overcast and
        not Jpats_Visual_Weather.Lower_Cloud_Layer_Broken and
        not Jpats_Visual_Weather.Lower_Cloud_Layer_Scattered and
        not Jpats_Visual_Weather.Upper_Cloud_Layer_Overcast and
        not Jpats_Visual_Weather.Upper_Cloud_Layer_Broken and
        not Jpats_Visual_Weather.Upper_Cloud_Layer_Scattered and
        not Jpats_Visual_Weather.Lower_Cloud_Layer_Active and
        not Jpats_Visual_Weather.Upper_Cloud_Layer_Active and
        Jpats_Visual_Weather.Lower_Cloud_Ceiling = 0 and
        Jpats_Visual_Weather.Lower_Cloud_Top = 0 and
        Jpats_Visual_Weather.Upper_Cloud_Ceiling = 0 and
        Jpats_Visual_Weather.Upper_Cloud_Top = 0 and
        not Jpats_Visual_Weather.Rain_Enable;

      Class_Test_Result_File.Report_Case_Status(Pass);

   end Test_Case_7;

begin

   Test_Case_1;
   Test_Case_2;
   Test_Case_3;
   Test_Case_4;
   Test_Case_5;
   Test_Case_6;
   Test_Case_7;

end;
