-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  James F. Narrin
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Ada.Text_Io;
with Ada.Integer_Text_Io;
with Fog;
with Class_Test_Result_File;
with Jpats_Visual_Weather_Types;

use Ada.Text_Io;
use Ada.Integer_Text_Io;

procedure Fog_Ct is

   type Fog_Mode is (Fog_On, Fog_Off,
                     Patchy_Fog_On, Patchy_Fog_Off,
                     Altitude_Set, Altitude_Unset,
		     Fog_Upper_Bound, Fog_Lower_Bound);

   type Mode_Array is array (1..15) of Fog_Mode;

   Mode : constant Mode_Array :=
     (Fog_On, Fog_Off,
      Patchy_Fog_On, Patchy_Fog_Off,
      Fog_On, Patchy_Fog_On,
      Patchy_Fog_Off, Patchy_Fog_On,
      Fog_On, Fog_Off,
      Altitude_Set, Altitude_Unset,
      Fog_Upper_Bound, Fog_Off, Fog_Lower_Bound);

   Fog_Top     : constant := 200;
   
   Fog_Bounds_Upper : constant := 12000;
   Fog_Bounds_Lower : constant := -10;
   
   The_Fog : Fog.Instance;

   Pass : Boolean;

begin
   
   Fog.Initialize(The_Fog);
   
   for I in 1..15 loop

      if Mode(I) = Fog_On then
         Fog.Set_Fog_Active(The_Fog, True);
	 Pass := Fog.Fog_Active(The_Fog) and 
	   not Fog.Patch_Fog(The_Fog) and
	   Fog.Fog_Top(The_Fog) > 0;
      
      elsif Mode(I) = Fog_Off then
         Fog.Set_Fog_Active(The_Fog, False);
	 Pass := not Fog.Fog_Active(The_Fog) and 
	   not Fog.Patch_Fog(The_Fog) and
	   Fog.Fog_Top(The_Fog) = 0;
      
      elsif Mode(I) = Patchy_Fog_On then
         Fog.Set_Patch_Fog(The_Fog, True);
	 Pass := not Fog.Fog_Active(The_Fog) and 
	   Fog.Patch_Fog(The_Fog) and
	   Fog.Fog_Top(The_Fog) > 0;

      elsif Mode(I) = Patchy_Fog_Off then
         Fog.Set_Patch_Fog(The_Fog, False);
	 Pass := not Fog.Fog_Active(The_Fog) and 
	   not Fog.Patch_Fog(The_Fog) and
	   Fog.Fog_Top(The_Fog) = 0;

      elsif Mode(I) = Altitude_Set then
         Fog.Set_Fog_Top(The_Fog, Fog_Top);
	 Pass := Fog.Fog_Active(The_Fog) and 
	   not Fog.Patch_Fog(The_Fog) and
	   Fog.Fog_Top(The_Fog) > 0;

      elsif Mode(I) = Altitude_Unset then
         Fog.Set_Fog_Top(The_Fog, 0);
	 Pass := not Fog.Fog_Active(The_Fog) and 
	   not Fog.Patch_Fog(The_Fog) and
	   Fog.Fog_Top(The_Fog) = 0;

      elsif Mode(I) =  Fog_Upper_Bound then
         Fog.Set_Fog_Top(The_Fog, Fog_Bounds_Upper);
	 Pass := Fog.Fog_Active(The_Fog) and 
	   not Fog.Patch_Fog(The_Fog) and
	   Fog.Fog_Top(The_Fog) > 0 and
	   Fog.Fog_Top(The_Fog) <= 10000;

      elsif Mode(I) = Fog_Lower_Bound then
         Fog.Set_Fog_Top(The_Fog, Fog_Bounds_Lower);
	 Pass := Fog.Fog_Active(The_Fog) and 
	   not Fog.Patch_Fog(The_Fog) and
	   Fog.Fog_Top(The_Fog) > 0;

      end if;


      Class_Test_Result_File.Report_Case_Status (Pass);

      if Pass then
         Put("Test Number ");
         Put(I);
         Put_Line(" Passed");
      else
         Put("Test Number ");
         Put(I);
         Put_Line(" Failed");
      end if;

   end loop;
   
   Put_Line("Finished");
end Fog_Ct;
