-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  James F. Narrin
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Ada.Text_Io;
with Ada.Integer_Text_Io;
with Cloud_Layer;
with Class_Test_Result_File;
with Jpats_Visual_Weather_Types;

use Ada.Text_Io;
use Ada.Integer_Text_Io;

procedure Cloud_Layer_Ct is

   type Cloud_Mode is (Overcast_On, Overcast_Off,
                       Broken_On, Broken_Off,
                       Scattered_On, Scattered_Off,
                       Cloud_Altitude_On, Cloud_Altitude_Off,
		       Cloud_Upper_Bounds, Cloud_Lower_Bounds);

   type Mode_Array is array (1..21) of Cloud_Mode;

   Mode : constant Mode_Array :=
     (Overcast_On, Overcast_Off,
      Broken_On, Broken_Off,
      Scattered_On, Scattered_Off,
      Overcast_On, Broken_On,
      Overcast_On, Scattered_On,
      Broken_On, Scattered_On,
      Overcast_On, Overcast_Off,
      Cloud_Altitude_On, Broken_On,
      Cloud_Altitude_Off,Cloud_Upper_Bounds,
      Cloud_Altitude_Off,Cloud_Lower_Bounds,
      Cloud_Altitude_Off);

   Cloud_Ceiling : constant := 5000;
   Cloud_Top     : constant := 10000;
   
   Cloud_Ceiling_Upper_Bound : constant := 20000;
   Cloud_Top_Upper_Bound : constant := 40000;
   Cloud_Ceiling_Lower_Bound : constant := -2;
   Cloud_Top_Lower_Bound : constant := -1;

   The_Cloud : Cloud_Layer.Instance;

   Pass : Boolean;

begin

   for I in 1..21 loop

      if Mode(I) = Overcast_On then
         Cloud_Layer.Set_Overcast(The_Cloud, True);

      elsif Mode(I) = Overcast_Off then
         Cloud_Layer.Set_Overcast(The_Cloud, False);

      elsif Mode(I) = Broken_On then
         Cloud_Layer.Set_Broken(The_Cloud, True);

      elsif Mode(I) = Broken_Off then
         Cloud_Layer.Set_Broken(The_Cloud, False);

      elsif Mode(I) = Scattered_On then
         Cloud_Layer.Set_Scattered(The_Cloud, True);

      elsif Mode(I) = Scattered_Off then
         Cloud_Layer.Set_Scattered(The_Cloud, False);

      elsif Mode(I) = Cloud_Altitude_On then
         Cloud_Layer.Set_Ceiling(The_Cloud, Cloud_Ceiling);
         Cloud_Layer.Set_Top(The_Cloud, Cloud_Top);

      elsif Mode(I) = Cloud_Altitude_Off then
         Cloud_Layer.Set_Ceiling(The_Cloud, 0);
         Cloud_Layer.Set_Top(The_Cloud, 0);
	 
      elsif Mode(I) = Cloud_Upper_Bounds then
	 Cloud_Layer.Set_Ceiling(The_Cloud, Cloud_Ceiling_Upper_Bound);
	 Cloud_Layer.Set_Top(The_Cloud, Cloud_Top_Upper_Bound);
	 
      elsif Mode(I) = Cloud_Lower_Bounds then
	 Cloud_Layer.Set_Ceiling(The_Cloud, Cloud_Ceiling_Lower_Bound);
	 Cloud_Layer.Set_Top(The_Cloud, Cloud_Top_Lower_Bound);
	 
      end if;


      if Mode(I) = Overcast_On then
         Pass := Cloud_Layer.Overcast(The_Cloud) and
           not Cloud_Layer.Broken(The_Cloud) and
           not Cloud_Layer.Scattered(The_Cloud) and
           (Cloud_Layer.Ceiling(The_Cloud) > 0 and
	    Cloud_Layer.Ceiling(The_Cloud) in 
	    Jpats_Visual_Weather_Types.Cloud_Ceiling_Type) and
	    (Cloud_Layer.Top(The_Cloud) > 0 and
	    Cloud_Layer.Top(The_Cloud) in 
	    Jpats_Visual_Weather_Types.Cloud_Top_Type);
      elsif Mode(I) = Overcast_Off then
         Pass := not Cloud_Layer.Overcast(The_Cloud) and
           not Cloud_Layer.Broken(The_Cloud) and
           not Cloud_Layer.Scattered(The_Cloud) and
           Cloud_Layer.Ceiling(The_Cloud) = 0 and
           Cloud_Layer.Top(The_Cloud) = 0;
      elsif Mode(I) = Broken_On then
         Pass := not Cloud_Layer.Overcast(The_Cloud) and
           Cloud_Layer.Broken(The_Cloud) and
           not Cloud_Layer.Scattered(The_Cloud) and
           (Cloud_Layer.Ceiling(The_Cloud) > 0 and
	    Cloud_Layer.Ceiling(The_Cloud) in 
	    Jpats_Visual_Weather_Types.Cloud_Ceiling_Type) and
           (Cloud_Layer.Top(The_Cloud) > 0 and
	    Cloud_Layer.Top(The_Cloud) in 
	    Jpats_Visual_Weather_Types.Cloud_Top_Type);
      elsif Mode(I) = Broken_Off then
         Pass := not Cloud_Layer.Overcast(The_Cloud) and
           not Cloud_Layer.Broken(The_Cloud) and
           not Cloud_Layer.Scattered(The_Cloud) and
           Cloud_Layer.Ceiling(The_Cloud) = 0 and
           Cloud_Layer.Top(The_Cloud) = 0;
      elsif Mode(I) = Scattered_On then
         Pass := not Cloud_Layer.Overcast(The_Cloud) and
           not Cloud_Layer.Broken(The_Cloud) and
           Cloud_Layer.Scattered(The_Cloud) and
           (Cloud_Layer.Ceiling(The_Cloud) > 0 and
	    Cloud_Layer.Ceiling(The_Cloud) in 
	    Jpats_Visual_Weather_Types.Cloud_Ceiling_Type) and
           (Cloud_Layer.Top(The_Cloud) > 0 and
	    Cloud_Layer.Top(The_Cloud) in 
	    Jpats_Visual_Weather_Types.Cloud_Top_Type);
      elsif Mode(I) = Scattered_Off then
         Pass := not Cloud_Layer.Overcast(The_Cloud) and
           not Cloud_Layer.Broken(The_Cloud) and
           not Cloud_Layer.Scattered(The_Cloud) and
           Cloud_Layer.Ceiling(The_Cloud) = 0 and
           Cloud_Layer.Top(The_Cloud) = 0;
      elsif Mode(I) = Cloud_Altitude_On then
         Pass := (Cloud_Layer.Ceiling(The_Cloud) > 0 and
	    Cloud_Layer.Ceiling(The_Cloud) in 
	    Jpats_Visual_Weather_Types.Cloud_Ceiling_Type) and
           (Cloud_Layer.Top(The_Cloud) > 0 and
	    Cloud_Layer.Top(The_Cloud) in 
	    Jpats_Visual_Weather_Types.Cloud_Top_Type) and
	   (Cloud_Layer.Overcast(The_Cloud) or
	    Cloud_Layer.Broken(The_Cloud) or
	    Cloud_Layer.Scattered(The_Cloud));
      elsif Mode(I) = Cloud_Altitude_Off then
         Pass := not Cloud_Layer.Overcast(The_Cloud) and
           not Cloud_Layer.Broken(The_Cloud) and
           not Cloud_Layer.Scattered(The_Cloud) and
           Cloud_Layer.Ceiling(The_Cloud) = 0 and
           Cloud_Layer.Top(The_Cloud) = 0;
      elsif Mode(I) = Cloud_Upper_Bounds then
         Pass := (Cloud_Layer.Ceiling(The_Cloud) > 0 and
	    Cloud_Layer.Ceiling(The_Cloud) in 
	    Jpats_Visual_Weather_Types.Cloud_Ceiling_Type) and
           (Cloud_Layer.Top(The_Cloud) > 0 and
	    Cloud_Layer.Top(The_Cloud) in 
	    Jpats_Visual_Weather_Types.Cloud_Top_Type) and
	   (Cloud_Layer.Overcast(The_Cloud) or
	    Cloud_Layer.Broken(The_Cloud) or
	    Cloud_Layer.Scattered(The_Cloud));
      elsif Mode(I) = Cloud_Upper_Bounds then
         Pass := (Cloud_Layer.Ceiling(The_Cloud) > 0 and
	    Cloud_Layer.Ceiling(The_Cloud) in 
	    Jpats_Visual_Weather_Types.Cloud_Ceiling_Type) and
           (Cloud_Layer.Top(The_Cloud) > 0 and
	    Cloud_Layer.Top(The_Cloud) in 
	    Jpats_Visual_Weather_Types.Cloud_Top_Type) and
	   (Cloud_Layer.Overcast(The_Cloud) or
	    Cloud_Layer.Broken(The_Cloud) or
	    Cloud_Layer.Scattered(The_Cloud));
      end if;
      
      Class_Test_Result_File.Report_Case_Status (Pass);

      if Pass then
         Put("Test Number ");
         Put(I);
         Put_Line(" Passed");
      else
         Put("Test Number ");
         Put(I);
         Put_Line(" Failed");
      end if;

   end loop;
   
   Put_Line("Finished");
end Cloud_Layer_Ct;
