-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  James F. Narrin
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Ada.Text_Io;
with Ada.Integer_Text_Io;
with Cloud_Layer;
with Clouds;
with Class_Test_Result_File;
with Jpats_Visual_Weather_Types;

use Ada.Text_Io;
use Ada.Integer_Text_Io;

procedure Clouds_Ct is

   type Cloud_Mode is (Lower_Layer_Active, Upper_Layer_Active,
                       Both_Active_Good, Both_Active_Reverse,
                       Lower_Active_Bad, Upper_Active_Bad,
                       Both_Active_Overlap);

   type Mode_Array is array (1..7) of Cloud_Mode;

   Mode : constant Mode_Array :=
     (Lower_Layer_Active,
      Upper_Layer_Active,
      Lower_Active_Bad,
      Upper_Active_Bad,
      Both_Active_Good,
      Both_Active_Reverse,
      Both_Active_Overlap);

   The_Clouds : Clouds.Instance;

   Airport_Altitude : constant := 500;

   Pass : Boolean;

begin

   Clouds.Set_Lower_Layer_Overcast(The_Clouds, False);
   Clouds.Set_Lower_Layer_Broken(The_Clouds, False);
   Clouds.Set_Lower_Layer_Scattered(The_Clouds, False);
   Clouds.Set_Lower_Layer_Ceiling(The_Clouds, 0);
   Clouds.Set_Lower_Layer_Top(The_Clouds, 0);
   Clouds.Set_Lower_Layer_Active(The_Clouds, False);
   Clouds.Set_Upper_Layer_Overcast(The_Clouds, False);
   Clouds.Set_Upper_Layer_Broken(The_Clouds, False);
   Clouds.Set_Upper_Layer_Scattered(The_Clouds, False);
   Clouds.Set_Upper_Layer_Ceiling(The_Clouds, 0);
   Clouds.Set_Upper_Layer_Top(The_Clouds, 0);
   Clouds.Set_Upper_Layer_Active(The_Clouds, False);

   for I in 1..7 loop

      if Mode(I) = Lower_Layer_Active then
         Clouds.Set_Lower_Layer_Ceiling(The_Clouds, 200);
         Clouds.Set_Lower_Layer_Top(The_Clouds, 1000);
         Clouds.Set_Upper_Layer_Ceiling(The_Clouds, 0);
         Clouds.Set_Upper_Layer_Top(The_Clouds, 0);

      elsif Mode(I) = Upper_Layer_Active then
         Clouds.Set_Lower_Layer_Ceiling(The_Clouds, 0);
         Clouds.Set_Lower_Layer_Top(The_Clouds, 0);
         Clouds.Set_Upper_Layer_Ceiling(The_Clouds, 200);
         Clouds.Set_Upper_Layer_Top(The_Clouds, 1000);

      elsif Mode(I) = Lower_Active_Bad then
         Clouds.Set_Lower_Layer_Ceiling(The_Clouds, 600);
         Clouds.Set_Lower_Layer_Top(The_Clouds, 1000);
         Clouds.Set_Upper_Layer_Ceiling(The_Clouds, 0);
         Clouds.Set_Upper_Layer_Top(The_Clouds, 0);

      elsif Mode(I) = Upper_Active_Bad then
         Clouds.Set_Lower_Layer_Ceiling(The_Clouds, 0);
         Clouds.Set_Lower_Layer_Top(The_Clouds, 0);
         Clouds.Set_Upper_Layer_Ceiling(The_Clouds, 700);
         Clouds.Set_Upper_Layer_Top(The_Clouds, 1100);

      elsif Mode(I) = Both_Active_Good then
         Clouds.Set_Lower_Layer_Ceiling(The_Clouds, 200);
         Clouds.Set_Lower_Layer_Top(The_Clouds, 1000);
         Clouds.Set_Upper_Layer_Ceiling(The_Clouds, 2000);
         Clouds.Set_Upper_Layer_Top(The_Clouds, 3000);

      elsif Mode(I) = Both_Active_Reverse then
         Clouds.Set_Lower_Layer_Ceiling(The_Clouds, 2000);
         Clouds.Set_Lower_Layer_Top(The_Clouds, 3000);
         Clouds.Set_Upper_Layer_Ceiling(The_Clouds, 200);
         Clouds.Set_Upper_Layer_Top(The_Clouds, 1000);

      elsif Mode(I) = Both_Active_Overlap then
         Clouds.Set_Lower_Layer_Ceiling(The_Clouds, 200);
         Clouds.Set_Lower_Layer_Top(The_Clouds, 2000);
         Clouds.Set_Upper_Layer_Ceiling(The_Clouds, 1500);
         Clouds.Set_Upper_Layer_Top(The_Clouds, 3000);

      end if;

      Clouds.Verify_Cloud_Layers(The_Clouds, Airport_Altitude);

      if (Clouds.Lower_Layer_Active(The_Clouds) = True and
          Clouds.Upper_Layer_Active(The_Clouds) = True) then
         Pass := (Clouds.Upper_Layer_Top(The_Clouds) >
           Clouds.Upper_Layer_Ceiling(The_Clouds)) and
           (Clouds.Upper_Layer_Ceiling(The_Clouds) >
              Clouds.Lower_Layer_Top(The_Clouds)) and
           (Clouds.Lower_Layer_Top(The_Clouds) >
              (Clouds.Lower_Layer_Ceiling(The_Clouds) +
               Airport_Altitude)) and
           Clouds.Lower_Layer_Ceiling(The_Clouds) /= 0 and
           Clouds.Lower_Layer_Top(The_Clouds) /= 0 and
           Clouds.Upper_Layer_Ceiling(The_Clouds) /= 0 and
           Clouds.Upper_Layer_Top(The_Clouds) /= 0;
      elsif Clouds.Lower_Layer_Active(The_Clouds) then
         Pass := Clouds.Upper_Layer_Ceiling(The_Clouds) = 0 and
           Clouds.Upper_Layer_Top(The_Clouds) = 0 and
           Clouds.Lower_Layer_Top(The_Clouds) >
           Clouds.Lower_Layer_Ceiling(The_Clouds) + Airport_Altitude and
           Clouds.Lower_Layer_Top(The_Clouds) /= 0 and
           Clouds.Lower_Layer_Ceiling(The_Clouds) /= 0;
      elsif Clouds.Upper_Layer_Active(The_Clouds) then
         Pass := Clouds.Lower_Layer_Ceiling(The_Clouds) = 0 and
           Clouds.Lower_Layer_Top(The_Clouds) = 0 and
           Clouds.Upper_Layer_Top(The_Clouds) >
           Clouds.Upper_Layer_Ceiling(The_Clouds) and
           Clouds.Upper_Layer_Top(The_Clouds) /= 0 and
           Clouds.Upper_Layer_Ceiling(The_Clouds) /= 0;
      else
         Pass := False;
      end if;

      Class_Test_Result_File.Report_Case_Status (Pass);

      if Pass then
         Put("Test Number ");
         Put(I);
         Put_Line(" Passed");
      else
         Put("Test Number ");
         Put(I);
         Put_Line(" Failed");
      end if;

   end loop;

   Put_Line("Finished");
end Clouds_Ct;
