-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  James F. Narrin
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Jpats_Visual_Models.Controller;
with Jpats_Visual_Models.Ios_If;
with Class_Test_Result_File;

procedure Jpats_Visual_Models.Controller_Ctd is

   -------------------------------------------------------
   -- Test Case 1
   --
   -- Inputs:
   --   Lower Cloud Layer Scattered
   --   Upper Cloud Layer Broken
   --
   -- Expected Results:
   --   Cloud model is activated with the proper settings
   --
   -- Purpose:
   --   To check that when scattered or broken clouds is selected
   --   for one of the cloud layers in the weather category, the
   --   approriate model is activated in this category.
   --
   -- Interfaces Tested:
   --   Jpats_Visual_Models_Category to Jpats_Visual_Airport and
   --   Jpats_Visual_Weather_Category and Jpats_Avionics_Category
   procedure Test_Case_1 is
      Pass : Boolean := False;
   begin

      Jpats_Visual_Models.Controller.Initialize;

      Jpats_Visual_Models.Controller.Update(0.067);

      Pass := (abs(Jpats_Visual_Models.Cloud_Position(1).Latitude - 45.0)
               < 0.0001) and
        (abs(Jpats_Visual_Models.Cloud_Position(1).Longitude + 45.0)
         < 0.0001) and
        (abs(Jpats_Visual_Models.Cloud_Position(2).Latitude - 45.0)
         < 0.0001) and
        (abs(Jpats_Visual_Models.Cloud_Position(2).Longitude + 45.0)
         < 0.0001) and
        (abs(Jpats_Visual_Models.Cloud_Position(1).Altitude - 8000.0)
         < 0.0001) and
        (abs(Jpats_Visual_Models.Cloud_Position(2).Altitude - 12000.0)
         < 0.0001) and
        Jpats_Visual_Models.Cloud_Type(1) = 60022 and
        Jpats_Visual_Models.Cloud_Type(2) = 60023 and
        Jpats_Visual_Models.Cloud_Active(1) and
        Jpats_Visual_Models.Cloud_Active(2) and
        not Jpats_Visual_Models.Host_Hazard_Active(1) and
        not Jpats_Visual_Models.Host_Hazard_Active(2) and
        not Jpats_Visual_Models.Host_Hazard_Active(3);

      Class_Test_Result_File.Report_Case_Status(Pass);

   end Test_Case_1;

   -------------------------------------------------------
   -- Test Case 2
   --   Lower Cloud Layer Broken
   --   Upper Cloud Layer Scattered
   --
   -- Inputs:
   --
   -- Expected Results:
   --   Cloud model is activated with the proper settings
   --
   -- Purpose:
   --   To check that when scattered or broken clouds is selected
   --   for one of the cloud layers in the weather category, the
   --   approriate model is activated in this category.
   --
   -- Interfaces Tested:
   --   Jpats_Visual_Models_Category to Jpats_Visual_Airport and
   --   Jpats_Visual_Weather_Category and Jpats_Avionics_Category
   procedure Test_Case_2 is
      Pass : Boolean := False;
   begin
      Jpats_Visual_Models.Controller.Initialize;

      Jpats_Visual_Models.Controller.Update(0.067);

      Pass := (abs(Jpats_Visual_Models.Cloud_Position(1).Latitude - 45.0)
               < 0.0001) and
        (abs(Jpats_Visual_Models.Cloud_Position(1).Longitude + 45.0)
         < 0.0001) and
        (abs(Jpats_Visual_Models.Cloud_Position(2).Latitude - 45.0)
         < 0.0001) and
        (abs(Jpats_Visual_Models.Cloud_Position(2).Longitude + 45.0)
         < 0.0001) and
        (abs(Jpats_Visual_Models.Cloud_Position(1).Altitude - 8000.0)
         < 0.0001) and
        (abs(Jpats_Visual_Models.Cloud_Position(2).Altitude - 12000.0)
         < 0.0001) and
        Jpats_Visual_Models.Cloud_Type(1) = 60023 and
        Jpats_Visual_Models.Cloud_Type(2) = 60022 and
        Jpats_Visual_Models.Cloud_Active(1) and
        Jpats_Visual_Models.Cloud_Active(2) and
        not Jpats_Visual_Models.Host_Hazard_Active(1) and
        not Jpats_Visual_Models.Host_Hazard_Active(2) and
        not Jpats_Visual_Models.Host_Hazard_Active(3);

      Class_Test_Result_File.Report_Case_Status(Pass);

   end Test_Case_2;

   -------------------------------------------------------
   -- Test Case 3
   --
   -- Inputs:
   --   Two Active Intruders from Jpats_Avionics Cat
   --
   -- Expected Results:
   --   Two moving models are activated with the correct model
   --   data from the Jpats_Avionics category.
   --
   -- Purpose:
   --   To test that when moving models are activated in the
   --   avionics category, the appropriate model is activated
   --   in this category.
   --
   -- Interfaces Tested:
   --   Jpats_Visual_Models_Category to Jpats_Visual_Airport and
   --   Jpats_Visual_Weather_Category and Jpats_Avionics_Category
   procedure Test_Case_3 is
      Pass : Boolean := False;
   begin
      Jpats_Visual_Models.Controller.Initialize;

      Jpats_Visual_Models.Controller.Update(0.067);

      Pass := not Jpats_Visual_Models.Cloud_Active(1) and
        not Jpats_Visual_Models.Cloud_Active(2) and
        Jpats_Visual_Models.Host_Hazard_Active(1) and
        Jpats_Visual_Models.Host_Hazard_Active(2) and
        not Jpats_Visual_Models.Host_Hazard_Active(3) and
        Jpats_Visual_Models.Host_Hazard_Type(1) = 25 and
        Jpats_Visual_Models.Host_Hazard_Type(2) = 26 and
        (abs(Jpats_Visual_Models.Host_Hazard_Position(1).Latitude - 44.0)
         < 0.0001) and
        (abs(Jpats_Visual_Models.Host_Hazard_Position(1).Longitude + 45.0)
         < 0.0001) and
        (abs(Jpats_Visual_Models.Host_Hazard_Position(1).Altitude - 4000.0)
         < 0.0001) and
        (abs(Jpats_Visual_Models.Host_Hazard_Position(2).Latitude - 45.0)
         < 0.0001) and
        (abs(Jpats_Visual_Models.Host_Hazard_Position(2).Longitude + 44.0)
         < 0.0001) and
        (abs(Jpats_Visual_Models.Host_Hazard_Position(2).Altitude - 6000.0)
         < 0.0001) and
        (abs(Jpats_Visual_Models.Host_Hazard_Heading(1) - 130.0) < 0.001) and
        (abs(Jpats_Visual_Models.Host_Hazard_Heading(2) - 230.0) < 0.001) and
        (abs(Jpats_Visual_Models.Host_Hazard_Pitch(1) - 10.0) < 0.001) and
        (abs(Jpats_Visual_Models.Host_Hazard_Pitch(2) + 10.0) < 0.001) and
        (abs(Jpats_Visual_Models.Host_Hazard_Roll(1) - 25.0) < 0.001) and
        (abs(Jpats_Visual_Models.Host_Hazard_Roll(2) - 15.0) < 0.001);

      Class_Test_Result_File.Report_Case_Status(Pass);

   end Test_Case_3;

   -------------------------------------------------------
   -- Test Case 4
   --
   -- Inputs:
   --   Ground Hazard Set Active
   --
   -- Expected Results:
   --   The ground hazard is activated with the appropriate path
   --
   -- Purpose:
   --   The test that when a ground hazard is selected on the IOS,
   --   the model is activated in this category.
   --
   -- Interfaces Tested:
   --   Jpats_Visual_Models_Category to Jpats_Visual_Airport and
   --   Jpats_Visual_Weather_Category and Jpats_Avionics_Category
   procedure Test_Case_4 is
      Pass : Boolean := False;
   begin
      Jpats_Visual_Models.Controller.Initialize;

      Jpats_Visual_Models.Ios_If.Set_Ground_Hazard_On(True);
      Jpats_Visual_Models.Ios_If.Set_Ground_Hazard_Path(20);
      Jpats_Visual_Models.Ios_If.Set_Ground_Hazard_Type(25);

      Jpats_Visual_Models.Controller.Update(0.067);

      Pass := not Jpats_Visual_Models.Cloud_Active(1) and
        not Jpats_Visual_Models.Cloud_Active(2) and
        not Jpats_Visual_Models.Host_Hazard_Active(1) and
        not Jpats_Visual_Models.Host_Hazard_Active(2) and
        not Jpats_Visual_Models.Host_Hazard_Active(3) and
        Jpats_Visual_Models.Ground_Hazard_Active and
        Jpats_Visual_Models.Ground_Hazard_Model_Type = 25 and
        Jpats_Visual_Models.Ground_Hazard_Path = 20;

      Class_Test_Result_File.Report_Case_Status(Pass);

   end Test_Case_4;


begin

   Test_Case_1;
   Test_Case_2;
   Test_Case_3;
   Test_Case_4;

end;
