-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  James F. Narrin
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Ada.Text_Io;
with Ada.Integer_Text_Io;
with Scene_Collection;
with Class_Test_Result_File;
with Jpats_Visual_Airport_Types;
with Lat_Long_Types;

use Ada.Text_Io;
use Ada.Integer_Text_Io;

procedure Scene_Collection_Ct is

   type Scene_Mode is (Test_Area, Atlanta,
		       Gatwick, Tulsa,
		       Change_Lat_Lon_1, Change_Lat_Lon_2);

   type Mode_Array is array (1..6) of Scene_Mode;

   Mode : constant Mode_Array :=
     (Test_Area, Atlanta,
      Gatwick, Tulsa,
      Change_Lat_Lon_1, Change_Lat_Lon_2);

   Airport_Name : Jpats_Visual_Airport_Types.Name_Type;
   Runway_Name : Jpats_Visual_Airport_Types.Name_Type;
   Visual_Name : Jpats_Visual_Airport_Types.Name_Type;
   Runway_Position : Lat_Long_Types.Position;
   Runway_Heading : Float;
   Aircraft_Lat : Lat_Long_Types.Latitude_Degrees;
   Aircraft_Lon : Lat_Long_Types.Longitude_Degrees;
   
   Pass : Boolean;

begin
   
   Scene_Collection.Initialize_List;
   
   for I in 1..6 loop

      if Mode(I) = Test_Area then
	 Airport_Name := "KTST";
	 Runway_Name := "27  ";
	 Runway_Position.Latitude := 45.000000;
	 Runway_Position.Longitude := -44.9573334;
	 Runway_Position.Altitude := 1000.0;
	 Runway_Heading := 270.0;
	 Scene_Collection.Set_Airport
	   (Airport_Name,
	    Visual_Name,
	    Runway_Name,
	    Runway_Position,
	    Runway_Heading);
	 Pass := Airport_Name = "KTST" and 
	   Visual_Name = "ktst";
      
      elsif Mode(I) = Atlanta then
	 Airport_Name := "KATL";
	 Runway_Name := "09R ";
	 Runway_Position.Latitude := 33.6318189;
	 Runway_Position.Longitude := -84.447967;
	 Runway_Position.Altitude := 1026.0;
	 Runway_Heading := 90.0;
	 Scene_Collection.Set_Airport
	   (Airport_Name,
	    Visual_Name,
	    Runway_Name,
	    Runway_Position,
	    Runway_Heading);
	 Pass := Airport_Name = "KATL" and 
	   Visual_Name = "katl";
      
      elsif Mode(I) = Gatwick then
	 Airport_Name := "EGKK";
	 Runway_Name := "08R ";
	 Runway_Position.Latitude := 51.1452999;
	 Runway_Position.Longitude := -0.2053359;
	 Runway_Position.Altitude := 196.0;
	 Runway_Heading := 78.0;
	 Scene_Collection.Set_Airport
	   (Airport_Name,
	    Visual_Name,
	    Runway_Name,
	    Runway_Position,
	    Runway_Heading);
	 Pass := Airport_Name = "EGKK" and 
	   Visual_Name = "egkk";

      elsif Mode(I) = Tulsa then
	 Airport_Name := "KTUL";
	 Runway_Name := "36R ";
	 Runway_Position.Latitude := 36.1865520;
	 Runway_Position.Longitude := -95.8831437;
	 Runway_Position.Altitude := 643.0;
	 Runway_Heading := 3.1;
	 Scene_Collection.Set_Airport
	   (Airport_Name,
	    Visual_Name,
	    Runway_Name,
	    Runway_Position,
	    Runway_Heading);
	 Pass := Airport_Name = "KTUL" and 
	   Visual_Name = "****";

      elsif Mode(I) =  Change_Lat_Lon_1 then
	 Aircraft_Lat := 37.513525;
	 Aircraft_Lon := -122.20000;
	 Scene_Collection.Find_Closest_Airport
	   (Aircraft_Lat,
	    Aircraft_Lon,
	    Airport_Name,
	    Visual_Name,
	    Runway_Name,
	    Runway_Position,
	    Runway_Heading);
	 Pass := Airport_Name = "KSFO" and
	   Runway_Name = "28R " and
	   Visual_Name = "ksfo";
	 
      elsif Mode(I) = Change_Lat_Lon_2 then
	 Aircraft_Lat := 36.186552;
	 Aircraft_Lon := -95.8831437;
	 Scene_Collection.Find_Closest_Airport
	   (Aircraft_Lat,
	    Aircraft_Lon,
	    Airport_Name,
	    Visual_Name,
	    Runway_Name,
	    Runway_Position,
	    Runway_Heading);
	 Pass := Airport_Name = "KTUL" and
	   Runway_Name = "36R " and
	   Visual_Name = "****";

      end if;


      Class_Test_Result_File.Report_Case_Status (Pass);

      if Pass then
         Put("Test Number ");
         Put(I);
         Put_Line(" Passed");
      else
         Put("Test Number ");
         Put(I);
         Put_Line(" Failed");
      end if;

   end loop;
   
   Put_Line("Finished");
end Scene_Collection_Ct;
