-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  James F. Narrin
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Jpats_Visual_Airport.Controller;
with Jpats_Visual_Airport.Ios_If;
with Class_Test_Result_File;
with Ada.Text_Io;
use Ada.Text_Io;
with Ada.Integer_Text_Io;
use Ada.Integer_Text_Io;

procedure Jpats_Visual_Airport.Controller_Ctd is


   -------------------------------------------------------
   -- Test Case 1
   --
   -- Inputs:
   --   Active airport and position at KDCA runway 03
   --
   -- Expected Results:
   --   Airport ident and position is KDCA
   --   Visual code is "kdca"
   --   Runway is 03
   --
   -- Purpose:
   --   To test the airport selected, search and configuration
   --   functions
   --
   -- Interfaces Tested:
   --   Jpats_Visual_Airport_Category to Jpats_Visual_Weather and
   --   Jpats_Simulated_Aircraft and Jpats_Reposition
   procedure Test_Case_1 is
      Pass : Boolean := False;
   begin

      Jpats_Visual_Airport.Controller.Initialize;

      Jpats_Visual_Airport.Controller.Update(0.067);

      Pass := Jpats_Visual_Airport.Airport_Icao_Code = "KDCA" and
        Jpats_Visual_Airport.Visual_Airport_Code = "kdca" and
        Jpats_Visual_Airport.Selected_Runway = "03  " and
        Jpats_Visual_Airport.Runway_Number = 3 and
        Jpats_Visual_Airport.Runway_Length = 10000 and
        Jpats_Visual_Airport.Runway_Width = 100 and
        (abs(Jpats_Visual_Airport.Runway_Position.Latitude - 38.8433)
         < 0.001) and
        (abs(Jpats_Visual_Airport.Runway_Position.Longitude + 77.0401)
         < 0.001);

      Class_Test_Result_File.Report_Case_Status(Pass);

   end Test_Case_1;

   -------------------------------------------------------
   -- Test Case 2
   --
   -- Inputs:
   --   Airport and position at KTUL runway 18L
   --
   -- Expected Results:
   --   Airport ident and position is KTUL
   --   Visual code is "****"
   --   Runway is 18L
   --
   -- Purpose:
   --   To test the airport selected, search and configuration
   --   functions
   --
   -- Interfaces Tested:
   --   Jpats_Visual_Airport_Category to Jpats_Visual_Weather and
   --   Jpats_Simulated_Aircraft and Jpats_Reposition
   procedure Test_Case_2 is
      Pass : Boolean := False;
   begin

      Jpats_Visual_Airport.Controller.Initialize;

      Jpats_Visual_Airport.Controller.Update(0.067);

      Pass := Jpats_Visual_Airport.Airport_Icao_Code = "KTUL" and
        Jpats_Visual_Airport.Visual_Airport_Code = "****" and
        Jpats_Visual_Airport.Selected_Runway = "18L " and
        Jpats_Visual_Airport.Runway_Number = 18 and
        Jpats_Visual_Airport.Runway_Length = 10100 and
        Jpats_Visual_Airport.Runway_Width = 110 and
        (abs(Jpats_Visual_Airport.Runway_Position.Latitude - 36.213942)
         < 0.001) and
        (abs(Jpats_Visual_Airport.Runway_Position.Longitude + 95.88131)
         < 0.001);


      Class_Test_Result_File.Report_Case_Status(Pass);

   end Test_Case_2;

   -------------------------------------------------------
   -- Test Case 3
   --
   -- Inputs:
   --   Initial airport of KTUL, reposition to KBOS runway 04L
   --
   -- Expected Results:
   --   Airport ident and position is KBOS
   --   Visual code is "kbos"
   --   Runway is 04L
   --
   -- Purpose:
   --   To test the airport selected, search and configuration
   --   functions
   --
   -- Interfaces Tested:
   --   Jpats_Visual_Airport_Category to Jpats_Visual_Weather and
   --   Jpats_Simulated_Aircraft and Jpats_Reposition
   procedure Test_Case_3 is
      Pass : Boolean := False;
   begin

      Jpats_Visual_Airport.Controller.Initialize;

      Jpats_Visual_Airport.Controller.Update(0.067);

      Jpats_Visual_Airport.Controller.Update(0.067);

      Pass := Jpats_Visual_Airport.Airport_Icao_Code = "KBOS" and
        Jpats_Visual_Airport.Visual_Airport_Code = "kbos" and
        Jpats_Visual_Airport.Selected_Runway = "04L " and
        Jpats_Visual_Airport.Runway_Number = 4 and
        Jpats_Visual_Airport.Runway_Length = 10200 and
        Jpats_Visual_Airport.Runway_Width = 120 and
        (abs(Jpats_Visual_Airport.Runway_Position.Latitude - 42.357988)
         < 0.001) and
        (abs(Jpats_Visual_Airport.Runway_Position.Longitude + 71.014339)
         < 0.001);


      Class_Test_Result_File.Report_Case_Status(Pass);

   end Test_Case_3;

   -------------------------------------------------------
   -- Test Case 4
   --
   -- Inputs:
   --   Airport and initial position KDFW runway 32R, reposition to
   --   runway 13L
   --
   -- Expected Results:
   --   Airport ident and position is KDFW
   --   Visual code is "kdfw"
   --   Runway is 13L
   --
   -- Purpose:
   --   To test the airport selected, search and configuration
   --   functions
   --
   -- Interfaces Tested:
   --   Jpats_Visual_Airport_Category to Jpats_Visual_Weather and
   --   Jpats_Simulated_Aircraft and Jpats_Reposition
   procedure Test_Case_4 is
      Pass : Boolean := False;
   begin

      Jpats_Visual_Airport.Controller.Initialize;


      Jpats_Visual_Airport.Controller.Update(0.067);

      Jpats_Visual_Airport.Controller.Update(0.067);

      Pass := Jpats_Visual_Airport.Airport_Icao_Code = "KDFW" and
        Jpats_Visual_Airport.Visual_Airport_Code = "kdfw" and
        Jpats_Visual_Airport.Selected_Runway = "13L " and
        Jpats_Visual_Airport.Runway_Number = 13 and
        Jpats_Visual_Airport.Runway_Length = 10300 and
        Jpats_Visual_Airport.Runway_Width = 130 and
        (abs(Jpats_Visual_Airport.Runway_Position.Latitude - 32.912584)
         < 0.001) and
        (abs(Jpats_Visual_Airport.Runway_Position.Longitude + 97.021194)
         < 0.001);


      Class_Test_Result_File.Report_Case_Status(Pass);

   end Test_Case_4;

   -------------------------------------------------------
   -- Test Case 5
   --
   -- Inputs:
   --   Airport and position at KATL runway 08L, turn all
   --   lights on
   --
   -- Expected Results:
   --   Airport ident and position is KATL
   --   Visual code is "katl"
   --   Runway is 08L
   --   All Lights on
   --
   -- Purpose:
   --   To test the light setting functions.
   --
   -- Interfaces Tested:
   --   Jpats_Visual_Airport_Category to Jpats_Visual_Weather and
   --   Jpats_Simulated_Aircraft and Jpats_Reposition
   procedure Test_Case_5 is
      Pass : Boolean := False;
   begin

      Jpats_Visual_Airport.Controller.Initialize;

      Jpats_Visual_Airport.Ios_If.Set_Approach_Li(5);
      Jpats_Visual_Airport.Ios_If.Set_Runway_Edge_Li(5);
      Jpats_Visual_Airport.Ios_If.Set_Runway_Center_Line_Li(5);
      Jpats_Visual_Airport.Ios_If.Set_Strobe_Li(5);
      Jpats_Visual_Airport.Ios_If.Set_Vasi_Papi_Li(5);
      Jpats_Visual_Airport.Ios_If.Set_Reil_Li(5);
      Jpats_Visual_Airport.Ios_If.Set_Runway_Fixed_Distance_Li(5);
      Jpats_Visual_Airport.Ios_If.Set_Threshold_Li(5);
      Jpats_Visual_Airport.Ios_If.Set_Td_Zone_Li(5);
      Jpats_Visual_Airport.Ios_If.Set_Runway_Agl_Lead_In_Li(5);
      Jpats_Visual_Airport.Ios_If.Set_Taxiway_Li(5);
      Jpats_Visual_Airport.Ios_If.Set_Cultural_Li(5);

      Jpats_Visual_Airport.Controller.Update(0.067);

      Pass := Jpats_Visual_Airport.Airport_Icao_Code = "KATL" and
        Jpats_Visual_Airport.Visual_Airport_Code = "katl" and
        Jpats_Visual_Airport.Selected_Runway = "08L " and
        Jpats_Visual_Airport.Runway_Number = 8 and
        Jpats_Visual_Airport.Runway_Length = 10400 and
        Jpats_Visual_Airport.Runway_Width = 140 and
        (abs(Jpats_Visual_Airport.Runway_Position.Latitude - 33.649533)
         < 0.001) and
        (abs(Jpats_Visual_Airport.Runway_Position.Longitude + 84.439021)
         < 0.001) and
        Jpats_Visual_Airport.Approach_Intensity = 5 and
        Jpats_Visual_Airport.Runway_Edge_Intensity = 5 and
        Jpats_Visual_Airport.Center_Line_Intensity = 5 and
        Jpats_Visual_Airport.Strobe_Intensity = 5 and
        Jpats_Visual_Airport.Vasi_Papi_Intensity = 5 and
        Jpats_Visual_Airport.Reil_Intensity = 5 and
        Jpats_Visual_Airport.Fixed_Distance_Intensity = 5 and
        Jpats_Visual_Airport.Threshold_Intensity = 5 and
        Jpats_Visual_Airport.Td_Zone_Intensity = 5 and
        Jpats_Visual_Airport.Agl_Intensity = 5 and
        Jpats_Visual_Airport.Taxiway_Light_Intensity = 5 and
        Jpats_Visual_Airport.Cultural_Intensity = 5;

      Class_Test_Result_File.Report_Case_Status(Pass);

   end Test_Case_5;


   -------------------------------------------------------
   -- Test Case 6
   --
   -- Inputs:
   --   Airport and position at KMIA runway 09L, Blowing snow on
   --
   -- Expected Results:
   --   Airport ident and position is KMIA
   --   Visual code is "kmia"
   --   Runway is 09L
   --
   -- Purpose:
   --   To test the runway contamination function.
   --
   -- Interfaces Tested:
   --   Jpats_Visual_Airport_Category to Jpats_Visual_Weather and
   --   Jpats_Simulated_Aircraft and Jpats_Reposition
   procedure Test_Case_6 is
      Pass : Boolean := False;
   begin

      Jpats_Visual_Airport.Controller.Initialize;

      Jpats_Visual_Airport.Ios_If.Set_Runway_Contamination_Select(3);
      Jpats_Visual_Airport.Ios_If.Set_Runway_Blowing_Contaminant(True);

      Jpats_Visual_Airport.Controller.Update(0.067);

      Pass := Jpats_Visual_Airport.Airport_Icao_Code = "KMIA" and
        Jpats_Visual_Airport.Visual_Airport_Code = "kmia" and
        Jpats_Visual_Airport.Selected_Runway = "09L " and
        Jpats_Visual_Airport.Runway_Number = 9 and
        Jpats_Visual_Airport.Runway_Length = 10500 and
        Jpats_Visual_Airport.Runway_Width = 150 and
        (abs(Jpats_Visual_Airport.Runway_Position.Latitude - 25.800801)
         < 0.001) and
        (abs(Jpats_Visual_Airport.Runway_Position.Longitude + 80.301479)
         < 0.001) and
        Jpats_Visual_Airport.Snowy_Runway and
        Jpats_Visual_Airport.Blowing_Contaminant;


      Class_Test_Result_File.Report_Case_Status(Pass);

   end Test_Case_6;


begin

   Test_Case_1;
   Test_Case_2;
   Test_Case_3;
   Test_Case_4;
   Test_Case_5;
   Test_Case_6;

end;
