-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  James F. Narrin
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Config_Collection;
with Class_Test_Result_File;

procedure Config_Collection_Ctd is

   Length : Integer;
   Width : Integer;
   Glideslope : Float;
   App_Path : Integer;
   Vasi : Integer;
   Markings :Integer;
   Reil : Boolean;
   Terrain : Integer;
   Building : Boolean;

   -------------------------------------------------------
   -- Test Case 1
   --
   -- Inputs:
   --   Airport Select of KTUL and runway of 36R
   --
   -- Expected Results:
   --   Data return that agrees with information from the
   --   data file
   --
   -- Purpose:
   --   To test the file read in and look up function of the
   --   generic airport configuration data table
   --
   -- Interfaces Tested:
   --   Config_Collection package and data file
   procedure Test_Case_1 is
      Pass : Boolean := False;
   begin

      Config_Collection.Initialize_List;

      Config_Collection.Find_Configuration
        ("KTUL","36R ",Length,Width,Glideslope,App_Path,
         Vasi,Markings,Reil,Terrain,Building);

      Pass := (Length = 9500) and
        (Width = 125) and
        (abs(Glideslope - 2.9) < 0.0001) and
        (App_Path = 1) and
        (Vasi = 1) and
        (Markings = 1) and
        not Reil and
        (Terrain = 1) and
        not Building;

      Class_Test_Result_File.Report_Case_Status(Pass);

   end Test_Case_1;

   -------------------------------------------------------
   -- Test Case 2
   --
   -- Inputs:
   --   Selected airport of KTUL and runway 18R
   --
   -- Expected Results:
   --   Data return that agrees with information from the
   --   data file
   --
   -- Purpose:
   --   To test the file read in and look up function of the
   --   generic airport configuration data table
   --
   -- Interfaces Tested:
   --   Config_Collection package and data file
   procedure Test_Case_2 is
      Pass : Boolean := False;
   begin

      Config_Collection.Initialize_List;

      Config_Collection.Find_Configuration
        ("KTUL","18R ",Length,Width,Glideslope,App_Path,
         Vasi,Markings,Reil,Terrain,Building);

      Pass := (Length = 6500) and
        (Width = 75) and
        (abs(Glideslope - 3.0) < 0.0001) and
        (App_Path = 2) and
        (Vasi = 2) and
        (Markings = 2) and
        Reil and
        (Terrain = 2) and
        Building;


      Class_Test_Result_File.Report_Case_Status(Pass);

   end Test_Case_2;

   -------------------------------------------------------
   -- Test Case 3
   --
   -- Inputs:
   --   Selected Airport of KRVS and runway 01R
   --
   -- Expected Results:
   --   Data return that agrees with information from the
   --   data file
   --
   -- Purpose:
   --   To test the file read in and look up function of the
   --   generic airport configuration data table
   --
   -- Interfaces Tested:
   --   Config_Collection package and data file
   procedure Test_Case_3 is
      Pass : Boolean := False;
   begin

      Config_Collection.Initialize_List;

      Config_Collection.Find_Configuration
        ("KRVS","01R ",Length,Width,Glideslope,App_Path,
         Vasi,Markings,Reil,Terrain,Building);

      Pass := (Length = 5500) and
        (Width = 100) and
        (abs(Glideslope - 3.1) < 0.0001) and
        (App_Path = 3) and
        (Vasi = 3) and
        (Markings = 3) and
        not Reil and
        (Terrain = 3) and
        not Building;

      Class_Test_Result_File.Report_Case_Status(Pass);

   end Test_Case_3;

   -------------------------------------------------------
   -- Test Case 4
   --
   -- Inputs:
   --   Selected airport of KATL and runway 36R
   --
   -- Expected Results:
   --   Returned runway length is 0 because airport is not in
   --   table
   --
   -- Purpose:
   --   To test the file read in and look up function of the
   --   generic airport configuration data table
   --
   -- Interfaces Tested:
   --   Config_Collection package and data file
   procedure Test_Case_4 is
      Pass : Boolean := False;
   begin

      Config_Collection.Initialize_List;

      Config_Collection.Find_Configuration
        ("KATL","36R ",Length,Width,Glideslope,App_Path,
         Vasi,Markings,Reil,Terrain,Building);

      Pass := (Length = 0);

      Class_Test_Result_File.Report_Case_Status(Pass);

   end Test_Case_4;

begin

   Test_Case_1;
   Test_Case_2;
   Test_Case_3;
   Test_Case_4;

end;
