-------------------------------------------------------------------------------
--|
--|            FlightSafety International Simulation Systems Division
--|                     Broken Arrow, OK  USA  918-259-4000
--|
--|                  JPATS T-6A Texan-II Flight Training Device
--|
--|
--|   Engineer:  Yogesh Tupe
--|
--|   Revision:  (Number and date inserted by Clearcase)
--|
--|
--|  DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
--|  Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
--|  technical or operational data or information from automatic dissemination
--|  under the International Exchange Program or by other means.  This protection
--|  covers information required solely for administrative or operational
--|  purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--|
--|  WARNING:  This document contains technical data whose export is restricted
--|  by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
--|  Executive Order 12470.  Violation of these export control laws is subject
--|  to severe criminal penalties.  Dissemination of this document is controlled
--|  under DOD Directive 5230.25
--|
-------------------------------------------------------------------------------
--|

with Ada.Text_IO;                              use Ada.Text_IO;
with Ada.Float_Text_IO;                        use Ada.Float_Text_IO;
with Ada.Integer_Text_IO;                      use Ada.Integer_Text_IO;
with Ada.Long_Float_Text_IO;                   use Ada.Long_Float_Text_IO;
with Ada.Numerics;
with Ada.Numerics.Elementary_Functions;        use Ada.Numerics.Elementary_Functions;


with Velocity;

with Angle_Types;
with Coordinate_Types;
with Length_Types;
with Mass_Types;
with Length_Types;
with Class_Test_Result_File;


procedure EXECUTE_Velocity is
   An_Instance                           : Velocity.Instance;

   A_Roll_Angle                          : Angle_Types.Radians;
   A_Pitch_Angle                         : Angle_Types.Radians;
   A_Yaw_Angle                           : Angle_Types.Radians;
   A_Velocity_Earth_Axis                 : Coordinate_Types.Cartesian;
   A_Predefined_Inertial_Velocity        : Coordinate_Types.Cartesian;

   A_Turbulence_Velocity                 : Coordinate_Types.Cartesian;
   A_Predefined_Velocity_Body_Axis       : Coordinate_Types.Cartesian;

   An_Acceleration_Earth_Axis            : Coordinate_Types.Cartesian;
   A_Last_Pass_Acceleration_Earth_Axis   : Coordinate_Types.Cartesian;
   A_Wind_Velocity                       : Coordinate_Types.Cartesian;
   An_Integration_Constant               : Float := 1.0/60.0;
   A_Predefined_Velocity_Earth_Axis      : Coordinate_Types.Cartesian;
   A_Predefined_Last_Pass_Velocity       : Coordinate_Types.Cartesian;
   A_True_Airspeed                       : Length_Types.Feet_per_Sec;
   A_Heading_Angle                       : Angle_Types.Radians;
   An_Air_Density_at_Altitude            : Mass_Types.Slugs_per_Cubic_Feet;
   A_Sealevel_Air_Density                : Mass_Types.Slugs_per_Cubic_Feet;
   A_Predefined_Angle_of_Attack          : Angle_Types.Radians;

   A_Predefined_Pitch_Rate                : Angle_Types.Radians_per_Sec;
   A_Predefined_Last_Pass_Pitch_Rate      : Angle_Types.Radians_per_Sec;
   A_Predefined_Roll_Rate                 : Angle_Types.Radians_per_Sec;
   A_Predefined_Last_Pass_Roll_Rate       : Angle_Types.Radians_per_Sec;
   A_Predefined_Yaw_Rate                  : Angle_Types.Radians_per_Sec;
   A_Predefined_Last_Pass_Yaw_Rate        : Angle_Types.Radians_per_Sec;

   A_Pitch_Acceleration                   : Angle_Types.Radians_per_Sq_Sec;
   A_Last_Pass_Pitch_Acceleration         : Angle_Types.Radians_per_Sq_Sec;
   A_Turbulence_Pitch_Rate_Body_Axis      : Angle_Types.Radians_per_Sq_Sec;

   A_Roll_Acceleration                    : Angle_Types.Radians_per_Sq_Sec;
   A_Last_Pass_Roll_Acceleration          : Angle_Types.Radians_per_Sq_Sec;
   A_Turbulence_Roll_Rate_Body_Axis       : Angle_Types.Radians_per_Sq_Sec;

   A_Yaw_Acceleration                     : Angle_Types.Radians_per_Sq_Sec;
   A_Last_Pass_Yaw_Acceleration           : Angle_Types.Radians_per_Sq_Sec;
   A_Turbulence_Yaw_Rate_Body_Axis        : Angle_Types.Radians_per_Sq_Sec;

   A_Predefined_Nondimensional_Angular_Rate  :Coordinate_Types.Attitude;

   A_Span_Wing                            : Length_Types.Feet;
   A_Chord_Wing                           : Length_Types.Feet;
   An_Angle_of_Attack                     : Angle_Types.Radians;
   A_Side_Slip_Angle                      : Angle_Types.Radians;

   Pass : Boolean := False;
   A_Tolerance : Float := 0.1;

begin


   A_Predefined_Pitch_Rate           := -0.4511952;
   A_Predefined_Last_Pass_Pitch_Rate := -0.4511952;
   --| This procedure will set the Pitch_Rate calculated during initalization, autotesting
   --| or when Pitch_Rate is defined by an approved other method.
   Velocity.Assign_Pitch_Rate (A_Predefined_Pitch_Rate           ,
                               A_Predefined_Last_Pass_Pitch_Rate,
                               An_Instance                      );
   --Put(Velocity.Get_Pitch_Rate(An_Instance));
   --Put_Line(" Pitch_Rate ");
   --Put(Velocity.Get_Last_Pass_Pitch_Rate(An_Instance));
   --Put_Line(" Last_Pass_Pitch_Rate ");

   A_Pitch_Acceleration              := -0.4833989;
   A_Last_Pass_Pitch_Acceleration    := -0.5523947;
   A_Turbulence_Pitch_Rate_Body_Axis := 0.0;
   --| This procedure computes the Pitch Angular Rate.
   Velocity.Set_Pitch_Rate (A_Pitch_Acceleration              ,
                            A_Last_Pass_Pitch_Acceleration   ,
                            A_Turbulence_Pitch_Rate_Body_Axis,
                            An_Integration_Constant          ,
                            An_Instance                      );
   Put(Velocity.Get_Pitch_Rate(An_Instance));
   Put_Line(" Pitch_Rate ");
   -- Put(Velocity.Get_Last_Pass_Pitch_Rate(An_Instance));
   -- Put_Line(" Last_Pass_Pitch_Rate ");

   A_Predefined_Roll_Rate            := -0.8729095;
   A_Predefined_Last_Pass_Roll_Rate  := -0.8729095;
   --| This procedure will set the Roll_Rate calculated during initalization, autotesting
   --| or when Roll_Rate is defined by an approved other method.
   Velocity.Assign_Roll_Rate (A_Predefined_Roll_Rate           ,
                              A_Predefined_Last_Pass_Roll_Rate ,
                              An_Instance                     );
   --Put(Velocity.Get_Roll_Rate(An_Instance));
   --Put_Line(" Roll_Rate ");
   --Put(Velocity.Get_Last_Pass_Roll_Rate(An_Instance));
   --Put_Line(" Last_Pass_Roll_Rate ");

   A_Roll_Acceleration              := -1.499341;
   A_Last_Pass_Roll_Acceleration    := -1.564003;
   A_Turbulence_Roll_Rate_Body_Axis := 0.0;
   --| This procedure computes the Roll Angular Rate.
   Velocity.Set_Roll_Rate (A_Roll_Acceleration             ,
                           A_Last_Pass_Roll_Acceleration   ,
                           A_Turbulence_Roll_Rate_Body_Axis,
                           An_Integration_Constant         ,
                           An_Instance                     );
   Put(Velocity.Get_Roll_Rate(An_Instance));
   Put_Line(" Roll_Rate ");
   --Put(Velocity.Get_Last_Pass_Roll_Rate(An_Instance));
   --Put_Line(" Last_Pass_Roll_Rate ");


   A_Predefined_Yaw_Rate           := -0.2850278;
   A_Predefined_Last_Pass_Yaw_Rate := -0.2850278;
   --| This procedure will set the Yaw_Rate calculated during initalization, autotesting
   --| or when Yaw_Rate is defined by an approved other method.
   Velocity.Assign_Yaw_Rate (A_Predefined_Yaw_Rate          ,
                             A_Predefined_Last_Pass_Yaw_Rate ,
                             An_Instance                    );
   --  Put(Velocity.Get_Yaw_Rate(An_Instance));
   --  Put_Line(" Yaw_Rate ");
   --  Put(Velocity.Get_Last_Pass_Yaw_Rate(An_Instance));
   --  Put_Line(" Last_Pass_Yaw_Rate ");

   A_Yaw_Acceleration              := -0.8409511;
   A_Last_Pass_Yaw_Acceleration    := -0.8638889;
   A_Turbulence_Yaw_Rate_Body_Axis := 0.0;
   Velocity.Set_Yaw_Rate (A_Yaw_Acceleration              ,
                          A_Last_Pass_Yaw_Acceleration    ,
                          A_Turbulence_Yaw_Rate_Body_Axis ,
                          An_Integration_Constant         ,
                          An_Instance                    );
   Put(Velocity.Get_Yaw_Rate(An_Instance));
   Put_Line(" Yaw_Rate ");
   --Put(Velocity.Get_Last_Pass_Yaw_Rate(An_Instance));
   --Put_Line(" Last_Pass_Yaw_Rate ");
   --1.
   Pass := abs(Velocity.Get_Pitch_Rate(An_Instance) - (-0.4586783)) <= A_Tolerance and
     abs(Velocity.Get_Roll_Rate(An_Instance)  - (-0.8973646)) <= A_Tolerance and
     abs(Velocity.Get_Yaw_Rate(An_Instance)   - (-0.2988553)) <= A_Tolerance;

   Class_Test_Result_File.Report_Case_Status(Pass);
   Pass := False;

   An_Acceleration_Earth_Axis          := (-0.33876,0.1834902,21.87071) ;
   A_Last_Pass_Acceleration_Earth_Axis := (-0.3010841,0.1160036,19.98078);
   A_Wind_Velocity                     := (5.134273e-7,42.195,0.0);
   A_Wind_Velocity                     := (0.0,0.0,0.0);
   A_Predefined_Velocity_Earth_Axis    := (-212.3997,-195.3978,4.774138);
   A_Predefined_Last_Pass_Velocity     := (-212.3956,-195.3993,4.456991);
   --A_True_Airspeed                     := 250.0;
   A_Heading_Angle                     := -2.527004;
   An_Air_Density_at_Altitude          := 0.002067756;
   A_Sealevel_Air_Density              := 0.002377;
   A_Pitch_Angle                       := -0.05834199;
   A_Predefined_Angle_of_Attack        := 0.08;

   Velocity.Assign_Earth_Axis(A_Predefined_Velocity_Earth_Axis          ,
                              A_Predefined_Last_Pass_Velocity,
                              An_Instance                               );

   --    Put(Velocity.Get_Earth_Axis(An_Instance).x);
   --    Put(Velocity.Get_Earth_Axis(An_Instance).y);
   --    Put(Velocity.Get_Earth_Axis(An_Instance).z);
   --    Put_Line(" Velocity_Earth_Axis ");
   --    Put(Velocity.Get_Last_Pass_Earth_Axis(An_Instance).x);
   --    Put(Velocity.Get_Last_Pass_Earth_Axis(An_Instance).y);
   --    Put(Velocity.Get_Last_Pass_Earth_Axis(An_Instance).z);
   --    Put_Line(" Last Pass Velocity_Earth_Axis ");

   Velocity.Set_Earth_Axis(An_Acceleration_Earth_Axis         ,
                           A_Last_Pass_Acceleration_Earth_Axis,
                           A_Wind_Velocity                    ,
                           An_Integration_Constant            ,
                           An_Instance                        );
   Put(Velocity.Get_Earth_Axis(An_Instance).x);
   Put(Velocity.Get_Earth_Axis(An_Instance).y);
   Put(Velocity.Get_Earth_Axis(An_Instance).z);
   Put_Line(" Velocity_Earth_Axis ");
   --    Put(Velocity.Get_Last_Pass_Earth_Axis(An_Instance).x);
   --    Put(Velocity.Get_Last_Pass_Earth_Axis(An_Instance).y);
   --    Put(Velocity.Get_Last_Pass_Earth_Axis(An_Instance).z);
   --    Put_Line(" Last Pass Velocity_Earth_Axis ");
   --2.
   Pass := abs(Velocity.Get_Earth_Axis(An_Instance).x - (-212.405)) <= A_Tolerance and
     abs(Velocity.Get_Earth_Axis(An_Instance).y - (-195.3953)) <= A_Tolerance;-- and
   --abs(Velocity.Get_Earth_Axis(An_Instance).z - (5.12297)) <= A_Tolerance;
   put(abs(Velocity.Get_Earth_Axis(An_Instance).x - (-212.405))); put(abs(Velocity.Get_Earth_Axis(An_Instance).y - (-195.3953)));
   put_line(" earth axis tolerance ");

   Class_Test_Result_File.Report_Case_Status(Pass);
   Pass := False;

   A_Roll_Angle                          := -0.171297;
   A_Pitch_Angle                         := -0.05834199;
   A_Yaw_Angle                           := -2.527004;
   A_Velocity_Earth_Axis                 := (-212.3997,-195.3978,4.774138);
   --A_Predefined_Inertial_Velocity        := (257.4,112.6,57.6);

   Velocity.Assign_Inertial(A_Velocity_Earth_Axis,
                            An_Instance);

   --Put(Velocity.Get_Inertial(An_Instance).x);
   --Put(Velocity.Get_Inertial(An_Instance).y);
   --Put(Velocity.Get_Inertial(An_Instance).z);
   --Put_Line( " Inertial_Velocity_Body_Axis ");

   A_Roll_Angle          := -0.171297;
   A_Pitch_Angle         := -0.05834199;
   A_Yaw_Angle           := -2.527004;
   A_Velocity_Earth_Axis := (-212.405,-195.3953,5.12297);
   --A_Velocity_Earth_Axis := (-212.405,-195.3953,5.12297);

   Velocity.Assign_Earth_Axis(A_Velocity_Earth_Axis,
                              A_Velocity_Earth_Axis,
                              An_Instance          );
   Velocity.Set_Inertial(A_Roll_Angle ,
                         A_Pitch_Angle,
                         A_Yaw_Angle  ,
                         An_Instance);

   Put(Velocity.Get_Inertial(An_Instance).x);
   Put(Velocity.Get_Inertial(An_Instance).y);
   Put(Velocity.Get_Inertial(An_Instance).z);
   Put_Line( " Inertial_Velocity_Body_Axis ");
   --3.
   Pass := abs(Velocity.Get_Inertial(An_Instance).x - (286.0182)) <= A_Tolerance and
     abs(Velocity.Get_Inertial(An_Instance).y - (38.59148)) <= A_Tolerance and
     abs(Velocity.Get_Inertial(An_Instance).z - (-5.07001)) <= A_Tolerance;

   Class_Test_Result_File.Report_Case_Status(Pass);
   Pass := False;

   A_Predefined_Velocity_Body_Axis       := (125.6,56.0,99.87);
   Velocity.Assign_Body_Axis(A_Predefined_Velocity_Body_Axis,
                             An_Instance);
   --Put(Velocity.Get_Body_Axis(An_Instance).x);
   --Put(Velocity.Get_Body_Axis(An_Instance).y);
   --Put(Velocity.Get_Body_Axis(An_Instance).z);
   --Put_Line( " Velocity_Body_Axis ");

   A_Roll_Angle          := -0.171297;
   A_Pitch_Angle         := -0.05834199;
   A_Yaw_Angle           := -2.527004;
   A_Velocity_Earth_Axis := (-212.405+5.134273e-7,-195.3953 + 42.195,5.12297);
   --A_Velocity_Earth_Axis := (-212.405,-195.3953,5.12297);

   Velocity.Assign_Earth_Axis(A_Velocity_Earth_Axis,
                              A_Velocity_Earth_Axis,
                              An_Instance          );
   A_Turbulence_Velocity                 := (0.0,0.0,0.0);
   Velocity.Set_Body_Axis(A_Roll_Angle ,
                          A_Pitch_Angle          ,
                          A_Yaw_Angle           ,
                          A_Turbulence_Velocity ,
                          An_Instance);

   Put(Velocity.Get_Body_Axis(An_Instance).x);
   Put(Velocity.Get_Body_Axis(An_Instance).y);
   Put(Velocity.Get_Body_Axis(An_Instance).z);
   Put_Line( " Velocity_Body_Axis----- ");

   --4.
   Pass := abs(Velocity.Get_Body_Axis(An_Instance).x - (261.729)) <= A_Tolerance and
     abs(Velocity.Get_Body_Axis(An_Instance).y - (4.380428)) <= A_Tolerance and
     abs(Velocity.Get_Body_Axis(An_Instance).z - (-9.548496)) <= A_Tolerance;

   Class_Test_Result_File.Report_Case_Status(Pass);
   Pass := False;

   A_Predefined_Velocity_Body_Axis       := (261.729,4.380428,-9.548496);
   Velocity.Assign_Body_Axis(A_Predefined_Velocity_Body_Axis,
                             An_Instance);
   A_Wind_Velocity  := (0.0,0.0,0.0);
   Velocity.Set_Body_to_Earth_Axis
     (A_Roll_Angle     ,
      A_Pitch_Angle    ,
      A_Yaw_Angle      ,
      A_Wind_Velocity ,
      An_Instance       );

   Put(Velocity.Get_Earth_Axis(An_Instance).x);
   Put(Velocity.Get_Earth_Axis(An_Instance).y-42.195);
   Put(Velocity.Get_Earth_Axis(An_Instance).z);
   Put_Line(" 5. Velocity_Earth_Axis ");
   --Put(Velocity.Get_Last_Pass_Earth_Axis(An_Instance).x);
   --Put(Velocity.Get_Last_Pass_Earth_Axis(An_Instance).y);
   --Put(Velocity.Get_Last_Pass_Earth_Axis(An_Instance).z);
   --Put_Line(" Last Pass Velocity_Earth_Axis ");


   --5.
   Pass := abs(Velocity.Get_Earth_Axis(An_Instance).x - (-212.405)) <= A_Tolerance and
     abs(Velocity.Get_Earth_Axis(An_Instance).y-42.195 - (-195.3953)) <= A_Tolerance and
     abs(Velocity.Get_Earth_Axis(An_Instance).z - (5.12297)) <= A_Tolerance;

   Class_Test_Result_File.Report_Case_Status(Pass);
   Pass := False;


   A_True_Airspeed    := 261.9611;
   An_Angle_of_Attack := -2.745265*22.0/7.0/180.0;
   A_Side_Slip_Angle  := 1.537552*22.0/7.0/180.0;
   Velocity.Set_Body_Axis_based_on_True_Airspeed
     (A_True_Airspeed    ,
      An_Angle_of_Attack,
      A_Side_Slip_Angle ,
      An_Instance       );
   Put(Velocity.Get_Body_Axis(An_Instance).x);
   Put(Velocity.Get_Body_Axis(An_Instance).y);
   Put(Velocity.Get_Body_Axis(An_Instance).z);
   Put_Line( " Velocity_Body_Axis ");


   --6.
   Pass := abs(Velocity.Get_Body_Axis(An_Instance).x - (261.5663)) <= A_Tolerance and
     abs(Velocity.Get_Body_Axis(An_Instance).y - (7.028971)) <= A_Tolerance and
     abs(Velocity.Get_Body_Axis(An_Instance).z - (-12.54226)) <= A_Tolerance;

   put(abs(Velocity.Get_Body_Axis(An_Instance).x - (261.5663)));put(abs(Velocity.Get_Body_Axis(An_Instance).y - (7.028971)));
   put(abs(Velocity.Get_Body_Axis(An_Instance).z - (-12.54226)));put_line(" body axis tolerance ");

   Class_Test_Result_File.Report_Case_Status(Pass);
   Pass := False;


   A_Roll_Acceleration               := -1.752373;
   A_Pitch_Acceleration              := -0.6995133;
   A_Yaw_Acceleration                := -0.90258;
   A_Last_Pass_Roll_Acceleration     := -1.847512;
   A_Last_Pass_Pitch_Acceleration    := -0.7810658;
   A_Last_Pass_Yaw_Acceleration      := -0.9184675;
   A_Turbulence_Roll_Rate_Body_Axis  := 0.0;
   A_Turbulence_Pitch_Rate_Body_Axis := 0.0;
   A_Turbulence_Yaw_Rate_Body_Axis   := 0.0;
   An_Integration_Constant           := 1.0/60.0;
   A_Predefined_Roll_Rate            := -0.7925026;
   A_Predefined_Pitch_Rate           := -0.4218363;
   A_Predefined_Yaw_Rate             := -0.2412903;
   A_Predefined_Last_Pass_Roll_Rate  := 5.2;
   A_Predefined_Last_Pass_Yaw_Rate   := 1.25;
   A_Predefined_Last_Pass_Pitch_Rate := 0.66;



   Velocity.Assign_Roll_Rate (A_Predefined_Roll_Rate           ,
                              A_Predefined_Last_Pass_Roll_Rate ,
                              An_Instance                      );
   Velocity.Assign_Pitch_Rate (A_Predefined_Pitch_Rate           ,
                               A_Predefined_Last_Pass_Pitch_Rate ,
                               An_Instance                       );
   Velocity.Assign_Yaw_Rate (A_Predefined_Yaw_Rate           ,
                             A_Predefined_Last_Pass_Yaw_Rate ,
                             An_Instance                     );

   --Put(Angular_Rate_Body_Axis.Get_Roll_Rate (An_Instance));
   --Put(Angular_Rate_Body_Axis.Get_Pitch_Rate (An_Instance));
   --Put(Angular_Rate_Body_Axis.Get_Yaw_Rate (An_Instance));
   --Put_Line(" Angular_Rate_Body_Axis ");

   --Put(Angular_Rate_Body_Axis.Get_Last_Pass_Roll_Rate (An_Instance));
   --Put(Angular_Rate_Body_Axis.Get_Last_Pass_Pitch_Rate (An_Instance));
   --Put(Angular_Rate_Body_Axis.Get_Last_Pass_Yaw_Rate (An_Instance));
   --Put_Line(" Last_Pass_Angular_Rate_Body_Axis ");

   Velocity.Set_Roll_Rate (A_Roll_Acceleration             ,
                           A_Last_Pass_Roll_Acceleration   ,
                           A_Turbulence_Roll_Rate_Body_Axis,
                           An_Integration_Constant         ,
                           An_Instance                     );

   Velocity.Set_Pitch_Rate (A_Pitch_Acceleration              ,
                            A_Last_Pass_Pitch_Acceleration    ,
                            A_Turbulence_Pitch_Rate_Body_Axis ,
                            An_Integration_Constant           ,
                            An_Instance                       );

   Velocity.Set_Yaw_Rate (A_Yaw_Acceleration              ,
                          A_Last_Pass_Yaw_Acceleration    ,
                          A_Turbulence_Yaw_Rate_Body_Axis ,
                          An_Integration_Constant         ,
                          An_Instance                     );

   Put(Velocity.Get_Roll_Rate (An_Instance));
   Put(Velocity.Get_Pitch_Rate (An_Instance));
   Put(Velocity.Get_Yaw_Rate (An_Instance));
   Put_Line(" Angular_Rate_Body_Axis ");

   --Put(Velocity.Get_Last_Pass_Roll_Rate (An_Instance));
   --Put(Velocity.Get_Last_Pass_Pitch_Rate (An_Instance));
   --Put(Velocity.Get_Last_Pass_Yaw_Rate (An_Instance));
   --Put_Line(" Last_Pass_Angular_Rate_Body_Axis ");

   A_Predefined_Nondimensional_Angular_Rate := (1.0,1.0,1.0);
   Velocity.Assign_Nondimensional_Angular
     (A_Predefined_Nondimensional_Angular_Rate ,
      An_Instance                             );
   --Put(Velocity.Get_Nondimensional_Angular(An_Instance).roll);   Put(Velocity.Get_Nondimensional_Angular(An_Instance).pitch);
   --Put(Velocity.Get_Nondimensional_Angular(An_Instance).yaw);    Put_Line(" Nondimensional_Angular ");

   A_Span_Wing           := 33.42;
   A_Chord_Wing       := 5.413;
   A_True_Airspeed    := 261.9304;
   An_Angle_of_Attack:= -1.757778*3.142/180.0;
   --| This procedure computes the Nondimensional Angular Rate.
   Velocity.Set_Nondimensional_Angular
     (A_Span_Wing        ,
      A_Chord_Wing       ,
      A_True_Airspeed    ,
      An_Angle_of_Attack ,
      An_Instance       );
   Put(Velocity.Get_Nondimensional_Angular(An_Instance).roll);   Put(Velocity.Get_Nondimensional_Angular(An_Instance).pitch);
   Put(Velocity.Get_Nondimensional_Angular(An_Instance).yaw);    Put_Line(" Nondimensional_Angular ");
   --7.
   Pass := abs(Velocity.Get_Nondimensional_Angular(An_Instance).roll - (-0.05184517)) <= A_Tolerance and
     abs(Velocity.Get_Nondimensional_Angular(An_Instance).pitch - (-0.004472259)) <= A_Tolerance and
     abs(Velocity.Get_Nondimensional_Angular(An_Instance).yaw - (-0.01794343)) <= A_Tolerance;

   Class_Test_Result_File.Report_Case_Status(Pass);
   Pass := False;


   put_line(" ----------------------- CONSTRAINT --------------------------------");
   A_Tolerance := 0.0;

   A_Predefined_Pitch_Rate           := 1000.0;
   A_Predefined_Last_Pass_Pitch_Rate := 1000.0;
   --| This procedure will set the Pitch_Rate calculated during initalization, autotesting
   --| or when Pitch_Rate is defined by an approved other method.
   Velocity.Assign_Pitch_Rate (A_Predefined_Pitch_Rate           ,
                               A_Predefined_Last_Pass_Pitch_Rate,
                               An_Instance                      );
   --Put(Velocity.Get_Pitch_Rate(An_Instance));
   --Put_Line(" Pitch_Rate ");
   --Put(Velocity.Get_Last_Pass_Pitch_Rate(An_Instance));
   --Put_Line(" Last_Pass_Pitch_Rate ");

   A_Pitch_Acceleration              := 1000.0;
   A_Last_Pass_Pitch_Acceleration    :=1000.0;
   A_Turbulence_Pitch_Rate_Body_Axis := 1000.0;
   --| This procedure computes the Pitch Angular Rate.
   Velocity.Set_Pitch_Rate (A_Pitch_Acceleration              ,
                            A_Last_Pass_Pitch_Acceleration   ,
                            A_Turbulence_Pitch_Rate_Body_Axis,
                            An_Integration_Constant          ,
                            An_Instance                      );
   Put(Velocity.Get_Pitch_Rate(An_Instance));
   Put_Line(" Pitch_Rate ");
   -- Put(Velocity.Get_Last_Pass_Pitch_Rate(An_Instance));
   -- Put_Line(" Last_Pass_Pitch_Rate ");

   A_Predefined_Roll_Rate            := 1000.0;
   A_Predefined_Last_Pass_Roll_Rate  := 1000.0;
   --| This procedure will set the Roll_Rate calculated during initalization, autotesting
   --| or when Roll_Rate is defined by an approved other method.
   Velocity.Assign_Roll_Rate (A_Predefined_Roll_Rate           ,
                              A_Predefined_Last_Pass_Roll_Rate ,
                              An_Instance                     );
   --Put(Velocity.Get_Roll_Rate(An_Instance));
   --Put_Line(" Roll_Rate ");
   --Put(Velocity.Get_Last_Pass_Roll_Rate(An_Instance));
   --Put_Line(" Last_Pass_Roll_Rate ");

   A_Roll_Acceleration              :=1000.0;
   A_Last_Pass_Roll_Acceleration    :=1000.0;
   A_Turbulence_Roll_Rate_Body_Axis :=1000.0;
   --| This procedure computes the Roll Angular Rate.
   Velocity.Set_Roll_Rate (A_Roll_Acceleration             ,
                           A_Last_Pass_Roll_Acceleration   ,
                           A_Turbulence_Roll_Rate_Body_Axis,
                           An_Integration_Constant         ,
                           An_Instance                     );
   Put(Velocity.Get_Roll_Rate(An_Instance));
   Put_Line(" Roll_Rate ");
   --Put(Velocity.Get_Last_Pass_Roll_Rate(An_Instance));
   --Put_Line(" Last_Pass_Roll_Rate ");


   A_Predefined_Yaw_Rate           := 1000.0;
   A_Predefined_Last_Pass_Yaw_Rate := 1000.0;
   --| This procedure will set the Yaw_Rate calculated during initalization, autotesting
   --| or when Yaw_Rate is defined by an approved other method.
   Velocity.Assign_Yaw_Rate (A_Predefined_Yaw_Rate          ,
                             A_Predefined_Last_Pass_Yaw_Rate ,
                             An_Instance                    );
   --  Put(Velocity.Get_Yaw_Rate(An_Instance));
   --  Put_Line(" Yaw_Rate ");
   --  Put(Velocity.Get_Last_Pass_Yaw_Rate(An_Instance));
   --  Put_Line(" Last_Pass_Yaw_Rate ");

   A_Yaw_Acceleration              := 1000.0;
   A_Last_Pass_Yaw_Acceleration    := 1000.0;
   A_Turbulence_Yaw_Rate_Body_Axis := 1000.0;
   Velocity.Set_Yaw_Rate (A_Yaw_Acceleration              ,
                          A_Last_Pass_Yaw_Acceleration    ,
                          A_Turbulence_Yaw_Rate_Body_Axis ,
                          An_Integration_Constant         ,
                          An_Instance                    );
   Put(Velocity.Get_Yaw_Rate(An_Instance));
   Put_Line(" Yaw_Rate ");
   --Put(Velocity.Get_Last_Pass_Yaw_Rate(An_Instance));
   --Put_Line(" Last_Pass_Yaw_Rate ");
   --1.
   Pass := abs(Velocity.Get_Pitch_Rate(An_Instance)) >= A_Tolerance and
     abs(Velocity.Get_Roll_Rate(An_Instance)) >= A_Tolerance and
     abs(Velocity.Get_Yaw_Rate(An_Instance)) >= A_Tolerance;

   Class_Test_Result_File.Report_Case_Status(Pass);
   Pass := False;

   An_Acceleration_Earth_Axis          := (1000.0,1000.0,1000.0) ;
   A_Last_Pass_Acceleration_Earth_Axis := (1000.0,1000.0,1000.0) ;
   A_Wind_Velocity                     := (1000.0,1000.0,1000.0) ;
   A_Wind_Velocity                     := (0.0,0.0,0.0);
   A_Predefined_Velocity_Earth_Axis    := (1000.0,1000.0,1000.0) ;
   A_Predefined_Last_Pass_Velocity     := (1000.0,1000.0,1000.0) ;
   --A_True_Airspeed                     := 250.0;
   A_Heading_Angle                     := 1000.0;
   An_Air_Density_at_Altitude          := 1000.0;
   A_Sealevel_Air_Density              := 1000.0;
   A_Pitch_Angle                       := 1000.0;
   A_Predefined_Angle_of_Attack        := 1000.0;

   Velocity.Assign_Earth_Axis(A_Predefined_Velocity_Earth_Axis          ,
                              A_Predefined_Last_Pass_Velocity,
                              An_Instance                               );

   --    Put(Velocity.Get_Earth_Axis(An_Instance).x);
   --    Put(Velocity.Get_Earth_Axis(An_Instance).y);
   --    Put(Velocity.Get_Earth_Axis(An_Instance).z);
   --    Put_Line(" Velocity_Earth_Axis ");
   --    Put(Velocity.Get_Last_Pass_Earth_Axis(An_Instance).x);
   --    Put(Velocity.Get_Last_Pass_Earth_Axis(An_Instance).y);
   --    Put(Velocity.Get_Last_Pass_Earth_Axis(An_Instance).z);
   --    Put_Line(" Last Pass Velocity_Earth_Axis ");

   Velocity.Set_Earth_Axis(An_Acceleration_Earth_Axis         ,
                           A_Last_Pass_Acceleration_Earth_Axis,
                           A_Wind_Velocity                    ,
                           An_Integration_Constant            ,
                           An_Instance                        );
   Put(Velocity.Get_Earth_Axis(An_Instance).x);
   Put(Velocity.Get_Earth_Axis(An_Instance).y);
   Put(Velocity.Get_Earth_Axis(An_Instance).z);
   Put_Line(" Velocity_Earth_Axis ");
   --    Put(Velocity.Get_Last_Pass_Earth_Axis(An_Instance).x);
   --    Put(Velocity.Get_Last_Pass_Earth_Axis(An_Instance).y);
   --    Put(Velocity.Get_Last_Pass_Earth_Axis(An_Instance).z);
   --    Put_Line(" Last Pass Velocity_Earth_Axis ");
   --2.
   Pass := abs(Velocity.Get_Earth_Axis(An_Instance).x ) >= A_Tolerance and
     abs(Velocity.Get_Earth_Axis(An_Instance).y) >= A_Tolerance and
     abs(Velocity.Get_Earth_Axis(An_Instance).z ) >= A_Tolerance;

   Class_Test_Result_File.Report_Case_Status(Pass);
   Pass := False;

   A_Roll_Angle                          := 1000.0;
   A_Pitch_Angle                         := 1000.0;
   A_Yaw_Angle                           := 1000.0;
   A_Velocity_Earth_Axis                 := (1000.0,1000.0,1000.0);
   --A_Predefined_Inertial_Velocity        := (257.4,112.6,57.6);

   Velocity.Assign_Inertial(A_Velocity_Earth_Axis,
                            An_Instance);

   --Put(Velocity.Get_Inertial(An_Instance).x);
   --Put(Velocity.Get_Inertial(An_Instance).y);
   --Put(Velocity.Get_Inertial(An_Instance).z);
   --Put_Line( " Inertial_Velocity_Body_Axis ");

   A_Roll_Angle          := 1000.0;
   A_Pitch_Angle         := 1000.0;
   A_Yaw_Angle           := 1000.0;
   A_Velocity_Earth_Axis := (1000.0,1000.0,1000.0);
   --A_Velocity_Earth_Axis := (-212.405,-195.3953,5.12297);

   Velocity.Assign_Earth_Axis(A_Velocity_Earth_Axis,
                              A_Velocity_Earth_Axis,
                              An_Instance          );
   Velocity.Set_Inertial(A_Roll_Angle ,
                         A_Pitch_Angle,
                         A_Yaw_Angle  ,
                         An_Instance);

   Put(Velocity.Get_Inertial(An_Instance).x);
   Put(Velocity.Get_Inertial(An_Instance).y);
   Put(Velocity.Get_Inertial(An_Instance).z);
   Put_Line( " Inertial_Velocity_Body_Axis ");
   --3.
   Pass := abs(Velocity.Get_Inertial(An_Instance).x ) >= A_Tolerance and
     abs(Velocity.Get_Inertial(An_Instance).y ) >= A_Tolerance and
     abs(Velocity.Get_Inertial(An_Instance).z) >= A_Tolerance;

   Class_Test_Result_File.Report_Case_Status(Pass);
   Pass := False;

   A_Predefined_Velocity_Body_Axis       := (1000.0,1000.0,1000.0);
   Velocity.Assign_Body_Axis(A_Predefined_Velocity_Body_Axis,
                             An_Instance);
   --Put(Velocity.Get_Body_Axis(An_Instance).x);
   --Put(Velocity.Get_Body_Axis(An_Instance).y);
   --Put(Velocity.Get_Body_Axis(An_Instance).z);
   --Put_Line( " Velocity_Body_Axis ");

   A_Roll_Angle          := 1000.0;
   A_Pitch_Angle         := 1000.0;
   A_Yaw_Angle           := 1000.0;
   A_Velocity_Earth_Axis := (1000.0,1000.0,1000.0);
   --A_Velocity_Earth_Axis := (-212.405,-195.3953,5.12297);

   Velocity.Assign_Earth_Axis(A_Velocity_Earth_Axis,
                              A_Velocity_Earth_Axis,
                              An_Instance          );
   A_Turbulence_Velocity                 := (0.0,0.0,0.0);
   Velocity.Set_Body_Axis(A_Roll_Angle ,
                          A_Pitch_Angle          ,
                          A_Yaw_Angle           ,
                          A_Turbulence_Velocity ,
                          An_Instance);

   Put(Velocity.Get_Body_Axis(An_Instance).x);
   Put(Velocity.Get_Body_Axis(An_Instance).y);
   Put(Velocity.Get_Body_Axis(An_Instance).z);
   Put_Line( " Velocity_Body_Axis----- ");

   --4.
   Pass := abs(Velocity.Get_Body_Axis(An_Instance).x ) >= A_Tolerance and
     abs(Velocity.Get_Body_Axis(An_Instance).y) >= A_Tolerance and
     abs(Velocity.Get_Body_Axis(An_Instance).z) >= A_Tolerance;

   Class_Test_Result_File.Report_Case_Status(Pass);
   Pass := False;

   A_Predefined_Velocity_Body_Axis       := (1000.0,1000.0,1000.0);
   Velocity.Assign_Body_Axis(A_Predefined_Velocity_Body_Axis,
                             An_Instance);
   A_Wind_Velocity  := (0.0,0.0,0.0);
   Velocity.Set_Body_to_Earth_Axis
     (A_Roll_Angle     ,
      A_Pitch_Angle    ,
      A_Yaw_Angle      ,
      A_Wind_Velocity ,
      An_Instance       );

   Put(Velocity.Get_Earth_Axis(An_Instance).x);
   Put(Velocity.Get_Earth_Axis(An_Instance).y-42.195);
   Put(Velocity.Get_Earth_Axis(An_Instance).z);
   Put_Line(" 5. Velocity_Earth_Axis ");
   --Put(Velocity.Get_Last_Pass_Earth_Axis(An_Instance).x);
   --Put(Velocity.Get_Last_Pass_Earth_Axis(An_Instance).y);
   --Put(Velocity.Get_Last_Pass_Earth_Axis(An_Instance).z);
   --Put_Line(" Last Pass Velocity_Earth_Axis ");


   --5.
   Pass := abs(Velocity.Get_Earth_Axis(An_Instance).x ) >= A_Tolerance and
     abs(Velocity.Get_Earth_Axis(An_Instance).y) >= A_Tolerance and
     abs(Velocity.Get_Earth_Axis(An_Instance).z) >= A_Tolerance;

   Class_Test_Result_File.Report_Case_Status(Pass);
   Pass := False;


   A_True_Airspeed    :=1000.0;
   An_Angle_of_Attack := 1000.0;
   A_Side_Slip_Angle  := 1000.0;
   Velocity.Set_Body_Axis_based_on_True_Airspeed
     (A_True_Airspeed    ,
      An_Angle_of_Attack,
      A_Side_Slip_Angle ,
      An_Instance       );
   Put(Velocity.Get_Body_Axis(An_Instance).x);
   Put(Velocity.Get_Body_Axis(An_Instance).y);
   Put(Velocity.Get_Body_Axis(An_Instance).z);
   Put_Line( " Velocity_Body_Axis ");


   --6.
   Pass := abs(Velocity.Get_Body_Axis(An_Instance).x ) >= A_Tolerance and
     abs(Velocity.Get_Body_Axis(An_Instance).y ) >= A_Tolerance and
     abs(Velocity.Get_Body_Axis(An_Instance).z ) >= A_Tolerance;

   put(abs(Velocity.Get_Body_Axis(An_Instance).x - (261.5663)));put(abs(Velocity.Get_Body_Axis(An_Instance).y - (7.028971)));
   put(abs(Velocity.Get_Body_Axis(An_Instance).z - (-12.54226)));put_line(" body axis tolerance ");

   Class_Test_Result_File.Report_Case_Status(Pass);
   Pass := False;


   A_Roll_Acceleration               := 1000.0;
   A_Pitch_Acceleration              :=1000.0;
   A_Yaw_Acceleration                := 1000.0;
   A_Last_Pass_Roll_Acceleration     := 1000.0;
   A_Last_Pass_Pitch_Acceleration    :=1000.0;
   A_Last_Pass_Yaw_Acceleration      := 1000.0;
   A_Turbulence_Roll_Rate_Body_Axis  :=0.0;
   A_Turbulence_Pitch_Rate_Body_Axis := 0.0;
   A_Turbulence_Yaw_Rate_Body_Axis   := 0.0;
   An_Integration_Constant           := 1.0/60.0;
   A_Predefined_Roll_Rate            := 1000.0;
   A_Predefined_Pitch_Rate           := 1000.0;
   A_Predefined_Yaw_Rate             := 1000.0;
   A_Predefined_Last_Pass_Roll_Rate  := 1000.0;
   A_Predefined_Last_Pass_Yaw_Rate   := 1000.0;
   A_Predefined_Last_Pass_Pitch_Rate := 1000.0;



   Velocity.Assign_Roll_Rate (A_Predefined_Roll_Rate           ,
                              A_Predefined_Last_Pass_Roll_Rate ,
                              An_Instance                      );
   Velocity.Assign_Pitch_Rate (A_Predefined_Pitch_Rate           ,
                               A_Predefined_Last_Pass_Pitch_Rate ,
                               An_Instance                       );
   Velocity.Assign_Yaw_Rate (A_Predefined_Yaw_Rate           ,
                             A_Predefined_Last_Pass_Yaw_Rate ,
                             An_Instance                     );

   --Put(Angular_Rate_Body_Axis.Get_Roll_Rate (An_Instance));
   --Put(Angular_Rate_Body_Axis.Get_Pitch_Rate (An_Instance));
   --Put(Angular_Rate_Body_Axis.Get_Yaw_Rate (An_Instance));
   --Put_Line(" Angular_Rate_Body_Axis ");

   --Put(Angular_Rate_Body_Axis.Get_Last_Pass_Roll_Rate (An_Instance));
   --Put(Angular_Rate_Body_Axis.Get_Last_Pass_Pitch_Rate (An_Instance));
   --Put(Angular_Rate_Body_Axis.Get_Last_Pass_Yaw_Rate (An_Instance));
   --Put_Line(" Last_Pass_Angular_Rate_Body_Axis ");

   Velocity.Set_Roll_Rate (A_Roll_Acceleration             ,
                           A_Last_Pass_Roll_Acceleration   ,
                           A_Turbulence_Roll_Rate_Body_Axis,
                           An_Integration_Constant         ,
                           An_Instance                     );

   Velocity.Set_Pitch_Rate (A_Pitch_Acceleration              ,
                            A_Last_Pass_Pitch_Acceleration    ,
                            A_Turbulence_Pitch_Rate_Body_Axis ,
                            An_Integration_Constant           ,
                            An_Instance                       );

   Velocity.Set_Yaw_Rate (A_Yaw_Acceleration              ,
                          A_Last_Pass_Yaw_Acceleration    ,
                          A_Turbulence_Yaw_Rate_Body_Axis ,
                          An_Integration_Constant         ,
                          An_Instance                     );

   Put(Velocity.Get_Roll_Rate (An_Instance));
   Put(Velocity.Get_Pitch_Rate (An_Instance));
   Put(Velocity.Get_Yaw_Rate (An_Instance));
   Put_Line(" Angular_Rate_Body_Axis ");

   --Put(Velocity.Get_Last_Pass_Roll_Rate (An_Instance));
   --Put(Velocity.Get_Last_Pass_Pitch_Rate (An_Instance));
   --Put(Velocity.Get_Last_Pass_Yaw_Rate (An_Instance));
   --Put_Line(" Last_Pass_Angular_Rate_Body_Axis ");

   A_Predefined_Nondimensional_Angular_Rate := (1000.0,1000.0,1000.0);
   Velocity.Assign_Nondimensional_Angular
     (A_Predefined_Nondimensional_Angular_Rate ,
      An_Instance                             );
   --Put(Velocity.Get_Nondimensional_Angular(An_Instance).roll);   Put(Velocity.Get_Nondimensional_Angular(An_Instance).pitch);
   --Put(Velocity.Get_Nondimensional_Angular(An_Instance).yaw);    Put_Line(" Nondimensional_Angular ");

   A_Span_Wing           := 1000.0;
   A_Chord_Wing       := 1000.0;
   A_True_Airspeed    := 1000.0;
   An_Angle_of_Attack:=1000.0;
   --| This procedure computes the Nondimensional Angular Rate.
   Velocity.Set_Nondimensional_Angular
     (A_Span_Wing        ,
      A_Chord_Wing       ,
      A_True_Airspeed    ,
      An_Angle_of_Attack ,
      An_Instance       );
   Put(Velocity.Get_Nondimensional_Angular(An_Instance).roll);   Put(Velocity.Get_Nondimensional_Angular(An_Instance).pitch);
   Put(Velocity.Get_Nondimensional_Angular(An_Instance).yaw);    Put_Line(" Nondimensional_Angular ");
   --7.
   Pass := abs(Velocity.Get_Nondimensional_Angular(An_Instance).roll ) >= A_Tolerance and
     abs(Velocity.Get_Nondimensional_Angular(An_Instance).pitch) >= A_Tolerance and
     abs(Velocity.Get_Nondimensional_Angular(An_Instance).yaw ) >= A_Tolerance;

   Class_Test_Result_File.Report_Case_Status(Pass);
   Pass := False;

   put_line(" ----------------------- CONSTRAINT --------------------------------");


   A_Predefined_Pitch_Rate           := 0.0;
   A_Predefined_Last_Pass_Pitch_Rate := 0.0;
   --| This procedure will set the Pitch_Rate calculated during initalization, autotesting
   --| or when Pitch_Rate is defined by an approved other method.
   Velocity.Assign_Pitch_Rate (A_Predefined_Pitch_Rate           ,
                               A_Predefined_Last_Pass_Pitch_Rate,
                               An_Instance                      );
   --Put(Velocity.Get_Pitch_Rate(An_Instance));
   --Put_Line(" Pitch_Rate ");
   --Put(Velocity.Get_Last_Pass_Pitch_Rate(An_Instance));
   --Put_Line(" Last_Pass_Pitch_Rate ");

   A_Pitch_Acceleration              := 0.0;
   A_Last_Pass_Pitch_Acceleration    :=0.0;
   A_Turbulence_Pitch_Rate_Body_Axis := 0.0;
   --| This procedure computes the Pitch Angular Rate.
   Velocity.Set_Pitch_Rate (A_Pitch_Acceleration              ,
                            A_Last_Pass_Pitch_Acceleration   ,
                            A_Turbulence_Pitch_Rate_Body_Axis,
                            An_Integration_Constant          ,
                            An_Instance                      );
   Put(Velocity.Get_Pitch_Rate(An_Instance));
   Put_Line(" Pitch_Rate ");
   -- Put(Velocity.Get_Last_Pass_Pitch_Rate(An_Instance));
   -- Put_Line(" Last_Pass_Pitch_Rate ");

   A_Predefined_Roll_Rate            := 0.0;
   A_Predefined_Last_Pass_Roll_Rate  := 0.0;
   --| This procedure will set the Roll_Rate calculated during initalization, autotesting
   --| or when Roll_Rate is defined by an approved other method.
   Velocity.Assign_Roll_Rate (A_Predefined_Roll_Rate           ,
                              A_Predefined_Last_Pass_Roll_Rate ,
                              An_Instance                     );
   --Put(Velocity.Get_Roll_Rate(An_Instance));
   --Put_Line(" Roll_Rate ");
   --Put(Velocity.Get_Last_Pass_Roll_Rate(An_Instance));
   --Put_Line(" Last_Pass_Roll_Rate ");

   A_Roll_Acceleration              :=0.0;
   A_Last_Pass_Roll_Acceleration    :=0.0;
   A_Turbulence_Roll_Rate_Body_Axis :=0.0;
   --| This procedure computes the Roll Angular Rate.
   Velocity.Set_Roll_Rate (A_Roll_Acceleration             ,
                           A_Last_Pass_Roll_Acceleration   ,
                           A_Turbulence_Roll_Rate_Body_Axis,
                           An_Integration_Constant         ,
                           An_Instance                     );
   Put(Velocity.Get_Roll_Rate(An_Instance));
   Put_Line(" Roll_Rate ");
   --Put(Velocity.Get_Last_Pass_Roll_Rate(An_Instance));
   --Put_Line(" Last_Pass_Roll_Rate ");


   A_Predefined_Yaw_Rate           := 0.0;
   A_Predefined_Last_Pass_Yaw_Rate := 0.0;
   --| This procedure will set the Yaw_Rate calculated during initalization, autotesting
   --| or when Yaw_Rate is defined by an approved other method.
   Velocity.Assign_Yaw_Rate (A_Predefined_Yaw_Rate          ,
                             A_Predefined_Last_Pass_Yaw_Rate ,
                             An_Instance                    );
   --  Put(Velocity.Get_Yaw_Rate(An_Instance));
   --  Put_Line(" Yaw_Rate ");
   --  Put(Velocity.Get_Last_Pass_Yaw_Rate(An_Instance));
   --  Put_Line(" Last_Pass_Yaw_Rate ");

   A_Yaw_Acceleration              := 0.0;
   A_Last_Pass_Yaw_Acceleration    := 0.0;
   A_Turbulence_Yaw_Rate_Body_Axis := 0.0;
   Velocity.Set_Yaw_Rate (A_Yaw_Acceleration              ,
                          A_Last_Pass_Yaw_Acceleration    ,
                          A_Turbulence_Yaw_Rate_Body_Axis ,
                          An_Integration_Constant         ,
                          An_Instance                    );
   Put(Velocity.Get_Yaw_Rate(An_Instance));
   Put_Line(" Yaw_Rate ");
   --Put(Velocity.Get_Last_Pass_Yaw_Rate(An_Instance));
   --Put_Line(" Last_Pass_Yaw_Rate ");
   --1.
   Pass := abs(Velocity.Get_Pitch_Rate(An_Instance)) >= A_Tolerance and
     abs(Velocity.Get_Roll_Rate(An_Instance)) >= A_Tolerance and
     abs(Velocity.Get_Yaw_Rate(An_Instance)) >= A_Tolerance;

   Class_Test_Result_File.Report_Case_Status(Pass);
   Pass := False;

   An_Acceleration_Earth_Axis          := (0.0,0.0,0.0) ;
   A_Last_Pass_Acceleration_Earth_Axis := (0.0,0.0,0.0) ;
   A_Wind_Velocity                     := (0.0,0.0,0.0) ;
   A_Wind_Velocity                     := (0.0,0.0,0.0);
   A_Predefined_Velocity_Earth_Axis    := (0.0,0.0,0.0) ;
   A_Predefined_Last_Pass_Velocity     := (0.0,0.0,0.0) ;
   --A_True_Airspeed                     := 250.0;
   A_Heading_Angle                     := 0.0;
   An_Air_Density_at_Altitude          := 0.0;
   A_Sealevel_Air_Density              := 0.0;
   A_Pitch_Angle                       := 0.0;
   A_Predefined_Angle_of_Attack        := 0.0;

   Velocity.Assign_Earth_Axis(A_Predefined_Velocity_Earth_Axis          ,
                              A_Predefined_Last_Pass_Velocity,
                              An_Instance                               );

   --    Put(Velocity.Get_Earth_Axis(An_Instance).x);
   --    Put(Velocity.Get_Earth_Axis(An_Instance).y);
   --    Put(Velocity.Get_Earth_Axis(An_Instance).z);
   --    Put_Line(" Velocity_Earth_Axis ");
   --    Put(Velocity.Get_Last_Pass_Earth_Axis(An_Instance).x);
   --    Put(Velocity.Get_Last_Pass_Earth_Axis(An_Instance).y);
   --    Put(Velocity.Get_Last_Pass_Earth_Axis(An_Instance).z);
   --    Put_Line(" Last Pass Velocity_Earth_Axis ");

   Velocity.Set_Earth_Axis(An_Acceleration_Earth_Axis         ,
                           A_Last_Pass_Acceleration_Earth_Axis,
                           A_Wind_Velocity                    ,
                           An_Integration_Constant            ,
                           An_Instance                        );
   Put(Velocity.Get_Earth_Axis(An_Instance).x);
   Put(Velocity.Get_Earth_Axis(An_Instance).y);
   Put(Velocity.Get_Earth_Axis(An_Instance).z);
   Put_Line(" Velocity_Earth_Axis ");
   --    Put(Velocity.Get_Last_Pass_Earth_Axis(An_Instance).x);
   --    Put(Velocity.Get_Last_Pass_Earth_Axis(An_Instance).y);
   --    Put(Velocity.Get_Last_Pass_Earth_Axis(An_Instance).z);
   --    Put_Line(" Last Pass Velocity_Earth_Axis ");
   --2.
   Pass := abs(Velocity.Get_Earth_Axis(An_Instance).x ) >= A_Tolerance and
     abs(Velocity.Get_Earth_Axis(An_Instance).y) >= A_Tolerance and
     abs(Velocity.Get_Earth_Axis(An_Instance).z ) >= A_Tolerance;

   Class_Test_Result_File.Report_Case_Status(Pass);
   Pass := False;

   A_Roll_Angle                          := 0.0;
   A_Pitch_Angle                         := 0.0;
   A_Yaw_Angle                           := 0.0;
   A_Velocity_Earth_Axis                 := (0.0,0.0,0.0);
   --A_Predefined_Inertial_Velocity        := (257.4,112.6,57.6);

   Velocity.Assign_Inertial(A_Velocity_Earth_Axis,
                            An_Instance);

   --Put(Velocity.Get_Inertial(An_Instance).x);
   --Put(Velocity.Get_Inertial(An_Instance).y);
   --Put(Velocity.Get_Inertial(An_Instance).z);
   --Put_Line( " Inertial_Velocity_Body_Axis ");

   A_Roll_Angle          := 0.0;
   A_Pitch_Angle         := 0.0;
   A_Yaw_Angle           := 0.0;
   A_Velocity_Earth_Axis := (0.0,0.0,0.0);
   --A_Velocity_Earth_Axis := (-212.405,-195.3953,5.12297);

   Velocity.Assign_Earth_Axis(A_Velocity_Earth_Axis,
                              A_Velocity_Earth_Axis,
                              An_Instance          );
   Velocity.Set_Inertial(A_Roll_Angle ,
                         A_Pitch_Angle,
                         A_Yaw_Angle  ,
                         An_Instance);

   Put(Velocity.Get_Inertial(An_Instance).x);
   Put(Velocity.Get_Inertial(An_Instance).y);
   Put(Velocity.Get_Inertial(An_Instance).z);
   Put_Line( " Inertial_Velocity_Body_Axis ");
   --3.
   Pass := abs(Velocity.Get_Inertial(An_Instance).x ) >= A_Tolerance and
     abs(Velocity.Get_Inertial(An_Instance).y ) >= A_Tolerance and
     abs(Velocity.Get_Inertial(An_Instance).z) >= A_Tolerance;

   Class_Test_Result_File.Report_Case_Status(Pass);
   Pass := False;

   A_Predefined_Velocity_Body_Axis       := (0.0,0.0,0.0);
   Velocity.Assign_Body_Axis(A_Predefined_Velocity_Body_Axis,
                             An_Instance);
   --Put(Velocity.Get_Body_Axis(An_Instance).x);
   --Put(Velocity.Get_Body_Axis(An_Instance).y);
   --Put(Velocity.Get_Body_Axis(An_Instance).z);
   --Put_Line( " Velocity_Body_Axis ");

   A_Roll_Angle          := 0.0;
   A_Pitch_Angle         := 0.0;
   A_Yaw_Angle           := 0.0;
   A_Velocity_Earth_Axis := (0.0,0.0,0.0);
   --A_Velocity_Earth_Axis := (-212.405,-195.3953,5.12297);

   Velocity.Assign_Earth_Axis(A_Velocity_Earth_Axis,
                              A_Velocity_Earth_Axis,
                              An_Instance          );
   A_Turbulence_Velocity                 := (0.0,0.0,0.0);
   Velocity.Set_Body_Axis(A_Roll_Angle ,
                          A_Pitch_Angle          ,
                          A_Yaw_Angle           ,
                          A_Turbulence_Velocity ,
                          An_Instance);

   Put(Velocity.Get_Body_Axis(An_Instance).x);
   Put(Velocity.Get_Body_Axis(An_Instance).y);
   Put(Velocity.Get_Body_Axis(An_Instance).z);
   Put_Line( " Velocity_Body_Axis----- ");

   --4.
   Pass := abs(Velocity.Get_Body_Axis(An_Instance).x ) >= A_Tolerance and
     abs(Velocity.Get_Body_Axis(An_Instance).y) >= A_Tolerance and
     abs(Velocity.Get_Body_Axis(An_Instance).z) >= A_Tolerance;

   Class_Test_Result_File.Report_Case_Status(Pass);
   Pass := False;

   A_Predefined_Velocity_Body_Axis       := (0.0,0.0,0.0);
   Velocity.Assign_Body_Axis(A_Predefined_Velocity_Body_Axis,
                             An_Instance);
   A_Wind_Velocity  := (0.0,0.0,0.0);
   Velocity.Set_Body_to_Earth_Axis
     (A_Roll_Angle     ,
      A_Pitch_Angle    ,
      A_Yaw_Angle      ,
      A_Wind_Velocity ,
      An_Instance       );

   Put(Velocity.Get_Earth_Axis(An_Instance).x);
   Put(Velocity.Get_Earth_Axis(An_Instance).y-42.195);
   Put(Velocity.Get_Earth_Axis(An_Instance).z);
   Put_Line(" 5. Velocity_Earth_Axis ");
   --Put(Velocity.Get_Last_Pass_Earth_Axis(An_Instance).x);
   --Put(Velocity.Get_Last_Pass_Earth_Axis(An_Instance).y);
   --Put(Velocity.Get_Last_Pass_Earth_Axis(An_Instance).z);
   --Put_Line(" Last Pass Velocity_Earth_Axis ");


   --5.
   Pass := abs(Velocity.Get_Earth_Axis(An_Instance).x ) >= A_Tolerance and
     abs(Velocity.Get_Earth_Axis(An_Instance).y) >= A_Tolerance and
     abs(Velocity.Get_Earth_Axis(An_Instance).z) >= A_Tolerance;

   Class_Test_Result_File.Report_Case_Status(Pass);
   Pass := False;


   A_True_Airspeed    :=0.0;
   An_Angle_of_Attack := 0.0;
   A_Side_Slip_Angle  := 0.0;
   Velocity.Set_Body_Axis_based_on_True_Airspeed
     (A_True_Airspeed    ,
      An_Angle_of_Attack,
      A_Side_Slip_Angle ,
      An_Instance       );
   Put(Velocity.Get_Body_Axis(An_Instance).x);
   Put(Velocity.Get_Body_Axis(An_Instance).y);
   Put(Velocity.Get_Body_Axis(An_Instance).z);
   Put_Line( " Velocity_Body_Axis ");


   --6.
   Pass := abs(Velocity.Get_Body_Axis(An_Instance).x ) >= A_Tolerance and
     abs(Velocity.Get_Body_Axis(An_Instance).y ) >= A_Tolerance and
     abs(Velocity.Get_Body_Axis(An_Instance).z ) >= A_Tolerance;

   put(abs(Velocity.Get_Body_Axis(An_Instance).x - (261.5663)));put(abs(Velocity.Get_Body_Axis(An_Instance).y - (7.028971)));
   put(abs(Velocity.Get_Body_Axis(An_Instance).z - (-12.54226)));put_line(" body axis tolerance ");

   Class_Test_Result_File.Report_Case_Status(Pass);
   Pass := False;


   A_Roll_Acceleration               := 0.0;
   A_Pitch_Acceleration              :=0.0;
   A_Yaw_Acceleration                := 0.0;
   A_Last_Pass_Roll_Acceleration     := 0.0;
   A_Last_Pass_Pitch_Acceleration    :=0.0;
   A_Last_Pass_Yaw_Acceleration      := 0.0;
   A_Turbulence_Roll_Rate_Body_Axis  :=0.0;
   A_Turbulence_Pitch_Rate_Body_Axis := 0.0;
   A_Turbulence_Yaw_Rate_Body_Axis   := 0.0;
   An_Integration_Constant           := 1.0/60.0;
   A_Predefined_Roll_Rate            := 0.0;
   A_Predefined_Pitch_Rate           := 0.0;
   A_Predefined_Yaw_Rate             := 0.0;
   A_Predefined_Last_Pass_Roll_Rate  := 0.0;
   A_Predefined_Last_Pass_Yaw_Rate   := 0.0;
   A_Predefined_Last_Pass_Pitch_Rate := 0.0;



   Velocity.Assign_Roll_Rate (A_Predefined_Roll_Rate           ,
                              A_Predefined_Last_Pass_Roll_Rate ,
                              An_Instance                      );
   Velocity.Assign_Pitch_Rate (A_Predefined_Pitch_Rate           ,
                               A_Predefined_Last_Pass_Pitch_Rate ,
                               An_Instance                       );
   Velocity.Assign_Yaw_Rate (A_Predefined_Yaw_Rate           ,
                             A_Predefined_Last_Pass_Yaw_Rate ,
                             An_Instance                     );

   --Put(Angular_Rate_Body_Axis.Get_Roll_Rate (An_Instance));
   --Put(Angular_Rate_Body_Axis.Get_Pitch_Rate (An_Instance));
   --Put(Angular_Rate_Body_Axis.Get_Yaw_Rate (An_Instance));
   --Put_Line(" Angular_Rate_Body_Axis ");

   --Put(Angular_Rate_Body_Axis.Get_Last_Pass_Roll_Rate (An_Instance));
   --Put(Angular_Rate_Body_Axis.Get_Last_Pass_Pitch_Rate (An_Instance));
   --Put(Angular_Rate_Body_Axis.Get_Last_Pass_Yaw_Rate (An_Instance));
   --Put_Line(" Last_Pass_Angular_Rate_Body_Axis ");

   Velocity.Set_Roll_Rate (A_Roll_Acceleration             ,
                           A_Last_Pass_Roll_Acceleration   ,
                           A_Turbulence_Roll_Rate_Body_Axis,
                           An_Integration_Constant         ,
                           An_Instance                     );

   Velocity.Set_Pitch_Rate (A_Pitch_Acceleration              ,
                            A_Last_Pass_Pitch_Acceleration    ,
                            A_Turbulence_Pitch_Rate_Body_Axis ,
                            An_Integration_Constant           ,
                            An_Instance                       );

   Velocity.Set_Yaw_Rate (A_Yaw_Acceleration              ,
                          A_Last_Pass_Yaw_Acceleration    ,
                          A_Turbulence_Yaw_Rate_Body_Axis ,
                          An_Integration_Constant         ,
                          An_Instance                     );

   Put(Velocity.Get_Roll_Rate (An_Instance));
   Put(Velocity.Get_Pitch_Rate (An_Instance));
   Put(Velocity.Get_Yaw_Rate (An_Instance));
   Put_Line(" Angular_Rate_Body_Axis ");

   --Put(Velocity.Get_Last_Pass_Roll_Rate (An_Instance));
   --Put(Velocity.Get_Last_Pass_Pitch_Rate (An_Instance));
   --Put(Velocity.Get_Last_Pass_Yaw_Rate (An_Instance));
   --Put_Line(" Last_Pass_Angular_Rate_Body_Axis ");

   A_Predefined_Nondimensional_Angular_Rate := (0.0,0.0,0.0);
   Velocity.Assign_Nondimensional_Angular
     (A_Predefined_Nondimensional_Angular_Rate ,
      An_Instance                             );
   --Put(Velocity.Get_Nondimensional_Angular(An_Instance).roll);   Put(Velocity.Get_Nondimensional_Angular(An_Instance).pitch);
   --Put(Velocity.Get_Nondimensional_Angular(An_Instance).yaw);    Put_Line(" Nondimensional_Angular ");

   A_Span_Wing           := 0.0;
   A_Chord_Wing       := 0.0;
   A_True_Airspeed    := 0.0;
   An_Angle_of_Attack:=0.0;
   --| This procedure computes the Nondimensional Angular Rate.
   Velocity.Set_Nondimensional_Angular
     (A_Span_Wing        ,
      A_Chord_Wing       ,
      A_True_Airspeed    ,
      An_Angle_of_Attack ,
      An_Instance       );
   Put(Velocity.Get_Nondimensional_Angular(An_Instance).roll);   Put(Velocity.Get_Nondimensional_Angular(An_Instance).pitch);
   Put(Velocity.Get_Nondimensional_Angular(An_Instance).yaw);    Put_Line(" Nondimensional_Angular ");
   --7.
   Pass := abs(Velocity.Get_Nondimensional_Angular(An_Instance).roll ) >= A_Tolerance and
     abs(Velocity.Get_Nondimensional_Angular(An_Instance).pitch) >= A_Tolerance and
     abs(Velocity.Get_Nondimensional_Angular(An_Instance).yaw ) >= A_Tolerance;

   Class_Test_Result_File.Report_Case_Status(Pass);
   Pass := False;










end EXECUTE_Velocity;
