-------------------------------------------------------------------------------
--|
--|            FlightSafety International Simulation Systems Division
--|                     Broken Arrow, OK  USA  918-259-4000
--|
--|                  JPATS T-6A Texan-II Flight Training Device
--|
--|
--|   Engineer:  Yogesh Tupe
--|
--|   Revision:  (Number and date inserted by Clearcase)
--|
--|
--|  DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
--|  Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
--|  technical or operational data or information from automatic dissemination
--|  under the International Exchange Program or by other means.  This protection
--|  covers information required solely for administrative or operational
--|  purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--|
--|  WARNING:  This document contains technical data whose export is restricted
--|  by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
--|  Executive Order 12470.  Violation of these export control laws is subject
--|  to severe criminal penalties.  Dissemination of this document is controlled
--|  under DOD Directive 5230.25
--|
-------------------------------------------------------------------------------
--|

with Ada.Text_IO;                             use Ada.Text_IO;
with Ada.Float_Text_IO;                        use Ada.Float_Text_IO;
with Ada.Integer_Text_IO;                      use Ada.Integer_Text_IO;
with Ada.Long_Float_Text_IO;                   use Ada.Long_Float_Text_IO;
with Ada.Numerics;
with Ada.Numerics.Elementary_Functions;        use Ada.Numerics.Elementary_Functions;


with Slews;

with Class_Test_Result_File;

procedure EXECUTE_slews is

   An_Instance : Slews.Instance;

   An_Aircraft_Slew_Rate   :Float;
   An_Integration_Constant :Float;
   A_Predefined_Slew       :Float;

   Pass : Boolean := False;
   A_Tolerance : Float := 0.000_5;

begin
   An_Aircraft_Slew_Rate  := 12.647;
   An_Integration_Constant := 1.0/60.0;

   Slews.Set(An_Aircraft_Slew_Rate  ,
             An_Integration_Constant,
             An_Instance            );

   put(Slews.Get(An_Instance )); put_line(" Slews ");

   Pass := abs(Slews.Get(An_Instance) - 0.2107833) <= A_Tolerance;

   Class_Test_Result_File.Report_Case_Status(Pass);
   Pass := False;

   put_line(" -------------------- CONSTRAINT --------------------");
   An_Aircraft_Slew_Rate  := 1000.0;
   An_Integration_Constant := 1000.0;

   Slews.Set(An_Aircraft_Slew_Rate  ,
             An_Integration_Constant,
             An_Instance            );

   put(Slews.Get(An_Instance )); put_line(" Slews ");

   Pass := abs(Slews.Get(An_Instance) ) >= 0.0;

   Class_Test_Result_File.Report_Case_Status(Pass);
   Pass := False;

   put_line(" -------------------- END --------------------");
   An_Aircraft_Slew_Rate  := 0.0;
   An_Integration_Constant := 0.0;

   Slews.Set(An_Aircraft_Slew_Rate  ,
             An_Integration_Constant,
             An_Instance            );

   put(Slews.Get(An_Instance )); put_line(" Slews ");

   Pass := abs(Slews.Get(An_Instance) ) >= 0.0;

   Class_Test_Result_File.Report_Case_Status(Pass);
   Pass := False;


end EXECUTE_slews;
