-------------------------------------------------------------------------------
--|
--|            FlightSafety International Simulation Systems Division
--|                     Broken Arrow, OK  USA  918-259-4000
--|
--|                  JPATS T-6A Texan-II Flight Training Device
--|
--|
--|   Engineer:  Yogesh Tupe
--|
--|   Revision:  (Number and date inserted by Clearcase)
--|
--|
--|  DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
--|  Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
--|  technical or operational data or information from automatic dissemination
--|  under the International Exchange Program or by other means.  This protection
--|  covers information required solely for administrative or operational
--|  purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--|
--|  WARNING:  This document contains technical data whose export is restricted
--|  by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
--|  Executive Order 12470.  Violation of these export control laws is subject
--|  to severe criminal penalties.  Dissemination of this document is controlled
--|  under DOD Directive 5230.25
--|
-------------------------------------------------------------------------------
--|

with Ada.Text_IO;                             use Ada.Text_IO;
with Ada.Float_Text_IO;                        use Ada.Float_Text_IO;
with Ada.Integer_Text_IO;                      use Ada.Integer_Text_IO;
with Ada.Long_Float_Text_IO;                   use Ada.Long_Float_Text_IO;
with Ada.Numerics;
with Ada.Numerics.Elementary_Functions;        use Ada.Numerics.Elementary_Functions;


with Reference_Coordinates;

with Angle_Types;
with Coordinate_Types;
with Length_Types;
with Mass_Types;
with Normalized_Types;
with Class_Test_Result_File;

procedure EXECUTE_Ref_Coord is

   An_Instance : Reference_Coordinates.Instance;

   A_Basic                      :Coordinate_Types.Reference_System;
   A_Baggage                    :Coordinate_Types.Reference_System;
   A_Front_Seat_Occupant        :Coordinate_Types.Reference_System;
   A_Rear_Seat_Occupant         :Coordinate_Types.Reference_System;
   A_Weight_Zero_Fuel           :Mass_Types.Lbm;
   A_Weight_Basic               :Mass_Types.Lbm;
   A_Weight_Front_Seat_Occupant :Mass_Types.Lbm;
   A_Weight_Rear_Seat_Occupant  :Mass_Types.Lbm;
   A_Weight_Baggage             :Mass_Types.Lbm;
   A_Predefined_Zero_Fuel_Reference_System :Coordinate_Types.Reference_System;
   A_Gross_Weight                          :Mass_Types.Lbm;
   A_Buttline_of_Current_Center_of_Gravity_of_Fuel_Tank :Length_Types.Feet;
   A_Predefined_Buttline_of_Current_Center_of_Gravity   :Length_Types.Feet;
   A_Fuselage_Station_of_Current_Center_of_Gravity_of_Fuel_Tank :Length_Types.Feet;
   A_Landing_Gear_Position                                      :Normalized_Types.Normalize;
   A_Location_of_Current_Center_of_Gravity_as_a_Percentage_of_Mean_Aerodynamic_Chord :Float;
   A_Mean_Aerodynamic_Center                                    :Length_Types.Feet;
   A_Fuselage_Station_of_Leading_Edge_of_Mean_Aerodynamic_Chord :Length_Types.Feet;
   A_Predefined_Fuselage_Station_of_Current_Center_of_Gravity   :Length_Types.Feet;
   A_Waterline_of_Current_Center_of_Gravity_of_Fuel_Tank :Length_Types.Feet;
   A_Predefined_Waterline_of_Current_Center_of_Gravity   :Length_Types.Feet;
   Pass : Boolean := False;
   A_Tolerance : Float := 0.000_5;

begin

   A_Basic                      :=(0.006_666_667,13.741_667,7.425);
   A_Baggage                    :=(0.0,22.633_333,7.425);
   A_Front_Seat_Occupant        := (0.0,13.566_667,8.233_333_3);
   A_Rear_Seat_Occupant         :=(0.0,18.241_667,8.766_666_7);
   A_Weight_Basic               := 4824.0;
   A_Weight_Front_Seat_Occupant :=  180.0;
   A_Weight_Rear_Seat_Occupant  :=  180.0;
   A_Weight_Baggage             :=  20.0;
   A_Weight_Zero_Fuel           :=   5204.0;

   Reference_Coordinates.Set_Zero_Fuel (A_Basic                      ,
                                        A_Baggage                    ,
                                        A_Front_Seat_Occupant        ,
                                        A_Rear_Seat_Occupant         ,
                                        A_Weight_Zero_Fuel           ,
                                        A_Weight_Basic               ,
                                        A_Weight_Front_Seat_Occupant ,
                                        A_Weight_Rear_Seat_Occupant  ,
                                        A_Weight_Baggage             ,
                                        An_Instance                  );

   put(Reference_Coordinates.Get_Zero_Fuel(An_Instance).Buttline*12.0); put(Reference_Coordinates.Get_Zero_Fuel(An_Instance).Fuselage_Station*12.0);
   put(Reference_Coordinates.Get_Zero_Fuel(An_Instance).Waterline*12.0); put_line(" Zero fuel Weight ");

   Pass := abs(Reference_Coordinates.Get_Zero_Fuel(An_Instance).Buttline)*12.0 - 0.0741583 <= A_Tolerance and
     abs(Reference_Coordinates.Get_Zero_Fuel(An_Instance).Fuselage_Station)*12.0 - 167.1052246 <= A_Tolerance and
     abs(Reference_Coordinates.Get_Zero_Fuel(An_Instance).Waterline)*12.0 - 89.992305 <= A_Tolerance;

   Class_Test_Result_File.Report_Case_Status(Pass);
   Pass := False;

   A_Gross_Weight                                       := 6204.0;
   A_Buttline_of_Current_Center_of_Gravity_of_Fuel_Tank := ( -13.58/12.0*48.57);--,2.0*170.25*475.71/12.0+164.93*48.57/12.0,2.0*76.87/12.0*475.71+72.65/12.0*48.57 )
   Reference_Coordinates.Set_Buttline_of_Current_Center_of_Gravity
     (A_Weight_Zero_Fuel                                   ,
      A_Gross_Weight                                       ,
      A_Buttline_of_Current_Center_of_Gravity_of_Fuel_Tank ,
      An_Instance                                          );
   put(Reference_Coordinates.Get_Buttline_of_Current_Center_of_Gravity(An_Instance)*12.0); put_line(" buttline of cg ");

   A_Fuselage_Station_of_Current_Center_of_Gravity_of_Fuel_Tank := 2.0*170.25*475.71/12.0+164.93*48.57/12.0;
   A_Landing_Gear_Position                                      := 0.0;
   Reference_Coordinates.Set_Fuselage_Station_of_Current_Center_of_Gravity
     (A_Weight_Zero_Fuel                                           ,
      A_Gross_Weight                                               ,
      A_Fuselage_Station_of_Current_Center_of_Gravity_of_Fuel_Tank ,
      A_Landing_Gear_Position                                      ,
      An_Instance                                                  );

   put(Reference_Coordinates.Get_Fuselage_Station_of_Current_Center_of_Gravity(An_Instance)*12.0); put_line(" Fuselage_Station of cg ");

   A_Location_of_Current_Center_of_Gravity_as_a_Percentage_of_Mean_Aerodynamic_Chord := 24.01;
   A_Mean_Aerodynamic_Center                                    := 5.413;
   A_Fuselage_Station_of_Leading_Edge_of_Mean_Aerodynamic_Chord := 12.705;
   Reference_Coordinates.Set_Fuselage_Station_of_Current_Center_of_Gravity_in_Percantage_of_Mean_Aerodynamic_Chord
     (A_Location_of_Current_Center_of_Gravity_as_a_Percentage_of_Mean_Aerodynamic_Chord,
      A_Mean_Aerodynamic_Center                                    ,
      A_Fuselage_Station_of_Leading_Edge_of_Mean_Aerodynamic_Chord ,
      An_Instance                                                  );

   put(Reference_Coordinates.Get_Fuselage_Station_of_Current_Center_of_Gravity(An_Instance)*12.0); put_line(" Fuselage_Station of cg ");

   A_Waterline_of_Current_Center_of_Gravity_of_Fuel_Tank := 2.0*76.87/12.0*475.71+72.65/12.0*48.57;
   Reference_Coordinates.Set_Waterline_of_Current_Center_of_Gravity
     (A_Weight_Zero_Fuel                                    ,
      A_Gross_Weight                                        ,
      A_Waterline_of_Current_Center_of_Gravity_of_Fuel_Tank ,
      A_Landing_Gear_Position                               ,
      An_Instance                                           );

   put(Reference_Coordinates.Get_Waterline_of_Current_Center_of_Gravity(An_Instance)*12.0); put_line(" Waterline of cg ");


   Pass := abs(Reference_Coordinates.Get_Buttline_of_Current_Center_of_Gravity(An_Instance)*12.0 - (-0.044121)) <= A_Tolerance and
     abs(Reference_Coordinates.Get_Fuselage_Station_of_Current_Center_of_Gravity(An_Instance)*12.0 - 168.0555) <= A_Tolerance and
     abs(Reference_Coordinates.Get_Waterline_of_Current_Center_of_Gravity(An_Instance)*12.0 - 88.843796) <= A_Tolerance;

   Class_Test_Result_File.Report_Case_Status(Pass);
   Pass := False;

   put_line(" ------------------------ CONSTRAINT -------------------------");


   A_Basic                      :=(1000.0,1000.0,1000.0);
   A_Baggage                    :=(1000.0,1000.0,1000.0);
   A_Front_Seat_Occupant        := (1000.0,1000.0,1000.0);
   A_Rear_Seat_Occupant         :=(1000.0,1000.0,1000.0);
   A_Weight_Basic               := 10000.0;
   A_Weight_Front_Seat_Occupant := 1000.0;
   A_Weight_Rear_Seat_Occupant  := 1000.0;
   A_Weight_Baggage             := 1000.0;
   A_Weight_Zero_Fuel           := 10000.0;

   Reference_Coordinates.Set_Zero_Fuel (A_Basic                      ,
                                        A_Baggage                    ,
                                        A_Front_Seat_Occupant        ,
                                        A_Rear_Seat_Occupant         ,
                                        A_Weight_Zero_Fuel           ,
                                        A_Weight_Basic               ,
                                        A_Weight_Front_Seat_Occupant ,
                                        A_Weight_Rear_Seat_Occupant  ,
                                        A_Weight_Baggage             ,
                                        An_Instance                  );

   put(Reference_Coordinates.Get_Zero_Fuel(An_Instance).Buttline*12.0); put(Reference_Coordinates.Get_Zero_Fuel(An_Instance).Fuselage_Station*12.0);
   put(Reference_Coordinates.Get_Zero_Fuel(An_Instance).Waterline*12.0); put_line(" Zero fuel Weight ");

   Pass := abs(Reference_Coordinates.Get_Zero_Fuel(An_Instance).Buttline*12.0) >= 0.0 and
     abs(Reference_Coordinates.Get_Zero_Fuel(An_Instance).Fuselage_Station*12.0 ) >= 0.0 and
     abs(Reference_Coordinates.Get_Zero_Fuel(An_Instance).Waterline*12.0) >= 0.0;

   Class_Test_Result_File.Report_Case_Status(Pass);
   Pass := False;

   A_Gross_Weight                                       := 10000.0;
   A_Buttline_of_Current_Center_of_Gravity_of_Fuel_Tank := ( 1000.0);--,2.0*170.25*475.71/12.0+164.93*48.57/12.0,2.0*76.87/12.0*475.71+72.65/12.0*48.57 )
   Reference_Coordinates.Set_Buttline_of_Current_Center_of_Gravity
     (A_Weight_Zero_Fuel                                   ,
      A_Gross_Weight                                       ,
      A_Buttline_of_Current_Center_of_Gravity_of_Fuel_Tank ,
      An_Instance                                          );
   put(Reference_Coordinates.Get_Buttline_of_Current_Center_of_Gravity(An_Instance)*12.0); put_line(" buttline of cg ");

   A_Fuselage_Station_of_Current_Center_of_Gravity_of_Fuel_Tank := 1000.0;
   A_Landing_Gear_Position                                      := 1000.0;
   Reference_Coordinates.Set_Fuselage_Station_of_Current_Center_of_Gravity
     (A_Weight_Zero_Fuel                                           ,
      A_Gross_Weight                                               ,
      A_Fuselage_Station_of_Current_Center_of_Gravity_of_Fuel_Tank ,
      A_Landing_Gear_Position                                      ,
      An_Instance                                                  );

   put(Reference_Coordinates.Get_Fuselage_Station_of_Current_Center_of_Gravity(An_Instance)*12.0); put_line(" Fuselage_Station of cg ");

   A_Location_of_Current_Center_of_Gravity_as_a_Percentage_of_Mean_Aerodynamic_Chord := 1000.0;
   A_Mean_Aerodynamic_Center                                    := 1000.0;
   A_Fuselage_Station_of_Leading_Edge_of_Mean_Aerodynamic_Chord := 1000.0;
   Reference_Coordinates.Set_Fuselage_Station_of_Current_Center_of_Gravity_in_Percantage_of_Mean_Aerodynamic_Chord
     (A_Location_of_Current_Center_of_Gravity_as_a_Percentage_of_Mean_Aerodynamic_Chord,
      A_Mean_Aerodynamic_Center                                    ,
      A_Fuselage_Station_of_Leading_Edge_of_Mean_Aerodynamic_Chord ,
      An_Instance                                                  );

   put(Reference_Coordinates.Get_Fuselage_Station_of_Current_Center_of_Gravity(An_Instance)*12.0); put_line(" Fuselage_Station of cg ");

   A_Waterline_of_Current_Center_of_Gravity_of_Fuel_Tank := 1000.0;
   Reference_Coordinates.Set_Waterline_of_Current_Center_of_Gravity
     (A_Weight_Zero_Fuel                                    ,
      A_Gross_Weight                                        ,
      A_Waterline_of_Current_Center_of_Gravity_of_Fuel_Tank ,
      A_Landing_Gear_Position                               ,
      An_Instance                                           );

   put(Reference_Coordinates.Get_Waterline_of_Current_Center_of_Gravity(An_Instance)*12.0); put_line(" Waterline of cg ");


   Pass := abs(Reference_Coordinates.Get_Buttline_of_Current_Center_of_Gravity(An_Instance)*12.0) >= 0.0 and
     abs(Reference_Coordinates.Get_Fuselage_Station_of_Current_Center_of_Gravity(An_Instance)*12.0) >= 0.0 and
     abs(Reference_Coordinates.Get_Waterline_of_Current_Center_of_Gravity(An_Instance)*12.0) >= 0.0;

   Class_Test_Result_File.Report_Case_Status(Pass);
   Pass := False;

   put_line(" ------------------------ END  -------------------------");


   A_Basic                      :=(0.0,0.0,0.0);
   A_Baggage                    :=(0.0,0.0,0.0);
   A_Front_Seat_Occupant        := (0.0,0.0,0.0);
   A_Rear_Seat_Occupant         :=(0.0,0.0,0.0);
   A_Weight_Basic               := 0.0;
   A_Weight_Front_Seat_Occupant := 0.0;
   A_Weight_Rear_Seat_Occupant  := 0.0;
   A_Weight_Baggage             := 0.0;
   A_Weight_Zero_Fuel           := 0.0;

   Reference_Coordinates.Set_Zero_Fuel (A_Basic                      ,
                                        A_Baggage                    ,
                                        A_Front_Seat_Occupant        ,
                                        A_Rear_Seat_Occupant         ,
                                        A_Weight_Zero_Fuel           ,
                                        A_Weight_Basic               ,
                                        A_Weight_Front_Seat_Occupant ,
                                        A_Weight_Rear_Seat_Occupant  ,
                                        A_Weight_Baggage             ,
                                        An_Instance                  );

   put(Reference_Coordinates.Get_Zero_Fuel(An_Instance).Buttline*12.0); put(Reference_Coordinates.Get_Zero_Fuel(An_Instance).Fuselage_Station*12.0);
   put(Reference_Coordinates.Get_Zero_Fuel(An_Instance).Waterline*12.0); put_line(" Zero fuel Weight ");

   Pass := abs(Reference_Coordinates.Get_Zero_Fuel(An_Instance).Buttline*12.0) >= 0.0 and
     abs(Reference_Coordinates.Get_Zero_Fuel(An_Instance).Fuselage_Station*12.0 ) >= 0.0 and
     abs(Reference_Coordinates.Get_Zero_Fuel(An_Instance).Waterline*12.0) >= 0.0;

   Class_Test_Result_File.Report_Case_Status(Pass);
   Pass := False;

   A_Gross_Weight                                       := 0.0;
   A_Buttline_of_Current_Center_of_Gravity_of_Fuel_Tank := ( 0.0);--,2.0*170.25*475.71/12.0+164.93*48.57/12.0,2.0*76.87/12.0*475.71+72.65/12.0*48.57 )
   Reference_Coordinates.Set_Buttline_of_Current_Center_of_Gravity
     (A_Weight_Zero_Fuel                                   ,
      A_Gross_Weight                                       ,
      A_Buttline_of_Current_Center_of_Gravity_of_Fuel_Tank ,
      An_Instance                                          );
   put(Reference_Coordinates.Get_Buttline_of_Current_Center_of_Gravity(An_Instance)*12.0); put_line(" buttline of cg ");

   A_Fuselage_Station_of_Current_Center_of_Gravity_of_Fuel_Tank := 0.0;
   A_Landing_Gear_Position                                      := 0.0;
   Reference_Coordinates.Set_Fuselage_Station_of_Current_Center_of_Gravity
     (A_Weight_Zero_Fuel                                           ,
      A_Gross_Weight                                               ,
      A_Fuselage_Station_of_Current_Center_of_Gravity_of_Fuel_Tank ,
      A_Landing_Gear_Position                                      ,
      An_Instance                                                  );

   put(Reference_Coordinates.Get_Fuselage_Station_of_Current_Center_of_Gravity(An_Instance)*12.0); put_line(" Fuselage_Station of cg ");

   A_Location_of_Current_Center_of_Gravity_as_a_Percentage_of_Mean_Aerodynamic_Chord := 0.0;
   A_Mean_Aerodynamic_Center                                    := 0.0;
   A_Fuselage_Station_of_Leading_Edge_of_Mean_Aerodynamic_Chord := 0.0;
   Reference_Coordinates.Set_Fuselage_Station_of_Current_Center_of_Gravity_in_Percantage_of_Mean_Aerodynamic_Chord
     (A_Location_of_Current_Center_of_Gravity_as_a_Percentage_of_Mean_Aerodynamic_Chord,
      A_Mean_Aerodynamic_Center                                    ,
      A_Fuselage_Station_of_Leading_Edge_of_Mean_Aerodynamic_Chord ,
      An_Instance                                                  );

   put(Reference_Coordinates.Get_Fuselage_Station_of_Current_Center_of_Gravity(An_Instance)*12.0); put_line(" Fuselage_Station of cg ");

   A_Waterline_of_Current_Center_of_Gravity_of_Fuel_Tank := 0.0;
   Reference_Coordinates.Set_Waterline_of_Current_Center_of_Gravity
     (A_Weight_Zero_Fuel                                    ,
      A_Gross_Weight                                        ,
      A_Waterline_of_Current_Center_of_Gravity_of_Fuel_Tank ,
      A_Landing_Gear_Position                               ,
      An_Instance                                           );

   put(Reference_Coordinates.Get_Waterline_of_Current_Center_of_Gravity(An_Instance)*12.0); put_line(" Waterline of cg ");


   Pass := abs(Reference_Coordinates.Get_Buttline_of_Current_Center_of_Gravity(An_Instance)*12.0) >= 0.0 and
     abs(Reference_Coordinates.Get_Fuselage_Station_of_Current_Center_of_Gravity(An_Instance)*12.0) >= 0.0 and
     abs(Reference_Coordinates.Get_Waterline_of_Current_Center_of_Gravity(An_Instance)*12.0) >= 0.0;

   Class_Test_Result_File.Report_Case_Status(Pass);
   Pass := False;

end EXECUTE_Ref_Coord;
