-------------------------------------------------------------------------------
--|
--|            FlightSafety International Simulation Systems Division
--|                     Broken Arrow, OK  USA  918-259-4000
--|
--|                  JPATS T-6A Texan-II Flight Training Device
--|
--|
--|   Engineer:  Yogesh Tupe
--|
--|   Revision:  (Number and date inserted by Clearcase)
--|
--|
--|  DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
--|  Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
--|  technical or operational data or information from automatic dissemination
--|  under the International Exchange Program or by other means.  This protection
--|  covers information required solely for administrative or operational
--|  purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--|
--|  WARNING:  This document contains technical data whose export is restricted
--|  by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
--|  Executive Order 12470.  Violation of these export control laws is subject
--|  to severe criminal penalties.  Dissemination of this document is controlled
--|  under DOD Directive 5230.25
--|
-------------------------------------------------------------------------------
--|

with Ada.Text_IO;                              use Ada.Text_IO;
with Ada.Float_Text_IO;                        use Ada.Float_Text_IO;
with Ada.Integer_Text_IO;                      use Ada.Integer_Text_IO;
with Ada.Long_Float_Text_IO;                   use Ada.Long_Float_Text_IO;
with Ada.Numerics;
with Ada.Numerics.Elementary_Functions;        use Ada.Numerics.Elementary_Functions;


with Quaternion;
with Angle_Types;
with Class_Test_Result_File;

procedure EXECUTE_Quaternion is
   An_Instance   : Quaternion.Instance;

   A_Roll_Rate   :Angle_Types.Radians_per_Sec;
   A_Pitch_Rate  :Angle_Types.Radians_per_Sec;
   A_Yaw_Rate    :Angle_Types.Radians_per_Sec;
   A_Roll_Angle  :Angle_Types.Radians;
   A_Pitch_Angle :Angle_Types.Radians;
   A_Yaw_Angle   :Angle_Types.Radians;

   A_Predefined_E_1_Rate           :Float;
   A_Predefined_E_2_Rate           :Float;
   A_Predefined_E_3_Rate           :Float;
   A_Predefined_E_4_Rate           :Float;
   A_Predefined_Last_Pass_E_1_Rate : Float;
   A_Predefined_Last_Pass_E_2_Rate : Float;
   A_Predefined_Last_Pass_E_3_Rate : Float;
   A_Predefined_Last_Pass_E_4_Rate : Float;


   An_Integration_Constant          :Float;
   A_Freezable_Integration_Constant :Float;

   A_Predefined_E_1 :Float;
   A_Predefined_E_2 :Float;
   A_Predefined_E_3 :Float;
   A_Predefined_E_4 :Float;

   A_Predefined_L_1 :Float;
   A_Predefined_L_2 :Float;
   A_Predefined_L_3 :Float;
   A_Predefined_M_1 :Float;
   A_Predefined_M_2 :Float;
   A_Predefined_M_3 :Float;
   A_Predefined_N_1 :Float;
   A_Predefined_N_2 :Float;
   A_Predefined_N_3 :Float;
   A_Predefined_Orthogonality_Correction_Factor :Float;

   Pass        : Boolean := False;
   A_Tolerance : Float   := 0.000_1;

begin

   A_Roll_Rate   := -0.8475446;
   A_Pitch_Rate  := -0.4425803;
   A_Yaw_Rate    := -0.270799;
   A_Roll_Angle  := -0.04276093;
   A_Pitch_Angle := -0.1442567;
   A_Yaw_Angle   := -2.520829;

   A_Predefined_E_1_Rate := -0.125625;
   A_Predefined_E_2_Rate := -0.00418321;
   A_Predefined_E_3_Rate := 0.318924;
   A_Predefined_E_4_Rate := -0.3379487;

   A_Predefined_Last_Pass_E_1_Rate  := -0.1172016;
   A_Predefined_Last_Pass_E_2_Rate  := -0.006392159;
   A_Predefined_Last_Pass_E_3_Rate  := 0.3076253;
   A_Predefined_Last_Pass_E_4_Rate  := -0.3280952;

   An_Integration_Constant          := 1.0/60.0;
   A_Freezable_Integration_Constant := An_Integration_Constant;

   A_Predefined_E_1 := 0.3010493;
   A_Predefined_E_2 := -0.9500253;
   A_Predefined_E_3 := 0.06731208;
   A_Predefined_E_4 := -0.04785826;

   A_Predefined_L_1 := 0.812691;
   A_Predefined_L_2 := -0.5811247;
   A_Predefined_L_3 := 0.0427479;
   A_Predefined_M_1 := 0.570616;
   A_Predefined_M_2 := -0.8085598;
   A_Predefined_M_3 := -0.1436255;
   A_Predefined_N_1 := 0.1180286;
   A_Predefined_N_2 := -0.09233048;
   A_Predefined_N_3 := 0.9887084;
   A_Predefined_Orthogonality_Correction_Factor := 1.0;



   Quaternion.Assign_Quaternion_Rate (A_Predefined_E_1_Rate,
                                      A_Predefined_E_2_Rate,
                                      A_Predefined_E_3_Rate,
                                      A_Predefined_E_4_Rate,
                                      A_Predefined_Last_Pass_E_1_Rate,
                                      A_Predefined_Last_Pass_E_2_Rate,
                                      A_Predefined_Last_Pass_E_3_Rate,
                                      A_Predefined_Last_Pass_E_4_Rate,
                                      An_Instance           );

   --
   Quaternion.Assign_Quaternion (A_Predefined_E_1,
                                 A_Predefined_E_2,
                                 A_Predefined_E_3,
                                 A_Predefined_E_4,
                                 A_Predefined_L_1,
                                 A_Predefined_L_2,
                                 A_Predefined_L_3,
                                 A_Predefined_M_1,
                                 A_Predefined_M_2,
                                 A_Predefined_M_3,
                                 A_Predefined_N_1,
                                 A_Predefined_N_2,
                                 A_Predefined_N_3,
                                 An_Instance      );



   Quaternion.Set_Orthogonality_Correction_Factor (An_Instance );
   Put(Quaternion.Get_E_1_Rate(An_Instance));  put(Quaternion.Get_E_2_Rate(An_Instance));
   Put(Quaternion.Get_E_3_Rate(An_Instance));  put(Quaternion.Get_E_4_Rate(An_Instance)); put_line(" E_Rate ");

   Put(Quaternion.Get_E_1(An_Instance));  put(Quaternion.Get_E_2(An_Instance));
   Put(Quaternion.Get_E_3(An_Instance));  put(Quaternion.Get_E_4(An_Instance)); put_line(" E ");
   Put_Line(" $$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$ ");
   --
   Quaternion.Set_Quaternion_Rate (A_Roll_Rate  ,
                                   A_Pitch_Rate ,
                                   A_Yaw_Rate   ,
                                   An_Instance  );
   --

   Quaternion.Set_Quaternion (An_Integration_Constant         ,
                              A_Freezable_Integration_Constant,
                              --" = 0.0 for Heading Freeze ELSE = An_Integration_Constant"
                              An_Instance                      );

   Put(Quaternion.Get_E_1_Rate(An_Instance));  put(Quaternion.Get_E_2_Rate(An_Instance));
   Put(Quaternion.Get_E_3_Rate(An_Instance));  put(Quaternion.Get_E_4_Rate(An_Instance)); put_line(" E_Rate ");

   Put(Quaternion.Get_E_1(An_Instance));  put(Quaternion.Get_E_2(An_Instance));
   Put(Quaternion.Get_E_3(An_Instance));  put(Quaternion.Get_E_4(An_Instance)); put_line(" E ");


   Pass := abs(Quaternion.Get_E_1_Rate(An_Instance) -(-0.1340185) ) <= A_Tolerance and
     abs(Quaternion.Get_E_2_Rate(An_Instance) - (-0.001646359)) <= A_Tolerance and
     abs(Quaternion.Get_E_3_Rate(An_Instance) - (0.3294952)) <= A_Tolerance and
     abs(Quaternion.Get_E_4_Rate(An_Instance) - (-0.3469216)) <= A_Tolerance;

   Class_Test_Result_File.Report_Case_Status(Pass);

   Pass := False;

   Pass := abs(Quaternion.Get_E_1(An_Instance) - 0.2988658) <= A_Tolerance and
     abs(Quaternion.Get_E_2(An_Instance) - (-0.9500122)) <= A_Tolerance and
     abs(Quaternion.Get_E_3(An_Instance) - 0.07271177) <= A_Tolerance and
     abs(Quaternion.Get_E_4(An_Instance) - (-0.05356301)) <= A_Tolerance;

   Class_Test_Result_File.Report_Case_Status(Pass);

   Put_Line(" ---------------------------CONSTRAINT----------------------------");
   Pass := False;

   A_Roll_Rate   := 1000.0;
   A_Pitch_Rate  := 1000.0;
   A_Yaw_Rate    := 1000.0;
   A_Roll_Angle  := 1000.0;
   A_Pitch_Angle := 1000.0;
   A_Yaw_Angle   := 1000.0;


   Quaternion.Set_Quaternion_Rate (A_Roll_Rate  ,
                                   A_Pitch_Rate ,
                                   A_Yaw_Rate   ,
                                   An_Instance  );
   --

   Quaternion.Set_Quaternion (An_Integration_Constant         ,
                              A_Freezable_Integration_Constant,
                              --" = 0.0 for Heading Freeze ELSE = An_Integration_Constant"
                              An_Instance                      );

   Put(Quaternion.Get_E_1_Rate(An_Instance));  put(Quaternion.Get_E_2_Rate(An_Instance));
   Put(Quaternion.Get_E_3_Rate(An_Instance));  put(Quaternion.Get_E_4_Rate(An_Instance)); put_line(" E_Rate ");

   Put(Quaternion.Get_E_1(An_Instance));  put(Quaternion.Get_E_2(An_Instance));
   Put(Quaternion.Get_E_3(An_Instance));  put(Quaternion.Get_E_4(An_Instance)); put_line(" E ");


   Pass := abs(Quaternion.Get_E_1_Rate(An_Instance) ) >= 0.0 and
     abs(Quaternion.Get_E_2_Rate(An_Instance) ) >= 0.0 and
     abs(Quaternion.Get_E_3_Rate(An_Instance) ) >= 0.0 and
     abs(Quaternion.Get_E_4_Rate(An_Instance) ) >= 0.0;

   Class_Test_Result_File.Report_Case_Status(Pass);

   Pass := False;

   Pass := abs(Quaternion.Get_E_1(An_Instance) ) >= 0.0 and
     abs(Quaternion.Get_E_2(An_Instance) ) >= 0.0 and
     abs(Quaternion.Get_E_3(An_Instance) ) >= 0.0 and
     abs(Quaternion.Get_E_4(An_Instance) ) >= 0.0;

   Class_Test_Result_File.Report_Case_Status(Pass);

   Put_Line(" ---------------------------CONSTRAINT----------------------------");
   Pass := False;

   A_Roll_Rate   := 0.0;
   A_Pitch_Rate  := 0.0;
   A_Yaw_Rate    := 0.0;
   A_Roll_Angle  := 0.0;
   A_Pitch_Angle := 0.0;
   A_Yaw_Angle   := 0.0;


   Quaternion.Set_Quaternion_Rate (A_Roll_Rate  ,
                                   A_Pitch_Rate ,
                                   A_Yaw_Rate   ,
                                   An_Instance  );
   --

   Quaternion.Set_Quaternion (An_Integration_Constant         ,
                              A_Freezable_Integration_Constant,
                              --" = 0.0 for Heading Freeze ELSE = An_Integration_Constant"
                              An_Instance                      );

   Put(Quaternion.Get_E_1_Rate(An_Instance));  put(Quaternion.Get_E_2_Rate(An_Instance));
   Put(Quaternion.Get_E_3_Rate(An_Instance));  put(Quaternion.Get_E_4_Rate(An_Instance)); put_line(" E_Rate ");

   Put(Quaternion.Get_E_1(An_Instance));  put(Quaternion.Get_E_2(An_Instance));
   Put(Quaternion.Get_E_3(An_Instance));  put(Quaternion.Get_E_4(An_Instance)); put_line(" E ");


   Pass := abs(Quaternion.Get_E_1_Rate(An_Instance) ) >= 0.0 and
     abs(Quaternion.Get_E_2_Rate(An_Instance) ) >= 0.0 and
     abs(Quaternion.Get_E_3_Rate(An_Instance) ) >= 0.0 and
     abs(Quaternion.Get_E_4_Rate(An_Instance) ) >= 0.0;

   Class_Test_Result_File.Report_Case_Status(Pass);

   Pass := False;

   Pass := abs(Quaternion.Get_E_1(An_Instance) ) >= 0.0 and
     abs(Quaternion.Get_E_2(An_Instance) ) >= 0.0 and
     abs(Quaternion.Get_E_3(An_Instance) ) >= 0.0 and
     abs(Quaternion.Get_E_4(An_Instance) ) >= 0.0;

   Class_Test_Result_File.Report_Case_Status(Pass);


end EXECUTE_Quaternion;
