-------------------------------------------------------------------------------
--|
--|            FlightSafety International Simulation Systems Division
--|                     Broken Arrow, OK  USA  918-259-4000
--|
--|                  JPATS T-6A Texan-II Flight Training Device
--|
--|
--|   Engineer:  Yogesh Tupe
--|
--|   Revision:  (Number and date inserted by Clearcase)
--|
--|
--|  DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
--|  Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
--|  technical or operational data or information from automatic dissemination
--|  under the International Exchange Program or by other means.  This protection
--|  covers information required solely for administrative or operational
--|  purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--|
--|  WARNING:  This document contains technical data whose export is restricted
--|  by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
--|  Executive Order 12470.  Violation of these export control laws is subject
--|  to severe criminal penalties.  Dissemination of this document is controlled
--|  under DOD Directive 5230.25
--|
-------------------------------------------------------------------------------
--|

with Ada.Text_IO;                              use Ada.Text_IO;
with Ada.Float_Text_IO;                        use Ada.Float_Text_IO;
with Ada.Integer_Text_IO;                      use Ada.Integer_Text_IO;
with Ada.Long_Float_Text_IO;                   use Ada.Long_Float_Text_IO;
with Ada.Numerics;
with Ada.Numerics.Elementary_Functions;        use Ada.Numerics.Elementary_Functions;


with Tank_Mass_Property;
with Moment_of_Inertia;
with Aircraft_Weight;
with Reference_Coordinates;

with Angle_Types;
with Coordinate_Types;
with Length_Types;
with Interpolation_Table.Singly_Indexed;
with Normalized_Types;
with JPATS_Simulated_Aircraft_Types;
with JPATS_Fuel_Types;
with Mass_Types;
with Class_Test_Result_File;

procedure EXECUTE_MI is
   An_Instance_RTMP : Tank_Mass_Property.Instance;
   An_Instance_LTMP : Tank_Mass_Property.Instance;
   An_Instance_CTMP : Tank_Mass_Property.Instance;
   An_Instance_MI   : Moment_of_Inertia.Instance;
   An_Instance_AW   : Aircraft_Weight.Instance;
   An_Instance_RC   : Reference_Coordinates.Instance;

   A_Sign                                               : Float;
   A_Fuel_Volume                                        : Length_Types.Gallons;
   AFUELBL                                              : Interpolation_Table.Singly_Indexed.Instance;
   FUELFS                                               : Interpolation_Table.Singly_Indexed.Instance;
   A_Predefined_Reference_Coordinates                   : Coordinate_Types.Reference_System;
   A_Weight_Fuel                                        : Mass_Types.Lbm;
   A_Predefined_Current_Center_of_Gravity               : Coordinate_Types.Reference_System;
   FUELKXX                                              : Interpolation_Table.Singly_Indexed.Instance;
   FUELKYY                                              : Interpolation_Table.Singly_Indexed.Instance;
   FUELKZZ                                              : Interpolation_Table.Singly_Indexed.Instance;
   FUELIXZ                                              : Interpolation_Table.Singly_Indexed.Instance;
   A_Reference_Coordinate_of_Current_Center_of_Gravity_of_Simulated_Aircraft : Coordinate_Types.Reference_System;
   A_Predefined_Inertia                                 :  Coordinate_Types.Inertia_Axis;
   A_Moment_of_Inertia_Basic                            : Coordinate_Types.Inertia_Axis;
   A_Moment_of_Inertia_Fuel_Tank                        : Coordinate_Types.Inertia_Axis;
   A_Weight_Zero_Fuel                                   : Mass_Types.Lbm;
   A_Weight_Basic                                       : Mass_Types.Lbm;
   A_Weight_Front_Seat_Occupant                         : Mass_Types.Lbm;
   A_Weight_Rear_Seat_Occupant                          : Mass_Types.Lbm;
   A_Weight_Baggage                                     : Mass_Types.Lbm;
   A_Reference_Coordinates_Basic                        : Coordinate_Types.Reference_System;
   A_Reference_Coordinates_Front_Seat_Occupant          : Coordinate_Types.Reference_System;
   A_Reference_Coordinates_Rear_Seat_Occupant           : Coordinate_Types.Reference_System;
   A_Reference_Coordinates_Baggage                      : Coordinate_Types.Reference_System;
   A_Reference_Coordinates_of_Current_Center_of_Gravity : Coordinate_Types.Reference_System;
   A_Reference_Coordinates_Zero_Fuel                    : Coordinate_Types.Reference_System;
   --|  = [Ixx + (BLcg - BLtank)] TERMS!!!
   A_Landing_Gear_Position                              : Normalized_Types.Normalize;
   A_Predefined_Moment_of_Inertia                       : Coordinate_Types.Inertia_Axis;
   File_Path : String := "c:\JPATS\Ada_Code\MkII\Data_Tables\Aero_Coefficients\";


   A_Predefined_Weight_Zero_Fuel : Mass_Types.Lbm;
   A_Weight_Ice_Wing_Body_Plus   : Mass_Types.Lbm;
   A_Predefined_Gross_Weight     : Mass_Types.Lbm;
   A_Predefined_Mass             : Mass_Types.Slugs_per_Cubic_Feet;


   A_Basic                                 : Coordinate_Types.Reference_System;
   A_Baggage                               : Coordinate_Types.Reference_System;
   A_Front_Seat_Occupant                   : Coordinate_Types.Reference_System;
   A_Rear_Seat_Occupant                    : Coordinate_Types.Reference_System;
   A_Predefined_Zero_Fuel_Reference_System : Coordinate_Types.Reference_System;
   A_Gross_Weight                                       : Mass_Types.Lbm;
   A_Buttline_of_Current_Center_of_Gravity_of_Fuel_Tank : Length_Types.Feet;
   A_Predefined_Buttline_of_Current_Center_of_Gravity   : Length_Types.Feet;
   A_Fuselage_Station_of_Current_Center_of_Gravity_of_Fuel_Tank : Length_Types.Feet;
   A_Location_of_Current_Center_of_Gravity_as_a_Percentage_of_Mean_Aerodynamic_Chord : Float;
   A_Mean_Aerodynamic_Center                                    : Length_Types.Feet;
   A_Fuselage_Station_of_Leading_Edge_of_Mean_Aerodynamic_Chord : Length_Types.Feet;
   A_Predefined_Fuselage_Station_of_Current_Center_of_Gravity   : Length_Types.Feet;
   A_Waterline_of_Current_Center_of_Gravity_of_Fuel_Tank        : Length_Types.Feet;
   A_Predefined_Waterline_of_Current_Center_of_Gravity          : Length_Types.Feet;

   Pass : Boolean := False;
   A_Tolerance : Float := 0.001;


begin

   Interpolation_Table.Singly_Indexed.Read_ASCII(File_Path & "AFUELBL.csv",AFUELBL);
   Interpolation_Table.Singly_Indexed.Read_ASCII(File_Path & "FUELFS.csv", FUELFS);
   Interpolation_Table.Singly_Indexed.Read_ASCII(File_Path & "FUELKXX.csv",FUELKXX);

   Interpolation_Table.Singly_Indexed.Read_ASCII(File_Path & "FUELKYY.csv",FUELKYY);
   Interpolation_Table.Singly_Indexed.Read_ASCII(File_Path & "FUELKZZ.csv",FUELKZZ);
   Interpolation_Table.Singly_Indexed.Read_ASCII(File_Path & "FUELIXZ.csv",FUELIXZ);

   A_Sign := -1.0;
   A_Fuel_Volume := 31.82;
   Tank_Mass_Property.Set_Wing_Reference_Coordinates
     (A_Sign       ,
      A_Fuel_Volume,
      AFUELBL      ,
      FUELFS       ,
      An_Instance_LTMP);

   A_Sign := 1.0;
   A_Fuel_Volume := 35.55;
   Tank_Mass_Property.Set_Wing_Reference_Coordinates
     (A_Sign       ,
      A_Fuel_Volume,
      AFUELBL      ,
      FUELFS       ,
      An_Instance_RTMP);

   A_Fuel_Volume := 7.25;
   A_Predefined_Reference_Coordinates := (JPATS_Fuel_Types.The_Collector_Tank_Buttline,
                                          JPATS_Fuel_Types.The_Collector_Tank_Fuselage_Station,
                                          (68.16 + 0.62 * A_Fuel_Volume)/12.0);
   Tank_Mass_Property.Assign_Reference_Coordinates
     (A_Predefined_Reference_Coordinates,
      An_Instance_CTMP);

   put(Tank_Mass_Property.Get_Reference_Coordinates(An_Instance_LTMP).Buttline*12.0);
   put(Tank_Mass_Property.Get_Reference_Coordinates(An_Instance_LTMP).Fuselage_Station*12.0);
   put(Tank_Mass_Property.Get_Reference_Coordinates(An_Instance_LTMP).Waterline*12.0);
   put_line(" LEFT Tank_Reference_Coordinates ");

   put(Tank_Mass_Property.Get_Reference_Coordinates(An_Instance_RTMP).Buttline*12.0);
   put(Tank_Mass_Property.Get_Reference_Coordinates(An_Instance_RTMP).Fuselage_Station*12.0);
   put(Tank_Mass_Property.Get_Reference_Coordinates(An_Instance_RTMP).Waterline*12.0);
   put_line(" RIGHT Tank_Reference_Coordinates ");

   put(Tank_Mass_Property.Get_Reference_Coordinates(An_Instance_CTMP).Buttline*12.0);
   put(Tank_Mass_Property.Get_Reference_Coordinates(An_Instance_CTMP).Fuselage_Station*12.0);
   put(Tank_Mass_Property.Get_Reference_Coordinates(An_Instance_CTMP).Waterline*12.0);
   put_line(" COLLECTOR Tank_Reference_Coordinates ");

   Pass:= abs(Tank_Mass_Property.Get_Reference_Coordinates(An_Instance_LTMP).Buttline - (-67.2748642/12.0)) <= 0.01 and
     abs(Tank_Mass_Property.Get_Reference_Coordinates(An_Instance_LTMP).Fuselage_Station - 169.7897/12.0) <= 0.01  and
     abs(Tank_Mass_Property.Get_Reference_Coordinates(An_Instance_LTMP).Waterline - 73.6339/12.0)  <= 0.01 and
     abs(Tank_Mass_Property.Get_Reference_Coordinates(An_Instance_RTMP).Buttline - 68.4669/12.0)  <= 0.01 and
     abs(Tank_Mass_Property.Get_Reference_Coordinates(An_Instance_RTMP).Fuselage_Station - 169.849/12.0) <= 0.01  and
     abs(Tank_Mass_Property.Get_Reference_Coordinates(An_Instance_RTMP).Waterline - 73.97496/12.0)  <= 0.01 and
     abs(Tank_Mass_Property.Get_Reference_Coordinates(An_Instance_CTMP).Buttline - (-13.58/12.0))  <= 0.01 and
     abs(Tank_Mass_Property.Get_Reference_Coordinates(An_Instance_CTMP).Fuselage_Station - 164.92999/12.0) <= 0.01 and
     abs(Tank_Mass_Property.Get_Reference_Coordinates(An_Instance_CTMP).Waterline - 72.654999/12.0) <= 0.01 ;

   Class_Test_Result_File.Report_Case_Status(Pass);
   Pass:=False;

   A_Weight_Fuel := 213.21;
   Tank_Mass_Property.Set_Current_Center_of_Gravity (A_Weight_Fuel,
                                                     An_Instance_LTMP);

   A_Weight_Fuel := 238.21;
   Tank_Mass_Property.Set_Current_Center_of_Gravity (A_Weight_Fuel,
                                                     An_Instance_RTMP);

   A_Weight_Fuel := 48.57;
   Tank_Mass_Property.Set_Current_Center_of_Gravity (A_Weight_Fuel,
                                                     An_Instance_CTMP);

   --put(Tank_Mass_Property.Get_Current_Center_of_Gravity(An_Instance_LTMP).Buttline);
   --put(Tank_Mass_Property.Get_Current_Center_of_Gravity(An_Instance_LTMP).Fuselage_Station);
   --put(Tank_Mass_Property.Get_Current_Center_of_Gravity(An_Instance_LTMP).Waterline);
   --put_line(" LEFT Tank_Current_Center_of_Gravity ");

   --put(Tank_Mass_Property.Get_Current_Center_of_Gravity(An_Instance_RTMP).Buttline);
   --put(Tank_Mass_Property.Get_Current_Center_of_Gravity(An_Instance_RTMP).Fuselage_Station);
   --put(Tank_Mass_Property.Get_Current_Center_of_Gravity(An_Instance_RTMP).Waterline);
   --put_line(" RIGHT Tank_Current_Center_of_Gravity ");

   --put(Tank_Mass_Property.Get_Current_Center_of_Gravity(An_Instance_CTMP).Buttline);
   --put(Tank_Mass_Property.Get_Current_Center_of_Gravity(An_Instance_CTMP).Fuselage_Station);
   --put(Tank_Mass_Property.Get_Current_Center_of_Gravity(An_Instance_CTMP).Waterline);
   --put_line(" COLLECTOR Tank_Current_Center_of_Gravity ");

   A_Weight_Basic               := JPATS_Simulated_Aircraft_Types.The_Weight_Basic;
   A_Weight_Front_Seat_Occupant := JPATS_Simulated_Aircraft_Types.The_Weight_Front_Seat_Occupant;
   A_Weight_Rear_Seat_Occupant  := JPATS_Simulated_Aircraft_Types.The_Weight_Rear_Seat_Occupant;
   A_Weight_Baggage             := JPATS_Simulated_Aircraft_Types.The_Weight_Baggage;
   Aircraft_Weight.Set_Zero_Fuel (A_Weight_Basic              ,
                                  A_Weight_Front_Seat_Occupant,
                                  A_Weight_Rear_Seat_Occupant ,
                                  A_Weight_Baggage            ,
                                  An_Instance_AW);

   --put(Aircraft_Weight.Get_Zero_Fuel(An_Instance_AW));put_line(" zero fuel weight ");

   A_Weight_Fuel            := 500.00;
   A_Weight_Ice_Wing_Body_Plus := 0.0;
   Aircraft_Weight.Set_Gross_Weight (A_Weight_Fuel           ,
                                     A_Weight_Ice_Wing_Body_Plus,
                                     An_Instance_AW);
   --put(Aircraft_Weight.Get_Gross_Weight(An_Instance_AW)); put_line(" gross weight ");

   Aircraft_Weight.Set_Mass(An_Instance_AW);

   --put(Aircraft_Weight.Get_Mass(An_Instance_AW)); put_line( " Mass ");

   A_Basic                     := JPATS_Simulated_Aircraft_Types.The_Reference_Coordinates_Basic;
   A_Baggage                   := JPATS_Simulated_Aircraft_Types.The_Reference_Coordinates_Baggage;
   A_Front_Seat_Occupant       := JPATS_Simulated_Aircraft_Types.The_Reference_Coordinates_Front_Seat_Occupant;
   A_Rear_Seat_Occupant        := JPATS_Simulated_Aircraft_Types.The_Reference_Coordinates_Rear_Seat_Occupant;
   A_Weight_Zero_Fuel          := Aircraft_Weight.Get_Zero_Fuel(An_Instance_AW);
   A_Weight_Basic              := JPATS_Simulated_Aircraft_Types.The_Weight_Basic;
   A_Weight_Front_Seat_Occupant:= JPATS_Simulated_Aircraft_Types.The_Weight_Front_Seat_Occupant;
   A_Weight_Rear_Seat_Occupant := JPATS_Simulated_Aircraft_Types.The_Weight_Rear_Seat_Occupant;
   A_Weight_Baggage            := JPATS_Simulated_Aircraft_Types.The_Weight_Baggage;
   Reference_Coordinates.Set_Zero_Fuel (A_Basic                     ,
                                        A_Baggage                   ,
                                        A_Front_Seat_Occupant       ,
                                        A_Rear_Seat_Occupant        ,
                                        A_Weight_Zero_Fuel          ,
                                        A_Weight_Basic              ,
                                        A_Weight_Front_Seat_Occupant,
                                        A_Weight_Rear_Seat_Occupant ,
                                        A_Weight_Baggage            ,
                                        An_Instance_RC);

   put(Reference_Coordinates.Get_Zero_Fuel(An_Instance_RC).buttline*12.0);
   put(Reference_Coordinates.Get_Zero_Fuel(An_Instance_RC).fuselage_station*12.0);
   put(Reference_Coordinates.Get_Zero_Fuel(An_Instance_RC).waterline*12.0); put_line(" zero fuel ref coord. ");

   Pass:= abs(Reference_Coordinates.Get_Zero_Fuel(An_Instance_RC).Buttline - (0.0741583/12.0)) <= A_Tolerance and
     abs(Reference_Coordinates.Get_Zero_Fuel(An_Instance_RC).Fuselage_Station - 167.1052246/12.0) <= A_Tolerance  and
     abs(Reference_Coordinates.Get_Zero_Fuel(An_Instance_RC).Waterline - 89.992386/12.0)  <= A_Tolerance;

   Class_Test_Result_File.Report_Case_Status(Pass);
   Pass:=False;

   A_Weight_Zero_Fuel      := Aircraft_Weight.Get_Zero_Fuel(An_Instance_AW);
   A_Gross_Weight          := Aircraft_Weight.Get_Gross_Weight(An_Instance_AW);
   A_Buttline_of_Current_Center_of_Gravity_of_Fuel_Tank :=
     (  Tank_Mass_Property.Get_Current_Center_of_Gravity(An_Instance_LTMP).buttline
        + Tank_Mass_Property.Get_Current_Center_of_Gravity(An_Instance_RTMP).buttline
        + Tank_Mass_Property.Get_Current_Center_of_Gravity(An_Instance_CTMP).buttline);

   Reference_Coordinates.Set_Buttline_of_Current_Center_of_Gravity
     (A_Weight_Zero_Fuel                                   ,
      A_Gross_Weight                                       ,
      A_Buttline_of_Current_Center_of_Gravity_of_Fuel_Tank ,
      An_Instance_RC);

   put(Reference_Coordinates.Get_Buttline_of_Current_Center_of_Gravity(An_Instance_RC)*12.0);
   put_line(" Buttline_of_Current_Center_of_Gravity ");


   --| This procedure will set the Fuselage_Station_of_Current_Center_of_Gravity calculated
   --| during initalization, autotesting or when Fuselage_Station_of_Current_Center_of_Gravity
   --| is defined by an approved other method.
   A_Predefined_Fuselage_Station_of_Current_Center_of_Gravity :=0.0;
   Reference_Coordinates.Assign_Fuselage_Station_of_Current_Center_of_Gravity
     (A_Predefined_Fuselage_Station_of_Current_Center_of_Gravity ,
      An_Instance_RC);

   A_Fuselage_Station_of_Current_Center_of_Gravity_of_Fuel_Tank :=
     (  Tank_Mass_Property.Get_Current_Center_of_Gravity(An_Instance_LTMP).fuselage_Station
        + Tank_Mass_Property.Get_Current_Center_of_Gravity(An_Instance_RTMP).fuselage_Station
        + Tank_Mass_Property.Get_Current_Center_of_Gravity(An_Instance_CTMP).fuselage_Station);
   A_Landing_Gear_Position := 1.0;
   Reference_Coordinates.Set_Fuselage_Station_of_Current_Center_of_Gravity
     (A_Weight_Zero_Fuel                                           ,
      A_Gross_Weight                                               ,
      A_Fuselage_Station_of_Current_Center_of_Gravity_of_Fuel_Tank ,
      A_Landing_Gear_Position                                      ,
      An_Instance_RC);

   --| Check if CG location is defined in terms of % of Mean Aerodynamic Chord.
   --Reference_Coordinates.Set_Fuselage_Station_of_Current_Center_of_Gravity_in_Percantage_of_Mean_Aerodynamic_Chord
   --  (A_Location_of_Current_Center_of_Gravity_as_a_Percentage_of_Mean_Aerodynamic_Chord,
   --   A_Mean_Aerodynamic_Center                                    ,
   --   A_Fuselage_Station_of_Leading_Edge_of_Mean_Aerodynamic_Chord ,
   --  An_Instance_RC);
   put(Reference_Coordinates.Get_Fuselage_Station_of_Current_Center_of_Gravity(An_Instance_RC)*12.0);
   put_line(" Fuselage_Station_of_Current_Center_of_Gravity ");

   --| This procedure will set the Waterline_of_Current_Center_of_Gravity calculated
   --| during initalization, autotesting or when Waterline_of_Current_Center_of_Gravity
   --| is defined by an approved other method.
   Reference_Coordinates.Assign_Waterline_of_Current_Center_of_Gravity
     (A_Predefined_Waterline_of_Current_Center_of_Gravity ,
      An_Instance_RC);

   A_Waterline_of_Current_Center_of_Gravity_of_Fuel_Tank :=
     (  Tank_Mass_Property.Get_Current_Center_of_Gravity(An_Instance_LTMP).waterline
        + Tank_Mass_Property.Get_Current_Center_of_Gravity(An_Instance_RTMP).waterline
        + Tank_Mass_Property.Get_Current_Center_of_Gravity(An_Instance_CTMP).waterline);

   Reference_Coordinates.Set_Waterline_of_Current_Center_of_Gravity
     (A_Weight_Zero_Fuel                                    ,
      A_Gross_Weight                                        ,
      A_Waterline_of_Current_Center_of_Gravity_of_Fuel_Tank ,
      A_Landing_Gear_Position                               ,
      An_Instance_RC);

   put(Reference_Coordinates.Get_Waterline_of_Current_Center_of_Gravity(An_Instance_RC)*12.0);
   put_line(" Waterline_of_Current_Center_of_Gravity ");


   new_line(2);


   A_Fuel_Volume := 31.82;
   A_Weight_Fuel := 213.21;
   Tank_Mass_Property.Set_Wing_Inertia
     (A_Fuel_Volume,
      A_Weight_Fuel,
      FUELKXX      ,
      FUELKYY      ,
      FUELKZZ      ,
      FUELIXZ      ,
      An_Instance_LTMP);

   A_Fuel_Volume := 35.55;
   A_Weight_Fuel := 238.21;
   Tank_Mass_Property.Set_Wing_Inertia
     (A_Fuel_Volume,
      A_Weight_Fuel,
      FUELKXX      ,
      FUELKYY      ,
      FUELKZZ      ,
      FUELIXZ      ,
      An_Instance_RTMP);

   A_Weight_Fuel := 48.57;
   Tank_Mass_Property.Set_Collector_Inertia (A_Weight_Fuel,
                                             An_Instance_CTMP);

   A_Reference_Coordinate_of_Current_Center_of_Gravity_of_Simulated_Aircraft :=
     (Reference_Coordinates.Get_buttline_of_Current_Center_of_Gravity(An_Instance_RC),
      Reference_Coordinates.Get_fuselage_station_of_Current_Center_of_Gravity(An_Instance_RC),
      Reference_Coordinates.Get_Waterline_of_Current_Center_of_Gravity(An_Instance_RC));
   A_Weight_Fuel := 213.21;
   Tank_Mass_Property.Set_Moment_of_Inertia
     (A_Reference_Coordinate_of_Current_Center_of_Gravity_of_Simulated_Aircraft,
      A_Weight_Fuel,
      An_Instance_LTMP);

   A_Weight_Fuel := 238.21;
   Tank_Mass_Property.Set_Moment_of_Inertia
     (A_Reference_Coordinate_of_Current_Center_of_Gravity_of_Simulated_Aircraft,
      A_Weight_Fuel,
      An_Instance_RTMP);

   A_Weight_Fuel := 48.75;
   Tank_Mass_Property.Set_Moment_of_Inertia
     (A_Reference_Coordinate_of_Current_Center_of_Gravity_of_Simulated_Aircraft,
      A_Weight_Fuel,
      An_Instance_CTMP);

   Put(Tank_Mass_Property.Get_Moment_of_Inertia(An_Instance_LTMP).xx);
   Put(Tank_Mass_Property.Get_Moment_of_Inertia(An_Instance_LTMP).yy);
   Put(Tank_Mass_Property.Get_Moment_of_Inertia(An_Instance_LTMP).zz);
   Put(Tank_Mass_Property.Get_Moment_of_Inertia(An_Instance_LTMP).xz);
   put_line(" Left Moment of Inertia ");

   Put(Tank_Mass_Property.Get_Moment_of_Inertia(An_Instance_RTMP).xx);
   Put(Tank_Mass_Property.Get_Moment_of_Inertia(An_Instance_RTMP).yy);
   Put(Tank_Mass_Property.Get_Moment_of_Inertia(An_Instance_RTMP).zz);
   Put(Tank_Mass_Property.Get_Moment_of_Inertia(An_Instance_RTMP).xz);
   put_line(" RIGHT Moment of Inertia ");

   Put(Tank_Mass_Property.Get_Moment_of_Inertia(An_Instance_CTMP).xx);
   Put(Tank_Mass_Property.Get_Moment_of_Inertia(An_Instance_CTMP).yy);
   Put(Tank_Mass_Property.Get_Moment_of_Inertia(An_Instance_CTMP).zz);
   Put(Tank_Mass_Property.Get_Moment_of_Inertia(An_Instance_CTMP).xz);
   put_line(" COLLECTOR Moment of Inertia ");

   A_Moment_of_Inertia_Basic     := JPATS_Simulated_Aircraft_Types.The_Moment_of_Inertia_Basic;
   A_Moment_of_Inertia_Fuel_Tank := (  Tank_Mass_Property.Get_Moment_of_Inertia(An_Instance_LTMP).xx
                                       + Tank_Mass_Property.Get_Moment_of_Inertia(An_Instance_RTMP).xx
                                       + Tank_Mass_Property.Get_Moment_of_Inertia(An_Instance_CTMP).xx,
                                       Tank_Mass_Property.Get_Moment_of_Inertia(An_Instance_LTMP).yy
                                       + Tank_Mass_Property.Get_Moment_of_Inertia(An_Instance_RTMP).yy
                                       + Tank_Mass_Property.Get_Moment_of_Inertia(An_Instance_CTMP).yy,
                                       Tank_Mass_Property.Get_Moment_of_Inertia(An_Instance_LTMP).zz
                                       + Tank_Mass_Property.Get_Moment_of_Inertia(An_Instance_RTMP).zz
                                       + Tank_Mass_Property.Get_Moment_of_Inertia(An_Instance_CTMP).zz,
                                       Tank_Mass_Property.Get_Moment_of_Inertia(An_Instance_LTMP).xz
                                       + Tank_Mass_Property.Get_Moment_of_Inertia(An_Instance_RTMP).xz
                                       + Tank_Mass_Property.Get_Moment_of_Inertia(An_Instance_CTMP).xz);

   put(A_Moment_of_Inertia_Fuel_Tank.xz); put_line("  A_Moment_of_Inertia_Fuel_Tank.xz ");

   A_Reference_Coordinates_of_Current_Center_of_Gravity :=
     (Reference_Coordinates.Get_buttline_of_Current_Center_of_Gravity(An_Instance_RC),
      Reference_Coordinates.Get_fuselage_station_of_Current_Center_of_Gravity(An_Instance_RC),
      Reference_Coordinates.Get_Waterline_of_Current_Center_of_Gravity(An_Instance_RC));
   A_Reference_Coordinates_Zero_Fuel  := (Reference_Coordinates.Get_Zero_Fuel(An_Instance_RC).buttline,
                                          Reference_Coordinates.Get_Zero_Fuel(An_Instance_RC).fuselage_Station,
                                          Reference_Coordinates.Get_Zero_Fuel(An_Instance_RC).waterline);
   --|  = [Ixx + (BLcg - BLtank)] TERMS!!!
   Moment_of_Inertia.Set_Inertia
     (A_Moment_of_Inertia_Basic    ,
      A_Moment_of_Inertia_Fuel_Tank,
      A_Weight_Zero_Fuel           ,
      A_Weight_Basic               ,
      A_Weight_Front_Seat_Occupant ,
      A_Weight_Rear_Seat_Occupant  ,
      A_Weight_Baggage             ,
      A_Basic                      ,
      A_Front_Seat_Occupant        ,
      A_Rear_Seat_Occupant         ,
      A_Baggage                    ,
      A_Reference_Coordinates_of_Current_Center_of_Gravity,
      A_Reference_Coordinates_Zero_Fuel                   ,
      --|  = [Ixx + (BLcg - BLtank)] TERMS!!!
      A_Landing_Gear_Position                             ,
      An_Instance_MI);

   Put(Moment_of_Inertia.Get_Inertia(An_Instance_MI).xx); Put(Moment_of_Inertia.Get_Inertia(An_Instance_MI).yy);
   Put(Moment_of_Inertia.Get_Inertia(An_Instance_MI).zz); Put(Moment_of_Inertia.Get_Inertia(An_Instance_MI).xz);
   put_line(" Moment of Inertia ");




   Pass:= abs(Moment_of_Inertia.Get_Inertia(An_Instance_MI).xx - 2776.173096) <= 0.1 and
     abs(Moment_of_Inertia.Get_Inertia(An_Instance_MI).yy - 6661.55176) <= 0.1  and
     abs(Moment_of_Inertia.Get_Inertia(An_Instance_MI).zz - 8659.77246)  <= 0.1 and
     abs(Moment_of_Inertia.Get_Inertia(An_Instance_MI).xz - 280.9183)  <= 0.1;

   Class_Test_Result_File.Report_Case_Status(Pass);
   Pass:=False;


   put_line(" -------------------------- CONSTRAINT ------------------------");


   A_Sign := -1.0;
   A_Fuel_Volume := 1000.0;
   Tank_Mass_Property.Set_Wing_Reference_Coordinates
     (A_Sign       ,
      A_Fuel_Volume,
      AFUELBL      ,
      FUELFS       ,
      An_Instance_LTMP);

   A_Sign := 1.0;
   A_Fuel_Volume := 1000.0;
   Tank_Mass_Property.Set_Wing_Reference_Coordinates
     (A_Sign       ,
      A_Fuel_Volume,
      AFUELBL      ,
      FUELFS       ,
      An_Instance_RTMP);

   A_Fuel_Volume := 1000.0;
   A_Predefined_Reference_Coordinates := (JPATS_Fuel_Types.The_Collector_Tank_Buttline,
                                          JPATS_Fuel_Types.The_Collector_Tank_Fuselage_Station,
                                          (68.16 + 0.62 * A_Fuel_Volume)/12.0);
   Tank_Mass_Property.Assign_Reference_Coordinates
     (A_Predefined_Reference_Coordinates,
      An_Instance_CTMP);

   put(Tank_Mass_Property.Get_Reference_Coordinates(An_Instance_LTMP).Buttline*12.0);
   put(Tank_Mass_Property.Get_Reference_Coordinates(An_Instance_LTMP).Fuselage_Station*12.0);
   put(Tank_Mass_Property.Get_Reference_Coordinates(An_Instance_LTMP).Waterline*12.0);
   put_line(" LEFT Tank_Reference_Coordinates ");

   put(Tank_Mass_Property.Get_Reference_Coordinates(An_Instance_RTMP).Buttline*12.0);
   put(Tank_Mass_Property.Get_Reference_Coordinates(An_Instance_RTMP).Fuselage_Station*12.0);
   put(Tank_Mass_Property.Get_Reference_Coordinates(An_Instance_RTMP).Waterline*12.0);
   put_line(" RIGHT Tank_Reference_Coordinates ");

   put(Tank_Mass_Property.Get_Reference_Coordinates(An_Instance_CTMP).Buttline*12.0);
   put(Tank_Mass_Property.Get_Reference_Coordinates(An_Instance_CTMP).Fuselage_Station*12.0);
   put(Tank_Mass_Property.Get_Reference_Coordinates(An_Instance_CTMP).Waterline*12.0);
   put_line(" COLLECTOR Tank_Reference_Coordinates ");

   Pass:= abs(Tank_Mass_Property.Get_Reference_Coordinates(An_Instance_LTMP).Buttline) >= 0.0 and
     abs(Tank_Mass_Property.Get_Reference_Coordinates(An_Instance_LTMP).Fuselage_Station) >= 0.0  and
     abs(Tank_Mass_Property.Get_Reference_Coordinates(An_Instance_LTMP).Waterline) >= 0.0 and
     abs(Tank_Mass_Property.Get_Reference_Coordinates(An_Instance_RTMP).Buttline) >= 0.0 and
     abs(Tank_Mass_Property.Get_Reference_Coordinates(An_Instance_RTMP).Fuselage_Station) >= 0.0 and
     abs(Tank_Mass_Property.Get_Reference_Coordinates(An_Instance_RTMP).Waterline ) >= 0.0 and
     abs(Tank_Mass_Property.Get_Reference_Coordinates(An_Instance_CTMP).Buttline) >= 0.0 and
     abs(Tank_Mass_Property.Get_Reference_Coordinates(An_Instance_CTMP).Fuselage_Station) >= 0.0 and
     abs(Tank_Mass_Property.Get_Reference_Coordinates(An_Instance_CTMP).Waterline ) >= 0.0;

   Class_Test_Result_File.Report_Case_Status(Pass);
   Pass:=False;

   A_Weight_Fuel := 1000.0;
   Tank_Mass_Property.Set_Current_Center_of_Gravity (A_Weight_Fuel,
                                                     An_Instance_LTMP);

   A_Weight_Fuel := 1000.0;
   Tank_Mass_Property.Set_Current_Center_of_Gravity (A_Weight_Fuel,
                                                     An_Instance_RTMP);

   A_Weight_Fuel := 1000.0;
   Tank_Mass_Property.Set_Current_Center_of_Gravity (A_Weight_Fuel,
                                                     An_Instance_CTMP);

   --put(Tank_Mass_Property.Get_Current_Center_of_Gravity(An_Instance_LTMP).Buttline);
   --put(Tank_Mass_Property.Get_Current_Center_of_Gravity(An_Instance_LTMP).Fuselage_Station);
   --put(Tank_Mass_Property.Get_Current_Center_of_Gravity(An_Instance_LTMP).Waterline);
   --put_line(" LEFT Tank_Current_Center_of_Gravity ");

   --put(Tank_Mass_Property.Get_Current_Center_of_Gravity(An_Instance_RTMP).Buttline);
   --put(Tank_Mass_Property.Get_Current_Center_of_Gravity(An_Instance_RTMP).Fuselage_Station);
   --put(Tank_Mass_Property.Get_Current_Center_of_Gravity(An_Instance_RTMP).Waterline);
   --put_line(" RIGHT Tank_Current_Center_of_Gravity ");

   --put(Tank_Mass_Property.Get_Current_Center_of_Gravity(An_Instance_CTMP).Buttline);
   --put(Tank_Mass_Property.Get_Current_Center_of_Gravity(An_Instance_CTMP).Fuselage_Station);
   --put(Tank_Mass_Property.Get_Current_Center_of_Gravity(An_Instance_CTMP).Waterline);
   --put_line(" COLLECTOR Tank_Current_Center_of_Gravity ");

   A_Weight_Basic               := JPATS_Simulated_Aircraft_Types.The_Weight_Basic;
   A_Weight_Front_Seat_Occupant := JPATS_Simulated_Aircraft_Types.The_Weight_Front_Seat_Occupant;
   A_Weight_Rear_Seat_Occupant  := JPATS_Simulated_Aircraft_Types.The_Weight_Rear_Seat_Occupant;
   A_Weight_Baggage             := JPATS_Simulated_Aircraft_Types.The_Weight_Baggage;
   Aircraft_Weight.Set_Zero_Fuel (A_Weight_Basic              ,
                                  A_Weight_Front_Seat_Occupant,
                                  A_Weight_Rear_Seat_Occupant ,
                                  A_Weight_Baggage            ,
                                  An_Instance_AW);

   --put(Aircraft_Weight.Get_Zero_Fuel(An_Instance_AW));put_line(" zero fuel weight ");

   A_Weight_Fuel            := 1000.0;
   A_Weight_Ice_Wing_Body_Plus := 0.0;
   Aircraft_Weight.Set_Gross_Weight (A_Weight_Fuel           ,
                                     A_Weight_Ice_Wing_Body_Plus,
                                     An_Instance_AW);
   --put(Aircraft_Weight.Get_Gross_Weight(An_Instance_AW)); put_line(" gross weight ");

   Aircraft_Weight.Set_Mass(An_Instance_AW);

   --put(Aircraft_Weight.Get_Mass(An_Instance_AW)); put_line( " Mass ");

   A_Basic                     := JPATS_Simulated_Aircraft_Types.The_Reference_Coordinates_Basic;
   A_Baggage                   := JPATS_Simulated_Aircraft_Types.The_Reference_Coordinates_Baggage;
   A_Front_Seat_Occupant       := JPATS_Simulated_Aircraft_Types.The_Reference_Coordinates_Front_Seat_Occupant;
   A_Rear_Seat_Occupant        := JPATS_Simulated_Aircraft_Types.The_Reference_Coordinates_Rear_Seat_Occupant;
   A_Weight_Zero_Fuel          := Aircraft_Weight.Get_Zero_Fuel(An_Instance_AW);
   A_Weight_Basic              := JPATS_Simulated_Aircraft_Types.The_Weight_Basic;
   A_Weight_Front_Seat_Occupant:= JPATS_Simulated_Aircraft_Types.The_Weight_Front_Seat_Occupant;
   A_Weight_Rear_Seat_Occupant := JPATS_Simulated_Aircraft_Types.The_Weight_Rear_Seat_Occupant;
   A_Weight_Baggage            := JPATS_Simulated_Aircraft_Types.The_Weight_Baggage;
   Reference_Coordinates.Set_Zero_Fuel (A_Basic                     ,
                                        A_Baggage                   ,
                                        A_Front_Seat_Occupant       ,
                                        A_Rear_Seat_Occupant        ,
                                        A_Weight_Zero_Fuel          ,
                                        A_Weight_Basic              ,
                                        A_Weight_Front_Seat_Occupant,
                                        A_Weight_Rear_Seat_Occupant ,
                                        A_Weight_Baggage            ,
                                        An_Instance_RC);

   put(Reference_Coordinates.Get_Zero_Fuel(An_Instance_RC).buttline*12.0);
   put(Reference_Coordinates.Get_Zero_Fuel(An_Instance_RC).fuselage_station*12.0);
   put(Reference_Coordinates.Get_Zero_Fuel(An_Instance_RC).waterline*12.0); put_line(" zero fuel ref coord. ");

   Pass:= abs(Reference_Coordinates.Get_Zero_Fuel(An_Instance_RC).Buttline) >= 0.0 and
     abs(Reference_Coordinates.Get_Zero_Fuel(An_Instance_RC).Fuselage_Station) >= 0.0 and
     abs(Reference_Coordinates.Get_Zero_Fuel(An_Instance_RC).Waterline) >= 0.0;

   Class_Test_Result_File.Report_Case_Status(Pass);
   Pass:=False;

   A_Weight_Zero_Fuel      := Aircraft_Weight.Get_Zero_Fuel(An_Instance_AW);
   A_Gross_Weight          := Aircraft_Weight.Get_Gross_Weight(An_Instance_AW);
   A_Buttline_of_Current_Center_of_Gravity_of_Fuel_Tank :=
     (  Tank_Mass_Property.Get_Current_Center_of_Gravity(An_Instance_LTMP).buttline
        + Tank_Mass_Property.Get_Current_Center_of_Gravity(An_Instance_RTMP).buttline
        + Tank_Mass_Property.Get_Current_Center_of_Gravity(An_Instance_CTMP).buttline);

   Reference_Coordinates.Set_Buttline_of_Current_Center_of_Gravity
     (A_Weight_Zero_Fuel                                   ,
      A_Gross_Weight                                       ,
      A_Buttline_of_Current_Center_of_Gravity_of_Fuel_Tank ,
      An_Instance_RC);

   put(Reference_Coordinates.Get_Buttline_of_Current_Center_of_Gravity(An_Instance_RC)*12.0);
   put_line(" Buttline_of_Current_Center_of_Gravity ");


   --| This procedure will set the Fuselage_Station_of_Current_Center_of_Gravity calculated
   --| during initalization, autotesting or when Fuselage_Station_of_Current_Center_of_Gravity
   --| is defined by an approved other method.
   A_Predefined_Fuselage_Station_of_Current_Center_of_Gravity :=0.0;
   Reference_Coordinates.Assign_Fuselage_Station_of_Current_Center_of_Gravity
     (A_Predefined_Fuselage_Station_of_Current_Center_of_Gravity ,
      An_Instance_RC);

   A_Fuselage_Station_of_Current_Center_of_Gravity_of_Fuel_Tank :=
     (  Tank_Mass_Property.Get_Current_Center_of_Gravity(An_Instance_LTMP).fuselage_Station
        + Tank_Mass_Property.Get_Current_Center_of_Gravity(An_Instance_RTMP).fuselage_Station
        + Tank_Mass_Property.Get_Current_Center_of_Gravity(An_Instance_CTMP).fuselage_Station);
   A_Landing_Gear_Position := 1.0;
   Reference_Coordinates.Set_Fuselage_Station_of_Current_Center_of_Gravity
     (A_Weight_Zero_Fuel                                           ,
      A_Gross_Weight                                               ,
      A_Fuselage_Station_of_Current_Center_of_Gravity_of_Fuel_Tank ,
      A_Landing_Gear_Position                                      ,
      An_Instance_RC);

   --| Check if CG location is defined in terms of % of Mean Aerodynamic Chord.
   --Reference_Coordinates.Set_Fuselage_Station_of_Current_Center_of_Gravity_in_Percantage_of_Mean_Aerodynamic_Chord
   --  (A_Location_of_Current_Center_of_Gravity_as_a_Percentage_of_Mean_Aerodynamic_Chord,
   --   A_Mean_Aerodynamic_Center                                    ,
   --   A_Fuselage_Station_of_Leading_Edge_of_Mean_Aerodynamic_Chord ,
   --  An_Instance_RC);
   put(Reference_Coordinates.Get_Fuselage_Station_of_Current_Center_of_Gravity(An_Instance_RC)*12.0);
   put_line(" Fuselage_Station_of_Current_Center_of_Gravity ");

   --| This procedure will set the Waterline_of_Current_Center_of_Gravity calculated
   --| during initalization, autotesting or when Waterline_of_Current_Center_of_Gravity
   --| is defined by an approved other method.
   Reference_Coordinates.Assign_Waterline_of_Current_Center_of_Gravity
     (A_Predefined_Waterline_of_Current_Center_of_Gravity ,
      An_Instance_RC);

   A_Waterline_of_Current_Center_of_Gravity_of_Fuel_Tank :=
     (  Tank_Mass_Property.Get_Current_Center_of_Gravity(An_Instance_LTMP).waterline
        + Tank_Mass_Property.Get_Current_Center_of_Gravity(An_Instance_RTMP).waterline
        + Tank_Mass_Property.Get_Current_Center_of_Gravity(An_Instance_CTMP).waterline);

   Reference_Coordinates.Set_Waterline_of_Current_Center_of_Gravity
     (A_Weight_Zero_Fuel                                    ,
      A_Gross_Weight                                        ,
      A_Waterline_of_Current_Center_of_Gravity_of_Fuel_Tank ,
      A_Landing_Gear_Position                               ,
      An_Instance_RC);

   put(Reference_Coordinates.Get_Waterline_of_Current_Center_of_Gravity(An_Instance_RC)*12.0);
   put_line(" Waterline_of_Current_Center_of_Gravity ");


   new_line(2);


   A_Fuel_Volume := 1000.0;
   A_Weight_Fuel := 1000.0;
   Tank_Mass_Property.Set_Wing_Inertia
     (A_Fuel_Volume,
      A_Weight_Fuel,
      FUELKXX      ,
      FUELKYY      ,
      FUELKZZ      ,
      FUELIXZ      ,
      An_Instance_LTMP);

   A_Fuel_Volume := 1000.0;
   A_Weight_Fuel := 1000.0;
   Tank_Mass_Property.Set_Wing_Inertia
     (A_Fuel_Volume,
      A_Weight_Fuel,
      FUELKXX      ,
      FUELKYY      ,
      FUELKZZ      ,
      FUELIXZ      ,
      An_Instance_RTMP);

   A_Weight_Fuel := 1000.0;
   Tank_Mass_Property.Set_Collector_Inertia (A_Weight_Fuel,
                                             An_Instance_CTMP);

   A_Reference_Coordinate_of_Current_Center_of_Gravity_of_Simulated_Aircraft :=
     (Reference_Coordinates.Get_buttline_of_Current_Center_of_Gravity(An_Instance_RC),
      Reference_Coordinates.Get_fuselage_station_of_Current_Center_of_Gravity(An_Instance_RC),
      Reference_Coordinates.Get_Waterline_of_Current_Center_of_Gravity(An_Instance_RC));
   A_Weight_Fuel := 1000.0;
   Tank_Mass_Property.Set_Moment_of_Inertia
     (A_Reference_Coordinate_of_Current_Center_of_Gravity_of_Simulated_Aircraft,
      A_Weight_Fuel,
      An_Instance_LTMP);

   A_Weight_Fuel := 1000.0;
   Tank_Mass_Property.Set_Moment_of_Inertia
     (A_Reference_Coordinate_of_Current_Center_of_Gravity_of_Simulated_Aircraft,
      A_Weight_Fuel,
      An_Instance_RTMP);

   A_Weight_Fuel := 1000.0;
   Tank_Mass_Property.Set_Moment_of_Inertia
     (A_Reference_Coordinate_of_Current_Center_of_Gravity_of_Simulated_Aircraft,
      A_Weight_Fuel,
      An_Instance_CTMP);

   Put(Tank_Mass_Property.Get_Moment_of_Inertia(An_Instance_LTMP).xx);
   Put(Tank_Mass_Property.Get_Moment_of_Inertia(An_Instance_LTMP).yy);
   Put(Tank_Mass_Property.Get_Moment_of_Inertia(An_Instance_LTMP).zz);
   Put(Tank_Mass_Property.Get_Moment_of_Inertia(An_Instance_LTMP).xz);
   put_line(" Left Moment of Inertia ");

   Put(Tank_Mass_Property.Get_Moment_of_Inertia(An_Instance_RTMP).xx);
   Put(Tank_Mass_Property.Get_Moment_of_Inertia(An_Instance_RTMP).yy);
   Put(Tank_Mass_Property.Get_Moment_of_Inertia(An_Instance_RTMP).zz);
   Put(Tank_Mass_Property.Get_Moment_of_Inertia(An_Instance_RTMP).xz);
   put_line(" RIGHT Moment of Inertia ");

   Put(Tank_Mass_Property.Get_Moment_of_Inertia(An_Instance_CTMP).xx);
   Put(Tank_Mass_Property.Get_Moment_of_Inertia(An_Instance_CTMP).yy);
   Put(Tank_Mass_Property.Get_Moment_of_Inertia(An_Instance_CTMP).zz);
   Put(Tank_Mass_Property.Get_Moment_of_Inertia(An_Instance_CTMP).xz);
   put_line(" COLLECTOR Moment of Inertia ");

   A_Moment_of_Inertia_Basic     := JPATS_Simulated_Aircraft_Types.The_Moment_of_Inertia_Basic;
   A_Moment_of_Inertia_Fuel_Tank := (  Tank_Mass_Property.Get_Moment_of_Inertia(An_Instance_LTMP).xx
                                       + Tank_Mass_Property.Get_Moment_of_Inertia(An_Instance_RTMP).xx
                                       + Tank_Mass_Property.Get_Moment_of_Inertia(An_Instance_CTMP).xx,
                                       Tank_Mass_Property.Get_Moment_of_Inertia(An_Instance_LTMP).yy
                                       + Tank_Mass_Property.Get_Moment_of_Inertia(An_Instance_RTMP).yy
                                       + Tank_Mass_Property.Get_Moment_of_Inertia(An_Instance_CTMP).yy,
                                       Tank_Mass_Property.Get_Moment_of_Inertia(An_Instance_LTMP).zz
                                       + Tank_Mass_Property.Get_Moment_of_Inertia(An_Instance_RTMP).zz
                                       + Tank_Mass_Property.Get_Moment_of_Inertia(An_Instance_CTMP).zz,
                                       Tank_Mass_Property.Get_Moment_of_Inertia(An_Instance_LTMP).xz
                                       + Tank_Mass_Property.Get_Moment_of_Inertia(An_Instance_RTMP).xz
                                       + Tank_Mass_Property.Get_Moment_of_Inertia(An_Instance_CTMP).xz);

   put(A_Moment_of_Inertia_Fuel_Tank.xz); put_line("  A_Moment_of_Inertia_Fuel_Tank.xz ");

   A_Reference_Coordinates_of_Current_Center_of_Gravity :=
     (Reference_Coordinates.Get_buttline_of_Current_Center_of_Gravity(An_Instance_RC),
      Reference_Coordinates.Get_fuselage_station_of_Current_Center_of_Gravity(An_Instance_RC),
      Reference_Coordinates.Get_Waterline_of_Current_Center_of_Gravity(An_Instance_RC));
   A_Reference_Coordinates_Zero_Fuel  := (Reference_Coordinates.Get_Zero_Fuel(An_Instance_RC).buttline,
                                          Reference_Coordinates.Get_Zero_Fuel(An_Instance_RC).fuselage_Station,
                                          Reference_Coordinates.Get_Zero_Fuel(An_Instance_RC).waterline);
   --|  = [Ixx + (BLcg - BLtank)] TERMS!!!
   Moment_of_Inertia.Set_Inertia
     (A_Moment_of_Inertia_Basic    ,
      A_Moment_of_Inertia_Fuel_Tank,
      A_Weight_Zero_Fuel           ,
      A_Weight_Basic               ,
      A_Weight_Front_Seat_Occupant ,
      A_Weight_Rear_Seat_Occupant  ,
      A_Weight_Baggage             ,
      A_Basic                      ,
      A_Front_Seat_Occupant        ,
      A_Rear_Seat_Occupant         ,
      A_Baggage                    ,
      A_Reference_Coordinates_of_Current_Center_of_Gravity,
      A_Reference_Coordinates_Zero_Fuel                   ,
      --|  = [Ixx + (BLcg - BLtank)] TERMS!!!
      A_Landing_Gear_Position                             ,
      An_Instance_MI);

   Put(Moment_of_Inertia.Get_Inertia(An_Instance_MI).xx); Put(Moment_of_Inertia.Get_Inertia(An_Instance_MI).yy);
   Put(Moment_of_Inertia.Get_Inertia(An_Instance_MI).zz); Put(Moment_of_Inertia.Get_Inertia(An_Instance_MI).xz);
   put_line(" Moment of Inertia ");




   Pass:= abs(Moment_of_Inertia.Get_Inertia(An_Instance_MI).xx) >= 0.0 and
     abs(Moment_of_Inertia.Get_Inertia(An_Instance_MI).yy) >= 0.0 and
     abs(Moment_of_Inertia.Get_Inertia(An_Instance_MI).zz) >= 0.0 and
     abs(Moment_of_Inertia.Get_Inertia(An_Instance_MI).xz) >= 0.0;

   Class_Test_Result_File.Report_Case_Status(Pass);
   Pass:=False;

   put_line(" -------------------------- END ------------------------");


   A_Sign := -1.0;
   A_Fuel_Volume := 0.0;
   Tank_Mass_Property.Set_Wing_Reference_Coordinates
     (A_Sign       ,
      A_Fuel_Volume,
      AFUELBL      ,
      FUELFS       ,
      An_Instance_LTMP);

   A_Sign := 1.0;
   A_Fuel_Volume := 0.0;
   Tank_Mass_Property.Set_Wing_Reference_Coordinates
     (A_Sign       ,
      A_Fuel_Volume,
      AFUELBL      ,
      FUELFS       ,
      An_Instance_RTMP);

   A_Fuel_Volume := 0.0;
   A_Predefined_Reference_Coordinates := (JPATS_Fuel_Types.The_Collector_Tank_Buttline,
                                          JPATS_Fuel_Types.The_Collector_Tank_Fuselage_Station,
                                          (68.16 + 0.62 * A_Fuel_Volume)/12.0);
   Tank_Mass_Property.Assign_Reference_Coordinates
     (A_Predefined_Reference_Coordinates,
      An_Instance_CTMP);

   put(Tank_Mass_Property.Get_Reference_Coordinates(An_Instance_LTMP).Buttline*12.0);
   put(Tank_Mass_Property.Get_Reference_Coordinates(An_Instance_LTMP).Fuselage_Station*12.0);
   put(Tank_Mass_Property.Get_Reference_Coordinates(An_Instance_LTMP).Waterline*12.0);
   put_line(" LEFT Tank_Reference_Coordinates ");

   put(Tank_Mass_Property.Get_Reference_Coordinates(An_Instance_RTMP).Buttline*12.0);
   put(Tank_Mass_Property.Get_Reference_Coordinates(An_Instance_RTMP).Fuselage_Station*12.0);
   put(Tank_Mass_Property.Get_Reference_Coordinates(An_Instance_RTMP).Waterline*12.0);
   put_line(" RIGHT Tank_Reference_Coordinates ");

   put(Tank_Mass_Property.Get_Reference_Coordinates(An_Instance_CTMP).Buttline*12.0);
   put(Tank_Mass_Property.Get_Reference_Coordinates(An_Instance_CTMP).Fuselage_Station*12.0);
   put(Tank_Mass_Property.Get_Reference_Coordinates(An_Instance_CTMP).Waterline*12.0);
   put_line(" COLLECTOR Tank_Reference_Coordinates ");

   Pass:= abs(Tank_Mass_Property.Get_Reference_Coordinates(An_Instance_LTMP).Buttline) >= 0.0 and
     abs(Tank_Mass_Property.Get_Reference_Coordinates(An_Instance_LTMP).Fuselage_Station) >= 0.0  and
     abs(Tank_Mass_Property.Get_Reference_Coordinates(An_Instance_LTMP).Waterline) >= 0.0 and
     abs(Tank_Mass_Property.Get_Reference_Coordinates(An_Instance_RTMP).Buttline) >= 0.0 and
     abs(Tank_Mass_Property.Get_Reference_Coordinates(An_Instance_RTMP).Fuselage_Station) >= 0.0 and
     abs(Tank_Mass_Property.Get_Reference_Coordinates(An_Instance_RTMP).Waterline ) >= 0.0 and
     abs(Tank_Mass_Property.Get_Reference_Coordinates(An_Instance_CTMP).Buttline) >= 0.0 and
     abs(Tank_Mass_Property.Get_Reference_Coordinates(An_Instance_CTMP).Fuselage_Station) >= 0.0 and
     abs(Tank_Mass_Property.Get_Reference_Coordinates(An_Instance_CTMP).Waterline ) >= 0.0;

   Class_Test_Result_File.Report_Case_Status(Pass);
   Pass:=False;

   A_Weight_Fuel := 0.0;
   Tank_Mass_Property.Set_Current_Center_of_Gravity (A_Weight_Fuel,
                                                     An_Instance_LTMP);

   A_Weight_Fuel := 0.0;
   Tank_Mass_Property.Set_Current_Center_of_Gravity (A_Weight_Fuel,
                                                     An_Instance_RTMP);

   A_Weight_Fuel := 0.0;
   Tank_Mass_Property.Set_Current_Center_of_Gravity (A_Weight_Fuel,
                                                     An_Instance_CTMP);

   --put(Tank_Mass_Property.Get_Current_Center_of_Gravity(An_Instance_LTMP).Buttline);
   --put(Tank_Mass_Property.Get_Current_Center_of_Gravity(An_Instance_LTMP).Fuselage_Station);
   --put(Tank_Mass_Property.Get_Current_Center_of_Gravity(An_Instance_LTMP).Waterline);
   --put_line(" LEFT Tank_Current_Center_of_Gravity ");

   --put(Tank_Mass_Property.Get_Current_Center_of_Gravity(An_Instance_RTMP).Buttline);
   --put(Tank_Mass_Property.Get_Current_Center_of_Gravity(An_Instance_RTMP).Fuselage_Station);
   --put(Tank_Mass_Property.Get_Current_Center_of_Gravity(An_Instance_RTMP).Waterline);
   --put_line(" RIGHT Tank_Current_Center_of_Gravity ");

   --put(Tank_Mass_Property.Get_Current_Center_of_Gravity(An_Instance_CTMP).Buttline);
   --put(Tank_Mass_Property.Get_Current_Center_of_Gravity(An_Instance_CTMP).Fuselage_Station);
   --put(Tank_Mass_Property.Get_Current_Center_of_Gravity(An_Instance_CTMP).Waterline);
   --put_line(" COLLECTOR Tank_Current_Center_of_Gravity ");

   A_Weight_Basic               := JPATS_Simulated_Aircraft_Types.The_Weight_Basic;
   A_Weight_Front_Seat_Occupant := JPATS_Simulated_Aircraft_Types.The_Weight_Front_Seat_Occupant;
   A_Weight_Rear_Seat_Occupant  := JPATS_Simulated_Aircraft_Types.The_Weight_Rear_Seat_Occupant;
   A_Weight_Baggage             := JPATS_Simulated_Aircraft_Types.The_Weight_Baggage;
   Aircraft_Weight.Set_Zero_Fuel (A_Weight_Basic              ,
                                  A_Weight_Front_Seat_Occupant,
                                  A_Weight_Rear_Seat_Occupant ,
                                  A_Weight_Baggage            ,
                                  An_Instance_AW);

   --put(Aircraft_Weight.Get_Zero_Fuel(An_Instance_AW));put_line(" zero fuel weight ");

   A_Weight_Fuel            := 0.0;
   A_Weight_Ice_Wing_Body_Plus := 0.0;
   Aircraft_Weight.Set_Gross_Weight (A_Weight_Fuel           ,
                                     A_Weight_Ice_Wing_Body_Plus,
                                     An_Instance_AW);
   --put(Aircraft_Weight.Get_Gross_Weight(An_Instance_AW)); put_line(" gross weight ");

   Aircraft_Weight.Set_Mass(An_Instance_AW);

   --put(Aircraft_Weight.Get_Mass(An_Instance_AW)); put_line( " Mass ");

   A_Basic                     := JPATS_Simulated_Aircraft_Types.The_Reference_Coordinates_Basic;
   A_Baggage                   := JPATS_Simulated_Aircraft_Types.The_Reference_Coordinates_Baggage;
   A_Front_Seat_Occupant       := JPATS_Simulated_Aircraft_Types.The_Reference_Coordinates_Front_Seat_Occupant;
   A_Rear_Seat_Occupant        := JPATS_Simulated_Aircraft_Types.The_Reference_Coordinates_Rear_Seat_Occupant;
   A_Weight_Zero_Fuel          := Aircraft_Weight.Get_Zero_Fuel(An_Instance_AW);
   A_Weight_Basic              := JPATS_Simulated_Aircraft_Types.The_Weight_Basic;
   A_Weight_Front_Seat_Occupant:= JPATS_Simulated_Aircraft_Types.The_Weight_Front_Seat_Occupant;
   A_Weight_Rear_Seat_Occupant := JPATS_Simulated_Aircraft_Types.The_Weight_Rear_Seat_Occupant;
   A_Weight_Baggage            := JPATS_Simulated_Aircraft_Types.The_Weight_Baggage;
   Reference_Coordinates.Set_Zero_Fuel (A_Basic                     ,
                                        A_Baggage                   ,
                                        A_Front_Seat_Occupant       ,
                                        A_Rear_Seat_Occupant        ,
                                        A_Weight_Zero_Fuel          ,
                                        A_Weight_Basic              ,
                                        A_Weight_Front_Seat_Occupant,
                                        A_Weight_Rear_Seat_Occupant ,
                                        A_Weight_Baggage            ,
                                        An_Instance_RC);

   put(Reference_Coordinates.Get_Zero_Fuel(An_Instance_RC).buttline*12.0);
   put(Reference_Coordinates.Get_Zero_Fuel(An_Instance_RC).fuselage_station*12.0);
   put(Reference_Coordinates.Get_Zero_Fuel(An_Instance_RC).waterline*12.0); put_line(" zero fuel ref coord. ");

   Pass:= abs(Reference_Coordinates.Get_Zero_Fuel(An_Instance_RC).Buttline) >= 0.0 and
     abs(Reference_Coordinates.Get_Zero_Fuel(An_Instance_RC).Fuselage_Station) >= 0.0 and
     abs(Reference_Coordinates.Get_Zero_Fuel(An_Instance_RC).Waterline) >= 0.0;

   Class_Test_Result_File.Report_Case_Status(Pass);
   Pass:=False;

   A_Weight_Zero_Fuel      := Aircraft_Weight.Get_Zero_Fuel(An_Instance_AW);
   A_Gross_Weight          := Aircraft_Weight.Get_Gross_Weight(An_Instance_AW);
   A_Buttline_of_Current_Center_of_Gravity_of_Fuel_Tank :=
     (  Tank_Mass_Property.Get_Current_Center_of_Gravity(An_Instance_LTMP).buttline
        + Tank_Mass_Property.Get_Current_Center_of_Gravity(An_Instance_RTMP).buttline
        + Tank_Mass_Property.Get_Current_Center_of_Gravity(An_Instance_CTMP).buttline);

   Reference_Coordinates.Set_Buttline_of_Current_Center_of_Gravity
     (A_Weight_Zero_Fuel                                   ,
      A_Gross_Weight                                       ,
      A_Buttline_of_Current_Center_of_Gravity_of_Fuel_Tank ,
      An_Instance_RC);

   put(Reference_Coordinates.Get_Buttline_of_Current_Center_of_Gravity(An_Instance_RC)*12.0);
   put_line(" Buttline_of_Current_Center_of_Gravity ");


   --| This procedure will set the Fuselage_Station_of_Current_Center_of_Gravity calculated
   --| during initalization, autotesting or when Fuselage_Station_of_Current_Center_of_Gravity
   --| is defined by an approved other method.
   A_Predefined_Fuselage_Station_of_Current_Center_of_Gravity :=0.0;
   Reference_Coordinates.Assign_Fuselage_Station_of_Current_Center_of_Gravity
     (A_Predefined_Fuselage_Station_of_Current_Center_of_Gravity ,
      An_Instance_RC);

   A_Fuselage_Station_of_Current_Center_of_Gravity_of_Fuel_Tank :=
     (  Tank_Mass_Property.Get_Current_Center_of_Gravity(An_Instance_LTMP).fuselage_Station
        + Tank_Mass_Property.Get_Current_Center_of_Gravity(An_Instance_RTMP).fuselage_Station
        + Tank_Mass_Property.Get_Current_Center_of_Gravity(An_Instance_CTMP).fuselage_Station);
   A_Landing_Gear_Position := 1.0;
   Reference_Coordinates.Set_Fuselage_Station_of_Current_Center_of_Gravity
     (A_Weight_Zero_Fuel                                           ,
      A_Gross_Weight                                               ,
      A_Fuselage_Station_of_Current_Center_of_Gravity_of_Fuel_Tank ,
      A_Landing_Gear_Position                                      ,
      An_Instance_RC);

   --| Check if CG location is defined in terms of % of Mean Aerodynamic Chord.
   --Reference_Coordinates.Set_Fuselage_Station_of_Current_Center_of_Gravity_in_Percantage_of_Mean_Aerodynamic_Chord
   --  (A_Location_of_Current_Center_of_Gravity_as_a_Percentage_of_Mean_Aerodynamic_Chord,
   --   A_Mean_Aerodynamic_Center                                    ,
   --   A_Fuselage_Station_of_Leading_Edge_of_Mean_Aerodynamic_Chord ,
   --  An_Instance_RC);
   put(Reference_Coordinates.Get_Fuselage_Station_of_Current_Center_of_Gravity(An_Instance_RC)*12.0);
   put_line(" Fuselage_Station_of_Current_Center_of_Gravity ");

   --| This procedure will set the Waterline_of_Current_Center_of_Gravity calculated
   --| during initalization, autotesting or when Waterline_of_Current_Center_of_Gravity
   --| is defined by an approved other method.
   Reference_Coordinates.Assign_Waterline_of_Current_Center_of_Gravity
     (A_Predefined_Waterline_of_Current_Center_of_Gravity ,
      An_Instance_RC);

   A_Waterline_of_Current_Center_of_Gravity_of_Fuel_Tank :=
     (  Tank_Mass_Property.Get_Current_Center_of_Gravity(An_Instance_LTMP).waterline
        + Tank_Mass_Property.Get_Current_Center_of_Gravity(An_Instance_RTMP).waterline
        + Tank_Mass_Property.Get_Current_Center_of_Gravity(An_Instance_CTMP).waterline);

   Reference_Coordinates.Set_Waterline_of_Current_Center_of_Gravity
     (A_Weight_Zero_Fuel                                    ,
      A_Gross_Weight                                        ,
      A_Waterline_of_Current_Center_of_Gravity_of_Fuel_Tank ,
      A_Landing_Gear_Position                               ,
      An_Instance_RC);

   put(Reference_Coordinates.Get_Waterline_of_Current_Center_of_Gravity(An_Instance_RC)*12.0);
   put_line(" Waterline_of_Current_Center_of_Gravity ");


   new_line(2);


   A_Fuel_Volume := 0.0;
   A_Weight_Fuel := 0.0;
   Tank_Mass_Property.Set_Wing_Inertia
     (A_Fuel_Volume,
      A_Weight_Fuel,
      FUELKXX      ,
      FUELKYY      ,
      FUELKZZ      ,
      FUELIXZ      ,
      An_Instance_LTMP);

   A_Fuel_Volume := 0.0;
   A_Weight_Fuel := 0.0;
   Tank_Mass_Property.Set_Wing_Inertia
     (A_Fuel_Volume,
      A_Weight_Fuel,
      FUELKXX      ,
      FUELKYY      ,
      FUELKZZ      ,
      FUELIXZ      ,
      An_Instance_RTMP);

   A_Weight_Fuel := 0.0;
   Tank_Mass_Property.Set_Collector_Inertia (A_Weight_Fuel,
                                             An_Instance_CTMP);

   A_Reference_Coordinate_of_Current_Center_of_Gravity_of_Simulated_Aircraft :=
     (Reference_Coordinates.Get_buttline_of_Current_Center_of_Gravity(An_Instance_RC),
      Reference_Coordinates.Get_fuselage_station_of_Current_Center_of_Gravity(An_Instance_RC),
      Reference_Coordinates.Get_Waterline_of_Current_Center_of_Gravity(An_Instance_RC));
   A_Weight_Fuel := 0.0;
   Tank_Mass_Property.Set_Moment_of_Inertia
     (A_Reference_Coordinate_of_Current_Center_of_Gravity_of_Simulated_Aircraft,
      A_Weight_Fuel,
      An_Instance_LTMP);

   A_Weight_Fuel := 0.0;
   Tank_Mass_Property.Set_Moment_of_Inertia
     (A_Reference_Coordinate_of_Current_Center_of_Gravity_of_Simulated_Aircraft,
      A_Weight_Fuel,
      An_Instance_RTMP);

   A_Weight_Fuel := 0.0;
   Tank_Mass_Property.Set_Moment_of_Inertia
     (A_Reference_Coordinate_of_Current_Center_of_Gravity_of_Simulated_Aircraft,
      A_Weight_Fuel,
      An_Instance_CTMP);

   Put(Tank_Mass_Property.Get_Moment_of_Inertia(An_Instance_LTMP).xx);
   Put(Tank_Mass_Property.Get_Moment_of_Inertia(An_Instance_LTMP).yy);
   Put(Tank_Mass_Property.Get_Moment_of_Inertia(An_Instance_LTMP).zz);
   Put(Tank_Mass_Property.Get_Moment_of_Inertia(An_Instance_LTMP).xz);
   put_line(" Left Moment of Inertia ");

   Put(Tank_Mass_Property.Get_Moment_of_Inertia(An_Instance_RTMP).xx);
   Put(Tank_Mass_Property.Get_Moment_of_Inertia(An_Instance_RTMP).yy);
   Put(Tank_Mass_Property.Get_Moment_of_Inertia(An_Instance_RTMP).zz);
   Put(Tank_Mass_Property.Get_Moment_of_Inertia(An_Instance_RTMP).xz);
   put_line(" RIGHT Moment of Inertia ");

   Put(Tank_Mass_Property.Get_Moment_of_Inertia(An_Instance_CTMP).xx);
   Put(Tank_Mass_Property.Get_Moment_of_Inertia(An_Instance_CTMP).yy);
   Put(Tank_Mass_Property.Get_Moment_of_Inertia(An_Instance_CTMP).zz);
   Put(Tank_Mass_Property.Get_Moment_of_Inertia(An_Instance_CTMP).xz);
   put_line(" COLLECTOR Moment of Inertia ");

   A_Moment_of_Inertia_Basic     := JPATS_Simulated_Aircraft_Types.The_Moment_of_Inertia_Basic;
   A_Moment_of_Inertia_Fuel_Tank := (  Tank_Mass_Property.Get_Moment_of_Inertia(An_Instance_LTMP).xx
                                       + Tank_Mass_Property.Get_Moment_of_Inertia(An_Instance_RTMP).xx
                                       + Tank_Mass_Property.Get_Moment_of_Inertia(An_Instance_CTMP).xx,
                                       Tank_Mass_Property.Get_Moment_of_Inertia(An_Instance_LTMP).yy
                                       + Tank_Mass_Property.Get_Moment_of_Inertia(An_Instance_RTMP).yy
                                       + Tank_Mass_Property.Get_Moment_of_Inertia(An_Instance_CTMP).yy,
                                       Tank_Mass_Property.Get_Moment_of_Inertia(An_Instance_LTMP).zz
                                       + Tank_Mass_Property.Get_Moment_of_Inertia(An_Instance_RTMP).zz
                                       + Tank_Mass_Property.Get_Moment_of_Inertia(An_Instance_CTMP).zz,
                                       Tank_Mass_Property.Get_Moment_of_Inertia(An_Instance_LTMP).xz
                                       + Tank_Mass_Property.Get_Moment_of_Inertia(An_Instance_RTMP).xz
                                       + Tank_Mass_Property.Get_Moment_of_Inertia(An_Instance_CTMP).xz);

   put(A_Moment_of_Inertia_Fuel_Tank.xz); put_line("  A_Moment_of_Inertia_Fuel_Tank.xz ");

   A_Reference_Coordinates_of_Current_Center_of_Gravity :=
     (Reference_Coordinates.Get_buttline_of_Current_Center_of_Gravity(An_Instance_RC),
      Reference_Coordinates.Get_fuselage_station_of_Current_Center_of_Gravity(An_Instance_RC),
      Reference_Coordinates.Get_Waterline_of_Current_Center_of_Gravity(An_Instance_RC));
   A_Reference_Coordinates_Zero_Fuel  := (Reference_Coordinates.Get_Zero_Fuel(An_Instance_RC).buttline,
                                          Reference_Coordinates.Get_Zero_Fuel(An_Instance_RC).fuselage_Station,
                                          Reference_Coordinates.Get_Zero_Fuel(An_Instance_RC).waterline);
   --|  = [Ixx + (BLcg - BLtank)] TERMS!!!
   Moment_of_Inertia.Set_Inertia
     (A_Moment_of_Inertia_Basic    ,
      A_Moment_of_Inertia_Fuel_Tank,
      A_Weight_Zero_Fuel           ,
      A_Weight_Basic               ,
      A_Weight_Front_Seat_Occupant ,
      A_Weight_Rear_Seat_Occupant  ,
      A_Weight_Baggage             ,
      A_Basic                      ,
      A_Front_Seat_Occupant        ,
      A_Rear_Seat_Occupant         ,
      A_Baggage                    ,
      A_Reference_Coordinates_of_Current_Center_of_Gravity,
      A_Reference_Coordinates_Zero_Fuel                   ,
      --|  = [Ixx + (BLcg - BLtank)] TERMS!!!
      A_Landing_Gear_Position                             ,
      An_Instance_MI);

   Put(Moment_of_Inertia.Get_Inertia(An_Instance_MI).xx); Put(Moment_of_Inertia.Get_Inertia(An_Instance_MI).yy);
   Put(Moment_of_Inertia.Get_Inertia(An_Instance_MI).zz); Put(Moment_of_Inertia.Get_Inertia(An_Instance_MI).xz);
   put_line(" Moment of Inertia ");




   Pass:= abs(Moment_of_Inertia.Get_Inertia(An_Instance_MI).xx) >= 0.0 and
     abs(Moment_of_Inertia.Get_Inertia(An_Instance_MI).yy) >= 0.0 and
     abs(Moment_of_Inertia.Get_Inertia(An_Instance_MI).zz) >= 0.0 and
     abs(Moment_of_Inertia.Get_Inertia(An_Instance_MI).xz) >= 0.0;

   Class_Test_Result_File.Report_Case_Status(Pass);
   Pass:=False;










end EXECUTE_MI;
