-------------------------------------------------------------------------------
--|
--|            FlightSafety International Simulation Systems Division
--|                     Broken Arrow, OK  USA  918-259-4000
--|
--|                  JPATS T-6A Texan-II Flight Training Device
--|
--|
--|   Engineer:  Yogesh Tupe
--|
--|   Revision:  (Number and date inserted by Clearcase)
--|
--|
--|  DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
--|  Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
--|  technical or operational data or information from automatic dissemination
--|  under the International Exchange Program or by other means.  This protection
--|  covers information required solely for administrative or operational
--|  purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--|
--|  WARNING:  This document contains technical data whose export is restricted
--|  by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
--|  Executive Order 12470.  Violation of these export control laws is subject
--|  to severe criminal penalties.  Dissemination of this document is controlled
--|  under DOD Directive 5230.25
--|
-------------------------------------------------------------------------------
--|

with Ada.Text_IO;                              use Ada.Text_IO;
with Ada.Float_Text_IO;                        use Ada.Float_Text_IO;
with Ada.Integer_Text_IO;                      use Ada.Integer_Text_IO;
with Ada.Long_Float_Text_IO;                   use Ada.Long_Float_Text_IO;
with Ada.Numerics;
with Ada.Numerics.Elementary_Functions;        use Ada.Numerics.Elementary_Functions;


with Location;
with Coordinate_Types;
with Length_Types;
with Angle_Types;
with Temperature_Types;
with Class_Test_Result_File;
with Lat_Long_Types;



procedure EXECUTE_location is
   An_Instance                : Location.Instance;

   A_x_Velocity_Earth_Axis                           : Length_Types.Feet_per_Sec;
   A_y_Velocity_Earth_Axis                           : Length_Types.Feet_per_Sec;
   A_z_Velocity_Earth_Axis                           : Length_Types.Feet_per_Sec;
   A_Last_Pass_x_Velocity_Earth_Axis                 : Length_Types.Feet_per_Sec;
   A_Last_Pass_y_Velocity_Earth_Axis                 : Length_Types.Feet_per_Sec;
   An_Integration_Constant                           : Float;
   A_Last_Pass_z_Velocity_Earth_Axis                 : Length_Types.Feet_per_Sec;
   A_Slew                                            : Float;
   A_Slew_Heading                                    : Angle_Types.Radians;
   A_Predefined_North                                : Lat_Long_Types.Latitude_Degrees;
   A_Predefined_Last_Pass_North                      : Lat_Long_Types.Latitude_Degrees;
   A_Predefined_East                                 : Lat_Long_Types.Longitude_Degrees;
   A_Predefined_Last_Pass_East                       : Lat_Long_Types.Longitude_Degrees;
   A_Pressure_Altitude                               : Length_Types.Feet;
   A_Standard_Day_Ambient_Temperature_at_Altitude    : Temperature_Types.Rankine;
   An_Aircraft_Ambient_Temperature                   : Temperature_Types.Rankine;
   A_Predefined_Geometric_Altitude                   : Length_Types.Feet;
   A_Predefined_Last_Pass_Geometric_Altitude         : Length_Types.Feet;
   A_Terrain_Height                                  : Length_Types.Feet;
   A_Predefined_Height_Above_Local_Terrain           : Length_Types.Feet;
   A_Predefined_Last_Pass_Height_Above_Local_Terrain : Length_Types.Feet;
   Pass                                              : Boolean := False;
   A_Tolerance                                       : Long_Float := 0.000_1;

begin


   A_x_Velocity_Earth_Axis                           := -212.405;
   A_y_Velocity_Earth_Axis                           := -195.395;
   A_z_Velocity_Earth_Axis                           := 5.12297;
   A_Last_Pass_x_Velocity_Earth_Axis                 := -212.3997;
   A_Last_Pass_y_Velocity_Earth_Axis                 := -195.3978;
   A_Last_Pass_z_Velocity_Earth_Axis                 := 4.774138;
   An_Integration_Constant                           := 1.0/60.0;
   A_Slew                                            := 12.5;
   A_Slew_Heading                                    := 30.0;
   A_Predefined_North                                := 45.23;
   A_Predefined_Last_Pass_North                      := 45.2299999;
   A_Predefined_East                                 := -44.583;
   A_Predefined_Last_Pass_East                       := -44.58299999;
   A_Pressure_Altitude                               := 4598.3;
   A_Standard_Day_Ambient_Temperature_at_Altitude    := 518.7;
   An_Aircraft_Ambient_Temperature                   := 498.36;
   A_Predefined_Geometric_Altitude                   := 5071.871;
   A_Predefined_Last_Pass_Geometric_Altitude         := 5071.902;
   A_Terrain_Height                                  := 2015.3;
   A_Predefined_Height_Above_Local_Terrain           := 1000.0;
   A_Predefined_Last_Pass_Height_Above_Local_Terrain := 1000.0;


   Location.Assign_North (A_Predefined_North           ,
                          A_Predefined_Last_Pass_North ,
                          An_Instance                 );

   Location.Assign_East (A_Predefined_East           ,
                         A_Predefined_Last_Pass_East ,
                         An_Instance                );
   Location.Assign_Geometric_Altitude (A_Predefined_Geometric_Altitude          ,
                                       A_Predefined_Last_Pass_Geometric_Altitude,
                                       An_Instance                              );

   --   Put(Location.Get_North(An_Instance));                 Put_Line(" Get_North ");
   --   Put(Location.Get_Last_Pass_North(An_Instance));       Put_Line(" Get_Last_Pass_North ");
   --   Put(Location.Get_East(An_Instance));                  Put_Line(" Get_East ");
   --   Put(Location.Get_Last_Pass_East(An_Instance));        Put_Line(" Get_Last_Pass_East ");
   --   Put(Location.Get_Geometric_Altitude(An_Instance));    Put_Line(" Get_Geometric_Altitude ");
   --   Put(Location.Get_Last_Pass_Geometric_Altitude(An_Instance));    Put_Line(" Get_Last_Pass_Geometric_Altitude ");

   Location.Set_North(A_x_Velocity_Earth_Axis          ,
                      A_Last_Pass_x_Velocity_Earth_Axis,
                      An_Integration_Constant          ,
                      An_Instance                      );
   Location.Set_East(A_y_Velocity_Earth_Axis          ,
                     A_Last_Pass_y_Velocity_Earth_Axis,
                     An_Integration_Constant          ,
                     An_Instance                      );

   Location.Set_Geometric_Altitude(A_z_Velocity_Earth_Axis          ,
                                   A_Last_Pass_z_Velocity_Earth_Axis,
                                   An_Integration_Constant          ,
                                   An_Instance                      );

   Put(Location.Get_North(An_Instance));                 Put_Line(" Get_North ");
   --Put(Location.Get_Last_Pass_North(An_Instance));       Put_Line(" Get_Last_Pass_North ");
   Put(Location.Get_East(An_Instance));                  Put_Line(" Get_East ");
   --Put(Location.Get_Last_Pass_East(An_Instance));        Put_Line(" Get_Last_Pass_East ");
   Put(Location.Get_Geometric_Altitude(An_Instance));    Put_Line(" Get_Geometric_Altitude ");
   --Put(Location.Get_Last_Pass_Geometric_Altitude(An_Instance));    Put_Line(" Get_Last_Pass_Geometric_Altitude ");

   Pass := abs(Location.Get_North(An_Instance) - 45.22999029) <= A_Tolerance and
     abs(Location.Get_East(An_Instance) - (-44.58300893)) <= A_Tolerance and
     abs(Location.Get_Geometric_Altitude(An_Instance) - 5071.789) <= 0.001;

   Class_Test_Result_File.Report_Case_Status(Pass);

   Pass := False;

   put(abs(Location.Get_North(An_Instance) - 45.22999029)); put(abs(Location.Get_East(An_Instance) - (-44.58300893)));
   put(abs(Location.Get_Geometric_Altitude(An_Instance) - 5071.789));
   put(Location.Get_Geometric_Altitude(An_Instance));put_line(" tolerance ");


   Location.Set_Slew_North(A_Slew         ,
                           A_Slew_Heading,
                           An_Instance   );

   Location.Set_Slew_East(A_Slew         ,
                          A_Slew_Heading,
                          An_Instance   );
   Location.Set_Geometric_Altitude_from_Pressure_Altitude
     (A_Pressure_Altitude                           ,
      A_Standard_Day_Ambient_Temperature_at_Altitude,
      An_Aircraft_Ambient_Temperature               ,
      An_Instance                                   );

   Put(Location.Get_North(An_Instance));                 Put_Line(" Get_North ");
   --  Put(Location.Get_Last_Pass_North(An_Instance));       Put_Line(" Get_Last_Pass_North ");
   Put(Location.Get_East(An_Instance));                  Put_Line(" Get_East ");
   --   Put(Location.Get_Last_Pass_East(An_Instance));        Put_Line(" Get_Last_Pass_East ");
   Put(Location.Get_Geometric_Altitude(An_Instance));    Put_Line(" Get_Geometric_Altitude ");
   --   Put(Location.Get_Last_Pass_Geometric_Altitude(An_Instance));    Put_Line(" Get_Last_Pass_Geometric_Altitude ");
   --   Put(Location.Get_Height_Above_Local_Terrain(An_Instance));      Put_Line(" Get_Height_Above_Local_Terrain ");
   --   Put(Location.Get_Last_Pass_Height_Above_Local_Terrain(An_Instance));
   Put_Line(" Get_Last_Pass_Height_Above_Local_Terrain ");

   Pass := abs(Location.Get_North(An_Instance) - 45.22999558) <= A_Tolerance and
     abs(Location.Get_East(An_Instance) - (-44.58311563)) <= A_Tolerance and
     abs(Location.Get_Geometric_Altitude(An_Instance) - 4417.98494) <= 0.001;

   Class_Test_Result_File.Report_Case_Status(Pass);

   Pass := False;

   put(abs(Location.Get_North(An_Instance) - 45.22999029)); put(abs(Location.Get_East(An_Instance) - (-44.58300893)));
   put(abs(Location.Get_Geometric_Altitude(An_Instance) - 5071.789));
   put(Location.Get_Geometric_Altitude(An_Instance));put_line(" tolerance ");


   Location.Set_Slew_Geometric_Altitude(A_Slew     ,
                                        An_Instance);
   --Location.Set_Geometric_Altitude_for_Jack_Release(An_Integration_Constant,
   --                                                 An_Instance            );

   Location.Set_Height_Above_Local_Terrain (A_Terrain_Height    ,
                                            An_Instance         );
   --Location.Assign_Height_Above_Local_Terrain
   --                          (A_Predefined_Height_Above_Local_Terrain          ,
   --                           A_Predefined_Last_Pass_Height_Above_Local_Terrain,
   --                           An_Instance                                      );


   --  Put(Location.Get_North(An_Instance));                 Put_Line(" Get_North ");
   --  Put(Location.Get_Last_Pass_North(An_Instance));       Put_Line(" Get_Last_Pass_North ");
   --  Put(Location.Get_East(An_Instance));                  Put_Line(" Get_East ");
   --  Put(Location.Get_Last_Pass_East(An_Instance));        Put_Line(" Get_Last_Pass_East ");
   Put(Location.Get_Geometric_Altitude(An_Instance));    Put_Line(" Get_Geometric_Altitude ");
   --  Put(Location.Get_Last_Pass_Geometric_Altitude(An_Instance));    Put_Line(" Get_Last_Pass_Geometric_Altitude ");
   Put(Location.Get_Height_Above_Local_Terrain(An_Instance));      Put_Line(" Get_Height_Above_Local_Terrain ");
   --  Put(Location.Get_Last_Pass_Height_Above_Local_Terrain(An_Instance));
   --  Put_Line(" Get_Last_Pass_Height_Above_Local_Terrain ");


   Pass := abs(Location.Get_Height_Above_Local_Terrain(An_Instance) - 2415.18494) <= 0.001 and
     abs(Location.Get_Geometric_Altitude(An_Instance) - 4430.48494) <= 0.001;

   Class_Test_Result_File.Report_Case_Status(Pass);

   Pass := False;

   put(abs(Location.Get_Height_Above_Local_Terrain(An_Instance) - 2415.18494));
   put(abs(Location.Get_Geometric_Altitude(An_Instance) - 4430.48494));
   put_line(" tolerance ");

   put_line(" -------------------- CONSTARINT ----------------------------");


   A_x_Velocity_Earth_Axis                           := 1000.0;
   A_y_Velocity_Earth_Axis                           := 1000.0;
   A_z_Velocity_Earth_Axis                           := 1000.0;
   A_Last_Pass_x_Velocity_Earth_Axis                 := 1000.0;
   A_Last_Pass_y_Velocity_Earth_Axis                 := 1000.0;
   A_Last_Pass_z_Velocity_Earth_Axis                 := 1000.0;
   An_Integration_Constant                           := 1.0/60.0;
   A_Slew                                            := 1000.0;
   A_Slew_Heading                                    := 1000.0;
   A_Predefined_North                                := 90.0;
   A_Predefined_Last_Pass_North                      := 90.0;
   A_Predefined_East                                 := -90.0;
   A_Predefined_Last_Pass_East                       := -90.0;
   A_Pressure_Altitude                               := 1000.0;
   A_Standard_Day_Ambient_Temperature_at_Altitude    := 1000.0;
   An_Aircraft_Ambient_Temperature                   := 1000.0;
   A_Predefined_Geometric_Altitude                   := 1000.0;
   A_Predefined_Last_Pass_Geometric_Altitude         := 1000.0;
   A_Terrain_Height                                  := 1000.0;
   A_Predefined_Height_Above_Local_Terrain           := 1000.0;
   A_Predefined_Last_Pass_Height_Above_Local_Terrain := 1000.0;


   Location.Assign_North (A_Predefined_North           ,
                          A_Predefined_Last_Pass_North ,
                          An_Instance                 );

   Location.Assign_East (A_Predefined_East           ,
                         A_Predefined_Last_Pass_East ,
                         An_Instance                );
   Location.Assign_Geometric_Altitude (A_Predefined_Geometric_Altitude          ,
                                       A_Predefined_Last_Pass_Geometric_Altitude,
                                       An_Instance                              );

   --   Put(Location.Get_North(An_Instance));                 Put_Line(" Get_North ");
   --   Put(Location.Get_Last_Pass_North(An_Instance));       Put_Line(" Get_Last_Pass_North ");
   --   Put(Location.Get_East(An_Instance));                  Put_Line(" Get_East ");
   --   Put(Location.Get_Last_Pass_East(An_Instance));        Put_Line(" Get_Last_Pass_East ");
   --   Put(Location.Get_Geometric_Altitude(An_Instance));    Put_Line(" Get_Geometric_Altitude ");
   --   Put(Location.Get_Last_Pass_Geometric_Altitude(An_Instance));    Put_Line(" Get_Last_Pass_Geometric_Altitude ");

   Location.Set_North(A_x_Velocity_Earth_Axis          ,
                      A_Last_Pass_x_Velocity_Earth_Axis,
                      An_Integration_Constant          ,
                      An_Instance                      );
   Location.Set_East(A_y_Velocity_Earth_Axis          ,
                     A_Last_Pass_y_Velocity_Earth_Axis,
                     An_Integration_Constant          ,
                     An_Instance                      );

   Location.Set_Geometric_Altitude(A_z_Velocity_Earth_Axis          ,
                                   A_Last_Pass_z_Velocity_Earth_Axis,
                                   An_Integration_Constant          ,
                                   An_Instance                      );

   Put(Location.Get_North(An_Instance));                 Put_Line(" Get_North ");
   --Put(Location.Get_Last_Pass_North(An_Instance));       Put_Line(" Get_Last_Pass_North ");
   Put(Location.Get_East(An_Instance));                  Put_Line(" Get_East ");
   --Put(Location.Get_Last_Pass_East(An_Instance));        Put_Line(" Get_Last_Pass_East ");
   Put(Location.Get_Geometric_Altitude(An_Instance));    Put_Line(" Get_Geometric_Altitude ");
   --Put(Location.Get_Last_Pass_Geometric_Altitude(An_Instance));    Put_Line(" Get_Last_Pass_Geometric_Altitude ");

   Pass := abs(Location.Get_North(An_Instance) ) >= 0.0 and
     abs(Location.Get_East(An_Instance) ) >= 0.0  and
     abs(Location.Get_Geometric_Altitude(An_Instance) ) >= 0.0 ;

   Class_Test_Result_File.Report_Case_Status(Pass);

   Pass := False;

   Location.Set_Slew_North(A_Slew         ,
                           A_Slew_Heading,
                           An_Instance   );

   Location.Set_Slew_East(A_Slew         ,
                          A_Slew_Heading,
                          An_Instance   );
   Location.Set_Geometric_Altitude_from_Pressure_Altitude
     (A_Pressure_Altitude                           ,
      A_Standard_Day_Ambient_Temperature_at_Altitude,
      An_Aircraft_Ambient_Temperature               ,
      An_Instance                                   );

   Put(Location.Get_North(An_Instance));                 Put_Line(" Get_North ");
   --  Put(Location.Get_Last_Pass_North(An_Instance));       Put_Line(" Get_Last_Pass_North ");
   Put(Location.Get_East(An_Instance));                  Put_Line(" Get_East ");
   --   Put(Location.Get_Last_Pass_East(An_Instance));        Put_Line(" Get_Last_Pass_East ");
   Put(Location.Get_Geometric_Altitude(An_Instance));    Put_Line(" Get_Geometric_Altitude ");
   --   Put(Location.Get_Last_Pass_Geometric_Altitude(An_Instance));    Put_Line(" Get_Last_Pass_Geometric_Altitude ");
   --   Put(Location.Get_Height_Above_Local_Terrain(An_Instance));      Put_Line(" Get_Height_Above_Local_Terrain ");
   --   Put(Location.Get_Last_Pass_Height_Above_Local_Terrain(An_Instance));
   Put_Line(" Get_Last_Pass_Height_Above_Local_Terrain ");

   Pass := abs(Location.Get_North(An_Instance)) >= 0.0  and
     abs(Location.Get_East(An_Instance) ) >= 0.0  and
     abs(Location.Get_Geometric_Altitude(An_Instance) ) >= 0.0 ;

   Class_Test_Result_File.Report_Case_Status(Pass);

   Pass := False;

   Location.Set_Slew_Geometric_Altitude(A_Slew     ,
                                        An_Instance);
   --Location.Set_Geometric_Altitude_for_Jack_Release(An_Integration_Constant,
   --                                                 An_Instance            );

   Location.Set_Height_Above_Local_Terrain (A_Terrain_Height    ,
                                            An_Instance         );
   --Location.Assign_Height_Above_Local_Terrain
   --                          (A_Predefined_Height_Above_Local_Terrain          ,
   --                           A_Predefined_Last_Pass_Height_Above_Local_Terrain,
   --                           An_Instance                                      );


   --  Put(Location.Get_North(An_Instance));                 Put_Line(" Get_North ");
   --  Put(Location.Get_Last_Pass_North(An_Instance));       Put_Line(" Get_Last_Pass_North ");
   --  Put(Location.Get_East(An_Instance));                  Put_Line(" Get_East ");
   --  Put(Location.Get_Last_Pass_East(An_Instance));        Put_Line(" Get_Last_Pass_East ");
   Put(Location.Get_Geometric_Altitude(An_Instance));    Put_Line(" Get_Geometric_Altitude ");
   --  Put(Location.Get_Last_Pass_Geometric_Altitude(An_Instance));    Put_Line(" Get_Last_Pass_Geometric_Altitude ");
   Put(Location.Get_Height_Above_Local_Terrain(An_Instance));      Put_Line(" Get_Height_Above_Local_Terrain ");
   --  Put(Location.Get_Last_Pass_Height_Above_Local_Terrain(An_Instance));
   --  Put_Line(" Get_Last_Pass_Height_Above_Local_Terrain ");


   Pass := abs(Location.Get_Height_Above_Local_Terrain(An_Instance) ) >= 0.0  and
     abs(Location.Get_Geometric_Altitude(An_Instance) ) >= 0.0 ;

   Class_Test_Result_File.Report_Case_Status(Pass);

   Pass := False;


   put_line(" -------------------- END ----------------------------");


   A_x_Velocity_Earth_Axis                           := 0.0;
   A_y_Velocity_Earth_Axis                           := 0.0;
   A_z_Velocity_Earth_Axis                           := 0.0;
   A_Last_Pass_x_Velocity_Earth_Axis                 := 0.0;
   A_Last_Pass_y_Velocity_Earth_Axis                 := 0.0;
   A_Last_Pass_z_Velocity_Earth_Axis                 := 0.0;
   An_Integration_Constant                           := 1.0/60.0;
   A_Slew                                            := 0.0;
   A_Slew_Heading                                    := 0.0;
   A_Predefined_North                                := 90.0;
   A_Predefined_Last_Pass_North                      := 90.0;
   A_Predefined_East                                 := -90.0;
   A_Predefined_Last_Pass_East                       := -90.0;
   A_Pressure_Altitude                               := 0.0;
   A_Standard_Day_Ambient_Temperature_at_Altitude    := 0.0;
   An_Aircraft_Ambient_Temperature                   := 0.0;
   A_Predefined_Geometric_Altitude                   := 0.0;
   A_Predefined_Last_Pass_Geometric_Altitude         := 0.0;
   A_Terrain_Height                                  := 0.0;
   A_Predefined_Height_Above_Local_Terrain           := 0.0;
   A_Predefined_Last_Pass_Height_Above_Local_Terrain := 0.0;


   Location.Assign_North (A_Predefined_North           ,
                          A_Predefined_Last_Pass_North ,
                          An_Instance                 );

   Location.Assign_East (A_Predefined_East           ,
                         A_Predefined_Last_Pass_East ,
                         An_Instance                );
   Location.Assign_Geometric_Altitude (A_Predefined_Geometric_Altitude          ,
                                       A_Predefined_Last_Pass_Geometric_Altitude,
                                       An_Instance                              );

   --   Put(Location.Get_North(An_Instance));                 Put_Line(" Get_North ");
   --   Put(Location.Get_Last_Pass_North(An_Instance));       Put_Line(" Get_Last_Pass_North ");
   --   Put(Location.Get_East(An_Instance));                  Put_Line(" Get_East ");
   --   Put(Location.Get_Last_Pass_East(An_Instance));        Put_Line(" Get_Last_Pass_East ");
   --   Put(Location.Get_Geometric_Altitude(An_Instance));    Put_Line(" Get_Geometric_Altitude ");
   --   Put(Location.Get_Last_Pass_Geometric_Altitude(An_Instance));    Put_Line(" Get_Last_Pass_Geometric_Altitude ");

   Location.Set_North(A_x_Velocity_Earth_Axis          ,
                      A_Last_Pass_x_Velocity_Earth_Axis,
                      An_Integration_Constant          ,
                      An_Instance                      );
   Location.Set_East(A_y_Velocity_Earth_Axis          ,
                     A_Last_Pass_y_Velocity_Earth_Axis,
                     An_Integration_Constant          ,
                     An_Instance                      );

   Location.Set_Geometric_Altitude(A_z_Velocity_Earth_Axis          ,
                                   A_Last_Pass_z_Velocity_Earth_Axis,
                                   An_Integration_Constant          ,
                                   An_Instance                      );

   Put(Location.Get_North(An_Instance));                 Put_Line(" Get_North ");
   --Put(Location.Get_Last_Pass_North(An_Instance));       Put_Line(" Get_Last_Pass_North ");
   Put(Location.Get_East(An_Instance));                  Put_Line(" Get_East ");
   --Put(Location.Get_Last_Pass_East(An_Instance));        Put_Line(" Get_Last_Pass_East ");
   Put(Location.Get_Geometric_Altitude(An_Instance));    Put_Line(" Get_Geometric_Altitude ");
   --Put(Location.Get_Last_Pass_Geometric_Altitude(An_Instance));    Put_Line(" Get_Last_Pass_Geometric_Altitude ");

   Pass := abs(Location.Get_North(An_Instance) ) >= 0.0 and
     abs(Location.Get_East(An_Instance) ) >= 0.0  and
     abs(Location.Get_Geometric_Altitude(An_Instance) ) >= 0.0 ;

   Class_Test_Result_File.Report_Case_Status(Pass);

   Pass := False;

   Location.Set_Slew_North(A_Slew         ,
                           A_Slew_Heading,
                           An_Instance   );

   Location.Set_Slew_East(A_Slew         ,
                          A_Slew_Heading,
                          An_Instance   );
   Location.Set_Geometric_Altitude_from_Pressure_Altitude
     (A_Pressure_Altitude                           ,
      A_Standard_Day_Ambient_Temperature_at_Altitude,
      An_Aircraft_Ambient_Temperature               ,
      An_Instance                                   );

   Put(Location.Get_North(An_Instance));                 Put_Line(" Get_North ");
   --  Put(Location.Get_Last_Pass_North(An_Instance));       Put_Line(" Get_Last_Pass_North ");
   Put(Location.Get_East(An_Instance));                  Put_Line(" Get_East ");
   --   Put(Location.Get_Last_Pass_East(An_Instance));        Put_Line(" Get_Last_Pass_East ");
   Put(Location.Get_Geometric_Altitude(An_Instance));    Put_Line(" Get_Geometric_Altitude ");
   --   Put(Location.Get_Last_Pass_Geometric_Altitude(An_Instance));    Put_Line(" Get_Last_Pass_Geometric_Altitude ");
   --   Put(Location.Get_Height_Above_Local_Terrain(An_Instance));      Put_Line(" Get_Height_Above_Local_Terrain ");
   --   Put(Location.Get_Last_Pass_Height_Above_Local_Terrain(An_Instance));
   Put_Line(" Get_Last_Pass_Height_Above_Local_Terrain ");

   Pass := abs(Location.Get_North(An_Instance)) >= 0.0  and
     abs(Location.Get_East(An_Instance) ) >= 0.0  and
     abs(Location.Get_Geometric_Altitude(An_Instance) ) >= 0.0 ;

   Class_Test_Result_File.Report_Case_Status(Pass);

   Pass := False;

   Location.Set_Slew_Geometric_Altitude(A_Slew     ,
                                        An_Instance);
   --Location.Set_Geometric_Altitude_for_Jack_Release(An_Integration_Constant,
   --                                                 An_Instance            );

   Location.Set_Height_Above_Local_Terrain (A_Terrain_Height    ,
                                            An_Instance         );
   --Location.Assign_Height_Above_Local_Terrain
   --                          (A_Predefined_Height_Above_Local_Terrain          ,
   --                           A_Predefined_Last_Pass_Height_Above_Local_Terrain,
   --                           An_Instance                                      );


   --  Put(Location.Get_North(An_Instance));                 Put_Line(" Get_North ");
   --  Put(Location.Get_Last_Pass_North(An_Instance));       Put_Line(" Get_Last_Pass_North ");
   --  Put(Location.Get_East(An_Instance));                  Put_Line(" Get_East ");
   --  Put(Location.Get_Last_Pass_East(An_Instance));        Put_Line(" Get_Last_Pass_East ");
   Put(Location.Get_Geometric_Altitude(An_Instance));    Put_Line(" Get_Geometric_Altitude ");
   --  Put(Location.Get_Last_Pass_Geometric_Altitude(An_Instance));    Put_Line(" Get_Last_Pass_Geometric_Altitude ");
   Put(Location.Get_Height_Above_Local_Terrain(An_Instance));      Put_Line(" Get_Height_Above_Local_Terrain ");
   --  Put(Location.Get_Last_Pass_Height_Above_Local_Terrain(An_Instance));
   --  Put_Line(" Get_Last_Pass_Height_Above_Local_Terrain ");


   Pass := abs(Location.Get_Height_Above_Local_Terrain(An_Instance) ) >= 0.0  and
     abs(Location.Get_Geometric_Altitude(An_Instance) ) >= 0.0 ;

   Class_Test_Result_File.Report_Case_Status(Pass);

   Pass := False;




end EXECUTE_location;
