-------------------------------------------------------------------------------
--|
--|            FlightSafety International Simulation Systems Division
--|                     Broken Arrow, OK  USA  918-259-4000
--|
--|                  JPATS T-6A Texan-II Flight Training Device
--|
--|
--|   Engineer:  Yogesh Tupe
--|
--|   Revision:  (Number and date inserted by Clearcase)
--|
--|
--|  DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
--|  Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
--|  technical or operational data or information from automatic dissemination
--|  under the International Exchange Program or by other means.  This protection
--|  covers information required solely for administrative or operational
--|  purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--|
--|  WARNING:  This document contains technical data whose export is restricted
--|  by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
--|  Executive Order 12470.  Violation of these export control laws is subject
--|  to severe criminal penalties.  Dissemination of this document is controlled
--|  under DOD Directive 5230.25
--|
-------------------------------------------------------------------------------
--|

with Ada.Text_IO;                             use Ada.Text_IO;
with Ada.Float_Text_IO;                        use Ada.Float_Text_IO;
with Ada.Integer_Text_IO;                      use Ada.Integer_Text_IO;
with Ada.Long_Float_Text_IO;                   use Ada.Long_Float_Text_IO;
with Ada.Numerics;
with Ada.Numerics.Elementary_Functions;        use Ada.Numerics.Elementary_Functions;


with Load_Factor;

with Angle_Types;
with Coordinate_Types;
with Length_Types;
with Mass_Types;
with Class_Test_Result_File;

procedure EXECUTE_Load_Factor is

   A_Span_Wing        :Length_Types.Feet;
   A_Chord_Wing       :Length_Types.Feet;
   A_True_Airspeed    :Length_Types.Feet_per_Sec;
   An_Angle_of_Attack :Angle_Types.Radians;
   A_Roll_Rate        :Angle_Types.Radians_per_Sec;
   A_Pitch_Rate       :Angle_Types.Radians_per_Sec;
   A_Yaw_Rate         :Angle_Types.Radians_per_Sec;
   A_Predefined_Nondimensional_Angular_Rate :Coordinate_Types.Attitude;



   An_Instance_LF                : Load_Factor.Instance;

   A_Force                   :Coordinate_Types.Cartesian;
   A_Gross_Weight            :Mass_Types.Lbm;
   An_Aircraft_Load_Factor   :Coordinate_Types.Cartesian;
   An_Attitude_Angle         :Coordinate_Types.Attitude;
   An_Angular_Acceleration   :Coordinate_Types.Attitude;
   An_Angular_Rate           :Coordinate_Types.Attitude;
   A_Predefined_Load_Factor  :Coordinate_Types.Cartesian;
   A_Reference_Coordinate_of_the_Current_Center_of_Gravity :Coordinate_Types.Reference_System;
   A_Reference_Coordinate_of_the_Flight_Test_Accelerometer :Coordinate_Types.Reference_System;
   A_Predefined_Flight_Test_Accelerometer_Arm_Length       :Coordinate_Types.Cartesian;
   Pass : Boolean := False;
   A_Tolerance : Float := 0.000_5;

begin

   A_Span_Wing        := 33.42;
   A_Chord_Wing       := 5.413;
   A_True_Airspeed    := 261.9501;
   An_Angle_of_Attack := -2.419001 * 3.142/180.0;
   A_Roll_Rate        := -0.8729095;
   A_Pitch_Rate       := -0.4511952;
   A_Yaw_Rate         := -0.2850278;


   A_Force                   := (-85.18573,321.2976,-2356.727);
   A_Gross_Weight            := 6278.0;
   An_Attitude_Angle         := (-0.1575623,-0.05042598,-2.52386);
   An_Angular_Acceleration   := (-1.752373,-0.6995133,-0.90258);
   An_Angular_Rate           := (-0.8209217,-0.4328175,-0.2562039);


   A_Predefined_Flight_Test_Accelerometer_Arm_Length       := (0.1941668,-0.5608333,0.7775002);

   Load_Factor.Assign_Flight_Test_Accelerometer_Arm_Length
     (A_Predefined_Flight_Test_Accelerometer_Arm_Length,
      An_Instance_LF                                      );

   --    Put(Load_Factor.Get_Flight_Test_Accelerometer_Arm_Length(An_Instance_LF).x);
   --    Put(Load_Factor.Get_Flight_Test_Accelerometer_Arm_Length(An_Instance_LF).y);
   --    Put(Load_Factor.Get_Flight_Test_Accelerometer_Arm_Length(An_Instance_LF).z);
   --    Put_Line(" Flight_Test_Accelerometer_Arm_Length ");


   Load_Factor.Set_Load_Factor (A_Force       ,
                                A_Gross_Weight,
                                An_Instance_LF);

   Put(Load_Factor.Get_Load_Factor(An_Instance_LF).x);
   Put(Load_Factor.Get_Load_Factor(An_Instance_LF).y);
   Put(Load_Factor.Get_Load_Factor(An_Instance_LF).z);
   Put_Line(" Load_Factor ");

   Pass := abs(Load_Factor.Get_Load_Factor(An_Instance_LF).x - (-0.01356893)) <= A_Tolerance and
     abs(Load_Factor.Get_Load_Factor(An_Instance_LF).y - (0.05117833)) <= A_Tolerance and
     abs(Load_Factor.Get_Load_Factor(An_Instance_LF).z - (0.3753945)) <= A_Tolerance;

   Class_Test_Result_File.Report_Case_Status(Pass);
   Pass := False;


   An_Aircraft_Load_Factor:=Load_Factor.Get_Load_Factor(An_Instance_LF);
   An_Attitude_Angle         := (0.0,0.02820,0.0);
   --
   Load_Factor.Set_Flight_Test_Load_Factor
     (An_Aircraft_Load_Factor,
      An_Attitude_Angle      ,
      An_Angular_Acceleration,
      An_Angular_Rate        ,
      An_Instance_LF         );

   Put(Load_Factor.Get_Load_Factor(An_Instance_LF).x);
   Put(Load_Factor.Get_Load_Factor(An_Instance_LF).y);
   Put(Load_Factor.Get_Load_Factor(An_Instance_LF).z);
   Put_Line(" Load_Factor ");

   Pass := abs(Load_Factor.Get_Load_Factor(An_Instance_LF).x - (-0.05892682)) <= A_Tolerance and
     abs(Load_Factor.Get_Load_Factor(An_Instance_LF).y - (0.1057936)) <= A_Tolerance and
     abs(Load_Factor.Get_Load_Factor(An_Instance_LF).z - (0.362103)) <= A_Tolerance;

   Class_Test_Result_File.Report_Case_Status(Pass);
   Pass := False;

   A_Reference_Coordinate_of_the_Current_Center_of_Gravity := (0.43/12.0,165.33/12.0,89.33/12.0);
   A_Reference_Coordinate_of_the_Flight_Test_Accelerometer := (0.525,13.5833,6.667);

   Load_Factor.Set_Flight_Test_Accelerometer_Arm_Length
     (A_Reference_Coordinate_of_the_Current_Center_of_Gravity,
      A_Reference_Coordinate_of_the_Flight_Test_Accelerometer,
      An_Instance_LF                                            );

   Put(Load_Factor.Get_Flight_Test_Accelerometer_Arm_Length(An_Instance_LF).x);
   Put(Load_Factor.Get_Flight_Test_Accelerometer_Arm_Length(An_Instance_LF).y);
   Put(Load_Factor.Get_Flight_Test_Accelerometer_Arm_Length(An_Instance_LF).z);
   Put_Line(" Flight_Test_Accelerometer_Arm_Length ");

   Pass := abs(Load_Factor.Get_Flight_Test_Accelerometer_Arm_Length(An_Instance_LF).x - (0.1941668)) <= A_Tolerance and
     abs(Load_Factor.Get_Flight_Test_Accelerometer_Arm_Length(An_Instance_LF).y - (-0.56083)) <= A_Tolerance and
     abs(Load_Factor.Get_Flight_Test_Accelerometer_Arm_Length(An_Instance_LF).z - (0.7775002)) <= A_Tolerance;

   Class_Test_Result_File.Report_Case_Status(Pass);
   Pass := False;


   put_line(" --------------------------- CONSTRAINT ------------------------------");

   A_Force                   := (1000.0,1000.0,1000.0);
   A_Gross_Weight            := 10000.0;
   An_Attitude_Angle         := (1000.0,1000.0,1000.0);
   An_Angular_Acceleration   := (1000.0,1000.0,1000.0);
   An_Angular_Rate           := (1000.0,1000.0,1000.0);


   A_Predefined_Flight_Test_Accelerometer_Arm_Length       := (1000.0,1000.0,1000.0);

   Load_Factor.Assign_Flight_Test_Accelerometer_Arm_Length
     (A_Predefined_Flight_Test_Accelerometer_Arm_Length,
      An_Instance_LF                                      );

   --    Put(Load_Factor.Get_Flight_Test_Accelerometer_Arm_Length(An_Instance_LF).x);
   --    Put(Load_Factor.Get_Flight_Test_Accelerometer_Arm_Length(An_Instance_LF).y);
   --    Put(Load_Factor.Get_Flight_Test_Accelerometer_Arm_Length(An_Instance_LF).z);
   --    Put_Line(" Flight_Test_Accelerometer_Arm_Length ");


   Load_Factor.Set_Load_Factor (A_Force       ,
                                A_Gross_Weight,
                                An_Instance_LF);

   Put(Load_Factor.Get_Load_Factor(An_Instance_LF).x);
   Put(Load_Factor.Get_Load_Factor(An_Instance_LF).y);
   Put(Load_Factor.Get_Load_Factor(An_Instance_LF).z);
   Put_Line(" Load_Factor ");

   Pass := abs(Load_Factor.Get_Load_Factor(An_Instance_LF).x) >= 0.0 and
     abs(Load_Factor.Get_Load_Factor(An_Instance_LF).y) >= 0.0  and
     abs(Load_Factor.Get_Load_Factor(An_Instance_LF).z) >= 0.0 ;

   Class_Test_Result_File.Report_Case_Status(Pass);
   Pass := False;


   An_Aircraft_Load_Factor:=Load_Factor.Get_Load_Factor(An_Instance_LF);
   An_Attitude_Angle         := (1000.0,1000.0,1000.0);
   --
   Load_Factor.Set_Flight_Test_Load_Factor
     (An_Aircraft_Load_Factor,
      An_Attitude_Angle      ,
      An_Angular_Acceleration,
      An_Angular_Rate        ,
      An_Instance_LF         );

   Put(Load_Factor.Get_Load_Factor(An_Instance_LF).x);
   Put(Load_Factor.Get_Load_Factor(An_Instance_LF).y);
   Put(Load_Factor.Get_Load_Factor(An_Instance_LF).z);
   Put_Line(" Load_Factor ");

   Pass := abs(Load_Factor.Get_Load_Factor(An_Instance_LF).x) >= 0.0  and
     abs(Load_Factor.Get_Load_Factor(An_Instance_LF).y) >= 0.0  and
     abs(Load_Factor.Get_Load_Factor(An_Instance_LF).z) >= 0.0 ;

   Class_Test_Result_File.Report_Case_Status(Pass);
   Pass := False;

   A_Reference_Coordinate_of_the_Current_Center_of_Gravity := (1000.0,1000.0,1000.0);
   A_Reference_Coordinate_of_the_Flight_Test_Accelerometer := (1000.0,1000.0,1000.0);

   Load_Factor.Set_Flight_Test_Accelerometer_Arm_Length
     (A_Reference_Coordinate_of_the_Current_Center_of_Gravity,
      A_Reference_Coordinate_of_the_Flight_Test_Accelerometer,
      An_Instance_LF                                            );

   Put(Load_Factor.Get_Flight_Test_Accelerometer_Arm_Length(An_Instance_LF).x);
   Put(Load_Factor.Get_Flight_Test_Accelerometer_Arm_Length(An_Instance_LF).y);
   Put(Load_Factor.Get_Flight_Test_Accelerometer_Arm_Length(An_Instance_LF).z);
   Put_Line(" Flight_Test_Accelerometer_Arm_Length ");

   Pass := abs(Load_Factor.Get_Flight_Test_Accelerometer_Arm_Length(An_Instance_LF).x) >= 0.0  and
     abs(Load_Factor.Get_Flight_Test_Accelerometer_Arm_Length(An_Instance_LF).y) >= 0.0  and
     abs(Load_Factor.Get_Flight_Test_Accelerometer_Arm_Length(An_Instance_LF).z) >= 0.0 ;

   Class_Test_Result_File.Report_Case_Status(Pass);
   Pass := False;

   put_line("----------------- END CONTSTRAINT ----------------------");

   A_Force                   := (0.0,0.0,0.0);
   A_Gross_Weight            := 0.0;
   An_Attitude_Angle         := (0.0,0.0,0.0);
   An_Angular_Acceleration   := (0.0,0.0,0.0);
   An_Angular_Rate           := (0.0,0.0,0.0);


   A_Predefined_Flight_Test_Accelerometer_Arm_Length       := (0.0,0.0,0.0);

   Load_Factor.Assign_Flight_Test_Accelerometer_Arm_Length
     (A_Predefined_Flight_Test_Accelerometer_Arm_Length,
      An_Instance_LF                                      );

   --    Put(Load_Factor.Get_Flight_Test_Accelerometer_Arm_Length(An_Instance_LF).x);
   --    Put(Load_Factor.Get_Flight_Test_Accelerometer_Arm_Length(An_Instance_LF).y);
   --    Put(Load_Factor.Get_Flight_Test_Accelerometer_Arm_Length(An_Instance_LF).z);
   --    Put_Line(" Flight_Test_Accelerometer_Arm_Length ");


   Load_Factor.Set_Load_Factor (A_Force       ,
                                A_Gross_Weight,
                                An_Instance_LF);

   Put(Load_Factor.Get_Load_Factor(An_Instance_LF).x);
   Put(Load_Factor.Get_Load_Factor(An_Instance_LF).y);
   Put(Load_Factor.Get_Load_Factor(An_Instance_LF).z);
   Put_Line(" Load_Factor ");

   Pass := abs(Load_Factor.Get_Load_Factor(An_Instance_LF).x) >= 0.0 and
     abs(Load_Factor.Get_Load_Factor(An_Instance_LF).y) >= 0.0  and
     abs(Load_Factor.Get_Load_Factor(An_Instance_LF).z) >= 0.0 ;

   Class_Test_Result_File.Report_Case_Status(Pass);
   Pass := False;


   An_Aircraft_Load_Factor:=Load_Factor.Get_Load_Factor(An_Instance_LF);
   An_Attitude_Angle         := (0.0,0.0,0.0);
   --
   Load_Factor.Set_Flight_Test_Load_Factor
     (An_Aircraft_Load_Factor,
      An_Attitude_Angle      ,
      An_Angular_Acceleration,
      An_Angular_Rate        ,
      An_Instance_LF         );

   Put(Load_Factor.Get_Load_Factor(An_Instance_LF).x);
   Put(Load_Factor.Get_Load_Factor(An_Instance_LF).y);
   Put(Load_Factor.Get_Load_Factor(An_Instance_LF).z);
   Put_Line(" Load_Factor ");

   Pass := abs(Load_Factor.Get_Load_Factor(An_Instance_LF).x) >= 0.0  and
     abs(Load_Factor.Get_Load_Factor(An_Instance_LF).y) >= 0.0  and
     abs(Load_Factor.Get_Load_Factor(An_Instance_LF).z) >= 0.0 ;

   Class_Test_Result_File.Report_Case_Status(Pass);
   Pass := False;

   A_Reference_Coordinate_of_the_Current_Center_of_Gravity := (0.0,0.0,0.0);
   A_Reference_Coordinate_of_the_Flight_Test_Accelerometer := (0.0,0.0,0.0);

   Load_Factor.Set_Flight_Test_Accelerometer_Arm_Length
     (A_Reference_Coordinate_of_the_Current_Center_of_Gravity,
      A_Reference_Coordinate_of_the_Flight_Test_Accelerometer,
      An_Instance_LF                                            );

   Put(Load_Factor.Get_Flight_Test_Accelerometer_Arm_Length(An_Instance_LF).x);
   Put(Load_Factor.Get_Flight_Test_Accelerometer_Arm_Length(An_Instance_LF).y);
   Put(Load_Factor.Get_Flight_Test_Accelerometer_Arm_Length(An_Instance_LF).z);
   Put_Line(" Flight_Test_Accelerometer_Arm_Length ");

   Pass := abs(Load_Factor.Get_Flight_Test_Accelerometer_Arm_Length(An_Instance_LF).x) >= 0.0  and
     abs(Load_Factor.Get_Flight_Test_Accelerometer_Arm_Length(An_Instance_LF).y) >= 0.0  and
     abs(Load_Factor.Get_Flight_Test_Accelerometer_Arm_Length(An_Instance_LF).z) >= 0.0 ;

   Class_Test_Result_File.Report_Case_Status(Pass);
   Pass := False;


end EXECUTE_Load_Factor;
