-------------------------------------------------------------------------------
--|
--|            FlightSafety International Simulation Systems Division
--|                     Broken Arrow, OK  USA  918-259-4000
--|
--|                  JPATS T-6A Texan-II Flight Training Device
--|
--|
--|   Engineer:  Yogesh Tupe
--|
--|   Revision:  (Number and date inserted by Clearcase)
--|
--|
--|  DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
--|  Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
--|  technical or operational data or information from automatic dissemination
--|  under the International Exchange Program or by other means.  This protection
--|  covers information required solely for administrative or operational
--|  purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--|
--|  WARNING:  This document contains technical data whose export is restricted
--|  by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
--|  Executive Order 12470.  Violation of these export control laws is subject
--|  to severe criminal penalties.  Dissemination of this document is controlled
--|  under DOD Directive 5230.25
--|
-------------------------------------------------------------------------------
--|

with Ada.Text_IO;                              use Ada.Text_IO;
with Ada.Float_Text_IO;                        use Ada.Float_Text_IO;
with Ada.Integer_Text_IO;                      use Ada.Integer_Text_IO;
with Ada.Long_Float_Text_IO;                   use Ada.Long_Float_Text_IO;

with Ada.Numerics.Elementary_Functions;             use Ada.Numerics.Elementary_Functions;

with Class_Test_Result_File;
with Formation;


procedure EXECUTE_Form is

   An_Integration_Constant : Float := 1.0/60.0;

   A_State_A              :Float;
   A_State_B              :Float;
   A_State_Q              :Float;
   A_Desired_Attribute    :Float;
   A_Predefined_Attribute :Float;
   A_Predefined_Gain      :Float;

   An_Instance : Formation.Instance;

   Pass : Boolean := False;
   A_Tolerance : Float := 0.000_1;

begin


   A_Predefined_Gain := 0.15;
   Formation.Assign_Gain(A_Predefined_Gain,
                         An_Instance      );

   A_Predefined_Attribute := 21.9;
   Formation.Assign_Attribute(A_Predefined_Attribute,
                              An_Instance           );

   A_State_A              := 1.87;
   A_State_B              := 0.76;
   A_State_Q              := 0.435;
   A_Desired_Attribute    := 24.7;

   Formation.Set_Attribute(A_State_A               ,
                           A_State_B               ,
                           A_State_Q               ,
                           A_Desired_Attribute     ,
                           An_Integration_Constant ,
                           An_Instance             );


   put(Formation.Get_Attribute(An_Instance)); put_line(" attribute ");

   Pass := abs(Formation.Get_Attribute(An_Instance) - 22.00612887) <= A_Tolerance;

   Class_Test_Result_File.Report_Case_Status(Pass);
   Pass := False;

   put_line(" ---------------------- CONSTRAINT ------------------");

   A_Predefined_Gain := 1000.0;
   Formation.Assign_Gain(A_Predefined_Gain,
                         An_Instance      );

   A_Predefined_Attribute := 1000.0;
   Formation.Assign_Attribute(A_Predefined_Attribute,
                              An_Instance           );

   A_State_A              := 1000.0;
   A_State_B              := 1000.0;
   A_State_Q              := 1000.0;
   A_Desired_Attribute    := 1000.0;

   Formation.Set_Attribute(A_State_A               ,
                           A_State_B               ,
                           A_State_Q               ,
                           A_Desired_Attribute     ,
                           An_Integration_Constant ,
                           An_Instance             );


   put(Formation.Get_Attribute(An_Instance)); put_line(" attribute ");

   Pass := abs(Formation.Get_Attribute(An_Instance)) >= 0.0;

   Class_Test_Result_File.Report_Case_Status(Pass);
   Pass := False;

   put_line(" ---------------------- END ------------------");

   A_Predefined_Gain := 0.0;
   Formation.Assign_Gain(A_Predefined_Gain,
                         An_Instance      );

   A_Predefined_Attribute := 0.0;
   Formation.Assign_Attribute(A_Predefined_Attribute,
                              An_Instance           );

   A_State_A              := 0.0;
   A_State_B              := 0.0;
   A_State_Q              := 0.0;
   A_Desired_Attribute    := 0.0;

   Formation.Set_Attribute(A_State_A               ,
                           A_State_B               ,
                           A_State_Q               ,
                           A_Desired_Attribute     ,
                           An_Integration_Constant ,
                           An_Instance             );


   put(Formation.Get_Attribute(An_Instance)); put_line(" attribute ");

   Pass := abs(Formation.Get_Attribute(An_Instance)) >= 0.0;

   Class_Test_Result_File.Report_Case_Status(Pass);
   Pass := False;

end EXECUTE_Form;

