-------------------------------------------------------------------------------
--|
--|            FlightSafety International Simulation Systems Division
--|                     Broken Arrow, OK  USA  918-259-4000
--|
--|                  JPATS T-6A Texan-II Flight Training Device
--|
--|
--|   Engineer:  Yogesh Tupe
--|
--|   Revision:  (Number and date inserted by Clearcase)
--|
--|
--|  DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
--|  Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
--|  technical or operational data or information from automatic dissemination
--|  under the International Exchange Program or by other means.  This protection
--|  covers information required solely for administrative or operational
--|  purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--|
--|  WARNING:  This document contains technical data whose export is restricted
--|  by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
--|  Executive Order 12470.  Violation of these export control laws is subject
--|  to severe criminal penalties.  Dissemination of this document is controlled
--|  under DOD Directive 5230.25
--|
-------------------------------------------------------------------------------
--|

with Ada.Text_IO;                              use Ada.Text_IO;
with Ada.Float_Text_IO;                        use Ada.Float_Text_IO;
with Ada.Integer_Text_IO;                      use Ada.Integer_Text_IO;
with Ada.Long_Float_Text_IO;                   use Ada.Long_Float_Text_IO;
with Ada.Numerics;
with Ada.Numerics.Elementary_Functions;        use Ada.Numerics.Elementary_Functions;


with Dynamic_Pressure;
with Length_Types;
with Mass_Types;
with Class_Test_Result_File;



procedure EXECUTE_Dynamic_Pressure is
   An_Instance : Dynamic_Pressure.Instance;


   An_Air_Density  :Mass_Types.Slugs_per_Cubic_Feet;
   A_True_Airspeed :Length_Types.Feet_per_Sec;
   Pass          : Boolean := False;
   A_Tolerance   : Float := 0.000_1;

begin
   An_Air_Density  := 0.002067745;
   A_True_Airspeed := 261.9223;
   Dynamic_Pressure.Set(An_Air_Density  ,
                        A_True_Airspeed ,
                        An_Instance     );


   Pass := abs(Dynamic_Pressure.Get(An_Instance) - 70.92708  ) <= A_Tolerance ;

   Class_Test_Result_File.Report_Case_Status(Pass);

   put(Dynamic_Pressure.Get(An_Instance));put_line(" Dynamic Pressure ");

   Pass := False;

   put_line("--------------------- CONSTRAINT -------------------------");
   An_Air_Density  := 1000.0;
   A_True_Airspeed := 1000.0;
   Dynamic_Pressure.Set(An_Air_Density  ,
                        A_True_Airspeed ,
                        An_Instance     );


   Pass := abs(Dynamic_Pressure.Get(An_Instance))>= 0.0;

   Class_Test_Result_File.Report_Case_Status(Pass);

   put(Dynamic_Pressure.Get(An_Instance));put_line(" Dynamic Pressure ");

   Pass := False;

   put_line("--------------------- END -------------------------");
   An_Air_Density  := 0.0;
   A_True_Airspeed := 0.0;
   Dynamic_Pressure.Set(An_Air_Density  ,
                        A_True_Airspeed ,
                        An_Instance     );


   Pass := abs(Dynamic_Pressure.Get(An_Instance))>= 0.0;

   Class_Test_Result_File.Report_Case_Status(Pass);

   put(Dynamic_Pressure.Get(An_Instance));put_line(" Dynamic Pressure ");

   Pass := False;



end EXECUTE_Dynamic_Pressure;
