-------------------------------------------------------------------------------
--|
--|            FlightSafety International Simulation Systems Division
--|                     Broken Arrow, OK  USA  918-259-4000
--|
--|                  JPATS T-6A Texan-II Flight Training Device
--|
--|
--|   Engineer:  Yogesh Tupe
--|
--|   Revision:  (Number and date inserted by Clearcase)
--|
--|
--|  DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
--|  Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
--|  technical or operational data or information from automatic dissemination
--|  under the International Exchange Program or by other means.  This protection
--|  covers information required solely for administrative or operational
--|  purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--|
--|  WARNING:  This document contains technical data whose export is restricted
--|  by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
--|  Executive Order 12470.  Violation of these export control laws is subject
--|  to severe criminal penalties.  Dissemination of this document is controlled
--|  under DOD Directive 5230.25
--|
-------------------------------------------------------------------------------
--|

with Ada.Text_IO;                             use Ada.Text_IO;
with Ada.Float_Text_IO;                        use Ada.Float_Text_IO;
with Ada.Integer_Text_IO;                      use Ada.Integer_Text_IO;
with Ada.Long_Float_Text_IO;                   use Ada.Long_Float_Text_IO;
with Ada.Numerics;
with Ada.Numerics.Elementary_Functions;        use Ada.Numerics.Elementary_Functions;


with Coordinate_Transformation;
with Coordinate_Types;
with Angle_Types;
with Class_Test_Result_File;

procedure EXECUTE_Coord_Trans is

   An_Input_Attribute  :Coordinate_Types.Cartesian;
   A_Roll_Angle        :Angle_Types.Radians;
   A_Pitch_Angle       :Angle_Types.Radians;
   A_Yaw_Angle         :Angle_Types.Radians;


   Pass : Boolean := False;
   A_Tolerance : Float := 0.000_5;

begin

   An_Input_Attribute  := (261.7879,3.170575,-8.033916);
   A_Roll_Angle        := -0.1575623;
   A_Pitch_Angle       := -0.05042598;
   A_Yaw_Angle         := -2.52386;

   put(Coordinate_Transformation.Body_to_Earth
       (An_Input_Attribute,
        A_Roll_Angle      ,
        A_Pitch_Angle     ,
        A_Yaw_Angle       ).x-5.134273e-7);
   put(Coordinate_Transformation.Body_to_Earth
       (An_Input_Attribute,
        A_Roll_Angle      ,
        A_Pitch_Angle     ,
        A_Yaw_Angle       ).y-42.195);
   put(Coordinate_Transformation.Body_to_Earth
       (An_Input_Attribute,
        A_Roll_Angle      ,
        A_Pitch_Angle     ,
        A_Yaw_Angle       ).z);
   put_line(" body to earth ");

   Pass := abs(Coordinate_Transformation.Body_to_Earth
               (An_Input_Attribute,
                A_Roll_Angle      ,
                A_Pitch_Angle     ,
                A_Yaw_Angle       ).x-5.134273e-7 - (-212.3997)) <= A_Tolerance and
     abs(Coordinate_Transformation.Body_to_Earth
         (An_Input_Attribute,
          A_Roll_Angle      ,
          A_Pitch_Angle     ,
          A_Yaw_Angle       ).y-42.195 - (-195.3979)) <= A_Tolerance and
     abs(Coordinate_Transformation.Body_to_Earth
         (An_Input_Attribute,
          A_Roll_Angle      ,
          A_Pitch_Angle     ,
          A_Yaw_Angle       ).z - 4.774138) <= A_Tolerance;

   Class_Test_Result_File.Report_Case_Status(Pass);
   Pass := False;


   An_Input_Attribute  := (-212.3997,-195.3978+42.195,4.774138);
   A_Roll_Angle        := -0.1575623;
   A_Pitch_Angle       := -0.05042598;
   A_Yaw_Angle         := -2.52386;

   put(Coordinate_Transformation.Earth_to_Body
       (An_Input_Attribute  ,
        A_Roll_Angle        ,
        A_Pitch_Angle       ,
        A_Yaw_Angle         ).x);
   put(Coordinate_Transformation.Earth_to_Body
       (An_Input_Attribute  ,
        A_Roll_Angle        ,
        A_Pitch_Angle       ,
        A_Yaw_Angle         ).y);
   put(Coordinate_Transformation.Earth_to_Body
       (An_Input_Attribute  ,
        A_Roll_Angle        ,
        A_Pitch_Angle       ,
        A_Yaw_Angle         ).z);
   put_line(" earth to body ");


   Pass := abs(Coordinate_Transformation.Earth_to_Body
               (An_Input_Attribute  ,
                A_Roll_Angle        ,
                A_Pitch_Angle       ,
                A_Yaw_Angle         ).x - 261.7879) <= A_Tolerance and
     abs(Coordinate_Transformation.Earth_to_Body
         (An_Input_Attribute  ,
          A_Roll_Angle        ,
          A_Pitch_Angle       ,
          A_Yaw_Angle         ).y - 3.170575) <= A_Tolerance and
     abs(Coordinate_Transformation.Earth_to_Body
         (An_Input_Attribute  ,
          A_Roll_Angle        ,
          A_Pitch_Angle       ,
          A_Yaw_Angle         ).z - (-8.033916)) <= A_Tolerance;

   Class_Test_Result_File.Report_Case_Status(Pass);
   Pass := False;

   put_line(" --------------------------- CONSTRAINT -----------------------");


   An_Input_Attribute  := (1000.0,1000.0,1000.0);
   A_Roll_Angle        := 1000.0;
   A_Pitch_Angle       := 1000.0;
   A_Yaw_Angle         := 1000.0;

   put(Coordinate_Transformation.Body_to_Earth
       (An_Input_Attribute,
        A_Roll_Angle      ,
        A_Pitch_Angle     ,
        A_Yaw_Angle       ).x-5.134273e-7);
   put(Coordinate_Transformation.Body_to_Earth
       (An_Input_Attribute,
        A_Roll_Angle      ,
        A_Pitch_Angle     ,
        A_Yaw_Angle       ).y-42.195);
   put(Coordinate_Transformation.Body_to_Earth
       (An_Input_Attribute,
        A_Roll_Angle      ,
        A_Pitch_Angle     ,
        A_Yaw_Angle       ).z);
   put_line(" body to earth ");

   Pass := abs(Coordinate_Transformation.Body_to_Earth
               (An_Input_Attribute,
                A_Roll_Angle      ,
                A_Pitch_Angle     ,
                A_Yaw_Angle       ).x) >= 0.0 and
     abs(Coordinate_Transformation.Body_to_Earth
         (An_Input_Attribute,
          A_Roll_Angle      ,
          A_Pitch_Angle     ,
          A_Yaw_Angle       ).y) >= 0.0 and
     abs(Coordinate_Transformation.Body_to_Earth
         (An_Input_Attribute,
          A_Roll_Angle      ,
          A_Pitch_Angle     ,
          A_Yaw_Angle       ).z) >= 0.0;

   Class_Test_Result_File.Report_Case_Status(Pass);
   Pass := False;


   An_Input_Attribute  := (1000.0,1000.0,1000.0);
   A_Roll_Angle        := 1000.0;
   A_Pitch_Angle       := 1000.0;
   A_Yaw_Angle         := 1000.0;

   put(Coordinate_Transformation.Earth_to_Body
       (An_Input_Attribute  ,
        A_Roll_Angle        ,
        A_Pitch_Angle       ,
        A_Yaw_Angle         ).x);
   put(Coordinate_Transformation.Earth_to_Body
       (An_Input_Attribute  ,
        A_Roll_Angle        ,
        A_Pitch_Angle       ,
        A_Yaw_Angle         ).y);
   put(Coordinate_Transformation.Earth_to_Body
       (An_Input_Attribute  ,
        A_Roll_Angle        ,
        A_Pitch_Angle       ,
        A_Yaw_Angle         ).z);
   put_line(" earth to body ");


   Pass := abs(Coordinate_Transformation.Earth_to_Body
               (An_Input_Attribute  ,
                A_Roll_Angle        ,
                A_Pitch_Angle       ,
                A_Yaw_Angle         ).x) >= 0.0 and
     abs(Coordinate_Transformation.Earth_to_Body
         (An_Input_Attribute  ,
          A_Roll_Angle        ,
          A_Pitch_Angle       ,
          A_Yaw_Angle         ).y) >= 0.0 and
     abs(Coordinate_Transformation.Earth_to_Body
         (An_Input_Attribute  ,
          A_Roll_Angle        ,
          A_Pitch_Angle       ,
          A_Yaw_Angle         ).z) >= 0.0;

   Class_Test_Result_File.Report_Case_Status(Pass);
   Pass := False;


   put_line(" --------------------------- END -----------------------");


   An_Input_Attribute  := (0.0,0.0,0.0);
   A_Roll_Angle        := 0.0;
   A_Pitch_Angle       := 0.0;
   A_Yaw_Angle         := 0.0;

   put(Coordinate_Transformation.Body_to_Earth
       (An_Input_Attribute,
        A_Roll_Angle      ,
        A_Pitch_Angle     ,
        A_Yaw_Angle       ).x-5.134273e-7);
   put(Coordinate_Transformation.Body_to_Earth
       (An_Input_Attribute,
        A_Roll_Angle      ,
        A_Pitch_Angle     ,
        A_Yaw_Angle       ).y-42.195);
   put(Coordinate_Transformation.Body_to_Earth
       (An_Input_Attribute,
        A_Roll_Angle      ,
        A_Pitch_Angle     ,
        A_Yaw_Angle       ).z);
   put_line(" body to earth ");

   Pass := abs(Coordinate_Transformation.Body_to_Earth
               (An_Input_Attribute,
                A_Roll_Angle      ,
                A_Pitch_Angle     ,
                A_Yaw_Angle       ).x) >= 0.0 and
     abs(Coordinate_Transformation.Body_to_Earth
         (An_Input_Attribute,
          A_Roll_Angle      ,
          A_Pitch_Angle     ,
          A_Yaw_Angle       ).y) >= 0.0 and
     abs(Coordinate_Transformation.Body_to_Earth
         (An_Input_Attribute,
          A_Roll_Angle      ,
          A_Pitch_Angle     ,
          A_Yaw_Angle       ).z) >= 0.0;

   Class_Test_Result_File.Report_Case_Status(Pass);
   Pass := False;


   An_Input_Attribute  := (0.0,0.0,0.0);
   A_Roll_Angle        := 0.0;
   A_Pitch_Angle       := 0.0;
   A_Yaw_Angle         := 0.0;

   put(Coordinate_Transformation.Earth_to_Body
       (An_Input_Attribute  ,
        A_Roll_Angle        ,
        A_Pitch_Angle       ,
        A_Yaw_Angle         ).x);
   put(Coordinate_Transformation.Earth_to_Body
       (An_Input_Attribute  ,
        A_Roll_Angle        ,
        A_Pitch_Angle       ,
        A_Yaw_Angle         ).y);
   put(Coordinate_Transformation.Earth_to_Body
       (An_Input_Attribute  ,
        A_Roll_Angle        ,
        A_Pitch_Angle       ,
        A_Yaw_Angle         ).z);
   put_line(" earth to body ");


   Pass := abs(Coordinate_Transformation.Earth_to_Body
               (An_Input_Attribute  ,
                A_Roll_Angle        ,
                A_Pitch_Angle       ,
                A_Yaw_Angle         ).x) >= 0.0 and
     abs(Coordinate_Transformation.Earth_to_Body
         (An_Input_Attribute  ,
          A_Roll_Angle        ,
          A_Pitch_Angle       ,
          A_Yaw_Angle         ).y) >= 0.0 and
     abs(Coordinate_Transformation.Earth_to_Body
         (An_Input_Attribute  ,
          A_Roll_Angle        ,
          A_Pitch_Angle       ,
          A_Yaw_Angle         ).z) >= 0.0;

   Class_Test_Result_File.Report_Case_Status(Pass);
   Pass := False;





end EXECUTE_Coord_Trans;
