-------------------------------------------------------------------------------
--|
--|            FlightSafety International Simulation Systems Division
--|                     Broken Arrow, OK  USA  918-259-4000
--|
--|                  JPATS T-6A Texan-II Flight Training Device
--|
--|
--|   Engineer:  Yogesh Tupe
--|
--|   Revision:  (Number and date inserted by Clearcase)
--|
--|
--|  DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
--|  Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
--|  technical or operational data or information from automatic dissemination
--|  under the International Exchange Program or by other means.  This protection
--|  covers information required solely for administrative or operational
--|  purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--|
--|  WARNING:  This document contains technical data whose export is restricted
--|  by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
--|  Executive Order 12470.  Violation of these export control laws is subject
--|  to severe criminal penalties.  Dissemination of this document is controlled
--|  under DOD Directive 5230.25
--|
-------------------------------------------------------------------------------
--|

with Ada.Text_IO;                              use Ada.Text_IO;
with Ada.Float_Text_IO;                        use Ada.Float_Text_IO;
with Ada.Integer_Text_IO;                      use Ada.Integer_Text_IO;
with Ada.Long_Float_Text_IO;                   use Ada.Long_Float_Text_IO;
with Ada.Numerics;
with Ada.Numerics.Elementary_Functions;        use Ada.Numerics.Elementary_Functions;


with Attitude_Angle;
with Length_Types;
with Angle_Types;
with Class_Test_Result_File;



procedure EXECUTE_Attitude_Angles is
   An_Instance : Attitude_Angle.Instance;

   A_L_3                    :Float ;
   A_E_1                    :Float ;
   A_E_2                    :Float ;
   A_E_3                    :Float ;
   A_E_4                    :Float ;
   A_Demanded_Rate_of_Climb :Length_Types.Feet_per_Sec;
   An_Actual_Rate_of_Climb  :Length_Types.Feet_per_Sec;
   A_True_Airspeed          :Length_Types.Feet_per_Sec;
   A_State_A                :Float;
   A_State_B                :Float;
   A_State_Q                :Float;
   A_Gain                   :Float;
   An_Integration_Constant  :Float;
   A_Predefined_Pitch_Angle :Angle_Types.Radians;
   A_N_3                    :Float;
   A_M_3                    :Float;
   A_Predefined_Roll_Angle  :Angle_Types.Radians;
   A_L_1                    :Float;
   A_L_2                    :Float;
   A_Slew                   :Angle_Types.Radians;
   A_Predefined_Yaw_Angle   :Angle_Types.Radians;

   Pass                    : Boolean := False;
   A_Tolerance             : Float := 0.000_01;

begin

   A_L_1 := -0.812691;
   A_L_2 := -0.5811247;
   A_L_3 := 0.0427479;
   A_N_3 := 0.9887084;
   A_M_3 := -0.1436255;

   Attitude_Angle.Set_Pitch(A_L_3       ,
                            An_Instance);

   Attitude_Angle.Set_Roll(A_N_3      ,
                           A_M_3      ,
                           An_Instance);

   Attitude_Angle.Set_Yaw (A_L_1      ,
                           A_L_2      ,
                           An_Instance);


   Pass := abs(Attitude_Angle.Get_Roll(An_Instance) - (-0.1442567)) <= A_Tolerance  and
     abs(Attitude_Angle.Get_Pitch(An_Instance) - (-0.04276093)) <= A_Tolerance and
     abs(Attitude_Angle.Get_Yaw(An_Instance) - (-2.520829)) <= A_Tolerance;

   Class_Test_Result_File.Report_Case_Status(Pass);

   put(Attitude_Angle.Get_Roll(An_Instance)); put(Attitude_Angle.Get_Pitch(An_Instance));
   put(Attitude_Angle.Get_Yaw(An_Instance));put_line(" Attitude Angles ");

   Pass := False;

   A_E_1 := 0.3030914;
   A_E_2 := -0.9499946;
   A_E_3 := 0.06209402;
   A_E_4 := -0.04230983;
   Attitude_Angle.Set_Pitch_from_E(A_E_1       ,
                                   A_E_2       ,
                                   A_E_3       ,
                                   A_E_4       ,
                                   An_Instance);

   Attitude_Angle.Set_Roll_from_E(A_E_1       ,
                                  A_E_2       ,
                                  A_E_3       ,
                                  A_E_4       ,
                                  An_Instance);

   Attitude_Angle.Set_Yaw_from_E(A_E_1       ,
                                 A_E_2       ,
                                 A_E_3       ,
                                 A_E_4       ,
                                 An_Instance);


   Pass := abs(Attitude_Angle.Get_Roll(An_Instance) - (-0.1442567)) <= A_Tolerance  and
     abs(Attitude_Angle.Get_Pitch(An_Instance) - (-0.04276093)) <= A_Tolerance and
     abs(Attitude_Angle.Get_Yaw(An_Instance) - (-2.520829)) <= A_Tolerance;

   Class_Test_Result_File.Report_Case_Status(Pass);

   put(Attitude_Angle.Get_Roll(An_Instance)); put(Attitude_Angle.Get_Pitch(An_Instance));
   put(Attitude_Angle.Get_Yaw(An_Instance));put_line(" Attitude Angles ");

   Pass := False;

   A_Demanded_Rate_of_Climb := 23.6;
   An_Actual_Rate_of_Climb  := 14.13;
   A_True_Airspeed          := 252.36;
   A_State_A                := 1.56;
   A_State_B                := 0.896;
   A_State_Q                := 4.258;
   A_Gain                   := 1.2;
   An_Integration_Constant  :=1.0/60.0;

   Attitude_Angle.Set_Pitch_affected_due_to_Airspeed_Change
     (A_Demanded_Rate_of_Climb,
      An_Actual_Rate_of_Climb ,
      A_True_Airspeed         ,
      A_State_A               ,
      A_State_B               ,
      A_State_Q               ,
      A_Gain                  ,
      An_Integration_Constant ,
      An_Instance             );


   Pass := abs(Attitude_Angle.Get_Pitch(An_Instance) - (-0.04132347)) <= A_Tolerance;

   Class_Test_Result_File.Report_Case_Status(Pass);

   put(Attitude_Angle.Get_Pitch(An_Instance));put_line(" Attitude Angles ");

   Pass := False;

   --| Set_Slew_Yaw method to be used when Heading Slew is commanded.
   --| For LEFT Slew assign A_Slew a NEGATIVE sign and for RIGHT Slew
   --| assign A_Slew a POSITIVE sign.   Where A_Slew is is computed
   --| in the Slew_G domain class and the +/-ve sign comes from the IOS.
   A_Slew:= 0.0136;
   Attitude_Angle.Set_Slew_Yaw (A_Slew      ,
                                An_Instance);

   Pass := abs(Attitude_Angle.Get_Yaw(An_Instance) - (-2.50723)) <= A_Tolerance;

   Class_Test_Result_File.Report_Case_Status(Pass);

   put(Attitude_Angle.Get_Yaw(An_Instance));put_line(" Attitude Angles ");

   Pass := False;

   --| Based on Pilot's handbook, a close approximation of Yaw angle.
   --| Used for Formation flying lead aircraft.
   Attitude_Angle.Set_Yaw_Approx(A_True_Airspeed        ,
                                 An_Integration_Constant,
                                 An_Instance            );

   Pass := abs(Attitude_Angle.Get_Yaw(An_Instance) - (-2.50753877)) <= A_Tolerance;

   Class_Test_Result_File.Report_Case_Status(Pass);

   put(Attitude_Angle.Get_Yaw(An_Instance));put_line(" Attitude Angles ");

   Pass := False;

   put_line("------------------- CONSTRAINT ---------------------------");

   A_L_1 := 1000.0;
   A_L_2 := 1000.0;
   A_L_3 := 1000.0;
   A_N_3 := 1000.0;
   A_M_3 := 1000.0;

   Attitude_Angle.Set_Pitch(A_L_3       ,
                            An_Instance);

   Attitude_Angle.Set_Roll(A_N_3      ,
                           A_M_3      ,
                           An_Instance);

   Attitude_Angle.Set_Yaw (A_L_1      ,
                           A_L_2      ,
                           An_Instance);


   Pass := abs(Attitude_Angle.Get_Roll(An_Instance) ) >= 0.0  and
     abs(Attitude_Angle.Get_Pitch(An_Instance)  ) >= 0.0  and
     abs(Attitude_Angle.Get_Yaw(An_Instance)  ) >= 0.0 ;

   Class_Test_Result_File.Report_Case_Status(Pass);

   put(Attitude_Angle.Get_Roll(An_Instance)); put(Attitude_Angle.Get_Pitch(An_Instance));
   put(Attitude_Angle.Get_Yaw(An_Instance));put_line(" Attitude Angles ");

   Pass := False;

   A_E_1 := 1000.0;
   A_E_2 := 1000.0;
   A_E_3 := 1000.0;
   A_E_4 := 1000.0;
   Attitude_Angle.Set_Pitch_from_E(A_E_1       ,
                                   A_E_2       ,
                                   A_E_3       ,
                                   A_E_4       ,
                                   An_Instance);

   Attitude_Angle.Set_Roll_from_E(A_E_1       ,
                                  A_E_2       ,
                                  A_E_3       ,
                                  A_E_4       ,
                                  An_Instance);

   Attitude_Angle.Set_Yaw_from_E(A_E_1       ,
                                 A_E_2       ,
                                 A_E_3       ,
                                 A_E_4       ,
                                 An_Instance);


   Pass := abs(Attitude_Angle.Get_Roll(An_Instance)  ) >= 0.0  and
     abs(Attitude_Angle.Get_Pitch(An_Instance)  ) >= 0.0  and
     abs(Attitude_Angle.Get_Yaw(An_Instance)  ) >= 0.0 ;

   Class_Test_Result_File.Report_Case_Status(Pass);

   put(Attitude_Angle.Get_Roll(An_Instance)); put(Attitude_Angle.Get_Pitch(An_Instance));
   put(Attitude_Angle.Get_Yaw(An_Instance));put_line(" Attitude Angles ");

   Pass := False;

   A_Demanded_Rate_of_Climb :=  1000.0;
   An_Actual_Rate_of_Climb  :=  1000.0;
   A_True_Airspeed          :=  1000.0;
   A_State_A                := 1000.0;
   A_State_B                :=  1000.0;
   A_State_Q                :=  1000.0;
   A_Gain                   :=  1000.0;
   An_Integration_Constant  :=1.0/60.0;

   Attitude_Angle.Set_Pitch_affected_due_to_Airspeed_Change
     (A_Demanded_Rate_of_Climb,
      An_Actual_Rate_of_Climb ,
      A_True_Airspeed         ,
      A_State_A               ,
      A_State_B               ,
      A_State_Q               ,
      A_Gain                  ,
      An_Integration_Constant ,
      An_Instance             );


   Pass := abs(Attitude_Angle.Get_Pitch(An_Instance)  ) >= 0.0 ;

   Class_Test_Result_File.Report_Case_Status(Pass);

   put(Attitude_Angle.Get_Pitch(An_Instance));put_line(" Attitude Angles ");

   Pass := False;

   --| Set_Slew_Yaw method to be used when Heading Slew is commanded.
   --| For LEFT Slew assign A_Slew a NEGATIVE sign and for RIGHT Slew
   --| assign A_Slew a POSITIVE sign.   Where A_Slew is is computed
   --| in the Slew_G domain class and the +/-ve sign comes from the IOS.
   A_Slew:=  1000.0;
   Attitude_Angle.Set_Slew_Yaw (A_Slew      ,
                                An_Instance);

   Pass := abs(Attitude_Angle.Get_Yaw(An_Instance)  ) >= 0.0 ;

   Class_Test_Result_File.Report_Case_Status(Pass);

   put(Attitude_Angle.Get_Yaw(An_Instance));put_line(" Attitude Angles ");

   Pass := False;

   --| Based on Pilot's handbook, a close approximation of Yaw angle.
   --| Used for Formation flying lead aircraft.
   Attitude_Angle.Set_Yaw_Approx(A_True_Airspeed        ,
                                 An_Integration_Constant,
                                 An_Instance            );

   Pass := abs(Attitude_Angle.Get_Yaw(An_Instance)  ) >= 0.0 ;

   Class_Test_Result_File.Report_Case_Status(Pass);

   put(Attitude_Angle.Get_Yaw(An_Instance));put_line(" Attitude Angles ");

   Pass := False;

   put_line("------------------- END ---------------------------");

   A_L_1 := 0.0;
   A_L_2 := 0.0;
   A_L_3 := 0.0;
   A_N_3 := 0.0;
   A_M_3 := 0.0;

   Attitude_Angle.Set_Pitch(A_L_3       ,
                            An_Instance);

   Attitude_Angle.Set_Roll(A_N_3      ,
                           A_M_3      ,
                           An_Instance);

   Attitude_Angle.Set_Yaw (A_L_1      ,
                           A_L_2      ,
                           An_Instance);


   Pass := abs(Attitude_Angle.Get_Roll(An_Instance) ) >= 0.0  and
     abs(Attitude_Angle.Get_Pitch(An_Instance)  ) >= 0.0  and
     abs(Attitude_Angle.Get_Yaw(An_Instance)  ) >= 0.0 ;

   Class_Test_Result_File.Report_Case_Status(Pass);

   put(Attitude_Angle.Get_Roll(An_Instance)); put(Attitude_Angle.Get_Pitch(An_Instance));
   put(Attitude_Angle.Get_Yaw(An_Instance));put_line(" Attitude Angles ");

   Pass := False;

   A_E_1 := 0.0;
   A_E_2 := 0.0;
   A_E_3 := 0.0;
   A_E_4 := 0.0;
   Attitude_Angle.Set_Pitch_from_E(A_E_1       ,
                                   A_E_2       ,
                                   A_E_3       ,
                                   A_E_4       ,
                                   An_Instance);

   Attitude_Angle.Set_Roll_from_E(A_E_1       ,
                                  A_E_2       ,
                                  A_E_3       ,
                                  A_E_4       ,
                                  An_Instance);

   Attitude_Angle.Set_Yaw_from_E(A_E_1       ,
                                 A_E_2       ,
                                 A_E_3       ,
                                 A_E_4       ,
                                 An_Instance);


   Pass := abs(Attitude_Angle.Get_Roll(An_Instance)  ) >= 0.0  and
     abs(Attitude_Angle.Get_Pitch(An_Instance)  ) >= 0.0  and
     abs(Attitude_Angle.Get_Yaw(An_Instance)  ) >= 0.0 ;

   Class_Test_Result_File.Report_Case_Status(Pass);

   put(Attitude_Angle.Get_Roll(An_Instance)); put(Attitude_Angle.Get_Pitch(An_Instance));
   put(Attitude_Angle.Get_Yaw(An_Instance));put_line(" Attitude Angles ");

   Pass := False;

   A_Demanded_Rate_of_Climb :=  0.0;
   An_Actual_Rate_of_Climb  :=  0.0;
   A_True_Airspeed          :=  0.0;
   A_State_A                := 0.0;
   A_State_B                :=  0.0;
   A_State_Q                :=  0.0;
   A_Gain                   :=  0.0;
   An_Integration_Constant  :=1.0/60.0;

   Attitude_Angle.Set_Pitch_affected_due_to_Airspeed_Change
     (A_Demanded_Rate_of_Climb,
      An_Actual_Rate_of_Climb ,
      A_True_Airspeed         ,
      A_State_A               ,
      A_State_B               ,
      A_State_Q               ,
      A_Gain                  ,
      An_Integration_Constant ,
      An_Instance             );


   Pass := abs(Attitude_Angle.Get_Pitch(An_Instance)  ) >= 0.0 ;

   Class_Test_Result_File.Report_Case_Status(Pass);

   put(Attitude_Angle.Get_Pitch(An_Instance));put_line(" Attitude Angles ");

   Pass := False;

   --| Set_Slew_Yaw method to be used when Heading Slew is commanded.
   --| For LEFT Slew assign A_Slew a NEGATIVE sign and for RIGHT Slew
   --| assign A_Slew a POSITIVE sign.   Where A_Slew is is computed
   --| in the Slew_G domain class and the +/-ve sign comes from the IOS.
   A_Slew:=  0.0;
   Attitude_Angle.Set_Slew_Yaw (A_Slew      ,
                                An_Instance);

   Pass := abs(Attitude_Angle.Get_Yaw(An_Instance)  ) >= 0.0 ;

   Class_Test_Result_File.Report_Case_Status(Pass);

   put(Attitude_Angle.Get_Yaw(An_Instance));put_line(" Attitude Angles ");

   Pass := False;

   --| Based on Pilot's handbook, a close approximation of Yaw angle.
   --| Used for Formation flying lead aircraft.
   Attitude_Angle.Set_Yaw_Approx(A_True_Airspeed        ,
                                 An_Integration_Constant,
                                 An_Instance            );

   Pass := abs(Attitude_Angle.Get_Yaw(An_Instance)  ) >= 0.0 ;

   Class_Test_Result_File.Report_Case_Status(Pass);

   put(Attitude_Angle.Get_Yaw(An_Instance));put_line(" Attitude Angles ");

   Pass := False;




end EXECUTE_Attitude_Angles;
