-------------------------------------------------------------------------------
--|
--|            FlightSafety International Simulation Systems Division
--|                     Broken Arrow, OK  USA  918-259-4000
--|
--|                  JPATS T-6A Texan-II Flight Training Device
--|
--|
--|   Engineer:  Yogesh Tupe
--|
--|   Revision:  (Number and date inserted by Clearcase)
--|
--|
--|  DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
--|  Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
--|  technical or operational data or information from automatic dissemination
--|  under the International Exchange Program or by other means.  This protection
--|  covers information required solely for administrative or operational
--|  purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--|
--|  WARNING:  This document contains technical data whose export is restricted
--|  by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
--|  Executive Order 12470.  Violation of these export control laws is subject
--|  to severe criminal penalties.  Dissemination of this document is controlled
--|  under DOD Directive 5230.25
--|
-------------------------------------------------------------------------------
--|

with Ada.Text_IO;                              use Ada.Text_IO;
with Ada.Float_Text_IO;                        use Ada.Float_Text_IO;
with Ada.Integer_Text_IO;                      use Ada.Integer_Text_IO;
with Ada.Long_Float_Text_IO;                   use Ada.Long_Float_Text_IO;
with Ada.Numerics;
with Ada.Numerics.Elementary_Functions;        use Ada.Numerics.Elementary_Functions;


with Airspeed;

with Angle_Types;
with Coordinate_Types;
with Class_Test_Result_File;
with Temperature_Types;
with Mass_Types;
with Normalized_Types;
with Length_Types;
with Interpolation_Table.Singly_Indexed;

procedure EXECUTE_Airspeed is
   An_Instance                : Airspeed.Instance;

   A_Velocity_Body_Axes                :Coordinate_Types.Cartesian;
   An_Angular_Rate                     :Coordinate_Types.Attitude;
   An_Ambient_Temperature              :Temperature_Types.Rankine;
   An_Indicated_Airspeed               :Length_Types.Feet_per_Sec;
   An_Aircraft_Sealevel_Air_Density    :Mass_Types.Slugs_per_Cubic_Feet;
   An_Aircraft_Air_Density_at_Altitude :Mass_Types.Slugs_per_Cubic_Feet;
   A_Predefined_True_Airspeed          :Length_Types.Feet_per_Sec;
   A_Predefined_True_Airspeed_Rate     :float;
   An_Ambient_Pressure_Ratio           :Normalized_Types.Normalize;
   A_Predefined_Mach_Number            :Length_Types.Mach;
   A_Predefined_Calibrated_Airspeed    :Length_Types.Knots;
   A_Gross_Weight                      :Mass_Types.Lbm;
   A_Flap_Position                     :Angle_Types.Degrees;
   A_z_Load_Factor                     :Float;
   SASSB_Table                         :Interpolation_Table.Singly_Indexed.Instance;
   SASSGWE_Table                       :Interpolation_Table.Singly_Indexed.Instance;
   A_Predefined_Load_Factor_Effect     :Float;
   A_Predefined_Stall_Speed            :Length_Types.Knots;
   A_z_Velocity_Earth_Axis            :Length_Types.Feet_per_Sec;
   An_Ambient_Temperature_at_Altitude :Temperature_Types.Rankine;
   A_Standard_Day_Ambient_Temperature_at_Altitude :Temperature_Types.Rankine;
   A_Predefined_Rate_of_Climb         :Length_Types.Feet_per_Min;
   A_x_Velocity_Earth_Axis            :Length_Types.Feet_per_Sec;
   A_y_Velocity_Earth_Axis            :Length_Types.Feet_per_Sec;
   A_L_1                              :Float;
   A_L_2                              :Float;
   A_Predefined_Ground_Speed          :Length_Types.Feet_per_Sec;

   A_Tolerance : Float := 0.000_1;
   Pass : Boolean := False;

begin

   --| This Airspeed.will set the True_Airspeed calculated during initalization, autotest
   --| or when True_Airspeed is defined by an approved other method.
   A_Predefined_True_Airspeed := 261.9398;
   Airspeed.Assign_True_Airspeed (A_Predefined_True_Airspeed,
                                  An_Instance              );

   A_Velocity_Body_Axes :=( 261.6554,5.66702,-11.05354);
   Airspeed.Set_True_Airspeed (A_Velocity_Body_Axes,
                               An_Instance        );

   Pass := abs(Airspeed.get_True_Airspeed (An_Instance) - 261.9501) <= A_Tolerance;
   Class_Test_Result_File.Report_Case_Status(Pass);

   A_Velocity_Body_Axes :=( 261.6554,5.66702,-11.05354);
   An_Angular_Rate :=( -0.8729095,-0.4511952,-0.2850278);
   Airspeed.Set_Flight_Test_True_Airspeed
     (A_Velocity_Body_Axes,
      An_Angular_Rate     ,
      An_Instance        );


   Pass := abs(Airspeed.get_True_Airspeed (An_Instance) - 266.4585) <= A_Tolerance;
   Class_Test_Result_File.Report_Case_Status(Pass);

   --| This Airspeed.will set the Mach_Number calculated during initalization, autotest
   --| or when Mach_Number is defined by an approved other method.
   A_Predefined_Mach_Number := 0.2402445;
   Airspeed.Assign_Mach_Number (A_Predefined_Mach_Number,
                                An_Instance             );
   An_Ambient_Temperature := 274.8586*1.8;
   Airspeed.Set_True_Airspeed_based_on_Mach_Number
     (An_Ambient_Temperature,
      An_Instance          );

   Pass := abs(Airspeed.get_True_Airspeed (An_Instance) - 261.9501) <= 0.1;
   Class_Test_Result_File.Report_Case_Status(Pass);


   --| This method to be used usually during formation flying an uncanned/dynamic/kinematic model.
   --   An_Indicated_Airspeed := 141.8873;
   --    An_Aircraft_Sealevel_Air_Density := 0.00237;
   --   An_Aircraft_Air_Density_at_Altitude := 0.002067761;
   --   Airspeed.Set_True_Airspeed_based_on_Indicated_Airspeed
   --    (An_Indicated_Airspeed              ,
   --     An_Aircraft_Sealevel_Air_Density   ,
   --    An_Aircraft_Air_Density_at_Altitude,
   --    An_Instance                        );

   --  put(Airspeed.get_True_Airspeed (An_Instance)); put_line(" True_Airspeed 1 ");

   --   Pass := abs(Airspeed.get_True_Airspeed (An_Instance) - 261.9501) <= A_Tolerance;
   --   Class_Test_Result_File.Report_Case_Status(Pass);


   An_Ambient_Temperature := 274.8586*1.8;
   Airspeed.Set_Mach_Number (An_Ambient_Temperature,
                             An_Instance          );

   Pass := abs(Airspeed.Get_Mach_Number (An_Instance) - 0.2402445) <= A_Tolerance;
   Class_Test_Result_File.Report_Case_Status(Pass);

   --| Set_Mach_Number_based_on_Calibrated_Airspeed, to be used when True
   --| airspeed is not directly available at such times only Calibrated airspeed
   --| is available. Use this calibrated airspeed to solve the Mach Number.  Take
   --| this Mach number to solve for the True airspeed.
   A_Predefined_Calibrated_Airspeed := 144.9253;
   Airspeed.Assign_Calibrated_Airspeed (A_Predefined_Calibrated_Airspeed ,
                                        An_Instance                    );

   An_Ambient_Pressure_Ratio := 0.8298075;
   Airspeed.Set_Mach_Number_based_on_Calibrated_Airspeed
     (An_Ambient_Pressure_Ratio ,
      An_Instance             );


   Pass := abs(Airspeed.Get_Mach_Number (An_Instance) - 0.2402265) <= 0.05;
   Class_Test_Result_File.Report_Case_Status(Pass);

   An_Ambient_Pressure_Ratio:=0.8298129;
   Airspeed.Set_Calibrated_Airspeed (An_Ambient_Pressure_Ratio,
                                     An_Instance             );


   Pass := abs(Airspeed.Get_Calibrated_Airspeed(An_Instance) - 144.9367) <= 0.1;
   Class_Test_Result_File.Report_Case_Status(Pass);


   --Airspeed.Set_Stall_Speed(A_Gross_Weight  ,
   --                          A_Flap_Position ,
   --                          A_z_Load_Factor,
   --                          SASSB_Table     ,
   --                          SASSGWE_Table   ,
   --                          An_Instance   );

   --Airspeed.Assign_Stall_Speed (A_Predefined_Load_Factor_Effect,
   --                              A_Predefined_Stall_Speed   ,
   --                              An_Instance                   );

   --Airspeed.Get_Stall_Speed(An_Instance);
   A_z_Velocity_Earth_Axis                       :=5.503195;
   An_Ambient_Temperature_at_Altitude            := 274.8586*1.8;
   A_Standard_Day_Ambient_Temperature_at_Altitude:= 278.1025*1.8;
   Airspeed.Set_Rate_of_Climb
     (A_z_Velocity_Earth_Axis                       ,
      An_Ambient_Temperature_at_Altitude            ,
      A_Standard_Day_Ambient_Temperature_at_Altitude,
      An_Instance                                  );
   put(Airspeed.get_Rate_of_Climb (An_Instance)); put_line(" Rate_of_Climb 1 ");
   Pass := abs(Airspeed.Get_Rate_of_Climb(An_Instance) - (-334.0887)) <= A_Tolerance;
   Class_Test_Result_File.Report_Case_Status(Pass);

   --| the -ve sign to make going up +ve as "z" velocity upwards is -ve.
   --| Set_Rate_of_Climb_for_Altitude_Freeze method is to be used when altitude
   --| freeze is commanded.  This method is used because the accelerations have
   --| become unnaturally frozen and during altitude freeze acceleration effects
   --| must be included.
   --Airspeed.Set_Rate_of_Climb_for_Altitude_Freeze (An_Instance );
   --
   --  A_x_Velocity_Earth_Axis:= -212.4107;
   --  A_y_Velocity_Earth_Axis:= -195.3918;
   --  A_L_1                  := -0.8170668;
   --  A_L_2                  := 0.5540981;
   --  Airspeed.Set_Ground_Speed (A_x_Velocity_Earth_Axis,
   --                              A_y_Velocity_Earth_Axis,
   --                              A_L_1                  ,
   --                              A_L_2                  ,
   --                              An_Instance           );

   --   Pass := abs(Airspeed.Set_Ground_Speed(An_Instance) - (-334.0887)) <= A_Tolerance;
   --   Class_Test_Result_File.Report_Case_Status(Pass);

end EXECUTE_Airspeed;
