-------------------------------------------------------------------------------
--|
--|            FlightSafety International Simulation Systems Division
--|                     Broken Arrow, OK  USA  918-259-4000
--|
--|                  JPATS T-6A Texan-II Flight Training Device
--|
--|
--|   Engineer:  Yogesh Tupe
--|
--|   Revision:  (Number and date inserted by Clearcase)
--|
--|
--|  DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
--|  Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
--|  technical or operational data or information from automatic dissemination
--|  under the International Exchange Program or by other means.  This protection
--|  covers information required solely for administrative or operational
--|  purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--|
--|  WARNING:  This document contains technical data whose export is restricted
--|  by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
--|  Executive Order 12470.  Violation of these export control laws is subject
--|  to severe criminal penalties.  Dissemination of this document is controlled
--|  under DOD Directive 5230.25
--|
-------------------------------------------------------------------------------
--|

with Ada.Text_IO;                              use Ada.Text_IO;
with Ada.Float_Text_IO;                        use Ada.Float_Text_IO;
with Ada.Integer_Text_IO;                      use Ada.Integer_Text_IO;
with Ada.Long_Float_Text_IO;                   use Ada.Long_Float_Text_IO;

with Ada.Numerics.Elementary_Functions;             use Ada.Numerics.Elementary_Functions;

with Class_Test_Result_File;
with Aircraft_Weight;
with Mass_Types;


procedure EXECUTE_Aircraft_Weight is

   An_Integration_Constant : Float := 1.0/60.0;

   A_Weight_Basic               :Mass_Types.Lbm;
   A_Weight_Front_Seat_Occupant :Mass_Types.Lbm;
   A_Weight_Rear_Seat_Occupant  :Mass_Types.Lbm;
   A_Weight_Baggage             :Mass_Types.Lbm;
   A_Predefined_Weight_Zero_Fuel:Mass_Types.Lbm;
   A_Weight_Fuel                :Mass_Types.Lbm;
   A_Weight_Ice_Wing_Body_Plus  :Mass_Types.Lbm;
   A_Predefined_Gross_Weight    :Mass_Types.Lbm;
   A_Predefined_Mass            :Mass_Types.Slugs_per_Cubic_Feet;

   An_Instance : Aircraft_Weight.Instance;

   Pass : Boolean := False;
   A_Tolerance : Float := 0.000_1;

begin

   A_Weight_Basic               := 4824.0;
   A_Weight_Front_Seat_Occupant := 180.0;
   A_Weight_Rear_Seat_Occupant  := 180.0;
   A_Weight_Baggage             := 20.0;
   Aircraft_Weight.Set_Zero_Fuel (A_Weight_Basic               ,
                                  A_Weight_Front_Seat_Occupant ,
                                  A_Weight_Rear_Seat_Occupant  ,
                                  A_Weight_Baggage             ,
                                  An_Instance                  );

   put(Aircraft_Weight.Get_Zero_Fuel(An_Instance )); put_line(" aircraft weight ");

   A_Weight_Fuel               := 1000.0;
   A_Weight_Ice_Wing_Body_Plus := 0.0;
   Aircraft_Weight.Set_Gross_Weight (A_Weight_Fuel               ,
                                     A_Weight_Ice_Wing_Body_Plus ,
                                     An_Instance                 );


   put(Aircraft_Weight.Get_Gross_Weight(An_Instance )); put_line(" gross weight ");


   Aircraft_Weight.Set_Mass(An_Instance );


   put(Aircraft_Weight.Get_Mass(An_Instance )); put_line(" mass ");


   pass := abs(Aircraft_Weight.Get_Zero_Fuel(An_Instance ) - 5204.0) <= A_Tolerance and
     abs(Aircraft_Weight.Get_Gross_Weight(An_Instance ) - 6204.0) <= A_Tolerance and
     abs(Aircraft_Weight.Get_Mass(An_Instance ) - 6204.0/32.174) <= A_Tolerance;

   Class_Test_Result_File.Report_Case_Status(Pass);
   Pass := False;

   put_line("---------------------- CONSTRAINT --------------------");

   A_Weight_Basic               := 10000.0;
   A_Weight_Front_Seat_Occupant := 1000.0;
   A_Weight_Rear_Seat_Occupant  := 1000.0;
   A_Weight_Baggage             := 1000.0;
   Aircraft_Weight.Set_Zero_Fuel (A_Weight_Basic               ,
                                  A_Weight_Front_Seat_Occupant ,
                                  A_Weight_Rear_Seat_Occupant  ,
                                  A_Weight_Baggage             ,
                                  An_Instance                  );

   put(Aircraft_Weight.Get_Zero_Fuel(An_Instance )); put_line(" aircraft weight ");

   A_Weight_Fuel               := 10000.0;
   A_Weight_Ice_Wing_Body_Plus := 1000.0;
   Aircraft_Weight.Set_Gross_Weight (A_Weight_Fuel               ,
                                     A_Weight_Ice_Wing_Body_Plus ,
                                     An_Instance                 );


   put(Aircraft_Weight.Get_Gross_Weight(An_Instance )); put_line(" gross weight ");


   Aircraft_Weight.Set_Mass(An_Instance );


   put(Aircraft_Weight.Get_Mass(An_Instance )); put_line(" mass ");


   pass := abs(Aircraft_Weight.Get_Zero_Fuel(An_Instance )) >= 0.0 and
     abs(Aircraft_Weight.Get_Gross_Weight(An_Instance )) >= 0.0 and
     abs(Aircraft_Weight.Get_Mass(An_Instance )) >= 0.0 ;

   Class_Test_Result_File.Report_Case_Status(Pass);
   Pass := False;

   put_line("---------------------- END --------------------");

   A_Weight_Basic               := 0.0;
   A_Weight_Front_Seat_Occupant := 0.0;
   A_Weight_Rear_Seat_Occupant  := 0.0;
   A_Weight_Baggage             := 0.0;
   Aircraft_Weight.Set_Zero_Fuel (A_Weight_Basic               ,
                                  A_Weight_Front_Seat_Occupant ,
                                  A_Weight_Rear_Seat_Occupant  ,
                                  A_Weight_Baggage             ,
                                  An_Instance                  );

   put(Aircraft_Weight.Get_Zero_Fuel(An_Instance )); put_line(" aircraft weight ");

   A_Weight_Fuel               := 0.0;
   A_Weight_Ice_Wing_Body_Plus := 0.0;
   Aircraft_Weight.Set_Gross_Weight (A_Weight_Fuel               ,
                                     A_Weight_Ice_Wing_Body_Plus ,
                                     An_Instance                 );


   put(Aircraft_Weight.Get_Gross_Weight(An_Instance )); put_line(" gross weight ");


   Aircraft_Weight.Set_Mass(An_Instance );


   put(Aircraft_Weight.Get_Mass(An_Instance )); put_line(" mass ");


   pass := abs(Aircraft_Weight.Get_Zero_Fuel(An_Instance )) >= 0.0 and
     abs(Aircraft_Weight.Get_Gross_Weight(An_Instance )) >= 0.0 and
     abs(Aircraft_Weight.Get_Mass(An_Instance )) >= 0.0 ;

   Class_Test_Result_File.Report_Case_Status(Pass);
   Pass := False;



end EXECUTE_Aircraft_Weight;

