-------------------------------------------------------------------------------
--|
--|            FlightSafety International Simulation Systems Division
--|                     Broken Arrow, OK  USA  918-259-4000
--|
--|                  JPATS T-6A Texan-II Flight Training Device
--|
--|
--|   Engineer:  Yogesh Tupe
--|
--|   Revision:  (Number and date inserted by Clearcase)
--|
--|
--|  DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
--|  Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
--|  technical or operational data or information from automatic dissemination
--|  under the International Exchange Program or by other means.  This protection
--|  covers information required solely for administrative or operational
--|  purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--|
--|  WARNING:  This document contains technical data whose export is restricted
--|  by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
--|  Executive Order 12470.  Violation of these export control laws is subject
--|  to severe criminal penalties.  Dissemination of this document is controlled
--|  under DOD Directive 5230.25
--|
-------------------------------------------------------------------------------
--|

with Ada.Text_IO;                              use Ada.Text_IO;
with Ada.Float_Text_IO;                        use Ada.Float_Text_IO;
with Ada.Integer_Text_IO;                      use Ada.Integer_Text_IO;
with Ada.Long_Float_Text_IO;                   use Ada.Long_Float_Text_IO;
with Ada.Numerics;
with Ada.Numerics.Elementary_Functions;        use Ada.Numerics.Elementary_Functions;


with Aerodynamic_Angle;

with Angle_Types;
with Coordinate_Types;
with Class_Test_Result_File;

procedure EXECUTE_Aero_Angle is
   An_Instance                : Aerodynamic_Angle.Instance;

   A_Velocity_Body_Axis              :Coordinate_Types.Cartesian;
   A_Predefined_Angle_of_Attack      :Angle_Types.Radians;
   A_Predefined_Side_Slip_Angle      :Angle_Types.Radians;
   An_Acceleration_Body_Axis         :Coordinate_Types.Cartesian;
   A_Predefined_Angle_of_Attack_Rate :Angle_Types.Radians_per_Sec;


   A_Tolerance : Float := 0.001;
   Pass : Boolean := False;
begin

   A_Velocity_Body_Axis              := (261.6554, 5.66702, -11.05354);
   A_Predefined_Angle_of_Attack      := 0.213;
   A_Predefined_Side_Slip_Angle      := 0.05;
   An_Acceleration_Body_Axis         := (-4.8755,0.0,-89.90469);
   A_Predefined_Angle_of_Attack_Rate := 1.56;

   Aerodynamic_Angle.Assign_Angle_of_Attack (A_Predefined_Angle_of_Attack,
                                             An_Instance                 );
   Aerodynamic_Angle.Assign_Side_Slip_Angle (A_Predefined_Side_Slip_Angle,
                                             An_Instance                 );
   Aerodynamic_Angle.Assign_Angle_of_Attack_Rate(A_Predefined_Angle_of_Attack_Rate,
                                                 An_Instance                      );


   Put(Aerodynamic_Angle.Get_Angle_of_Attack(An_Instance));       Put_Line(" Get_Angle_of_Attack ");
   Put(Aerodynamic_Angle.Get_Side_Slip_Angle(An_Instance));       Put_Line(" Get_Side_Slip_Angle ");
   Put(Aerodynamic_Angle.Get_Angle_of_Attack_Rate(An_Instance));  Put_Line(" Get_Angle_of_Attack_Rate ");


   Aerodynamic_Angle.Set_Angle_of_Attack(A_Velocity_Body_Axis,
                                         An_Instance         );
   Aerodynamic_Angle.Set_Side_Slip_Angle(A_Velocity_Body_Axis,
                                         An_Instance          );
   Aerodynamic_Angle.Set_Angle_of_Attack_Rate(A_Velocity_Body_Axis     ,
                                              An_Acceleration_Body_Axis,
                                              An_Instance              );


   Put(Aerodynamic_Angle.Get_Angle_of_Attack(An_Instance)*180.0/3.142);       Put_Line(" Get_Angle_of_Attack ");
   Put(Aerodynamic_Angle.Get_Side_Slip_Angle(An_Instance)*180.0/3.142);       Put_Line(" Get_Side_Slip_Angle ");
   Put(Aerodynamic_Angle.Get_Angle_of_Attack_Rate(An_Instance)*180.0/3.142);  Put_Line(" Get_Angle_of_Attack_Rate ");


   Put(Aerodynamic_Angle.Get_Angle_of_Attack(An_Instance));       Put_Line(" Get_Angle_of_Attack ");
   Put(Aerodynamic_Angle.Get_Side_Slip_Angle(An_Instance));       Put_Line(" Get_Side_Slip_Angle ");
   Put(Aerodynamic_Angle.Get_Angle_of_Attack_Rate(An_Instance));  Put_Line(" Get_Angle_of_Attack_Rate ");

   Pass := abs(Aerodynamic_Angle.Get_Angle_of_Attack(An_Instance) - (-2.419001*22.0/7.0/180.0))  < A_Tolerance and
     abs(Aerodynamic_Angle.Get_Side_Slip_Angle(An_Instance) - (1.239632*22.0/7.0/180.0))  < A_Tolerance and
     abs(Aerodynamic_Angle.Get_Angle_of_Attack_Rate(An_Instance) - (-19.69675*22.0/7.0/180.0)) < A_Tolerance ;


   Class_Test_Result_File.Report_Case_Status(Pass);


   Put_Line(" ---------------SET CONSTRAINT ---------------------");

   A_Velocity_Body_Axis              := (1000.0, 1000.0, 1000.0);
   A_Predefined_Angle_of_Attack      := 1000.0;
   A_Predefined_Side_Slip_Angle      := 1000.0;
   An_Acceleration_Body_Axis         := (1000.0,1000.0,1000.0);
   A_Predefined_Angle_of_Attack_Rate := 1000.0;

   Aerodynamic_Angle.Assign_Angle_of_Attack (A_Predefined_Angle_of_Attack,
                                             An_Instance                 );
   Aerodynamic_Angle.Assign_Side_Slip_Angle (A_Predefined_Side_Slip_Angle,
                                             An_Instance                 );
   Aerodynamic_Angle.Assign_Angle_of_Attack_Rate(A_Predefined_Angle_of_Attack_Rate,
                                                 An_Instance                      );


   Put(Aerodynamic_Angle.Get_Angle_of_Attack(An_Instance));       Put_Line(" Get_Angle_of_Attack ");
   Put(Aerodynamic_Angle.Get_Side_Slip_Angle(An_Instance));       Put_Line(" Get_Side_Slip_Angle ");
   Put(Aerodynamic_Angle.Get_Angle_of_Attack_Rate(An_Instance));  Put_Line(" Get_Angle_of_Attack_Rate ");


   Aerodynamic_Angle.Set_Angle_of_Attack(A_Velocity_Body_Axis,
                                         An_Instance         );
   Aerodynamic_Angle.Set_Side_Slip_Angle(A_Velocity_Body_Axis,
                                         An_Instance          );
   Aerodynamic_Angle.Set_Angle_of_Attack_Rate(A_Velocity_Body_Axis     ,
                                              An_Acceleration_Body_Axis,
                                              An_Instance              );


   Put(Aerodynamic_Angle.Get_Angle_of_Attack(An_Instance)*180.0/3.142);       Put_Line(" Get_Angle_of_Attack ");
   Put(Aerodynamic_Angle.Get_Side_Slip_Angle(An_Instance)*180.0/3.142);       Put_Line(" Get_Side_Slip_Angle ");
   Put(Aerodynamic_Angle.Get_Angle_of_Attack_Rate(An_Instance)*180.0/3.142);  Put_Line(" Get_Angle_of_Attack_Rate ");


   Put(Aerodynamic_Angle.Get_Angle_of_Attack(An_Instance));       Put_Line(" Get_Angle_of_Attack ");
   Put(Aerodynamic_Angle.Get_Side_Slip_Angle(An_Instance));       Put_Line(" Get_Side_Slip_Angle ");
   Put(Aerodynamic_Angle.Get_Angle_of_Attack_Rate(An_Instance));  Put_Line(" Get_Angle_of_Attack_Rate ");

   Pass := False;
   if  abs(Aerodynamic_Angle.Get_Angle_of_Attack(An_Instance)) >= 0.0 and
     abs(Aerodynamic_Angle.Get_Side_Slip_Angle(An_Instance)) >= 0.0 and
     abs(Aerodynamic_Angle.Get_Angle_of_Attack_Rate(An_Instance)) >= 0.0 then
      Pass := True;
   else
      Pass := False;

   end if;


   Class_Test_Result_File.Report_Case_Status(Pass);


   Put_Line(" ---------------SET CONSTRAINT ---------------------");

   A_Velocity_Body_Axis              := (0.0, 0.0, 0.0);
   A_Predefined_Angle_of_Attack      := 0.0;
   A_Predefined_Side_Slip_Angle      := 0.0;
   An_Acceleration_Body_Axis         := (0.0,0.0,0.0);
   A_Predefined_Angle_of_Attack_Rate := 0.0;

   Aerodynamic_Angle.Assign_Angle_of_Attack (A_Predefined_Angle_of_Attack,
                                             An_Instance                 );
   Aerodynamic_Angle.Assign_Side_Slip_Angle (A_Predefined_Side_Slip_Angle,
                                             An_Instance                 );
   Aerodynamic_Angle.Assign_Angle_of_Attack_Rate(A_Predefined_Angle_of_Attack_Rate,
                                                 An_Instance                      );


   Put(Aerodynamic_Angle.Get_Angle_of_Attack(An_Instance));       Put_Line(" Get_Angle_of_Attack ");
   Put(Aerodynamic_Angle.Get_Side_Slip_Angle(An_Instance));       Put_Line(" Get_Side_Slip_Angle ");
   Put(Aerodynamic_Angle.Get_Angle_of_Attack_Rate(An_Instance));  Put_Line(" Get_Angle_of_Attack_Rate ");


   Aerodynamic_Angle.Set_Angle_of_Attack(A_Velocity_Body_Axis,
                                         An_Instance         );
   Aerodynamic_Angle.Set_Side_Slip_Angle(A_Velocity_Body_Axis,
                                         An_Instance          );
   Aerodynamic_Angle.Set_Angle_of_Attack_Rate(A_Velocity_Body_Axis     ,
                                              An_Acceleration_Body_Axis,
                                              An_Instance              );


   Put(Aerodynamic_Angle.Get_Angle_of_Attack(An_Instance)*180.0/3.142);       Put_Line(" Get_Angle_of_Attack ");
   Put(Aerodynamic_Angle.Get_Side_Slip_Angle(An_Instance)*180.0/3.142);       Put_Line(" Get_Side_Slip_Angle ");
   Put(Aerodynamic_Angle.Get_Angle_of_Attack_Rate(An_Instance)*180.0/3.142);  Put_Line(" Get_Angle_of_Attack_Rate ");


   Put(Aerodynamic_Angle.Get_Angle_of_Attack(An_Instance));       Put_Line(" Get_Angle_of_Attack ");
   Put(Aerodynamic_Angle.Get_Side_Slip_Angle(An_Instance));       Put_Line(" Get_Side_Slip_Angle ");
   Put(Aerodynamic_Angle.Get_Angle_of_Attack_Rate(An_Instance));  Put_Line(" Get_Angle_of_Attack_Rate ");

   Pass := False;
   if  abs(Aerodynamic_Angle.Get_Angle_of_Attack(An_Instance)) >= 0.0 and
     abs(Aerodynamic_Angle.Get_Side_Slip_Angle(An_Instance)) >= 0.0 and
     abs(Aerodynamic_Angle.Get_Angle_of_Attack_Rate(An_Instance)) >= 0.0 then
      Pass := True;
   else
      Pass := False;

   end if;


   Class_Test_Result_File.Report_Case_Status(Pass);


   Put_Line(" ---------------END -------------------------");


end EXECUTE_Aero_Angle;
