-------------------------------------------------------------------------------
--|
--|            FlightSafety International Simulation Systems Division
--|                     Broken Arrow, OK  USA  918-259-4000
--|
--|                  JPATS T-6A Texan-II Flight Training Device
--|
--|
--|   Engineer:  Yogesh Tupe
--|
--|   Revision:  (Number and date inserted by Clearcase)
--|
--|
--|  DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
--|  Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
--|  technical or operational data or information from automatic dissemination
--|  under the International Exchange Program or by other means.  This protection
--|  covers information required solely for administrative or operational
--|  purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--|
--|  WARNING:  This document contains technical data whose export is restricted
--|  by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
--|  Executive Order 12470.  Violation of these export control laws is subject
--|  to severe criminal penalties.  Dissemination of this document is controlled
--|  under DOD Directive 5230.25
--|
-------------------------------------------------------------------------------
--|


with Ada.Text_IO;                              use Ada.Text_IO;
with Ada.Float_Text_IO;                        use Ada.Float_Text_IO;
with Ada.Integer_Text_IO;                      use Ada.Integer_Text_IO;
with Ada.Long_Float_Text_IO;                   use Ada.Long_Float_Text_IO;
with Ada.Numerics;
with Ada.Numerics.Elementary_Functions;        use Ada.Numerics.Elementary_Functions;


with Acceleration;
with Class_Test_Result_File;
with Angle_Types;
with Coordinate_Types;
with Mass_Types;
with Length_Types;

procedure EXECUTE_Acceleration is
   An_Instance                                 : Acceleration.Instance;

   A_Velocity_Body_Axis                        : Coordinate_Types.Cartesian;
   A_y_Velocity_Body_Axis                      : Length_Types.Feet_per_Sec;
   A_z_Velocity_Body_Axis                      : Length_Types.Feet_per_Sec;
   A_Roll_Angle                                : Angle_Types.Radians;
   A_Pitch_Angle                               : Angle_Types.Radians;
   A_Yaw_Angle                                 : Angle_Types.Radians;
   A_Roll_Rate                                 : Angle_Types.Radians_per_Sec;
   A_Pitch_Rate                                : Angle_Types.Radians_per_Sec;
   A_Yaw_Rate                                  : Angle_Types.Radians_per_Sec;
   A_Mass                                      : Mass_Types.Lbm;
   A_Force                                     : Coordinate_Types.Cartesian;
   A_Predefined_Acceleration                   : Coordinate_Types.Cartesian;
   A_Predefined_Last_Pass_Acceleration         : Coordinate_Types.Cartesian;
   A_Predefined_Angular_Acceleration           : Coordinate_Types.Attitude;
   A_Predefined_Last_Pass_Angular_Acceleration : Coordinate_Types.Attitude;
   A_Moment                                    : Coordinate_Types.Cartesian;
   An_Inertia                                  : Coordinate_Types.Inertia_Axis;
   An_Angular_Rate                             : Coordinate_Types.Attitude;
   Pass : Boolean := False;
   A_Tolerance : Float := 0.000_01;
begin

   A_Predefined_Acceleration := (-0.2352709,0.02,-90.99911);
   Acceleration.Assign_Body_Axis(A_Predefined_Acceleration,
                                 An_Instance              );

   Put(Acceleration.Get_Body_Axis(An_Instance).x);
   Put(Acceleration.Get_Body_Axis(An_Instance).y);
   Put(Acceleration.Get_Body_Axis(An_Instance).z);
   Put_Line(" Acceleration_Body_Axis ");

   A_Velocity_Body_Axis := (261.7879,3.170575,-8.033916);
   A_Force              := (-85.1857,321.2976,-2356.727);
   A_Roll_Angle         := -0.1575623;
   A_Pitch_Angle        := -0.05042598;
   A_Yaw_Angle          := -2.52386;
   A_Mass               := 195.1265;
   A_Roll_Rate          := -0.8209217;
   A_Pitch_Rate         := -0.4328175;
   A_Yaw_Rate           := -0.2562039;
   Acceleration.Set_Body_Axis
     (A_Velocity_Body_Axis,
      A_Roll_Angle        ,
      A_Pitch_Angle       ,
      A_Yaw_Angle         ,
      A_Roll_Rate         ,
      A_Pitch_Rate        ,
      A_Yaw_Rate          ,
      A_Mass              ,
      A_Force             ,
      An_Instance              );

   Put(Acceleration.Get_Body_Axis(An_Instance).x);
   Put(Acceleration.Get_Body_Axis(An_Instance).y);
   Put(Acceleration.Get_Body_Axis(An_Instance).z);
   Put_Line(" Acceleration_Body_Axis ");

   Pass := abs(Acceleration.Get_Body_Axis(An_Instance).x - (-3.104382)) <= A_Tolerance and
     abs(Acceleration.Get_Body_Axis(An_Instance).z - (-91.04648)) <= A_Tolerance;

   Class_Test_Result_File.Report_Case_Status(Pass);

   A_Predefined_Acceleration           := (-0.1914934,0.06874111,18.06922);
   A_Predefined_Last_Pass_Acceleration := (-0.1914934,0.06874111,18.06922);
   Acceleration.Assign_Earth_Axis
     (A_Predefined_Acceleration,
      A_Predefined_Last_Pass_Acceleration,
      An_Instance                       );

   Put(Acceleration.Get_Earth_Axis(An_Instance).x);
   Put(Acceleration.Get_Earth_Axis(An_Instance).y);
   Put(Acceleration.Get_Earth_Axis(An_Instance).z);
   Put_Line(" Acceleration_Earth_Axis ");

   Put(Acceleration.Get_Last_Pass_Earth_Axis(An_Instance).x);
   Put(Acceleration.Get_Last_Pass_Earth_Axis(An_Instance).y);
   Put(Acceleration.Get_Last_Pass_Earth_Axis(An_Instance).z);
   Put_Line(" Last Pass Acceleration_Earth_Axis ");

   A_Force       := (-85.1857,321.2976,-2356.727);
   A_Roll_Angle  := -0.1575623;
   A_Pitch_Angle := -0.05042598;
   A_Yaw_Angle   := -2.52386;
   A_Mass        := 195.1265;
   Acceleration.Set_Earth_Axis
     (A_Force      ,
      A_Roll_Angle  ,
      A_Pitch_Angle,
      A_Yaw_Angle  ,
      A_Mass       ,
      An_Instance  );

   Put(Acceleration.Get_Earth_Axis(An_Instance).x);
   Put(Acceleration.Get_Earth_Axis(An_Instance).y);
   Put(Acceleration.Get_Earth_Axis(An_Instance).z);
   Put_Line(" Acceleration_Earth_Axis ");

   Put(Acceleration.Get_Last_Pass_Earth_Axis(An_Instance).x);
   Put(Acceleration.Get_Last_Pass_Earth_Axis(An_Instance).y);
   Put(Acceleration.Get_Last_Pass_Earth_Axis(An_Instance).z);
   Put_Line(" Last Pass Acceleration_Earth_Axis ");

   Pass := abs(Acceleration.Get_Earth_Axis(An_Instance).x - (-0.3010841)) <= A_Tolerance and
     abs(Acceleration.Get_Earth_Axis(An_Instance).y - (0.1160036)) <= A_Tolerance and
     abs(Acceleration.Get_Earth_Axis(An_Instance).z - (19.98078)) <= A_Tolerance;

   Class_Test_Result_File.Report_Case_Status(Pass);




   A_Predefined_Angular_Acceleration           := (-1.564003,-0.552394, -0.8638889);
   A_Predefined_Last_Pass_Angular_Acceleration := (-1.564003,-0.552394, -0.8638889);
   Acceleration.Assign_Angular(A_Predefined_Angular_Acceleration           ,
                               A_Predefined_Last_Pass_Angular_Acceleration ,
                               An_Instance);

   Put(Acceleration.Get_Angular(An_Instance).Roll);
   Put(Acceleration.Get_Angular(An_Instance).Pitch);
   Put(Acceleration.Get_Angular(An_Instance).Yaw);
   Put_Line(" Angular_Acceleration_Body_Axis ");

   Put(Acceleration.Get_Last_Pass_Angular(An_Instance).Roll);
   Put(Acceleration.Get_Last_Pass_Angular(An_Instance).Pitch);
   Put(Acceleration.Get_Last_Pass_Angular(An_Instance).Yaw);
   Put_Line(" Last Pass Angular_Acceleration_Body_Axis ");

   A_Moment        := (-3857.37,-4995.116,-5860.033);
   An_Inertia      := (2819.0,7218.0,9408.0,196.0);
   An_Angular_Rate := (-0.8729095,-0.4511952,-0.2850278);

   Acceleration.Set_Angular(A_Moment       ,
                            An_Inertia      ,
                            An_Angular_Rate,
                            An_Instance);

   Put(Acceleration.Get_Angular(An_Instance).Roll);
   Put(Acceleration.Get_Angular(An_Instance).Pitch);
   Put(Acceleration.Get_Angular(An_Instance).Yaw);
   Put_Line(" Angular_Acceleration_Body_Axis ");

   Put(Acceleration.Get_Last_Pass_Angular(An_Instance).Roll);
   Put(Acceleration.Get_Last_Pass_Angular(An_Instance).Pitch);
   Put(Acceleration.Get_Last_Pass_Angular(An_Instance).Yaw);
   Put_Line(" Last Pass Angular_Acceleration_Body_Axis ");


   Pass := abs(Acceleration.Get_Angular(An_Instance).roll - (-1.499341)) <= A_Tolerance and
     abs(Acceleration.Get_Angular(An_Instance).pitch - (-0.4833989)) <= A_Tolerance and
     abs(Acceleration.Get_Angular(An_Instance).yaw - (-0.8409511)) <= A_Tolerance;

   Class_Test_Result_File.Report_Case_Status(Pass);


   Put_Line("---------NEXT SET ---CONSTRAINTED-------------");

   A_Predefined_Acceleration := (1000.0,1000.0,1000.0);
   Acceleration.Assign_Body_Axis(A_Predefined_Acceleration,
                                 An_Instance              );

   Put(Acceleration.Get_Body_Axis(An_Instance).x);
   Put(Acceleration.Get_Body_Axis(An_Instance).y);
   Put(Acceleration.Get_Body_Axis(An_Instance).z);
   Put_Line(" Acceleration_Body_Axis ");

   A_Velocity_Body_Axis := (100.0,100.0,100.0);
   A_Force              := (1000.0,1000.0,10000.0);
   A_Roll_Angle         := 1000.0;
   A_Pitch_Angle        := 1000.0;
   A_Yaw_Angle          := 1000.0;
   A_Mass               := 1000.0;
   A_Roll_Rate          := 1000.0;
   A_Pitch_Rate         := 1000.0;
   A_Yaw_Rate           := 1000.0;
   Acceleration.Set_Body_Axis
     (A_Velocity_Body_Axis,
      A_Roll_Angle        ,
      A_Pitch_Angle       ,
      A_Yaw_Angle         ,
      A_Roll_Rate         ,
      A_Pitch_Rate        ,
      A_Yaw_Rate          ,
      A_Mass              ,
      A_Force             ,
      An_Instance              );

   Put(Acceleration.Get_Body_Axis(An_Instance).x);
   Put(Acceleration.Get_Body_Axis(An_Instance).y);
   Put(Acceleration.Get_Body_Axis(An_Instance).z);
   Put_Line(" Acceleration_Body_Axis ");

   if  abs(Acceleration.Get_Body_Axis(An_Instance).x) >= 0.0 and
     abs(Acceleration.Get_Body_Axis(An_Instance).z) >= 0.0 then
      Pass := True;
   else
      Pass := False;
   end if;

   Class_Test_Result_File.Report_Case_Status(Pass);

   A_Predefined_Acceleration           := (1000.0,1000.0,1000.0);
   A_Predefined_Last_Pass_Acceleration := (1000.0,1000.0,1000.0);
   Acceleration.Assign_Earth_Axis
     (A_Predefined_Acceleration,
      A_Predefined_Last_Pass_Acceleration,
      An_Instance                       );

   Put(Acceleration.Get_Earth_Axis(An_Instance).x);
   Put(Acceleration.Get_Earth_Axis(An_Instance).y);
   Put(Acceleration.Get_Earth_Axis(An_Instance).z);
   Put_Line(" Acceleration_Earth_Axis ");

   Put(Acceleration.Get_Last_Pass_Earth_Axis(An_Instance).x);
   Put(Acceleration.Get_Last_Pass_Earth_Axis(An_Instance).y);
   Put(Acceleration.Get_Last_Pass_Earth_Axis(An_Instance).z);
   Put_Line(" Last Pass Acceleration_Earth_Axis ");

   Acceleration.Set_Earth_Axis
     (A_Force      ,
      A_Roll_Angle  ,
      A_Pitch_Angle,
      A_Yaw_Angle  ,
      A_Mass       ,
      An_Instance  );

   Put(Acceleration.Get_Earth_Axis(An_Instance).x);
   Put(Acceleration.Get_Earth_Axis(An_Instance).y);
   Put(Acceleration.Get_Earth_Axis(An_Instance).z);
   Put_Line(" Acceleration_Earth_Axis ");

   Put(Acceleration.Get_Last_Pass_Earth_Axis(An_Instance).x);
   Put(Acceleration.Get_Last_Pass_Earth_Axis(An_Instance).y);
   Put(Acceleration.Get_Last_Pass_Earth_Axis(An_Instance).z);
   Put_Line(" Last Pass Acceleration_Earth_Axis ");

   if  abs(Acceleration.Get_Earth_Axis(An_Instance).x) >= 0.0 and
     abs(Acceleration.Get_Earth_Axis(An_Instance).y) >= 0.0 and
     abs(Acceleration.Get_Earth_Axis(An_Instance).z) >= 0.0 then
      Pass := True;
   else
      Pass := False;
   end if;

   Class_Test_Result_File.Report_Case_Status(Pass);

   A_Predefined_Angular_Acceleration           := (1000.0,1000.0, 1000.0);
   A_Predefined_Last_Pass_Angular_Acceleration := (1000.0,1000.0, 1000.0);
   Acceleration.Assign_Angular(A_Predefined_Angular_Acceleration           ,
                               A_Predefined_Last_Pass_Angular_Acceleration ,
                               An_Instance);

   Put(Acceleration.Get_Angular(An_Instance).Roll);
   Put(Acceleration.Get_Angular(An_Instance).Pitch);
   Put(Acceleration.Get_Angular(An_Instance).Yaw);
   Put_Line(" Angular_Acceleration_Body_Axis ");

   Put(Acceleration.Get_Last_Pass_Angular(An_Instance).Roll);
   Put(Acceleration.Get_Last_Pass_Angular(An_Instance).Pitch);
   Put(Acceleration.Get_Last_Pass_Angular(An_Instance).Yaw);
   Put_Line(" Last Pass Angular_Acceleration_Body_Axis ");

   A_Moment        := (10000.0,10000.0,10000.0);
   An_Inertia      := (10000.0,10000.0,10000.0,10000.0);
   An_Angular_Rate := (100.0,100.0,100.0);

   Acceleration.Set_Angular(A_Moment       ,
                            An_Inertia      ,
                            An_Angular_Rate,
                            An_Instance);

   Put(Acceleration.Get_Angular(An_Instance).Roll);
   Put(Acceleration.Get_Angular(An_Instance).Pitch);
   Put(Acceleration.Get_Angular(An_Instance).Yaw);
   Put_Line(" Angular_Acceleration_Body_Axis ");

   Put(Acceleration.Get_Last_Pass_Angular(An_Instance).Roll);
   Put(Acceleration.Get_Last_Pass_Angular(An_Instance).Pitch);
   Put(Acceleration.Get_Last_Pass_Angular(An_Instance).Yaw);
   Put_Line(" Last Pass Angular_Acceleration_Body_Axis ");

   if  abs(Acceleration.Get_Angular(An_Instance).roll) >= 0.0 and
     abs(Acceleration.Get_Angular(An_Instance).pitch) >= 0.0 and
     abs(Acceleration.Get_Angular(An_Instance).yaw) >= 0.0 then
      Pass := True;
   else
      Pass := False;
   end if;

   Class_Test_Result_File.Report_Case_Status(Pass);

   Put_Line("---------NEXT SET ---CONSTRAINTED-------------");


   A_Predefined_Acceleration := (0.0,0.0,0.0);
   Acceleration.Assign_Body_Axis(A_Predefined_Acceleration,
                                 An_Instance              );

   Put(Acceleration.Get_Body_Axis(An_Instance).x);
   Put(Acceleration.Get_Body_Axis(An_Instance).y);
   Put(Acceleration.Get_Body_Axis(An_Instance).z);
   Put_Line(" Acceleration_Body_Axis ");

   A_Velocity_Body_Axis := (0.0,0.0,0.0);
   A_Force              := (0.0,0.0,0.0);
   A_Roll_Angle         := 0.0;
   A_Pitch_Angle        := 0.0;
   A_Yaw_Angle          := 0.0;
   A_Mass               := 0.0;
   A_Roll_Rate          := 0.0;
   A_Pitch_Rate         := 0.0;
   A_Yaw_Rate           := 0.0;
   Acceleration.Set_Body_Axis
     (A_Velocity_Body_Axis,
      A_Roll_Angle        ,
      A_Pitch_Angle       ,
      A_Yaw_Angle         ,
      A_Roll_Rate         ,
      A_Pitch_Rate        ,
      A_Yaw_Rate          ,
      A_Mass              ,
      A_Force             ,
      An_Instance              );

   Put(Acceleration.Get_Body_Axis(An_Instance).x);
   Put(Acceleration.Get_Body_Axis(An_Instance).y);
   Put(Acceleration.Get_Body_Axis(An_Instance).z);
   Put_Line(" Acceleration_Body_Axis ");

   if  abs(Acceleration.Get_Body_Axis(An_Instance).x) >= 0.0 and
     abs(Acceleration.Get_Body_Axis(An_Instance).z) >= 0.0 then
      Pass := True;
   else
      Pass := False;
   end if;

   Class_Test_Result_File.Report_Case_Status(Pass);

   A_Predefined_Acceleration           := (0.0,0.0,0.0);
   A_Predefined_Last_Pass_Acceleration := (0.0,0.0,0.0);
   Acceleration.Assign_Earth_Axis
     (A_Predefined_Acceleration,
      A_Predefined_Last_Pass_Acceleration,
      An_Instance                       );

   Put(Acceleration.Get_Earth_Axis(An_Instance).x);
   Put(Acceleration.Get_Earth_Axis(An_Instance).y);
   Put(Acceleration.Get_Earth_Axis(An_Instance).z);
   Put_Line(" Acceleration_Earth_Axis ");

   Put(Acceleration.Get_Last_Pass_Earth_Axis(An_Instance).x);
   Put(Acceleration.Get_Last_Pass_Earth_Axis(An_Instance).y);
   Put(Acceleration.Get_Last_Pass_Earth_Axis(An_Instance).z);
   Put_Line(" Last Pass Acceleration_Earth_Axis ");

   Acceleration.Set_Earth_Axis
     (A_Force      ,
      A_Roll_Angle  ,
      A_Pitch_Angle,
      A_Yaw_Angle  ,
      A_Mass       ,
      An_Instance  );

   Put(Acceleration.Get_Earth_Axis(An_Instance).x);
   Put(Acceleration.Get_Earth_Axis(An_Instance).y);
   Put(Acceleration.Get_Earth_Axis(An_Instance).z);
   Put_Line(" Acceleration_Earth_Axis ");

   Put(Acceleration.Get_Last_Pass_Earth_Axis(An_Instance).x);
   Put(Acceleration.Get_Last_Pass_Earth_Axis(An_Instance).y);
   Put(Acceleration.Get_Last_Pass_Earth_Axis(An_Instance).z);
   Put_Line(" Last Pass Acceleration_Earth_Axis ");

   if  abs(Acceleration.Get_Earth_Axis(An_Instance).x) >= 0.0 and
     abs(Acceleration.Get_Earth_Axis(An_Instance).y) >= 0.0 and
     abs(Acceleration.Get_Earth_Axis(An_Instance).z) >= 0.0 then
      Pass := True;
   else
      Pass := False;
   end if;

   Class_Test_Result_File.Report_Case_Status(Pass);

   A_Predefined_Angular_Acceleration           := (0.0,0.0, 0.0);
   A_Predefined_Last_Pass_Angular_Acceleration := (0.0,0.0, 0.0);
   Acceleration.Assign_Angular(A_Predefined_Angular_Acceleration           ,
                               A_Predefined_Last_Pass_Angular_Acceleration ,
                               An_Instance);

   Put(Acceleration.Get_Angular(An_Instance).Roll);
   Put(Acceleration.Get_Angular(An_Instance).Pitch);
   Put(Acceleration.Get_Angular(An_Instance).Yaw);
   Put_Line(" Angular_Acceleration_Body_Axis ");

   Put(Acceleration.Get_Last_Pass_Angular(An_Instance).Roll);
   Put(Acceleration.Get_Last_Pass_Angular(An_Instance).Pitch);
   Put(Acceleration.Get_Last_Pass_Angular(An_Instance).Yaw);
   Put_Line(" Last Pass Angular_Acceleration_Body_Axis ");

   A_Moment        := (00.0,00.0,00.0);
   An_Inertia      := (00.0,00.0,00.0,00.0);
   An_Angular_Rate := (0.0,0.0,0.0);

   Acceleration.Set_Angular(A_Moment       ,
                            An_Inertia      ,
                            An_Angular_Rate,
                            An_Instance);

   Put(Acceleration.Get_Angular(An_Instance).Roll);
   Put(Acceleration.Get_Angular(An_Instance).Pitch);
   Put(Acceleration.Get_Angular(An_Instance).Yaw);
   Put_Line(" Angular_Acceleration_Body_Axis ");

   Put(Acceleration.Get_Last_Pass_Angular(An_Instance).Roll);
   Put(Acceleration.Get_Last_Pass_Angular(An_Instance).Pitch);
   Put(Acceleration.Get_Last_Pass_Angular(An_Instance).Yaw);
   Put_Line(" Last Pass Angular_Acceleration_Body_Axis ");

   if  abs(Acceleration.Get_Angular(An_Instance).roll) >= 0.0 and
     abs(Acceleration.Get_Angular(An_Instance).pitch) >= 0.0 and
     abs(Acceleration.Get_Angular(An_Instance).yaw) >= 0.0 then
      Pass := True;
   else
      Pass := False;
   end if;

   Class_Test_Result_File.Report_Case_Status(Pass);

   Put_Line("---------END SET ----------------------------");

end EXECUTE_Acceleration;
