-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------


with Class_Test_Result_File;
with Ada.Calendar; use Ada.Calendar;

with Tad;
with Length_Types;
with Angle_Types;
with Jpats_Secondary_Flight_Controls_Types;

procedure Tad_Ctd is


begin


   -------------------------------------------------------------------------------
   -- Test_1
   --
   -- Inputs           :
   -- Expected results :
   -- Purpose          :

   Test_1 : declare
      -------------------------------------------------------------------------------
      -------------------------------------------------------------------------------

      Interval : Duration := 10.0;
      Stop_Time :  Ada.Calendar.Time := Ada.Calendar.Clock + Interval;

      Half_Stop_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.50000) * Interval;

      One_Third_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.66666) * Interval;
      Two_Thirds_Time     : Ada.Calendar.Time := Stop_Time - Duration(0.33333) * Interval;

      One_Quarter_Time    : Ada.Calendar.Time := Stop_Time - Duration(0.75000) * Interval;
      Two_Quarter_Time    : Ada.Calendar.Time := Stop_Time - Duration(0.50000) * Interval;
      Three_Quarter_Time  : Ada.Calendar.Time := Stop_Time - Duration(0.25000) * Interval;

      Reset_In_Time       : Ada.Calendar.Time := Stop_Time - Duration(0.2000) * Interval;
      Reset_Off_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.1660) * Interval;

      function Now return Ada.Calendar.Time renames Ada.Calendar.Clock;

      Iconst : Float := 0.06666666;
      I : Integer := 0;

      In_First_Quarter  : Boolean := true;
      In_Second_Quarter : Boolean := true;
      In_Third_Quarter  : Boolean := true;
      In_Fourth_Quarter : Boolean := true;

      -------------------------------------------------------------------------------
      -------------------------------------------------------------------------------

      A_Tad : Tad.Instance;

      Test_Case_1 : Boolean;


   begin

      Tad.Initialize (A_Tad);

      Test_Case_1 := Tad.Tad_Command (A_Tad) = 0.0 and not Tad.Tad_On (A_Tad);

      Class_Test_Result_File.Report_Case_Status (Success => Test_Case_1, Number => 1);

   end Test_1;





   -------------------------------------------------------------------------------
   -- Test_2
   --
   -- Inputs           :
   -- Expected results :
   -- Purpose          :

   Test_2 : declare
      -------------------------------------------------------------------------------
      -------------------------------------------------------------------------------

      Interval : Duration := 10.0;
      Stop_Time :  Ada.Calendar.Time := Ada.Calendar.Clock + Interval;

      Half_Stop_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.50000) * Interval;

      One_Third_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.66666) * Interval;
      Two_Thirds_Time     : Ada.Calendar.Time := Stop_Time - Duration(0.33333) * Interval;

      One_Quarter_Time    : Ada.Calendar.Time := Stop_Time - Duration(0.75000) * Interval;
      Two_Quarter_Time    : Ada.Calendar.Time := Stop_Time - Duration(0.50000) * Interval;
      Three_Quarter_Time  : Ada.Calendar.Time := Stop_Time - Duration(0.25000) * Interval;

      Reset_In_Time       : Ada.Calendar.Time := Stop_Time - Duration(0.2000) * Interval;
      Reset_Off_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.1660) * Interval;

      function Now return Ada.Calendar.Time renames Ada.Calendar.Clock;

      Iconst : Float := 0.06666666;
      I : Integer := 0;

      In_First_Quarter  : Boolean := true;
      In_Second_Quarter : Boolean := true;
      In_Third_Quarter  : Boolean := true;
      In_Fourth_Quarter : Boolean := true;

      -------------------------------------------------------------------------------
      -------------------------------------------------------------------------------

      A_Tad : Tad.Instance;

      Test_Case_2 : array (1..2) of Boolean := (others => False);
      Flag : Integer := 0;


      A_Left_Wow_Relay                : Boolean;
      A_Right_Wow_Relay               : Boolean;
      A_Tad_Cb                        : Boolean;
      A_Kias_Adc                      : Length_Types.Knots;
      A_Pitch_Rate                    : Angle_Types.Radians_per_Sec;
      A_Pressure_Altitude             : Length_Types.Feet;
      A_Engine_Torque                 : Float;
      A_Rudder_Trim_Actuated_Position : Jpats_Secondary_Flight_Controls_Types.Rudder_Trim_Position_Type;
      A_Trim_Disconnect               : Boolean;
      A_Trim_Interrupt                : Boolean;
      A_Tad_Fault                     : Boolean;
      A_Rudder_Trim_Switch_Left       : Boolean;
      A_Rudder_Trim_Switch_Right      : Boolean;
      A_Tad_On_Switch                 : Boolean;

   begin

      Tad.Initialize (A_Tad);

      A_Left_Wow_Relay                := False;      -- Boolean;
      A_Right_Wow_Relay               := False;      -- Boolean;
      A_Tad_Cb                        := False;      -- Boolean;
      A_Kias_Adc                      := 0.0;      -- Length_Types.Knots;
      A_Pitch_Rate                    := 0.0;      -- Angle_Types.Radians_per_Sec;
      A_Pressure_Altitude             := 0.0;      -- Length_Types.Feet;
      A_Engine_Torque                 := 0.0;      -- Float;
      A_Rudder_Trim_Actuated_Position := 0.0;      -- Jpats_Secondary_Flight_Controls_Types.Rudder_Trim_Position_Type;
      A_Trim_Disconnect               := False;      -- Boolean;
      A_Trim_Interrupt                := False;      -- Boolean;
      A_Tad_Fault                     := False;      -- Boolean;
      A_Rudder_Trim_Switch_Left       := False;      -- Boolean;
      A_Rudder_Trim_Switch_Right      := False;      -- Boolean;
      A_Tad_On_Switch                 := False;      -- Boolean;

      Tad.Update
        (An_Instance                   => A_Tad                          ,                 -- in out Instance;
         Iconst                        => Iconst                         ,                 -- in     Float;
         Left_Wow_Relay                => A_Left_Wow_Relay               ,                 -- in     Boolean;
         Right_Wow_Relay               => A_Right_Wow_Relay              ,                 -- in     Boolean;
         Tad_Cb                        => A_Tad_Cb                       ,                 -- in     Boolean;
         Kias_Adc                      => A_Kias_Adc                     ,                 -- in     Length_Types.Knots;
         Pitch_Rate                    => A_Pitch_Rate                   ,                 -- in     Angle_Types.Radians_per_Sec;
         Pressure_Altitude             => A_Pressure_Altitude            ,                 -- in     Length_Types.Feet;
         Engine_Torque                 => A_Engine_Torque                ,                 -- in     Float;
         Rudder_Trim_Actuated_Position => A_Rudder_Trim_Actuated_Position,
                                                     -- in     Jpats_Secondary_Flight_Controls_Types.Rudder_Trim_Position_Type;
         Trim_Disconnect               => A_Trim_Disconnect              ,                 -- in     Boolean;
         Trim_Interrupt                => A_Trim_Interrupt               ,                 -- in     Boolean;
         Tad_Fault                     => A_Tad_Fault                    ,                 -- in     Boolean;
         Rudder_Trim_Switch_Left       => A_Rudder_Trim_Switch_Left      ,                 -- in     Boolean;
         Rudder_Trim_Switch_Right      => A_Rudder_Trim_Switch_Right     ,                 -- in     Boolean;
         Tad_On_Switch                 => A_Tad_On_Switch                );                 -- in     Boolean);


   end Test_2;





   -------------------------------------------------------------------------------
   -- Test_3
   --
   -- Inputs           :
   -- Expected results :
   -- Purpose          :

   Test_3 : declare
      -------------------------------------------------------------------------------
      -------------------------------------------------------------------------------

      Interval : Duration := 10.0;
      Stop_Time :  Ada.Calendar.Time := Ada.Calendar.Clock + Interval;

      Half_Stop_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.50000) * Interval;

      One_Third_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.66666) * Interval;
      Two_Thirds_Time     : Ada.Calendar.Time := Stop_Time - Duration(0.33333) * Interval;

      One_Quarter_Time    : Ada.Calendar.Time := Stop_Time - Duration(0.75000) * Interval;
      Two_Quarter_Time    : Ada.Calendar.Time := Stop_Time - Duration(0.50000) * Interval;
      Three_Quarter_Time  : Ada.Calendar.Time := Stop_Time - Duration(0.25000) * Interval;

      Reset_In_Time       : Ada.Calendar.Time := Stop_Time - Duration(0.2000) * Interval;
      Reset_Off_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.1660) * Interval;

      function Now return Ada.Calendar.Time renames Ada.Calendar.Clock;

      Iconst : Float := 0.06666666;
      I : Integer := 0;

      In_First_Quarter  : Boolean := true;
      In_Second_Quarter : Boolean := true;
      In_Third_Quarter  : Boolean := true;
      In_Fourth_Quarter : Boolean := true;

      -------------------------------------------------------------------------------
      -------------------------------------------------------------------------------

   begin



      null;
   end Test_3;


end Tad_Ctd;
