-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Class_Test_Result_File;
with Ada.Calendar; use Ada.Calendar;

with Speedbrake;

procedure Speedbrake_Ctd is


begin

   declare

      -------------------------------------------------------------------------------
      -------------------------------------------------------------------------------

      Interval : Duration := 10.0;
      Stop_Time :  Ada.Calendar.Time := Ada.Calendar.Clock + Interval;

      Half_Stop_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.50000) * Interval;

      One_Third_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.66666) * Interval;
      Two_Thirds_Time     : Ada.Calendar.Time := Stop_Time - Duration(0.33333) * Interval;

      One_Quarter_Time    : Ada.Calendar.Time := Stop_Time - Duration(0.75000) * Interval;
      Two_Quarter_Time    : Ada.Calendar.Time := Stop_Time - Duration(0.50000) * Interval;
      Three_Quarter_Time  : Ada.Calendar.Time := Stop_Time - Duration(0.25000) * Interval;

      Reset_In_Time       : Ada.Calendar.Time := Stop_Time - Duration(0.2000) * Interval;
      Reset_Off_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.1660) * Interval;

      function Now return Ada.Calendar.Time renames Ada.Calendar.Clock;

      Iconst : Float := 0.06666666;
      I : Integer := 0;

      In_First_Quarter  : Boolean := true;
      In_Second_Quarter : Boolean := true;
      In_Third_Quarter  : Boolean := true;
      In_Fourth_Quarter : Boolean := true;

      In_First_Quarter_Timer  : Float := 0.0;
      In_Second_Quarter_Timer : float := 0.0;
      In_Third_Quarter_Timer  : float := 0.0;
      In_Fourth_Quarter_Timer : float := 0.0;

      In_First_Quarter_Latch  : Boolean := true;
      In_Second_Quarter_Latch : Boolean := true;
      In_Third_Quarter_Latch  : Boolean := true;
      In_Fourth_Quarter_Latch : Boolean := true;

      -------------------------------------------------------------------------------
      -------------------------------------------------------------------------------

      A_Brake : Speedbrake.Instance;
      K_Hyd : Float range 0.0..1.0 := 1.0;

      Test_1  : Boolean;
      Test_2  : Boolean;
      Test_3  : Boolean;
      Test_4  : Boolean;
      Test_5  : Boolean;
      Test_6  : Boolean;
      Test_7  : Boolean;
      Test_8  : Boolean;
      Test_9  : Boolean;
      Test_10 : Boolean;
      Test_11 : Boolean;
      Test_12 : Boolean;
      Test_13 : Boolean;
      Test_14 : Boolean;
      Test_15 : Boolean;


   begin

      Speedbrake.Initialize (A_Brake);
      Test_1 := Speedbrake.Position (A_Brake) = 0.0;
      Test_2 := Speedbrake.Load (A_Brake) = 0.0;
      Test_3 := Speedbrake.Hydraulic_Load (A_Brake) = 0.0;
      Class_Test_Result_File.Report_Case_Status (Success => Test_1, Number => 1);
      Class_Test_Result_File.Report_Case_Status (Success => Test_2, Number => 2);
      Class_Test_Result_File.Report_Case_Status (Success => Test_3, Number => 3);

      while Now < Stop_Time
      loop

         if Now < One_Quarter_Time then

            Speedbrake.Update
              (An_Instance    => A_Brake, -- in out Instance;
               Iconst         => Iconst, -- in     Float;
               Flaps_Sel_Up   => True, -- in     Boolean;
               Pcl_Max        => False, -- in     Boolean;
               Electrical_Pwr => False, -- in     Boolean;
               Hyd_Fcn        => K_Hyd, -- in     Jpats_Hydraulics_Types.Normalized_Pressure_Type;
               Dynamic_Px     => 0.0, -- in     Force_Types.Pounds_per_Sq_Feet;
               Switch_Extend  => True, -- in     Boolean;
               Switch_Retract => False); -- in     Boolean);

            if In_First_Quarter_Latch and In_First_Quarter_Timer > 40.0 then
              Test_4 := Speedbrake.Position (A_Brake) = 0.0;
              Test_5 := Speedbrake.Load (A_Brake) = 0.0;
              Test_6 := Speedbrake.Hydraulic_Load (A_Brake) = 0.0;
              Class_Test_Result_File.Report_Case_Status (Success => Test_4, Number => 4);
              Class_Test_Result_File.Report_Case_Status (Success => Test_5, Number => 5);
              Class_Test_Result_File.Report_Case_Status (Success => Test_6, Number => 6);
              In_First_Quarter_Latch := False;
            end if;
            In_First_Quarter_Timer := In_First_Quarter_Timer + Iconst;
         elsif Now < Two_Quarter_Time then

            Speedbrake.Update
              (An_Instance    => A_Brake, -- in out Instance;
               Iconst         => Iconst, -- in     Float;
               Flaps_Sel_Up   => True, -- in     Boolean;
               Pcl_Max        => False, -- in     Boolean;
               Electrical_Pwr => True, -- in     Boolean;
               Hyd_Fcn        => K_Hyd, -- in     Jpats_Hydraulics_Types.Normalized_Pressure_Type;
               Dynamic_Px     => 0.0, -- in     Force_Types.Pounds_per_Sq_Feet;
               Switch_Extend  => False, -- in     Boolean;
               Switch_Retract => True); -- in     Boolean);

            if In_Second_Quarter_Latch and In_Second_Quarter_Timer > 40.0 then
              Test_7 := Speedbrake.Position (A_Brake) = 0.0;
              Test_8 := Speedbrake.Load (A_Brake) = 0.465;
              Test_9 := Speedbrake.Hydraulic_Load (A_Brake) = 0.0;
              Class_Test_Result_File.Report_Case_Status (Success => Test_7, Number => 7);
              Class_Test_Result_File.Report_Case_Status (Success => Test_8, Number => 8);
              Class_Test_Result_File.Report_Case_Status (Success => Test_9, Number => 9);
              In_Second_Quarter_Latch := False;
            end if;
            In_Second_Quarter_Timer := In_Second_Quarter_Timer + Iconst;
         elsif Now < Three_Quarter_Time then

            Speedbrake.Update
              (An_Instance    => A_Brake, -- in out Instance;
               Iconst         => Iconst, -- in     Float;
               Flaps_Sel_Up   => True, -- in     Boolean;
               Pcl_Max        => False, -- in     Boolean;
               Electrical_Pwr => True, -- in     Boolean;
               Hyd_Fcn        => K_Hyd, -- in     Jpats_Hydraulics_Types.Normalized_Pressure_Type;
               Dynamic_Px     => 0.0, -- in     Force_Types.Pounds_per_Sq_Feet;
               Switch_Extend  => True, -- in     Boolean;
               Switch_Retract => False); -- in     Boolean);

            if In_Third_Quarter_Latch and In_Third_Quarter_Timer > 45.0 then
              Test_10 := Speedbrake.Position (A_Brake) = 1.0;
              Test_11 := Speedbrake.Load (A_Brake) = 0.465;
              Test_12 := Speedbrake.Hydraulic_Load (A_Brake) = 0.0;
              Class_Test_Result_File.Report_Case_Status (Success => Test_10, Number => 10);
              Class_Test_Result_File.Report_Case_Status (Success => Test_11, Number => 11);
              Class_Test_Result_File.Report_Case_Status (Success => Test_12, Number => 12);
              In_Third_Quarter_Latch := False;
            end if;
            In_Third_Quarter_Timer := In_Third_Quarter_Timer + Iconst;
         else

            Speedbrake.Update
              (An_Instance    => A_Brake, -- in out Instance;
               Iconst         => Iconst, -- in     Float;
               Flaps_Sel_Up   => True, -- in     Boolean;
               Pcl_Max        => False, -- in     Boolean;
               Electrical_Pwr => True, -- in     Boolean;
               Hyd_Fcn        => K_Hyd, -- in     Jpats_Hydraulics_Types.Normalized_Pressure_Type;
               Dynamic_Px     => 0.0, -- in     Force_Types.Pounds_per_Sq_Feet;
               Switch_Extend  => False, -- in     Boolean;
               Switch_Retract => True); -- in     Boolean);

            if In_Fourth_Quarter_Latch and In_Fourth_Quarter_Timer > 40.0 then
              Test_13 := Speedbrake.Position (A_Brake) = 0.0;
              Test_14 := Speedbrake.Load (A_Brake) = 0.465;
              Test_15 := Speedbrake.Hydraulic_Load (A_Brake) = 0.0;
              Class_Test_Result_File.Report_Case_Status (Success => Test_13, Number => 13);
              Class_Test_Result_File.Report_Case_Status (Success => Test_14, Number => 14);
              Class_Test_Result_File.Report_Case_Status (Success => Test_15, Number => 15);
              In_Fourth_Quarter_Latch := False;
            end if;
            In_Fourth_Quarter_Timer := In_Fourth_Quarter_Timer + Iconst;
         end if;

      end loop;

   end;



   declare
      -------------------------------------------------------------------------------
      -------------------------------------------------------------------------------

      Interval : Duration := 10.0;
      Stop_Time :  Ada.Calendar.Time := Ada.Calendar.Clock + Interval;

      Half_Stop_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.50000) * Interval;

      One_Third_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.66666) * Interval;
      Two_Thirds_Time     : Ada.Calendar.Time := Stop_Time - Duration(0.33333) * Interval;

      One_Quarter_Time    : Ada.Calendar.Time := Stop_Time - Duration(0.75000) * Interval;
      Two_Quarter_Time    : Ada.Calendar.Time := Stop_Time - Duration(0.50000) * Interval;
      Three_Quarter_Time  : Ada.Calendar.Time := Stop_Time - Duration(0.25000) * Interval;

      Reset_In_Time       : Ada.Calendar.Time := Stop_Time - Duration(0.2000) * Interval;
      Reset_Off_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.1660) * Interval;

      function Now return Ada.Calendar.Time renames Ada.Calendar.Clock;

      Iconst : Float := 0.06666666;
      I : Integer := 0;

      In_First_Quarter  : Boolean := true;
      In_Second_Quarter : Boolean := true;
      In_Third_Quarter  : Boolean := true;
      In_Fourth_Quarter : Boolean := true;

      -------------------------------------------------------------------------------
      -------------------------------------------------------------------------------
   begin
      null;
   end;
   declare
      -------------------------------------------------------------------------------
      -------------------------------------------------------------------------------

      Interval : Duration := 10.0;
      Stop_Time :  Ada.Calendar.Time := Ada.Calendar.Clock + Interval;

      Half_Stop_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.50000) * Interval;

      One_Third_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.66666) * Interval;
      Two_Thirds_Time     : Ada.Calendar.Time := Stop_Time - Duration(0.33333) * Interval;

      One_Quarter_Time    : Ada.Calendar.Time := Stop_Time - Duration(0.75000) * Interval;
      Two_Quarter_Time    : Ada.Calendar.Time := Stop_Time - Duration(0.50000) * Interval;
      Three_Quarter_Time  : Ada.Calendar.Time := Stop_Time - Duration(0.25000) * Interval;

      Reset_In_Time       : Ada.Calendar.Time := Stop_Time - Duration(0.2000) * Interval;
      Reset_Off_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.1660) * Interval;

      function Now return Ada.Calendar.Time renames Ada.Calendar.Clock;

      Iconst : Float := 0.06666666;
      I : Integer := 0;

      In_First_Quarter  : Boolean := true;
      In_Second_Quarter : Boolean := true;
      In_Third_Quarter  : Boolean := true;
      In_Fourth_Quarter : Boolean := true;

      -------------------------------------------------------------------------------
      -------------------------------------------------------------------------------
   begin
      null;
   end;



end Speedbrake_Ctd;

