-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------



with Class_Test_Result_File;
with Ada.Calendar; use Ada.Calendar;

with Rudder_Trim;
with Electrical_Units_Types;

procedure Rudder_Trim_Ctd is


begin

   declare

      -------------------------------------------------------------------------------
      -------------------------------------------------------------------------------

      Interval : Duration := 10.0;
      Stop_Time :  Ada.Calendar.Time := Ada.Calendar.Clock + Interval;

      Half_Stop_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.50000) * Interval;

      One_Third_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.66666) * Interval;
      Two_Thirds_Time     : Ada.Calendar.Time := Stop_Time - Duration(0.33333) * Interval;

      One_Quarter_Time    : Ada.Calendar.Time := Stop_Time - Duration(0.75000) * Interval;
      Two_Quarter_Time    : Ada.Calendar.Time := Stop_Time - Duration(0.50000) * Interval;
      Three_Quarter_Time  : Ada.Calendar.Time := Stop_Time - Duration(0.25000) * Interval;

      Reset_In_Time       : Ada.Calendar.Time := Stop_Time - Duration(0.2000) * Interval;
      Reset_Off_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.1660) * Interval;

      function Now return Ada.Calendar.Time renames Ada.Calendar.Clock;

      Iconst : Float := 0.06666666;
      I : Integer := 0;

      In_First_Quarter  : Boolean := true;
      In_Second_Quarter : Boolean := true;
      In_Third_Quarter  : Boolean := true;
      In_Fourth_Quarter : Boolean := true;

      In_First_Quarter_Timer  : Float := 0.0;
      In_Second_Quarter_Timer : float := 0.0;
      In_Third_Quarter_Timer  : float := 0.0;
      In_Fourth_Quarter_Timer : float := 0.0;

      In_First_Quarter_Latch  : Boolean := true;
      In_Second_Quarter_Latch : Boolean := true;
      In_Third_Quarter_Latch  : Boolean := true;
      In_Fourth_Quarter_Latch : Boolean := true;

      -------------------------------------------------------------------------------
      -------------------------------------------------------------------------------

      A_Rud_Trim : Rudder_Trim.Instance;

      Test_1  : Boolean;
      Test_2  : Boolean;
      Test_3  : Boolean;
      Test_4  : Boolean;
      Test_5  : Boolean;
      Test_6  : Boolean;
      Test_7  : Boolean;
      Test_8  : Boolean;
      Test_9  : Boolean;
      Test_10 : Boolean;

   begin


      Rudder_Trim.Initialize (A_Rud_Trim);
      Test_1 := Rudder_Trim.Position (A_Rud_Trim) = 0.0;
      Test_2 := Rudder_Trim.Load (A_Rud_Trim) = 0.0;
      Class_Test_Result_File.Report_Case_Status (Success => Test_1, Number => 1);
      Class_Test_Result_File.Report_Case_Status (Success => Test_2, Number => 2);

      while Now < Stop_Time
      loop

         if Now < One_Quarter_Time then

            Rudder_Trim.Update
              (An_Instance              => A_Rud_Trim,
               Iconst                   => Iconst,
               Rud_Trim_Cb              => False, -- in     Boolean;
               Tad_On                   => False, -- in     Boolean;
               Trim_Interrupt           => False, -- in     Boolean;
               Trim_Disconnect          => False, -- in     Boolean;
               Tad_Command              => 0.0, -- in     Float;
               Rudder_Trim_Switch_Left  => True, -- in     Boolean;
               Rudder_Trim_Switch_Right => False, -- in     Boolean;
               Rudder_Angle             => 0.0); -- in     Float);


            if In_First_Quarter_Latch and In_First_Quarter_Timer > 40.0 then
               Test_3 := Rudder_Trim.Position (A_Rud_Trim) = 0.0;
               Test_4 := Rudder_Trim.Load (A_Rud_Trim) = 0.0;
               Class_Test_Result_File.Report_Case_Status (Success => Test_3, Number => 3);
               Class_Test_Result_File.Report_Case_Status (Success => Test_4, Number => 4);
               In_First_Quarter_Latch := False;
            end if;
            In_First_Quarter_Timer := In_First_Quarter_Timer + Iconst;
         elsif Now < Two_Quarter_Time then


            Rudder_Trim.Update
              (An_Instance              => A_Rud_Trim,
               Iconst                   => Iconst,
               Rud_Trim_Cb              => True, -- in     Boolean;
               Tad_On                   => False, -- in     Boolean;
               Trim_Interrupt           => False, -- in     Boolean;
               Trim_Disconnect          => False, -- in     Boolean;
               Tad_Command              => 0.0, -- in     Float;
               Rudder_Trim_Switch_Left  => True, -- in     Boolean;
               Rudder_Trim_Switch_Right => False, -- in     Boolean;
               Rudder_Angle             => 0.0); -- in     Float);

            if In_Second_Quarter_Latch and In_Second_Quarter_Timer > 40.0 then
               Test_5 := Rudder_Trim.Position (A_Rud_Trim) = -6.0;
               Test_6 := Rudder_Trim.Load (A_Rud_Trim) = 0.0;
               Class_Test_Result_File.Report_Case_Status (Success => Test_5, Number => 5);
               Class_Test_Result_File.Report_Case_Status (Success => Test_6, Number => 6);
               In_Second_Quarter_Latch := False;
            end if;
            In_Second_Quarter_Timer := In_Second_Quarter_Timer + Iconst;
         elsif Now < Three_Quarter_Time then

            Rudder_Trim.Update
              (An_Instance              => A_Rud_Trim,
               Iconst                   => Iconst,
               Rud_Trim_Cb              => True, -- in     Boolean;
               Tad_On                   => False, -- in     Boolean;
               Trim_Interrupt           => False, -- in     Boolean;
               Trim_Disconnect          => False, -- in     Boolean;
               Tad_Command              => 0.0, -- in     Float;
               Rudder_Trim_Switch_Left  => False, -- in     Boolean;
               Rudder_Trim_Switch_Right => True, -- in     Boolean;
               Rudder_Angle             => 0.0); -- in     Float);

            if In_Third_Quarter_Latch and In_Third_Quarter_Timer > 45.0 then
               Test_7 := Rudder_Trim.Position (A_Rud_Trim) = 11.0;
               Test_8 := Rudder_Trim.Load (A_Rud_Trim) = 0.0;
               Class_Test_Result_File.Report_Case_Status (Success => Test_7, Number => 7);
               Class_Test_Result_File.Report_Case_Status (Success => Test_8, Number => 8);
               In_Third_Quarter_Latch := False;
            end if;
            In_Third_Quarter_Timer := In_Third_Quarter_Timer + Iconst;
         else

            Rudder_Trim.Update
              (An_Instance              => A_Rud_Trim,
               Iconst                   => Iconst,
               Rud_Trim_Cb              => True, -- in     Boolean;
               Tad_On                   => False, -- in     Boolean;
               Trim_Interrupt           => True, -- in     Boolean;
               Trim_Disconnect          => False, -- in     Boolean;
               Tad_Command              => 0.0, -- in     Float;
               Rudder_Trim_Switch_Left  => True, -- in     Boolean;
               Rudder_Trim_Switch_Right => False, -- in     Boolean;
               Rudder_Angle             => 0.0); -- in     Float);

            if In_Fourth_Quarter_Latch and In_Fourth_Quarter_Timer > 40.0 then
               Test_9  := Rudder_Trim.Position (A_Rud_Trim) = 11.0;
               Test_10 := Rudder_Trim.Load (A_Rud_Trim) = 0.0;
               Class_Test_Result_File.Report_Case_Status (Success => Test_9, Number => 9);
               Class_Test_Result_File.Report_Case_Status (Success => Test_10, Number => 10);
               In_Fourth_Quarter_Latch := False;
            end if;
            In_Fourth_Quarter_Timer := In_Fourth_Quarter_Timer + Iconst;
         end if;

      end loop;


   end;



   declare
      -------------------------------------------------------------------------------
      -------------------------------------------------------------------------------

      Interval : Duration := 10.0;
      Stop_Time :  Ada.Calendar.Time := Ada.Calendar.Clock + Interval;

      Half_Stop_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.50000) * Interval;

      One_Third_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.66666) * Interval;
      Two_Thirds_Time     : Ada.Calendar.Time := Stop_Time - Duration(0.33333) * Interval;

      One_Quarter_Time    : Ada.Calendar.Time := Stop_Time - Duration(0.75000) * Interval;
      Two_Quarter_Time    : Ada.Calendar.Time := Stop_Time - Duration(0.50000) * Interval;
      Three_Quarter_Time  : Ada.Calendar.Time := Stop_Time - Duration(0.25000) * Interval;

      Reset_In_Time       : Ada.Calendar.Time := Stop_Time - Duration(0.2000) * Interval;
      Reset_Off_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.1660) * Interval;

      function Now return Ada.Calendar.Time renames Ada.Calendar.Clock;

      Iconst : Float := 0.06666666;
      I : Integer := 0;

      In_First_Quarter  : Boolean := true;
      In_Second_Quarter : Boolean := true;
      In_Third_Quarter  : Boolean := true;
      In_Fourth_Quarter : Boolean := true;

      -------------------------------------------------------------------------------
      -------------------------------------------------------------------------------
   begin
      null;
   end;
   declare
      -------------------------------------------------------------------------------
      -------------------------------------------------------------------------------

      Interval : Duration := 10.0;
      Stop_Time :  Ada.Calendar.Time := Ada.Calendar.Clock + Interval;

      Half_Stop_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.50000) * Interval;

      One_Third_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.66666) * Interval;
      Two_Thirds_Time     : Ada.Calendar.Time := Stop_Time - Duration(0.33333) * Interval;

      One_Quarter_Time    : Ada.Calendar.Time := Stop_Time - Duration(0.75000) * Interval;
      Two_Quarter_Time    : Ada.Calendar.Time := Stop_Time - Duration(0.50000) * Interval;
      Three_Quarter_Time  : Ada.Calendar.Time := Stop_Time - Duration(0.25000) * Interval;

      Reset_In_Time       : Ada.Calendar.Time := Stop_Time - Duration(0.2000) * Interval;
      Reset_Off_Time      : Ada.Calendar.Time := Stop_Time - Duration(0.1660) * Interval;

      function Now return Ada.Calendar.Time renames Ada.Calendar.Clock;

      Iconst : Float := 0.06666666;
      I : Integer := 0;

      In_First_Quarter  : Boolean := true;
      In_Second_Quarter : Boolean := true;
      In_Third_Quarter  : Boolean := true;
      In_Fourth_Quarter : Boolean := true;

      -------------------------------------------------------------------------------
      -------------------------------------------------------------------------------
   begin
      null;
   end;


end Rudder_Trim_Ctd;
