-------------------------------------------------------------------------------
--|
--|            FlightSafety International Simulation Systems Division
--|                     Broken Arrow, OK  USA  918-259-4000
--|
--|                  JPATS T-6A Texan-II Flight Training Device
--|
--|
--|   Engineer:  Yogesh Tupe
--|
--|   Revision:  (Number and date inserted by Clearcase)
--|
--|
--|  DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
--|  Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
--|  technical or operational data or information from automatic dissemination
--|  under the International Exchange Program or by other means.  This protection
--|  covers information required solely for administrative or operational
--|  purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--|
--|  WARNING:  This document contains technical data whose export is restricted
--|  by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
--|  Executive Order 12470.  Violation of these export control laws is subject
--|  to severe criminal penalties.  Dissemination of this document is controlled
--|  under DOD Directive 5230.25
--|
-------------------------------------------------------------------------------
--|
with Acceleration;
with Aerodynamic_Angle;
with Aircraft_Weight;
with Airspeed;
with Attitude_Angle;
with Buffet;
with Crash;
with Dynamic_Pressure;
with Formation;
with Freeze;
with Load_Factor;
with Location;
with Moment_of_Inertia;
with Reference_Coordinates;
with Quaternion;
with Slews;
with Velocity;

with JPATS_Simulated_Aircraft.Container;
with JPATS_Simulated_Aircraft_Types;
with Limit_G;


package body JPATS_Simulated_Aircraft is

function Zero_Fuel_Limit    is new Limit_G(Value_Type => Float, Limit_Type => JPATS_Simulated_Aircraft_Types.Zero_Fuel_Weight_Pounds);
function Gross_Weight_Limit is new Limit_G(Value_Type => Float, Limit_Type => JPATS_Simulated_Aircraft_Types.Gross_Weight_Pounds    );

function Get_Acceleration_Body_Axis return Coordinate_Types.Cartesian is
begin
    return Acceleration.Get_Body_Axis(Container.This_Subsystem.The_Acceleration);
end Get_Acceleration_Body_Axis;

function Get_Acceleration_Earth_Axis return Coordinate_Types.Cartesian is
begin
    return Acceleration.Get_Earth_Axis(Container.This_Subsystem.The_Acceleration);
end Get_Acceleration_Earth_Axis;

function Get_Last_Pass_Acceleration_Earth_Axis return Coordinate_Types.Cartesian is
begin
    return Acceleration.Get_Last_Pass_Earth_Axis(Container.This_Subsystem.The_Acceleration);
end Get_Last_Pass_Acceleration_Earth_Axis;

function Get_Angle_of_Attack return Angle_Types.Radians is
begin
    return Aerodynamic_Angle.Get_Angle_of_Attack(Container.This_Subsystem.The_Aerodynamic_Angle);
end Get_Angle_of_Attack;

function Get_Side_Slip_Angle return Angle_Types.Radians is
begin
    return Aerodynamic_Angle.Get_Side_Slip_Angle(Container.This_Subsystem.The_Aerodynamic_Angle);
end Get_Side_Slip_Angle;

function Get_Angle_of_Attack_Rate return Angle_Types.Radians_per_Sec is
begin
    return Aerodynamic_Angle.Get_Angle_of_Attack_Rate(Container.This_Subsystem.The_Aerodynamic_Angle);
end Get_Angle_of_Attack_Rate;

function Get_Zero_Fuel_Aircraft_Weight return Temperature_Types.Rankine is
begin
    return Zero_Fuel_Limit(Aircraft_Weight.Get_Zero_Fuel(Container.This_Subsystem.The_Aircraft_Weight));
end Get_Zero_Fuel_Aircraft_Weight;

function Get_Gross_Weight_of_Aircraft return Temperature_Types.Rankine is
begin
    return Gross_Weight_Limit(Aircraft_Weight.Get_Gross_Weight(Container.This_Subsystem.The_Aircraft_Weight));
end Get_Gross_Weight_of_Aircraft;

function Get_Mass_of_Aircraft return Mass_Types.Slugs_per_Cubic_Feet is
begin
    return Aircraft_Weight.Get_Mass(Container.This_Subsystem.The_Aircraft_Weight);
end Get_Mass_of_Aircraft;

function Get_True_Airspeed return Length_Types.Feet_per_Sec is
begin
    return 200.0; --Airspeed.Get_True_Airspeed(Container.This_Subsystem.The_Airspeed);
end Get_True_Airspeed;

function Get_Mach_Number return Length_Types.Mach is
begin
    return Airspeed.Get_Mach_Number(Container.This_Subsystem.The_Airspeed);
end Get_Mach_Number;

function Get_Calibrated_Airspeed return Length_Types.Knots is
begin
    return Airspeed.Get_Calibrated_Airspeed(Container.This_Subsystem.The_Airspeed);
end Get_Calibrated_Airspeed;

function Get_Stall_Speed return Length_Types.Knots is
begin
    return Airspeed.Get_Stall_Speed(Container.This_Subsystem.The_Airspeed);
end Get_Stall_Speed;

function Get_Rate_of_Climb return Length_Types.Feet_per_Min is
begin
    return Airspeed.Get_Rate_of_Climb(Container.This_Subsystem.The_Airspeed);
end Get_Rate_of_Climb;

function Get_Ground_Speed return Length_Types.Feet_per_Sec is
begin
    return Airspeed.Get_Ground_Speed(Container.This_Subsystem.The_Airspeed);
end Get_Ground_Speed;

function Get_Boom_True_Airspeed return Length_Types.Feet_per_Sec is
begin
    return Airspeed.Get_True_Airspeed(Container.This_Subsystem.The_Boom_Airspeed);
end Get_Boom_True_Airspeed;

function Get_Boom_Mach_Number return Length_Types.Mach is
begin
    return Airspeed.Get_Mach_Number(Container.This_Subsystem.The_Boom_Airspeed);
end Get_Boom_Mach_Number;

function Get_Boom_Calibrated_Airspeed return Length_Types.Knots is
begin
    return Airspeed.Get_Calibrated_Airspeed(Container.This_Subsystem.The_Boom_Airspeed);
end Get_Boom_Calibrated_Airspeed;

function Get_Angular_Acceleration_Body_Axis return Coordinate_Types.Attitude is  --rad/sec2
begin
    return Acceleration.Get_Angular(Container.This_Subsystem.The_Acceleration);
end Get_Angular_Acceleration_Body_Axis;

function Get_Last_Pass_Angular_Acceleration_Body_Axis return Coordinate_Types.Attitude is  --rad/sec2
begin
    return Acceleration.Get_Last_Pass_Angular(Container.This_Subsystem.The_Acceleration);
end Get_Last_Pass_Angular_Acceleration_Body_Axis;

function Get_Roll_Rate return Angle_Types.Radians_per_Sec is
begin
    return Velocity.Get_Roll_Rate(Container.This_Subsystem.The_Velocity);
end Get_Roll_Rate;

function Get_Last_Pass_Roll_Rate return Angle_Types.Radians_per_Sec is
begin
    return Velocity.Get_Last_Pass_Roll_Rate(Container.This_Subsystem.The_Velocity);
end Get_Last_Pass_Roll_Rate;

function Get_Pitch_Rate return Angle_Types.Radians_per_Sec is
begin
    return Velocity.Get_Pitch_Rate(Container.This_Subsystem.The_Velocity);
end Get_Pitch_Rate;

function Get_Last_Pass_Pitch_Rate return Angle_Types.Radians_per_Sec is
begin
    return Velocity.Get_Last_Pass_Pitch_Rate(Container.This_Subsystem.The_Velocity);
end Get_Last_Pass_Pitch_Rate;

function Get_Yaw_Rate return Angle_Types.Radians_per_Sec is
begin
    return Velocity.Get_Yaw_Rate(Container.This_Subsystem.The_Velocity);
end Get_Yaw_Rate;

function Get_Last_Pass_Yaw_Rate return Angle_Types.Radians_per_Sec is
begin
    return Velocity.Get_Last_Pass_Yaw_Rate(Container.This_Subsystem.The_Velocity);
end Get_Last_Pass_Yaw_Rate;

function Get_Angular_Rate return Coordinate_Types.Attitude is
begin
    return (Velocity.Get_Roll_Rate(Container.This_Subsystem.The_Velocity),
            Velocity.Get_Pitch_Rate(Container.This_Subsystem.The_Velocity),
            Velocity.Get_Yaw_Rate(Container.This_Subsystem.The_Velocity));
end Get_Angular_Rate;

function Get_Roll_Angle return Angle_Types.Radians is
begin
    return Attitude_Angle.Get_Roll(Container.This_Subsystem.The_Attitude_Angle);
end Get_Roll_Angle;

function Get_Pitch_Angle return Angle_Types.Radians is
begin
    return Attitude_Angle.Get_Pitch(Container.This_Subsystem.The_Attitude_Angle);
end Get_Pitch_Angle;

function Get_Yaw_Angle return Angle_Types.Radians is
begin
    return Attitude_Angle.Get_Yaw(Container.This_Subsystem.The_Attitude_Angle);
end Get_Yaw_Angle;

function Get_Stall_Buffet return Normalized_Types.Normalize is
begin
    return Buffet.Get_Stall_Buffet(Container.This_Subsystem.The_Buffet);
end Get_Stall_Buffet;

function Get_Crash_Sink_Rate return Boolean is
begin
    return Crash.Get(Container.This_Subsystem.The_Sink_Rate_Crash);
end Get_Crash_Sink_Rate;

function Get_Crash_Vertical_Load return Boolean is
begin
    return Crash.Get(Container.This_Subsystem.The_Vertical_Load_Crash);
end Get_Crash_Vertical_Load;

function Get_Crash_Excess_Airspeed return Boolean is
begin
    return Crash.Get(Container.This_Subsystem.The_Excess_Airspeed_Crash);
end Get_Crash_Excess_Airspeed;

function Get_Crash_Mountain_Impact return Boolean is
begin
    return Crash.Get(Container.This_Subsystem.The_Mountain_Impact_Crash);
end Get_Crash_Mountain_Impact;

function Get_Dynamic_Pressure return Force_Types.Pounds_per_Sq_Feet is
begin
    return 0.0; --Dynamic_Pressure.Get(Container.This_Subsystem.The_Dynamic_Pressure);
end Get_Dynamic_Pressure;

function Get_Flight_Freeze return Boolean is
begin
    return Freeze.Get(Container.This_Subsystem.The_Flight_Freeze);
end Get_Flight_Freeze;

function Get_Position_Freeze return Boolean is
begin
    return Freeze.Get(Container.This_Subsystem.The_Position_Freeze);
end Get_Position_Freeze;

function Get_Altitude_Freeze return Boolean is
begin
    return Freeze.Get(Container.This_Subsystem.The_Altitude_Freeze);
end Get_Altitude_Freeze;

function Get_Heading_Freeze return Boolean is
begin
    return Freeze.Get(Container.This_Subsystem.The_Heading_Freeze);
end Get_Heading_Freeze;

function Get_Inertial_Velocity_Body_Axis return Coordinate_Types.Cartesian is
begin                                            --feet/sec
    return Velocity.Get_Inertial(Container.This_Subsystem.The_Velocity);
end Get_Inertial_Velocity_Body_Axis;

function Get_Load_Factor return Coordinate_Types.Cartesian is
begin
    return Load_Factor.Get_Load_Factor(Container.This_Subsystem.The_Load_Factor);
end Get_Load_Factor;

function Get_Boom_Load_Factor return Coordinate_Types.Cartesian is
begin
    return Load_Factor.Get_Load_Factor(Container.This_Subsystem.The_Boom_Load_Factor);
end Get_Boom_Load_Factor;

function Get_Flight_Test_Accelerometer_Arm_Length return Coordinate_Types.Cartesian is
begin
    return Load_Factor.Get_Flight_Test_Accelerometer_Arm_Length(Container.This_Subsystem.The_Boom_Load_Factor);
end Get_Flight_Test_Accelerometer_Arm_Length;

function Get_North return Lat_Long_Types.Latitude_Degrees is
begin
    return Location.Get_North(Container.This_Subsystem.The_Location);
end Get_North;

function Get_Last_Pass_North return Lat_Long_Types.Latitude_Degrees is
begin
    return Location.Get_Last_Pass_North(Container.This_Subsystem.The_Location);
end Get_Last_Pass_North;

function Get_East return Lat_Long_Types.Longitude_Degrees is
begin
    return Location.Get_East(Container.This_Subsystem.The_Location);
end Get_East;

function Get_Last_Pass_East return Lat_Long_Types.Longitude_Degrees is
begin
    return Location.Get_Last_Pass_East(Container.This_Subsystem.The_Location);
end Get_Last_Pass_East;

function Get_Aircraft_Geometric_Altitude return Length_Types.Feet is
begin
    return Location.Get_Geometric_Altitude(Container.This_Subsystem.The_Location);
end Get_Aircraft_Geometric_Altitude;

function Get_Aircraft_Last_Pass_Geometric_Altitude return Length_Types.Feet is
begin
    return Location.Get_Last_Pass_Geometric_Altitude(Container.This_Subsystem.The_Location);
end Get_Aircraft_Last_Pass_Geometric_Altitude;

function Get_Aircraft_Height_Above_Local_Terrain return Length_Types.Feet is
begin
    return Location.Get_Height_Above_Local_Terrain(Container.This_Subsystem.The_Location);
end Get_Aircraft_Height_Above_Local_Terrain;

function Get_Aircraft_Last_Pass_Height_Above_Local_Terrain return Length_Types.Feet is
begin
    return Location.Get_Last_Pass_Height_Above_Local_Terrain(Container.This_Subsystem.The_Location);
end Get_Aircraft_Last_Pass_Height_Above_Local_Terrain;

function Get_Aircraft_Position return Lat_Long_Types.Position is
begin
    return (Location.Get_North(Container.This_Subsystem.The_Location),
            Location.Get_East(Container.This_Subsystem.The_Location),
            Location.Get_Geometric_Altitude(Container.This_Subsystem.The_Location));
end Get_Aircraft_Position;

function Get_Aircraft_On_Jacks return Boolean is
begin
    return Location.Get_Aircraft_On_Jacks(Container.This_Subsystem.The_Location);
end Get_Aircraft_On_Jacks;

function Get_Aircraft_Moment_of_Inertia return Coordinate_Types.Inertia_Axis is
begin
    return Moment_of_Inertia.Get_Inertia(Container.This_Subsystem.The_Moment_of_Inertia);
end Get_Aircraft_Moment_of_Inertia;

function Get_Nondimensional_Angular_Rate return Coordinate_Types.Attitude is
begin
    return Velocity.Get_Nondimensional_Angular(Container.This_Subsystem.The_Velocity);
end Get_Nondimensional_Angular_Rate;

function Get_E_1_Rate return Float is
begin
    return Quaternion.Get_E_1_Rate(Container.This_Subsystem.The_Quaternion);
end Get_E_1_Rate;

function Get_E_2_Rate return Float is
begin
    return Quaternion.Get_E_2_Rate(Container.This_Subsystem.The_Quaternion);
end Get_E_2_Rate;

function Get_E_3_Rate return Float is
begin
    return Quaternion.Get_E_3_Rate(Container.This_Subsystem.The_Quaternion);
end Get_E_3_Rate;

function Get_E_4_Rate return Float is
begin
    return Quaternion.Get_E_4_Rate(Container.This_Subsystem.The_Quaternion);
end Get_E_4_Rate;

function Get_E_1 return Float is
begin
    return Quaternion.Get_E_1(Container.This_Subsystem.The_Quaternion);
end Get_E_1;

function Get_E_2 return Float is
begin
    return Quaternion.Get_E_2(Container.This_Subsystem.The_Quaternion);
end Get_E_2;

function Get_E_3 return Float is
begin
    return Quaternion.Get_E_3(Container.This_Subsystem.The_Quaternion);
end Get_E_3;

function Get_E_4 return Float is
begin
    return Quaternion.Get_E_4(Container.This_Subsystem.The_Quaternion);
end Get_E_4;

function Get_L_1 return Float is
begin
    return Quaternion.Get_L_1(Container.This_Subsystem.The_Quaternion);
end Get_L_1;

function Get_L_2 return Float is
begin
    return Quaternion.Get_L_2(Container.This_Subsystem.The_Quaternion);
end Get_L_2;

function Get_L_3 return Float is
begin
    return Quaternion.Get_L_3(Container.This_Subsystem.The_Quaternion);
end Get_L_3;

function Get_M_1 return Float is
begin
    return Quaternion.Get_M_1(Container.This_Subsystem.The_Quaternion);
end Get_M_1;

function Get_M_2 return Float is
begin
    return Quaternion.Get_M_2(Container.This_Subsystem.The_Quaternion);
end Get_M_2;

function Get_M_3 return Float is
begin
    return Quaternion.Get_M_3(Container.This_Subsystem.The_Quaternion);
end Get_M_3;

function Get_N_1 return Float is
begin
    return Quaternion.Get_N_1(Container.This_Subsystem.The_Quaternion);
end Get_N_1;

function Get_N_2 return Float is
begin
    return Quaternion.Get_N_2(Container.This_Subsystem.The_Quaternion);
end Get_N_2;

function Get_N_3 return Float is
begin
    return Quaternion.Get_N_3(Container.This_Subsystem.The_Quaternion);
end Get_N_3;

function Get_Orthogonality_Correction_Factor return Float is
begin
    return Quaternion.Get_Orthogonality_Correction_Factor(Container.This_Subsystem.The_Quaternion);
end Get_Orthogonality_Correction_Factor;

function Get_Zero_Fuel_Reference_Coordinates_of_Simulated_Aircraft return Coordinate_Types.Reference_System is
begin
    return Reference_Coordinates.Get_Zero_Fuel(Container.This_Subsystem.The_Reference_Coordinates);
end Get_Zero_Fuel_Reference_Coordinates_of_Simulated_Aircraft;

function Get_Buttline_of_Current_Center_of_Gravity_of_Simulated_Aircraft return Length_Types.Feet is
begin
    return Reference_Coordinates.Get_Buttline_of_Current_Center_of_Gravity
                                            (Container.This_Subsystem.The_Reference_Coordinates);
end Get_Buttline_of_Current_Center_of_Gravity_of_Simulated_Aircraft;

function Get_Fuselage_Station_of_Current_Center_of_Gravity_of_Simulated_Aircraft return Length_Types.Feet is
begin
    return Reference_Coordinates.Get_Fuselage_Station_of_Current_Center_of_Gravity
                                            (Container.This_Subsystem.The_Reference_Coordinates);
end Get_Fuselage_Station_of_Current_Center_of_Gravity_of_Simulated_Aircraft;

function Get_Waterline_of_Current_Center_of_Gravity_of_Simulated_Aircraft return Length_Types.Feet is
begin
    return Reference_Coordinates.Get_Waterline_of_Current_Center_of_Gravity(Container.This_Subsystem.The_Reference_Coordinates);
end Get_Waterline_of_Current_Center_of_Gravity_of_Simulated_Aircraft;

function Get_Current_Center_of_Gravity_of_Simulated_Aircraft return Coordinate_Types.Reference_System is
begin
    return (Reference_Coordinates.Get_Buttline_of_Current_Center_of_Gravity
                                            (Container.This_Subsystem.The_Reference_Coordinates),
            Reference_Coordinates.Get_Fuselage_Station_of_Current_Center_of_Gravity
                                            (Container.This_Subsystem.The_Reference_Coordinates),
            Reference_Coordinates.Get_Waterline_of_Current_Center_of_Gravity(Container.This_Subsystem.The_Reference_Coordinates));
end Get_Current_Center_of_Gravity_of_Simulated_Aircraft;

function Get_Altitude_Slew return Float is
begin
    return Slews.Get(Container.This_Subsystem.The_Altitude_Slew);
end Get_Altitude_Slew;

function Get_Heading_Slew return Float is
begin
    return Slews.Get(Container.This_Subsystem.The_Heading_Slew);
end Get_Heading_Slew;

function Get_Position_Slew return Float is
begin
    return Slews.Get(Container.This_Subsystem.The_Position_Slew);
end Get_Position_Slew;

function Get_Velocity_Body_Axis return Coordinate_Types.Cartesian is
begin
    return Velocity.Get_Body_Axis(Container.This_Subsystem.The_Velocity);
end Get_Velocity_Body_Axis;

function Get_Velocity_Earth_Axis return Coordinate_Types.Cartesian is
begin
    return Velocity.Get_Earth_Axis(Container.This_Subsystem.The_Velocity);
end Get_Velocity_Earth_Axis;

function Get_Last_Pass_Velocity_Earth_Axis return Coordinate_Types.Cartesian is
begin
    return Velocity.Get_Last_Pass_Earth_Axis(Container.This_Subsystem.The_Velocity);
end Get_Last_Pass_Velocity_Earth_Axis;

function Get_Pitch_Angle_for_Formation return Angle_Types.Radians is
begin
    return Formation.Get_Attribute(Container.This_Subsystem.The_Pitch_Formation_Control);
end Get_Pitch_Angle_for_Formation;

function Get_Pitch_Gain_for_Formation return Float is
begin
    return Formation.Get_Gain(Container.This_Subsystem.The_Pitch_Formation_Control);
end Get_Pitch_Gain_for_Formation;

function Get_Bank_Angle_for_Formation return Angle_Types.Radians is
begin
    return Formation.Get_Attribute(Container.This_Subsystem.The_Bank_Formation_Control);
end Get_Bank_Angle_for_Formation;

function Get_Bank_Gain_for_Formation return Float is
begin
    return Formation.Get_Gain(Container.This_Subsystem.The_Bank_Formation_Control);
end Get_Bank_Gain_for_Formation;

function Get_Yaw_Angle_for_Formation return Angle_Types.Radians is
begin
    return Attitude_Angle.Get_Yaw(Container.This_Subsystem.The_Formation_Attitude_Angle);
end Get_Yaw_Angle_for_Formation;

function Get_Formation_True_Airspeed return Length_Types.Feet_per_Sec is
begin
    return Airspeed.Get_True_Airspeed(Container.This_Subsystem.The_Formation_Airspeed);
end Get_Formation_True_Airspeed;

function Get_Formation_Angle_of_Attack return Angle_Types.Radians is
begin
    return Aerodynamic_Angle.Get_Angle_of_Attack(Container.This_Subsystem.The_Formation_Aerodynamic_Angle);
end Get_Formation_Angle_of_Attack;

function Get_Formation_North return Lat_Long_Types.Latitude_Degrees is
begin
    return Location.Get_North(Container.This_Subsystem.The_Formation_Location);
end Get_Formation_North;

function Get_Formation_East return Lat_Long_Types.Longitude_Degrees is
begin
    return Location.Get_East(Container.This_Subsystem.The_Formation_Location);
end Get_Formation_East;

function Get_Formation_Aircraft_Geometric_Altitude return Length_Types.Feet is
begin
    return Location.Get_Geometric_Altitude(Container.This_Subsystem.The_Formation_Location);
end Get_Formation_Aircraft_Geometric_Altitude;

function Get_Formation_Velocity_Body_Axis return Coordinate_Types.Cartesian is
begin
    return Velocity.Get_Body_Axis(Container.This_Subsystem.The_Formation_Velocity);
end Get_Formation_Velocity_Body_Axis;

function Get_Formation_Velocity_Earth_Axis return Coordinate_Types.Cartesian is
begin
    return Velocity.Get_Earth_Axis(Container.This_Subsystem.The_Formation_Velocity);
end Get_Formation_Velocity_Earth_Axis;

function Get_Formation_Last_Pass_Velocity_Earth_Axis return Coordinate_Types.Cartesian is
begin
    return Velocity.Get_Last_Pass_Earth_Axis(Container.This_Subsystem.The_Formation_Velocity);
end Get_Formation_Last_Pass_Velocity_Earth_Axis;

end JPATS_Simulated_Aircraft;
